package com.bringspring.workflow.engine.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 流程节点
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Data
@TableName("FLOW_TASK_NODE")
public class FlowTaskNodeEntity {
    /**
     * 节点实例主键
     */
    @TableId("ID")
    private String id;

    /**
     * 节点编码
     */
    @TableField("NODE_CODE")
    private String nodeCode;

    /**
     * 节点名称
     */
    @TableField("NODE_NAME")
    private String nodeName;

    /**
     * 节点类型
     */
    @TableField("NODE_TYPE")
    private String nodeType;

    /**
     * 节点属性Json
     */
    @TableField("NODE_PROPERTY_JSON")
    private String nodePropertyJson;

    /**
     * 上一节点 1.上一步骤 0.返回开始
     */
    @TableField("NODE_UP")
    private String nodeUp;

    /**
     * 下一节点
     */
    @TableField("NODE_NEXT")
    private String nodeNext;

    /**
     * 是否完成
     */
    @TableField("COMPLETION")
    private Integer completion;

    /**
     * 描述
     */
    @TableField("DESCRIPTION")
    private String description;

    /**
     * 排序码
     */
    @TableField("SORT_CODE")
    private Long sortCode;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 任务主键
     */
    @TableField("TASK_ID")
    private String taskId;

    /**
     * 状态 0.新流程 -1.无用节点
     */
    @TableField("STATE")
    private Integer state;

    /**
     * 候选人
     */
    @TableField("CANDIDATES")
    private String candidates;
}
