package com.bringspring.workflow.engine.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 流程经办记录
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Data
@TableName("FLOW_TASK_OPERATOR_RECORD")
public class FlowTaskOperatorRecordEntity {
    /**
     * 节点流转主键
     */
    @TableId("ID")
    private String id;

    /**
     * 节点编码
     */
    @TableField("NODE_CODE")
    private String nodeCode;

    /**
     * 节点名称
     */
    @TableField("NODE_NAME")
    private String nodeName;

    /**
     * 经办状态 0-拒绝、1-同意、2-提交、3-撤回、4-终止、5-指派、6-加签、7-转办
     */
    @TableField("HANDLE_STATUS")
    private Integer handleStatus;

    /**
     * 抄送人
     **/
    @TableField(exist = false)
    private List<String> objectId;

    /**
     * 经办附件
     */
    @TableField("HANDLE_FILES")
    private String handleFiles;

    /**
     * 经办人员
     */
    @TableField("HANDLE_ID")
    private String handleId;

    /**
     * 经办时间
     */
    @TableField("HANDLE_TIME")
    private Date handleTime;

    /**
     * 经办理由
     */
    @TableField("HANDLE_OPINION")
    private String handleOpinion;

    /**
     * 流转操作人
     */
    @TableField("OPERATOR_ID")
    private String operatorId;

    /**
     * 经办主键
     */
    @TableField(value="TASK_OPERATOR_ID",fill = FieldFill.UPDATE)
    private String taskOperatorId;

    /**
     * 节点主键
     */
    @TableField(value="TASK_NODE_ID",fill = FieldFill.UPDATE)
    private String taskNodeId;

    /**
     * 任务主键
     */
    @TableField("TASK_ID")
    private String taskId;

    /**
     * 签名图片
     */
    @TableField("SIGN_IMG")
    private String signImg;

    /**
     * 0.进行数据 -1.作废数据 1.加签数据 3.已办不显示数据
     */
    @TableField("STATUS")
    private Integer status;

    /**
     * 被退回的节点重新提交时的方式
     */
    @TableField("REJECT_AUDIT_TYPE")
    private String rejectAuditType;
}
