package com.bringspring.workflow.engine.model.flowenginetemplate;


import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.Date;

@Data
public class FlowEngineTemplateModel {

    /**
     * 流程模板主键
     */
    @JsonProperty("id")
    private String id;

    /**
     * 流程引擎id
     */
    @JsonProperty("flowId")
    private String flowId;

    /**
     * 流程编码
     */
    @JsonProperty("enCode")
    private String enCode;

    @JsonProperty("companyId")
    private String companyId;

    /**
     * 流程名称
     */
    @JsonProperty("fullName")
    private String fullName;

    /**
     * 可见类型 0-全部可见、1-指定经办
     */
    @JsonProperty("visibleType")
    private Integer visibleType;


    @JsonProperty("version")
    private String version;

    /**
     * 流程模板
     */
    @JsonProperty("flowTemplateJson")
    private String flowTemplateJson;

    /**
     * 版本号id
     */
    @JsonProperty("versionId")
    private String versionId;

    /**
     * 排序码
     */
    @JsonProperty("sortCode")
    private Long sortCode;

    /**
     * 有效标志
     */
    @JsonProperty("enabledMark")
    private Integer enabledMark;

    /**
     * 创建时间
     */
    @JsonProperty("creatorTime")
    private Date creatorTime;

    /**
     * 创建用户
     */
    @JsonProperty("creatorUserId")
    private String creatorUserId;

    /**
     * 修改时间
     */
    @JsonProperty("lastModifyTime")
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @JsonProperty("lastModifyUserId")
    private String lastModifyUserId;

    /**
     * 删除标志
     */
    @JsonProperty("deleteMark")
    private Integer deleteMark;

    /**
     * 删除时间
     */
    @JsonProperty("deleteTime")
    private Date deleteTime;

    /**
     * 删除用户
     */
    @JsonProperty("deleteUserId")
    private String deleteUserId;

    @JsonProperty("type")
    private String type;
}
