package com.bringspring.workflow.engine.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.entity.FlowEngineTemplateEntity;
import com.bringspring.workflow.engine.model.flowengine.FlowPagination;
import com.bringspring.workflow.engine.model.flowengine.PaginationFlowEngine;

import java.util.List;


public interface FlowEngineTemplateService extends IService<FlowEngineTemplateEntity> {

    List<FlowEngineTemplateEntity> getListByFlowId(String flowId);

    List<FlowEngineTemplateEntity> getListByFlowIdAndCompanyId(String flowId,String companyId);

    List<FlowEngineTemplateEntity> getListByCompanyId(String companyId);

    Boolean deleteByTemplateId(String templateId);

    /**
     * 分页列表
     *
     * @param pagination 分页
     * @return
     */
    List<FlowEngineTemplateEntity> getPageList(FlowPagination pagination);

    /**
     * 不分页数据
     *
     * @param pagination 分页
     * @return
     */
    List<FlowEngineTemplateEntity> getList(PaginationFlowEngine pagination);


}
