package com.bringspring.workflow.engine.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.msgcenter.enums.TermTypeEnum;
import com.bringspring.system.msgcenter.model.CustomKeysLink;
import com.bringspring.system.msgcenter.model.LinkMsgKeys;
import com.bringspring.system.msgcenter.model.TaskMsg;
import com.bringspring.system.msgcenter.util.SendTaskMsgUtils;
import com.bringspring.workflow.engine.entity.FlowCommentEntity;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.mapper.FlowCommentMapper;
import com.bringspring.workflow.engine.model.flowcomment.FlowCommentPagination;
import com.bringspring.workflow.engine.service.FlowCommentService;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 流程评论
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 */
@Slf4j
@Service
public class FlowCommentServiceImpl extends ServiceImpl<FlowCommentMapper, FlowCommentEntity> implements FlowCommentService {

    @Autowired
    private UserProvider userProvider;

    @Autowired
    private SysConfigService sysConfigService;

    @Autowired
    private SendTaskMsgUtils sendTaskMsgUtils;

    @Autowired
    private FlowTaskService flowTaskService;

    @Autowired
    private ServiceAllUtil serviceAllUtil;

    @Autowired
    private FlowEngineService flowEngineService;

    @Override
    public List<FlowCommentEntity> getlist(FlowCommentPagination pagination) {
        QueryWrapper<FlowCommentEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(FlowCommentEntity::getTaskId, pagination.getTaskId());
        queryWrapper.lambda().orderByDesc(FlowCommentEntity::getCreatorTime);
        Page<FlowCommentEntity> page = new Page<>(pagination.getCurrentPage(), pagination.getPageSize());
        IPage<FlowCommentEntity> userIPage = this.page(page, queryWrapper);
        return pagination.setData(userIPage.getRecords(), page.getTotal());
    }

    @Override
    public FlowCommentEntity getInfo(String id) {
        QueryWrapper<FlowCommentEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(FlowCommentEntity::getId, id);
        return this.getOne(queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(FlowCommentEntity entity) throws WorkFlowException {
        entity.setCreatorTime(new Date());
        entity.setCreatorUserId(userProvider.get().getUserId());
        entity.setId(RandomUtil.uuId());
        //发送消息
        this.send(entity);
        this.save(entity);

    }

    @Override
    @DSTransactional
    public void update(String id, FlowCommentEntity entity) {
        entity.setId(id);
        this.updateById(entity);
    }

    @Override
    public void delete(FlowCommentEntity entity) {
        if (entity != null) {
            this.removeById(entity.getId());
        }
    }

    public void send(FlowCommentEntity entity) throws WorkFlowException {
        //接收人                                      
        List<String> toUserIds = CollectionUtil.list(false);
        toUserIds.addAll(entity.getRemindUserId());
        //消息内容
        String taskCode = "流程评论消息提醒";
        String sendCode = "FlowCommentTemplate";
        HashMap<String, String> keys = MapUtil.newHashMap();
        FlowTaskEntity taskEntity = flowTaskService.getDraftTaskByProcessId(entity.getTaskId());
        FlowEngineEntity engine = flowEngineService.getInfo(taskEntity.getFlowId());
        keys.put("title",taskEntity.getFullName()+"有新的流程评论");
        keys.put("content",serviceAllUtil.getUserInfo(entity.getCreatorUserId()).getRealName()+"在评论中提醒了你");
        keys.put("creatorUser", serviceAllUtil.getUserInfo(entity.getCreatorUserId()).getRealName());
        keys.put("MessageTime", DateUtil.getNow());


        HashMap map = MapUtil.newHashMap();
        map.put("id", taskEntity.getProcessId());
        map.put("processId", taskEntity.getProcessId());
        map.put("taskId", taskEntity.getId());
        map.put("enCode", taskEntity.getFlowCode());
        map.put("flowId", taskEntity.getFlowId());
        map.put("formType", engine.getFormType());
        map.put("opType", 3);
        map.put("fullName", taskEntity.getFullName());
        map.put("status", taskEntity.getStatus());
        map.put("type",4);
        map.put("isSub", true);
        String localTime = System.currentTimeMillis() + "";
        String appUrl = "/#/pages/workFlow/flowCenter/index?type=4&processId=" + taskEntity.getProcessId() + "&flowId=" + taskEntity.getFlowId()+"&localTime="+localTime;
        String pcUrl = "/#/workFlow/flowRelation?processId=" + taskEntity.getProcessId() + "&flowId=" + taskEntity.getFlowId()+"&localTime="+localTime;
        String termType = TermTypeEnum.TERM_APP_PC.getCode();
        String typeDesc = "";
        this.sendMessageNew(taskCode, sendCode, keys, null, appUrl, pcUrl, CollectionUtil.join(toUserIds, ","), termType, typeDesc,map);

    }

    public void sendMessageNew(String taskCode, String sendCode, HashMap<String, String> keys, String linkUrl, String appUrl, String pcUrl, String userId, String termType, String typeDesc,HashMap map) {
        log.info("code:{},接收人:{}",sendCode,userId);
        TaskMsg taskMsg = new TaskMsg();
        taskMsg.setTaskCode(taskCode);
        taskMsg.setSendCode(sendCode);
        LinkMsgKeys linkMsgKeys = new LinkMsgKeys();
        linkMsgKeys.setKeys(keys);
        if (StrUtil.isEmpty(linkUrl)) {
            try {
                linkUrl = sysConfigService.getConfigByKeyName("sysMobileUrl").getKeyValue();
            } catch (BaseException e) {
                e.printStackTrace();
            }
        }
        linkMsgKeys.setLinkUrl("");
        CustomKeysLink customKeysLink = new CustomKeysLink();
        //消息链接多端类型 1:支持app端;2:支持pc端;3:支持app和pc端
        customKeysLink.setTermType(termType);
//            消息链接多端类型 提示内容
        customKeysLink.setTermTypeDesc(typeDesc);
        customKeysLink.setPcUrl(pcUrl);
        customKeysLink.setAppUrl(appUrl);
        customKeysLink.setOtherKey(map);
        taskMsg.setCustomKey(customKeysLink);
        taskMsg.setBusinessKey(linkMsgKeys);
        taskMsg.setToUserIds(userId);
        try {
            sendTaskMsgUtils.sendTaskMsg(taskMsg);
        } catch (Exception e) {
            log.error("发送消息异常:" + e.getMessage());
            e.printStackTrace();
        }
    }
}
