package com.bringspring.workflow.engine.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.model.visiual.ComponentKeyConsts;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.entity.FlowTaskNodeEntity;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode.ChildNode;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode.ProperCond;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode.Properties;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.nodejson.ChildNodeList;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.nodejson.ConditionList;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.nodejson.Custom;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.nodejson.DateProperties;
import com.bringspring.workflow.engine.model.flowtask.FlowConditionModel;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 在线工作流开发
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Data
@Slf4j
public class FlowJsonUtil {

    /**
     * 外层节点
     **/
    private static String cusNum = "0";

    /**
     * 获取下一节点
     **/
    public static String getNextNode(FlowConditionModel conditionModel) {
        String next = nextNodeId(conditionModel);
        return next;
    }

    public static List<String> getNextNodeId(FlowConditionModel conditionModel,String type) {
        List<String> next = privateGetNextNodeId(conditionModel,type);
        return next;
    }

    /**
     * 下一节点id
     **/
    private static String nextNodeId(FlowConditionModel conditionModel) {
        List<ChildNodeList> childNodeListAll = conditionModel.getChildNodeListAll();
        String nodeId = conditionModel.getNodeId();
        String nextId = "";
        boolean flag = false;
        ChildNodeList childNode = childNodeListAll.stream().filter(t -> t.getCustom().getNodeId().equals(nodeId)).findFirst().orElse(null);
        String contextType = childNode.getConditionType();
        //条件、分流的判断
        if (StringUtils.isNotEmpty(contextType)) {
            if (FlowCondition.CONDITION.equals(contextType)) {
                List<String> nextNodeId = new ArrayList<>();
                getContionNextNode(conditionModel, nextNodeId);
                nextId = String.join(",", nextNodeId);
                if (StringUtils.isNotEmpty(nextId)) {
                    flag = true;
                }
            } else if (FlowCondition.INTERFLOW.equals(contextType)) {
                nextId = childNode.getCustom().getFlowId();
                flag = true;
            }
        }
        //子节点
        if (!flag) {
            if (childNode.getCustom().getFlow()) {
                nextId = childNode.getCustom().getFlowId();
            } else {
                //不是外层的下一节点
                if (!cusNum.equals(childNode.getCustom().getNum())) {
                    nextId = childNode.getCustom().getFirstId();
                    if (childNode.getCustom().getChild()) {
                        nextId = childNode.getCustom().getChildNode();
                    }
                } else {
                    //外层的子节点
                    if (childNode.getCustom().getChild()) {
                        nextId = childNode.getCustom().getChildNode();
                    }
                }
            }
        }
        return nextId;
    }

    private static List<String> privateGetNextNodeId(FlowConditionModel conditionModel,String type) {
        List<String> nodeCodeList = new ArrayList<>();
        List<ChildNodeList> childNodeListAll = conditionModel.getChildNodeListAll();
        String nodeId = conditionModel.getNodeId();
        List<ChildNodeList> childNodeLists = childNodeListAll.stream().filter(t -> t.getCustom().getNodeId().equals(nodeId)).collect(Collectors.toList());
        childNodeLists.stream().forEach(childNode->{
            boolean flag = false;
            String nextId = "";
            String contextType = childNode.getConditionType();
            //条件、分流的判断
            if (StringUtils.isNotEmpty(contextType)) {
                if (FlowCondition.CONDITION.equals(contextType)) {
                    List<String> nextNodeId = new ArrayList<>();
                    getContionNextNode(conditionModel, nextNodeId);
                    nextId = String.join(",", nextNodeId);
                    if (StringUtils.isNotEmpty(nextId)) {
                        flag = true;
                    }
                } else if (FlowCondition.INTERFLOW.equals(contextType)) {
                    nextId = childNode.getCustom().getFlowId();
                    flag = true;
                }
            }
            //子节点
            if (!flag) {
                if (childNode.getCustom().getFlow()) {
                    nextId = childNode.getCustom().getFlowId();
                } else {
                    //不是外层的下一节点
                    if (!cusNum.equals(childNode.getCustom().getNum())) {
                        nextId = childNode.getCustom().getFirstId();
                        if (childNode.getCustom().getChild()) {
                            nextId = childNode.getCustom().getChildNode();
                        }
                    } else {
                        //外层的子节点
                        if (childNode.getCustom().getChild()) {
                            nextId = childNode.getCustom().getChildNode();
                        }
                    }
                }
            }
            nodeCodeList.add(nextId);
        });

        return nodeCodeList;
    }



    //---------------------------------------------------递归获取当前的上节点和下节点----------------------------------------------

    /**
     * 获取当前已完成节点
     **/
    private static void upList(List<FlowTaskNodeEntity> flowTaskNodeList, String node, Set<String> upList, String[] tepId) {
        FlowTaskNodeEntity entity = flowTaskNodeList.stream().filter(t -> t.getNodeCode().equals(node)).findFirst().orElse(null);
        if (entity != null) {
            List<String> list = flowTaskNodeList.stream().filter(t -> t.getSortCode() != null && t.getSortCode() < entity.getSortCode()).map(t -> t.getNodeCode()).collect(Collectors.toList());
            list.removeAll(Arrays.asList(tepId));
            upList.addAll(list);
        }
    }

    /**
     * 获取当前未完成节点
     **/
    private static void nextList(List<FlowTaskNodeEntity> flowTaskNodeList, String node, Set<String> nextList, String[] tepId) {
        FlowTaskNodeEntity entity = flowTaskNodeList.stream().filter(t -> t.getNodeCode().equals(node)).findFirst().orElse(null);
        if (entity != null) {
            List<String> list = flowTaskNodeList.stream().filter(t -> t.getSortCode() != null && t.getSortCode() > entity.getSortCode()).map(t -> t.getNodeCode()).collect(Collectors.toList());
            list.removeAll(Arrays.asList(tepId));
            nextList.addAll(list);
        }
    }

    //---------------------------------------------------条件----------------------------------------------

    /**
     * 递归条件
     **/
    private static void getContionNextNode(FlowConditionModel conditionModel, List<String> nextNodeId) {
        String nodeId = conditionModel.getNodeId();
        List<ConditionList> conditionListAll = conditionModel.getConditionListAll();
        List<ConditionList> conditionAll = conditionListAll.stream().filter(t -> t.getPrevId().equals(nodeId)).collect(Collectors.toList());
        for (int i = 0; i < conditionAll.size(); i++) {
            ConditionList condition = conditionAll.get(i);
            List<ProperCond> conditions = condition.getConditions();
            boolean flag = nodeConditionDecide(conditionModel, conditions);
            //判断条件是否成立或者其他情况条件
            if (flag || condition.getIsDefault()) {
                String conditionId = condition.getNodeId();
                List<ConditionList> collect = conditionListAll.stream().filter(t -> t.getPrevId().equals(conditionId)).collect(Collectors.toList());
                if (collect.size() > 0) {
                    conditionModel.setNodeId(conditionId);
                    getContionNextNode(conditionModel, nextNodeId);
                } else {
                    if (nextNodeId.size() == 0) {
                        //先获取条件下的分流节点
                        if (condition.getFlow()) {
                            nextNodeId.add(condition.getFlowId());
                        } else {
                            //条件的子节点
                            if (condition.getChild()) {
                                nextNodeId.add(condition.getChildNodeId());
                            } else {
                                nextNodeId.add(condition.getFirstId());
                            }
                        }
                    }
                }
            }
        }
    }

    /**
     * 节点条件判断
     **/
    private static boolean nodeConditionDecide(FlowConditionModel conditionModel, List<ProperCond> conditionList) {
        String data = conditionModel.getData();
        boolean flag = false;
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("js");
        Map<String, Object> map = JsonUtil.stringToMap(data);
//        log.info("条件数据:{}",map);
        StringBuilder expression = new StringBuilder();
        for (int i = 0; i < conditionList.size(); i++) {
            String contain = "!=-1";
            String logic = conditionList.get(i).getLogic();
            String field = conditionList.get(i).getField();
            String keyName = conditionList.get(i).getKeyName();
            Object form = formValue(conditionModel, keyName, map.get(field));
            String formValue = "'" + form + "'";
            String symbol = conditionList.get(i).getSymbol();
            boolean include = ("like".equals(symbol) || "notLike".equals(symbol));
            if ("<>".equals(symbol)) {
                symbol = "!=";
            }
            Object value = filedValue(conditionModel, conditionList.get(i).getFiledValue(), keyName, form);
            String filedValue = "'" + value + "'";
            if (">".equals(symbol) || ">=".equals(symbol) || "<=".equals(symbol) || "<".equals(symbol)) {
                formValue = "parseFloat(" + formValue + ")";
                filedValue = "parseFloat(" + filedValue + ")";
            }
            String pression = formValue + symbol + filedValue;
            if (include) {
                if ("notLike".equals(symbol)) {
                    contain = "==-1";
                }
                symbol = ".indexOf";
                pression = formValue + symbol + "(" + filedValue + ")" + contain;
            }
            expression.append(pression);
            if (!StringUtils.isEmpty(logic)) {
                if (i != conditionList.size() - 1) {
                    expression.append(" " + logic + " ");
                }
            }
        }
        try {
            flag = (Boolean) scriptEngine.eval(expression.toString());
        } catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }
    /**
     * 条件数据修改
     *
     * @param conditionModel
     * @param value
     */
    private static Object filedValue(FlowConditionModel conditionModel, Object value, String keyName, Object form) {
        UserInfo userInfo = conditionModel.getUserInfo();
        if ("currentUser".equals(value)) {
            value = userInfo.getUserId();
        }
        try {
            value = JsonUtil.getJsonToList(String.valueOf(value), String.class);
        } catch (Exception e) {

        }
        if (value instanceof List) {
            List data = (List) value;
            if ("currOrganize".equals(keyName)) {
                value = data.stream().filter(t -> t.equals(form)).findFirst().orElse(null);
            } else {
                value = String.join(",", data);
            }
        }
        return value;
    }

    /**
     * 表单数据修改
     *
     * @param form
     */
    private static Object formValue(FlowConditionModel conditionModel, String keyName, Object form) {
        Object result = form;
        UserEntity userEntity = conditionModel.getUserEntity();
        FlowTaskEntity flowTaskEntity = conditionModel.getFlowTaskEntity();
        try {
            try {
                form = JsonUtil.getJsonToBean(String.valueOf(form), String[][].class);
            } catch (Exception e) {
            }
            try {
                form = JsonUtil.getJsonToList(String.valueOf(form), String.class);
            } catch (Exception e) {
            }
            if (form instanceof String[][]) {
                List<String> id = new ArrayList<>();
                String[][] dataAll = (String[][]) form;
                for (String[] data : dataAll) {
                    for (String value : data) {
                        id.add(value);
                    }
                }
                result = String.join(",", id);
            } else if (form instanceof List) {
                result = String.join(",", (List) form);
            } else {
                if (ComponentKeyConsts.CREATETIME.equals(keyName)) {
                    result = flowTaskEntity.getCreatorTime().getTime() + "";
                } else if (ComponentKeyConsts.CREATEUSER.equals(keyName)) {
                    result = flowTaskEntity.getCreatorUserId();
                } else if (ComponentKeyConsts.CURRORGANIZE.equals(keyName)) {
                    result = userEntity.getOrganizeId();
                } else if (ComponentKeyConsts.CURRPOSITION.equals(keyName)) {
                    result = userEntity.getPositionId();
                } else if (ComponentKeyConsts.MODIFYTIME.equals(keyName)) {
                    result = flowTaskEntity.getLastModifyTime().getTime() + "";
                } else if (ComponentKeyConsts.MODIFYUSER.equals(keyName)) {
                    result = flowTaskEntity.getLastModifyUserId();
                }
            }
        } catch (Exception e) {
        }
        return result;
    }

    //---------------------------------------------------------------解析--------------------------------------------------------------------------
    /**
     * 加签增加节点
     * 前置加签-before,在当前节点前面加签并修改当前状态为未开始，增加的节点为进行中
     * 后置加签-after,在当前节点后面增加节点，节点状态为进行中
     * @param childNode 任务节点模板
     * @param currentNodeCode 当前节点编码
     * @param freeApprovalType 加签类型：前置加签-before,后置加签-after
     **/
    public static ChildNode addFreeApprovalNode(ChildNode childNode,String currentNodeCode,String freeApprovalType,String addApprovalUser,String nodeCode,Integer counterSign) {
        if (childNode != null) {
            boolean haschildNode = childNode.getChildNode() != null;
            boolean hasConditionNodes = childNode.getConditionType() != null &&childNode.getConditionNodes() != null
                    &&  FlowCondition.CONDITION.equals(childNode.getConditionType());
            boolean hasInterflowNodes = childNode.getConditionType() != null &&childNode.getConditionNodes() != null
                    &&  FlowCondition.INTERFLOW.equals(childNode.getConditionType());
            boolean isInterflowNodes = childNode.getIsInterflow() != null &&  childNode.getIsInterflow();

            //分流合流节点没有下一级
            if(isInterflowNodes){
                //分流和流[前加签]
                if(childNode.getNodeId().equals(currentNodeCode)&&freeApprovalType.equals("before")){
                    Properties properties = new Properties();
                    properties.setCounterSign(counterSign);
                    ChildNode addBeforeNode = new ChildNode();
                    properties.setTitle("加签审批");
                    addBeforeNode.setType("approver");
                    addBeforeNode.setProperties(properties);
                    addBeforeNode.setContent(addApprovalUser);
                    addBeforeNode.setConditionType(null);
                    addBeforeNode.setConditionNodes(null);
                    addBeforeNode.setNodeId(nodeCode);
                    addBeforeNode.setPrevId(childNode.getPrevId());
                    addBeforeNode.setIsInterflow(Boolean.TRUE);
                    childNode.setPrevId(nodeCode);
                    childNode.setIsInterflow(null);
                    addBeforeNode.setChildNode(childNode);
                    childNode = addBeforeNode;
                }
            }
            if (haschildNode) {
                ChildNode nextNode = childNode.getChildNode();
                //普通审核节点/条件分支节点[前置加签]
                if(nextNode.getNodeId().equals(currentNodeCode)&&freeApprovalType.equals("before")){
                    Properties properties = new Properties();
                    properties.setCounterSign(counterSign);
                    ChildNode addBeforeNode = new ChildNode();
                    properties.setTitle("加签审批");
                    addBeforeNode.setType("approver");
                    addBeforeNode.setProperties(properties);
                    addBeforeNode.setContent("指定加签人员");
                    addBeforeNode.setConditionType(null);
                    addBeforeNode.setConditionNodes(null);
                    addBeforeNode.setNodeId(nodeCode);
                    addBeforeNode.setPrevId(nextNode.getPrevId());
                    nextNode.setPrevId(nodeCode);
                    addBeforeNode.setChildNode(nextNode);
                    childNode.setChildNode(addBeforeNode);
                }else if(nextNode.getNodeId().equals(currentNodeCode)&&freeApprovalType.equals("after")){
                    //后置加签
                    //子节点的子节点
                    Properties properties = new Properties();
                    properties.setCounterSign(counterSign);
                    ChildNode addAfterNode = new ChildNode();
                    properties.setTitle("加签审批");
                    addAfterNode.setType("approver");
                    addAfterNode.setProperties(properties);
                    addAfterNode.setContent("指定加签人员");
                    addAfterNode.setConditionType(null);
                    addAfterNode.setConditionNodes(null);
                    addAfterNode.setNodeId(nodeCode);
                    addAfterNode.setPrevId(nextNode.getNodeId());
                    if(ObjectUtil.isNotNull(nextNode.getChildNode())){
                        ChildNode afterNode = nextNode.getChildNode();
                        afterNode.setPrevId(nodeCode);
                        addAfterNode.setChildNode(afterNode);
                    }
                    //集成当前几点条件分支或者分流合流节点
                    addAfterNode.setConditionType(nextNode.getConditionType());
                    addAfterNode.setConditionNodes(nextNode.getConditionNodes());
                    nextNode.setChildNode(addAfterNode);
                    nextNode.setConditionType(null);
                    nextNode.setConditionNodes(null);
                }else {
                    childNode.setChildNode(addFreeApprovalNode(nextNode, currentNodeCode, freeApprovalType,addApprovalUser,nodeCode,counterSign));
                }
            }
            if (hasConditionNodes||hasInterflowNodes){
                List<ChildNode> conditionNodes = childNode.getConditionNodes();
                if (CollectionUtil.isNotEmpty(conditionNodes)){
                    List<ChildNode> conditionNodesNew = new ArrayList<>();
                    for (ChildNode conditionNode : conditionNodes) {
                        conditionNodesNew.add(addFreeApprovalNode(conditionNode, currentNodeCode, freeApprovalType, addApprovalUser, nodeCode,counterSign));
                    }
                    childNode.setConditionNodes(conditionNodesNew);
                }
            }

        }
        return childNode;
    }
    /**
     * 递归外层的节点
     **/
    private static void childListAll(ChildNode childNode, List<ChildNode> chilNodeList) {
        if (childNode != null) {
            chilNodeList.add(childNode);
            boolean haschildNode = childNode.getChildNode() != null;
            if (haschildNode) {
                ChildNode nextNode = childNode.getChildNode();
                childListAll(nextNode, chilNodeList);
            }
        }
    }

    /**
     * 最外层的json
     **/
    public static void getTemplateAll(ChildNode childNode, List<ChildNodeList> childNodeListAll, List<ConditionList> conditionListAll) {
        List<ChildNode> chilNodeList = new ArrayList<>();
        childListAll(childNode, chilNodeList);
        if (childNode != null) {
            String nodeId = childNode.getNodeId();
            String prevId = childNode.getPrevId();
            boolean haschildNode = childNode.getChildNode() != null;
            boolean hasconditionNodes = childNode.getConditionNodes() != null;
            Properties properties = childNode.getProperties();
            //属性赋值
            assignment(properties);
            ChildNodeList childNodeList = new ChildNodeList();
            childNodeList.setProperties(properties);
            //定时器
            DateProperties model = JsonUtil.getJsonToBean(properties, DateProperties.class);
            childNodeList.setTimer(model);
            //自定义属性
            Custom customModel = new Custom();
            customModel.setType(childNode.getType());
            customModel.setNum("0");
            customModel.setFirstId("");
            customModel.setChild(haschildNode);
            customModel.setNodeId(nodeId);
            customModel.setPrevId(prevId);
            customModel.setChildNode(haschildNode == true ? childNode.getChildNode().getNodeId() : "");
            //判断子节点数据是否还有分流节点,有的话保存分流节点id
            if (hasconditionNodes) {
                childNodeList.setConditionType(FlowCondition.CONDITION);
                List<ChildNode> conditionNodes = childNode.getConditionNodes().stream().filter(t -> t.getIsInterflow() != null).collect(Collectors.toList());
                boolean isFlow = conditionNodes.size() > 0;
                if (isFlow) {
                    customModel.setFlow(isFlow);
                    childNodeList.setConditionType(FlowCondition.INTERFLOW);
                    List<String> flowIdAll = conditionNodes.stream().map(t -> t.getNodeId()).collect(Collectors.toList());
                    customModel.setFlowId(String.join(",", flowIdAll));
                }
            }
            childNodeList.setCustom(customModel);
            childNodeListAll.add(childNodeList);
            String firstId = "";
            if (haschildNode) {
                firstId = childNode.getChildNode().getNodeId();
            }
            if (hasconditionNodes) {
                conditionList(childNode, firstId, childNodeListAll, conditionListAll, chilNodeList);
            }
            if (haschildNode) {
                getchildNode(childNode, firstId, childNodeListAll, conditionListAll, chilNodeList);
            }
        }
    }

    /**
     * 递归子节点的子节点
     **/
    private static void getchildNode(ChildNode parentChildNodeTest, String firstId, List<ChildNodeList> childNodeListAll, List<ConditionList> conditionListAll, List<ChildNode> chilNodeList) {
        ChildNode childNode = parentChildNodeTest.getChildNode();
        if (childNode != null) {
            String nodeId = childNode.getNodeId();
            String prevId = childNode.getPrevId();
            boolean haschildNode = childNode.getChildNode() != null;
            boolean hasconditionNodes = childNode.getConditionNodes() != null;
            Properties properModel = childNode.getProperties();
            //属性赋值
            assignment(properModel);
            ChildNodeList childNodeList = new ChildNodeList();
            childNodeList.setProperties(properModel);
            //定时器
            DateProperties model = JsonUtil.getJsonToBean(properModel, DateProperties.class);
            childNodeList.setTimer(model);
            //自定义属性
            Custom customModel = new Custom();
            customModel.setType(childNode.getType());
            boolean isFirst = chilNodeList.stream().filter(t -> t.getNodeId().equals(nodeId)).count() > 0;
            customModel.setNum(isFirst ? "0" : "1");
            customModel.setFirstId(firstId);
            if (isFirst) {
                customModel.setFirstId(haschildNode ? childNode.getChildNode().getNodeId() : "");
            }
            customModel.setChild(haschildNode);
            customModel.setNodeId(nodeId);
            customModel.setPrevId(prevId);
            customModel.setChildNode(haschildNode == true ? childNode.getChildNode().getNodeId() : "");
            //判断子节点数据是否还有分流节点,有的话保存分流节点id
            if (hasconditionNodes) {
                childNodeList.setConditionType(FlowCondition.CONDITION);
                List<ChildNode> conditionNodes = childNode.getConditionNodes().stream().filter(t -> t.getIsInterflow() != null).collect(Collectors.toList());
                boolean isFlow = conditionNodes.size() > 0;
                if (isFlow) {
                    customModel.setFlow(isFlow);
                    childNodeList.setConditionType(FlowCondition.INTERFLOW);
                    List<String> flowIdAll = conditionNodes.stream().map(t -> t.getNodeId()).collect(Collectors.toList());
                    customModel.setFlowId(String.join(",", flowIdAll));
                }
            }
            childNodeList.setCustom(customModel);
            childNodeListAll.add(childNodeList);
            //条件或者分流递归
            if (hasconditionNodes) {
                conditionList(childNode, firstId, childNodeListAll, conditionListAll, chilNodeList);
            }
            //子节点递归
            if (haschildNode) {
                getchildNode(childNode, firstId, childNodeListAll, conditionListAll, chilNodeList);
            }
        }
    }

    /**
     * 条件、分流递归
     **/
    private static void conditionList(ChildNode childNode, String firstId, List<ChildNodeList> childNodeListAll, List<ConditionList> conditionListAll, List<ChildNode> chilNodeList) {
        List<ChildNode> conditionNodes = childNode.getConditionNodes();
        if (conditionNodes.size() > 0) {
            //判断是条件还是分流
            //判断父节点是否还有子节点,有的话替换子节点数据
            ChildNode childNodeModel = childNode.getChildNode();
            if (childNodeModel != null) {
                firstId = childNodeModel.getNodeId();
            } else {
                ChildNode nodes = chilNodeList.stream().filter(t -> t.getNodeId().equals(childNode.getNodeId())).findFirst().orElse(null);
                if (nodes != null) {
                    if (nodes.getChildNode() != null) {
                        firstId = childNode.getChildNode().getNodeId();
                    } else {
                        firstId = "";
                    }
                }
            }
            for (ChildNode node : conditionNodes) {
                boolean conditionType = node.getIsInterflow() == null ? true : false;
                if (conditionType) {
                    getCondition(node, firstId, childNodeListAll, conditionListAll, chilNodeList);
                } else {
                    getConditonFlow(node, firstId, childNodeListAll, conditionListAll, chilNodeList);
                }
            }
        }
    }

    /**
     * 条件递归
     **/
    private static void getCondition(ChildNode childNode, String firstId, List<ChildNodeList> childNodeListAll, List<ConditionList> conditionListAll, List<ChildNode> chilNodeList) {
        if (childNode != null) {
            String nodeId = childNode.getNodeId();
            String prevId = childNode.getPrevId();
            boolean haschildNode = childNode.getChildNode() != null;
            boolean hasconditionNodes = childNode.getConditionNodes() != null;
            boolean isDefault = childNode.getProperties().getIsDefault() != null ? childNode.getProperties().getIsDefault() : false;
            ConditionList conditionList = new ConditionList();
            conditionList.setNodeId(nodeId);
            conditionList.setPrevId(prevId);
            conditionList.setChild(haschildNode);
            conditionList.setTitle(childNode.getProperties().getTitle());
            conditionList.setConditions(childNode.getProperties().getConditions());
            conditionList.setChildNodeId(haschildNode == true ? childNode.getChildNode().getNodeId() : "");
            conditionList.setIsDefault(isDefault);
            conditionList.setFirstId(firstId);
            //判断子节点数据是否还有分流节点,有的话保存分流节点id
            if (hasconditionNodes) {
                List<ChildNode> conditionNodes = childNode.getConditionNodes().stream().filter(t -> t.getIsInterflow() != null).collect(Collectors.toList());
                boolean isFlow = conditionNodes.size() > 0;
                if (isFlow) {
                    conditionList.setFlow(isFlow);
                    List<String> flowIdAll = conditionNodes.stream().map(t -> t.getNodeId()).collect(Collectors.toList());
                    conditionList.setFlowId(String.join(",", flowIdAll));
                }
            }
            conditionListAll.add(conditionList);
            //递归条件、分流
            if (hasconditionNodes) {
                conditionList(childNode, firstId, childNodeListAll, conditionListAll, chilNodeList);
            }
            //递归子节点
            if (haschildNode) {
                getchildNode(childNode, firstId, childNodeListAll, conditionListAll, chilNodeList);
            }
        }
    }

    /**
     * 条件递归
     **/
    private static void getConditonFlow(ChildNode childNode, String firstId, List<ChildNodeList> childNodeListAll, List<ConditionList> conditionListAll, List<ChildNode> chilNodeList) {
        if (childNode != null) {
            String nodeId = childNode.getNodeId();
            String prevId = childNode.getPrevId();
            boolean haschildNode = childNode.getChildNode() != null;
            boolean hasconditionNodes = childNode.getConditionNodes() != null;
            Properties properties = childNode.getProperties();
            //属性赋值
            assignment(properties);
            ChildNodeList childNodeList = new ChildNodeList();
            childNodeList.setProperties(properties);
            //定时器
            DateProperties model = JsonUtil.getJsonToBean(properties, DateProperties.class);
            childNodeList.setTimer(model);
            //自定义属性
            Custom customModel = new Custom();
            customModel.setType(childNode.getType());
            customModel.setNum("1");
            customModel.setFirstId(firstId);
            customModel.setChild(haschildNode);
            customModel.setChildNode(haschildNode == true ? childNode.getChildNode().getNodeId() : "");
            customModel.setNodeId(nodeId);
            customModel.setPrevId(prevId);
            //判断子节点数据是否还有分流节点,有的话保存分流节点id
            if (hasconditionNodes) {
                childNodeList.setConditionType(FlowCondition.CONDITION);
                List<ChildNode> conditionNodes = childNode.getConditionNodes().stream().filter(t -> t.getIsInterflow() != null).collect(Collectors.toList());
                boolean isFlow = conditionNodes.size() > 0;
                if (isFlow) {
                    customModel.setFlow(isFlow);
                    childNodeList.setConditionType(FlowCondition.INTERFLOW);
                    List<String> flowIdAll = conditionNodes.stream().map(t -> t.getNodeId()).collect(Collectors.toList());
                    customModel.setFlowId(String.join(",", flowIdAll));
                }
            }
            childNodeList.setCustom(customModel);
            childNodeListAll.add(childNodeList);
            if (hasconditionNodes) {
                conditionList(childNode, firstId, childNodeListAll, conditionListAll, chilNodeList);
            }
            if (haschildNode) {
                getchildNode(childNode, firstId, childNodeListAll, conditionListAll, chilNodeList);
            }
        }
    }

    /**
     * 属性赋值
     *
     * @param properties
     */
    public static void assignment(Properties properties) {
    }

}
