/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.engine.controller;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.entity.FlowEngineTemplateEntity;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.model.flowmonitor.FlowMonitorListVO;
import com.bringspring.workflow.engine.model.flowtask.FlowDeleteModel;
import com.bringspring.workflow.engine.model.flowtask.PaginationFlowTask;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.service.FlowEngineTemplateService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6d41\u7a0b\u76d1\u63a7"}, value="FlowMonitor")
@RestController
@RequestMapping(value={"/api/workflow/Engine/FlowMonitor"})
public class FlowMonitorController {
    @Autowired
    private FlowEngineService flowEngineService;
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private FlowEngineTemplateService flowEngineTemplateService;
    @Autowired
    private UserService userService;

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u76d1\u63a7\u5217\u8868")
    @GetMapping
    public ActionResult<PageListVO<FlowMonitorListVO>> list(PaginationFlowTask paginationFlowTask) {
        List<FlowTaskEntity> list = this.flowTaskService.getMonitorList(paginationFlowTask);
        List<FlowEngineEntity> engineList = this.flowEngineService.getFlowList(list.stream().map(t -> t.getFlowId()).collect(Collectors.toList()));
        List<UserEntity> userList = this.serviceUtil.getUserName(list.stream().map(t -> t.getCreatorUserId()).collect(Collectors.toList()));
        LinkedList<FlowMonitorListVO> listVO = new LinkedList<FlowMonitorListVO>();
        for (FlowTaskEntity taskEntity : list) {
            FlowEngineTemplateEntity templateEntity;
            OrganizeEntity organizeEntity;
            FlowMonitorListVO vo = (FlowMonitorListVO)JsonUtil.getJsonToBean((Object)taskEntity, FlowMonitorListVO.class);
            UserEntity user = userList.stream().filter(t -> t.getId().equals(taskEntity.getCreatorUserId())).findFirst().orElse(null);
            vo.setUserName(user != null ? user.getRealName() : "");
            FlowEngineEntity engine = engineList.stream().filter(t -> t.getId().equals(taskEntity.getFlowId())).findFirst().orElse(null);
            if (engine != null) {
                vo.setFormType(engine.getFormType());
                listVO.add(vo);
            }
            if (ObjectUtil.isNotEmpty((Object)(organizeEntity = this.organizeService.getInfo((templateEntity = (FlowEngineTemplateEntity)this.flowEngineTemplateService.getById((Serializable)((Object)taskEntity.getTemplateId()))).getCompanyId())))) {
                vo.setBelongCompany(organizeEntity.getShortName());
            }
            UserEntity userInfo = this.userService.getInfo(taskEntity.getCreatorUserId());
            OrganizeEntity userOrganize = this.organizeService.getInfo(userInfo.getOrganizeId());
            OrganizeEntity applyOrganize = this.organizeService.getInfo(userOrganize.getOrganizeId());
            vo.setApplyCompany(applyOrganize.getShortName());
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)paginationFlowTask), PaginationVO.class);
        return ActionResult.page(listVO, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6d41\u7a0b\u76d1\u63a7")
    @DeleteMapping
    public ActionResult delete(@RequestBody FlowDeleteModel deleteModel) throws WorkFlowException {
        String[] taskId = deleteModel.getIds().split(",");
        this.flowTaskService.delete(taskId);
        return ActionResult.success((String)MsgCode.SU003.get());
    }
}

