/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.engine.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.workflow.engine.entity.FlowTaskOperatorRecordEntity;
import com.bringspring.workflow.engine.enums.FlowNodeEnum;
import com.bringspring.workflow.engine.enums.FlowRecordEnum;
import com.bringspring.workflow.engine.mapper.FlowTaskOperatorRecordMapper;
import com.bringspring.workflow.engine.service.FlowTaskOperatorRecordService;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
public class FlowTaskOperatorRecordServiceImpl
extends ServiceImpl<FlowTaskOperatorRecordMapper, FlowTaskOperatorRecordEntity>
implements FlowTaskOperatorRecordService {
    @Override
    public List<FlowTaskOperatorRecordEntity> getList(String taskId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(FlowTaskOperatorRecordEntity::getTaskId, (Object)taskId)).orderByAsc(FlowTaskOperatorRecordEntity::getHandleTime);
        queryWrapper.lambda().orderByDesc(FlowTaskOperatorRecordEntity::getHandleTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<FlowTaskOperatorRecordEntity> getRecordList(String taskId, List<Integer> handleStatus) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowTaskOperatorRecordEntity::getTaskId, (Object)taskId);
        if (handleStatus.size() > 0) {
            queryWrapper.lambda().in(FlowTaskOperatorRecordEntity::getHandleStatus, handleStatus);
        }
        queryWrapper.lambda().orderByDesc(FlowTaskOperatorRecordEntity::getHandleTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<FlowTaskOperatorRecordEntity> getListByAddSign(String userId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(FlowTaskOperatorRecordEntity::getHandleId, (Object)userId)).eq(FlowTaskOperatorRecordEntity::getNodeName, (Object)"\u524d\u7f6e\u52a0\u7b7e")).eq(FlowTaskOperatorRecordEntity::getHandleStatus, (Object)6);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public FlowTaskOperatorRecordEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowTaskOperatorRecordEntity::getId, (Object)id);
        return (FlowTaskOperatorRecordEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void delete(FlowTaskOperatorRecordEntity entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowTaskOperatorRecordEntity::getId, (Object)entity.getId());
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public void create(FlowTaskOperatorRecordEntity entity) {
        entity.setId(RandomUtil.uuId());
        this.save(entity);
    }

    @Override
    public void update(String id, FlowTaskOperatorRecordEntity entity) {
        entity.setId(id);
        this.updateById(entity);
    }

    @Override
    public void updateStatus(Set<String> taskNodeId, String taskId) {
        if (taskNodeId.size() > 0) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.lambda().in(FlowTaskOperatorRecordEntity::getTaskNodeId, taskNodeId);
            updateWrapper.lambda().eq(FlowTaskOperatorRecordEntity::getTaskId, (Object)taskId);
            updateWrapper.lambda().set(FlowTaskOperatorRecordEntity::getStatus, (Object)FlowRecordEnum.revoke.getCode());
            this.update((Wrapper)updateWrapper);
        }
    }

    @Override
    public FlowTaskOperatorRecordEntity getInfo(String taskId, String taskNodeId, String taskOperatorId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowTaskOperatorRecordEntity::getTaskId, (Object)taskId);
        queryWrapper.lambda().eq(FlowTaskOperatorRecordEntity::getTaskNodeId, (Object)taskNodeId);
        queryWrapper.lambda().eq(FlowTaskOperatorRecordEntity::getTaskOperatorId, (Object)taskOperatorId);
        queryWrapper.lambda().eq(FlowTaskOperatorRecordEntity::getStatus, (Object)FlowNodeEnum.FreeApprover.getCode());
        queryWrapper.lambda().eq(FlowTaskOperatorRecordEntity::getHandleStatus, (Object)FlowRecordEnum.audit.getCode());
        return (FlowTaskOperatorRecordEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public FlowTaskOperatorRecordEntity getInfoNotHandleStatus(String taskId, String taskNodeId, String taskOperatorId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowTaskOperatorRecordEntity::getTaskId, (Object)taskId);
        queryWrapper.lambda().eq(FlowTaskOperatorRecordEntity::getTaskNodeId, (Object)taskNodeId);
        queryWrapper.lambda().eq(FlowTaskOperatorRecordEntity::getOperatorId, (Object)taskOperatorId);
        queryWrapper.lambda().eq(FlowTaskOperatorRecordEntity::getStatus, (Object)FlowNodeEnum.FreeApprover.getCode());
        return (FlowTaskOperatorRecordEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void updateStatus(List<String> idAll) {
        if (idAll.size() > 0) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.lambda().in(FlowTaskOperatorRecordEntity::getId, idAll);
            updateWrapper.lambda().set(FlowTaskOperatorRecordEntity::getStatus, (Object)FlowRecordEnum.revoke.getCode());
            this.update((Wrapper)updateWrapper);
        }
    }

    @Override
    public void update(String taskId) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.lambda().eq(FlowTaskOperatorRecordEntity::getTaskId, (Object)taskId);
        updateWrapper.lambda().set(FlowTaskOperatorRecordEntity::getStatus, (Object)FlowRecordEnum.revoke.getCode());
        this.update((Wrapper)updateWrapper);
    }
}

