/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.engine.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.entity.FlowTaskNodeEntity;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode.ChildNode;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode.ProperCond;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode.Properties;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.nodejson.ChildNodeList;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.nodejson.ConditionList;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.nodejson.Custom;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.nodejson.DateProperties;
import com.bringspring.workflow.engine.model.flowtask.FlowConditionModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowJsonUtil {
    private static final Logger log = LoggerFactory.getLogger(FlowJsonUtil.class);
    private static String cusNum = "0";

    public static String getNextNode(FlowConditionModel conditionModel) {
        String next = FlowJsonUtil.nextNodeId(conditionModel);
        return next;
    }

    public static List<String> getNextNodeId(FlowConditionModel conditionModel, String type) {
        List<String> next = FlowJsonUtil.privateGetNextNodeId(conditionModel, type);
        return next;
    }

    private static String nextNodeId(FlowConditionModel conditionModel) {
        List<ChildNodeList> childNodeListAll = conditionModel.getChildNodeListAll();
        String nodeId = conditionModel.getNodeId();
        String nextId = "";
        boolean flag = false;
        ChildNodeList childNode = childNodeListAll.stream().filter(t -> t.getCustom().getNodeId().equals(nodeId)).findFirst().orElse(null);
        String contextType = childNode.getConditionType();
        if (StringUtils.isNotEmpty((CharSequence)contextType)) {
            if ("condition".equals(contextType)) {
                ArrayList<String> nextNodeId = new ArrayList<String>();
                FlowJsonUtil.getContionNextNode(conditionModel, nextNodeId);
                nextId = String.join((CharSequence)",", nextNodeId);
                if (StringUtils.isNotEmpty((CharSequence)nextId)) {
                    flag = true;
                }
            } else if ("interflow".equals(contextType)) {
                nextId = childNode.getCustom().getFlowId();
                flag = true;
            }
        }
        if (!flag) {
            if (childNode.getCustom().getFlow().booleanValue()) {
                nextId = childNode.getCustom().getFlowId();
            } else if (!cusNum.equals(childNode.getCustom().getNum())) {
                nextId = childNode.getCustom().getFirstId();
                if (childNode.getCustom().getChild().booleanValue()) {
                    nextId = childNode.getCustom().getChildNode();
                }
            } else if (childNode.getCustom().getChild().booleanValue()) {
                nextId = childNode.getCustom().getChildNode();
            }
        }
        return nextId;
    }

    private static List<String> privateGetNextNodeId(FlowConditionModel conditionModel, String type) {
        ArrayList<String> nodeCodeList = new ArrayList<String>();
        List<ChildNodeList> childNodeListAll = conditionModel.getChildNodeListAll();
        String nodeId = conditionModel.getNodeId();
        List childNodeLists = childNodeListAll.stream().filter(t -> t.getCustom().getNodeId().equals(nodeId)).collect(Collectors.toList());
        childNodeLists.stream().forEach(childNode -> {
            boolean flag = false;
            String nextId = "";
            String contextType = childNode.getConditionType();
            if (StringUtils.isNotEmpty((CharSequence)contextType)) {
                if ("condition".equals(contextType)) {
                    ArrayList<String> nextNodeId = new ArrayList<String>();
                    FlowJsonUtil.getContionNextNode(conditionModel, nextNodeId);
                    nextId = String.join((CharSequence)",", nextNodeId);
                    if (StringUtils.isNotEmpty((CharSequence)nextId)) {
                        flag = true;
                    }
                } else if ("interflow".equals(contextType)) {
                    nextId = childNode.getCustom().getFlowId();
                    flag = true;
                }
            }
            if (!flag) {
                if (childNode.getCustom().getFlow().booleanValue()) {
                    nextId = childNode.getCustom().getFlowId();
                } else if (!cusNum.equals(childNode.getCustom().getNum())) {
                    nextId = childNode.getCustom().getFirstId();
                    if (childNode.getCustom().getChild().booleanValue()) {
                        nextId = childNode.getCustom().getChildNode();
                    }
                } else if (childNode.getCustom().getChild().booleanValue()) {
                    nextId = childNode.getCustom().getChildNode();
                }
            }
            nodeCodeList.add(nextId);
        });
        return nodeCodeList;
    }

    private static void upList(List<FlowTaskNodeEntity> flowTaskNodeList, String node, Set<String> upList, String[] tepId) {
        FlowTaskNodeEntity entity = flowTaskNodeList.stream().filter(t -> t.getNodeCode().equals(node)).findFirst().orElse(null);
        if (entity != null) {
            List list = flowTaskNodeList.stream().filter(t -> t.getSortCode() != null && t.getSortCode() < entity.getSortCode()).map(t -> t.getNodeCode()).collect(Collectors.toList());
            list.removeAll(Arrays.asList(tepId));
            upList.addAll(list);
        }
    }

    private static void nextList(List<FlowTaskNodeEntity> flowTaskNodeList, String node, Set<String> nextList, String[] tepId) {
        FlowTaskNodeEntity entity = flowTaskNodeList.stream().filter(t -> t.getNodeCode().equals(node)).findFirst().orElse(null);
        if (entity != null) {
            List list = flowTaskNodeList.stream().filter(t -> t.getSortCode() != null && t.getSortCode() > entity.getSortCode()).map(t -> t.getNodeCode()).collect(Collectors.toList());
            list.removeAll(Arrays.asList(tepId));
            nextList.addAll(list);
        }
    }

    private static void getContionNextNode(FlowConditionModel conditionModel, List<String> nextNodeId) {
        String nodeId = conditionModel.getNodeId();
        List<ConditionList> conditionListAll = conditionModel.getConditionListAll();
        List conditionAll = conditionListAll.stream().filter(t -> t.getPrevId().equals(nodeId)).collect(Collectors.toList());
        for (int i = 0; i < conditionAll.size(); ++i) {
            ConditionList condition = (ConditionList)conditionAll.get(i);
            List<ProperCond> conditions = condition.getConditions();
            boolean flag = FlowJsonUtil.nodeConditionDecide(conditionModel, conditions);
            if (!flag && !condition.getIsDefault().booleanValue()) continue;
            String conditionId = condition.getNodeId();
            List collect = conditionListAll.stream().filter(t -> t.getPrevId().equals(conditionId)).collect(Collectors.toList());
            if (collect.size() > 0) {
                conditionModel.setNodeId(conditionId);
                FlowJsonUtil.getContionNextNode(conditionModel, nextNodeId);
                continue;
            }
            if (nextNodeId.size() != 0) continue;
            if (condition.getFlow().booleanValue()) {
                nextNodeId.add(condition.getFlowId());
                continue;
            }
            if (condition.getChild().booleanValue()) {
                nextNodeId.add(condition.getChildNodeId());
                continue;
            }
            nextNodeId.add(condition.getFirstId());
        }
    }

    private static boolean nodeConditionDecide(FlowConditionModel conditionModel, List<ProperCond> conditionList) {
        String data = conditionModel.getData();
        boolean flag = false;
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine scriptEngine = scriptEngineManager.getEngineByName("js");
        Map map = JsonUtil.stringToMap((String)data);
        StringBuilder expression = new StringBuilder();
        for (int i = 0; i < conditionList.size(); ++i) {
            boolean include;
            String contain = "!=-1";
            String logic = conditionList.get(i).getLogic();
            String field = conditionList.get(i).getField();
            String keyName = conditionList.get(i).getKeyName();
            Object form = FlowJsonUtil.formValue(conditionModel, keyName, map.get(field));
            String formValue = "'" + form + "'";
            String symbol = conditionList.get(i).getSymbol();
            boolean bl = include = "like".equals(symbol) || "notLike".equals(symbol);
            if ("<>".equals(symbol)) {
                symbol = "!=";
            }
            Object value = FlowJsonUtil.filedValue(conditionModel, conditionList.get(i).getFiledValue(), keyName, form);
            String filedValue = "'" + value + "'";
            if (">".equals(symbol) || ">=".equals(symbol) || "<=".equals(symbol) || "<".equals(symbol)) {
                formValue = "parseFloat(" + formValue + ")";
                filedValue = "parseFloat(" + filedValue + ")";
            }
            String pression = formValue + symbol + filedValue;
            if (include) {
                if ("notLike".equals(symbol)) {
                    contain = "==-1";
                }
                symbol = ".indexOf";
                pression = formValue + symbol + "(" + filedValue + ")" + contain;
            }
            expression.append(pression);
            if (StringUtils.isEmpty((CharSequence)logic) || i == conditionList.size() - 1) continue;
            expression.append(" " + logic + " ");
        }
        try {
            flag = (Boolean)scriptEngine.eval(expression.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    private static Object filedValue(FlowConditionModel conditionModel, Object value, String keyName, Object form) {
        UserInfo userInfo = conditionModel.getUserInfo();
        if ("currentUser".equals(value)) {
            value = userInfo.getUserId();
        }
        try {
            value = JsonUtil.getJsonToList((String)String.valueOf(value), String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (value instanceof List) {
            List data = (List)value;
            value = "currOrganize".equals(keyName) ? data.stream().filter(t -> t.equals(form)).findFirst().orElse(null) : String.join((CharSequence)",", data);
        }
        return value;
    }

    private static Object formValue(FlowConditionModel conditionModel, String keyName, Object form) {
        Object result = form;
        UserEntity userEntity = conditionModel.getUserEntity();
        FlowTaskEntity flowTaskEntity = conditionModel.getFlowTaskEntity();
        try {
            try {
                form = JsonUtil.getJsonToBean((String)String.valueOf(form), String[][].class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                form = JsonUtil.getJsonToList((String)String.valueOf(form), String.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (form instanceof String[][]) {
                String[][] dataAll;
                ArrayList<String> id = new ArrayList<String>();
                String[][] stringArray = dataAll = (String[][])form;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String[] data;
                    for (String value : data = stringArray[i]) {
                        id.add(value);
                    }
                }
                result = String.join((CharSequence)",", id);
            } else if (form instanceof List) {
                result = String.join((CharSequence)",", (List)form);
            } else if ("createTime".equals(keyName)) {
                result = flowTaskEntity.getCreatorTime().getTime() + "";
            } else if ("createUser".equals(keyName)) {
                result = flowTaskEntity.getCreatorUserId();
            } else if ("currOrganize".equals(keyName)) {
                result = userEntity.getOrganizeId();
            } else if ("currPosition".equals(keyName)) {
                result = userEntity.getPositionId();
            } else if ("modifyTime".equals(keyName)) {
                result = flowTaskEntity.getLastModifyTime().getTime() + "";
            } else if ("modifyUser".equals(keyName)) {
                result = flowTaskEntity.getLastModifyUserId();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static ChildNode addFreeApprovalNode(ChildNode childNode, String currentNodeCode, String freeApprovalType, String addApprovalUser, String nodeCode, Integer counterSign) {
        if (childNode != null) {
            List<ChildNode> conditionNodes;
            boolean isInterflowNodes;
            boolean haschildNode = childNode.getChildNode() != null;
            boolean hasConditionNodes = childNode.getConditionType() != null && childNode.getConditionNodes() != null && "condition".equals(childNode.getConditionType());
            boolean hasInterflowNodes = childNode.getConditionType() != null && childNode.getConditionNodes() != null && "interflow".equals(childNode.getConditionType());
            boolean bl = isInterflowNodes = childNode.getIsInterflow() != null && childNode.getIsInterflow() != false;
            if (isInterflowNodes && childNode.getNodeId().equals(currentNodeCode) && freeApprovalType.equals("before")) {
                Properties properties = new Properties();
                properties.setCounterSign(counterSign);
                ChildNode addBeforeNode = new ChildNode();
                properties.setTitle("\u52a0\u7b7e\u5ba1\u6279");
                addBeforeNode.setType("approver");
                addBeforeNode.setProperties(properties);
                addBeforeNode.setContent(addApprovalUser);
                addBeforeNode.setConditionType(null);
                addBeforeNode.setConditionNodes(null);
                addBeforeNode.setNodeId(nodeCode);
                addBeforeNode.setPrevId(childNode.getPrevId());
                addBeforeNode.setIsInterflow(Boolean.TRUE);
                childNode.setPrevId(nodeCode);
                childNode.setIsInterflow(null);
                addBeforeNode.setChildNode(childNode);
                childNode = addBeforeNode;
            }
            if (haschildNode) {
                Properties properties;
                ChildNode nextNode = childNode.getChildNode();
                if (nextNode.getNodeId().equals(currentNodeCode) && freeApprovalType.equals("before")) {
                    properties = new Properties();
                    properties.setCounterSign(counterSign);
                    ChildNode addBeforeNode = new ChildNode();
                    properties.setTitle("\u52a0\u7b7e\u5ba1\u6279");
                    addBeforeNode.setType("approver");
                    addBeforeNode.setProperties(properties);
                    addBeforeNode.setContent("\u6307\u5b9a\u52a0\u7b7e\u4eba\u5458");
                    addBeforeNode.setConditionType(null);
                    addBeforeNode.setConditionNodes(null);
                    addBeforeNode.setNodeId(nodeCode);
                    addBeforeNode.setPrevId(nextNode.getPrevId());
                    nextNode.setPrevId(nodeCode);
                    addBeforeNode.setChildNode(nextNode);
                    childNode.setChildNode(addBeforeNode);
                } else if (nextNode.getNodeId().equals(currentNodeCode) && freeApprovalType.equals("after")) {
                    properties = new Properties();
                    properties.setCounterSign(counterSign);
                    ChildNode addAfterNode = new ChildNode();
                    properties.setTitle("\u52a0\u7b7e\u5ba1\u6279");
                    addAfterNode.setType("approver");
                    addAfterNode.setProperties(properties);
                    addAfterNode.setContent("\u6307\u5b9a\u52a0\u7b7e\u4eba\u5458");
                    addAfterNode.setConditionType(null);
                    addAfterNode.setConditionNodes(null);
                    addAfterNode.setNodeId(nodeCode);
                    addAfterNode.setPrevId(nextNode.getNodeId());
                    if (ObjectUtil.isNotNull((Object)nextNode.getChildNode())) {
                        ChildNode afterNode = nextNode.getChildNode();
                        afterNode.setPrevId(nodeCode);
                        addAfterNode.setChildNode(afterNode);
                    }
                    addAfterNode.setConditionType(nextNode.getConditionType());
                    addAfterNode.setConditionNodes(nextNode.getConditionNodes());
                    nextNode.setChildNode(addAfterNode);
                    nextNode.setConditionType(null);
                    nextNode.setConditionNodes(null);
                } else {
                    childNode.setChildNode(FlowJsonUtil.addFreeApprovalNode(nextNode, currentNodeCode, freeApprovalType, addApprovalUser, nodeCode, counterSign));
                }
            }
            if ((hasConditionNodes || hasInterflowNodes) && CollectionUtil.isNotEmpty(conditionNodes = childNode.getConditionNodes())) {
                ArrayList<ChildNode> conditionNodesNew = new ArrayList<ChildNode>();
                for (ChildNode conditionNode : conditionNodes) {
                    conditionNodesNew.add(FlowJsonUtil.addFreeApprovalNode(conditionNode, currentNodeCode, freeApprovalType, addApprovalUser, nodeCode, counterSign));
                }
                childNode.setConditionNodes(conditionNodesNew);
            }
        }
        return childNode;
    }

    private static void childListAll(ChildNode childNode, List<ChildNode> chilNodeList) {
        if (childNode != null) {
            boolean haschildNode;
            chilNodeList.add(childNode);
            boolean bl = haschildNode = childNode.getChildNode() != null;
            if (haschildNode) {
                ChildNode nextNode = childNode.getChildNode();
                FlowJsonUtil.childListAll(nextNode, chilNodeList);
            }
        }
    }

    public static void getTemplateAll(ChildNode childNode, List<ChildNodeList> childNodeListAll, List<ConditionList> conditionListAll) {
        ArrayList<ChildNode> chilNodeList = new ArrayList<ChildNode>();
        FlowJsonUtil.childListAll(childNode, chilNodeList);
        if (childNode != null) {
            String nodeId = childNode.getNodeId();
            String prevId = childNode.getPrevId();
            boolean haschildNode = childNode.getChildNode() != null;
            boolean hasconditionNodes = childNode.getConditionNodes() != null;
            Properties properties = childNode.getProperties();
            FlowJsonUtil.assignment(properties);
            ChildNodeList childNodeList = new ChildNodeList();
            childNodeList.setProperties(properties);
            DateProperties model = (DateProperties)JsonUtil.getJsonToBean((Object)properties, DateProperties.class);
            childNodeList.setTimer(model);
            Custom customModel = new Custom();
            customModel.setType(childNode.getType());
            customModel.setNum("0");
            customModel.setFirstId("");
            customModel.setChild(haschildNode);
            customModel.setNodeId(nodeId);
            customModel.setPrevId(prevId);
            customModel.setChildNode(haschildNode ? childNode.getChildNode().getNodeId() : "");
            if (hasconditionNodes) {
                boolean isFlow;
                childNodeList.setConditionType("condition");
                List conditionNodes = childNode.getConditionNodes().stream().filter(t -> t.getIsInterflow() != null).collect(Collectors.toList());
                boolean bl = isFlow = conditionNodes.size() > 0;
                if (isFlow) {
                    customModel.setFlow(isFlow);
                    childNodeList.setConditionType("interflow");
                    List flowIdAll = conditionNodes.stream().map(t -> t.getNodeId()).collect(Collectors.toList());
                    customModel.setFlowId(String.join((CharSequence)",", flowIdAll));
                }
            }
            childNodeList.setCustom(customModel);
            childNodeListAll.add(childNodeList);
            String firstId = "";
            if (haschildNode) {
                firstId = childNode.getChildNode().getNodeId();
            }
            if (hasconditionNodes) {
                FlowJsonUtil.conditionList(childNode, firstId, childNodeListAll, conditionListAll, chilNodeList);
            }
            if (haschildNode) {
                FlowJsonUtil.getchildNode(childNode, firstId, childNodeListAll, conditionListAll, chilNodeList);
            }
        }
    }

    private static void getchildNode(ChildNode parentChildNodeTest, String firstId, List<ChildNodeList> childNodeListAll, List<ConditionList> conditionListAll, List<ChildNode> chilNodeList) {
        ChildNode childNode = parentChildNodeTest.getChildNode();
        if (childNode != null) {
            String nodeId = childNode.getNodeId();
            String prevId = childNode.getPrevId();
            boolean haschildNode = childNode.getChildNode() != null;
            boolean hasconditionNodes = childNode.getConditionNodes() != null;
            Properties properModel = childNode.getProperties();
            FlowJsonUtil.assignment(properModel);
            ChildNodeList childNodeList = new ChildNodeList();
            childNodeList.setProperties(properModel);
            DateProperties model = (DateProperties)JsonUtil.getJsonToBean((Object)properModel, DateProperties.class);
            childNodeList.setTimer(model);
            Custom customModel = new Custom();
            customModel.setType(childNode.getType());
            boolean isFirst = chilNodeList.stream().filter(t -> t.getNodeId().equals(nodeId)).count() > 0L;
            customModel.setNum(isFirst ? "0" : "1");
            customModel.setFirstId(firstId);
            if (isFirst) {
                customModel.setFirstId(haschildNode ? childNode.getChildNode().getNodeId() : "");
            }
            customModel.setChild(haschildNode);
            customModel.setNodeId(nodeId);
            customModel.setPrevId(prevId);
            customModel.setChildNode(haschildNode ? childNode.getChildNode().getNodeId() : "");
            if (hasconditionNodes) {
                boolean isFlow;
                childNodeList.setConditionType("condition");
                List conditionNodes = childNode.getConditionNodes().stream().filter(t -> t.getIsInterflow() != null).collect(Collectors.toList());
                boolean bl = isFlow = conditionNodes.size() > 0;
                if (isFlow) {
                    customModel.setFlow(isFlow);
                    childNodeList.setConditionType("interflow");
                    List flowIdAll = conditionNodes.stream().map(t -> t.getNodeId()).collect(Collectors.toList());
                    customModel.setFlowId(String.join((CharSequence)",", flowIdAll));
                }
            }
            childNodeList.setCustom(customModel);
            childNodeListAll.add(childNodeList);
            if (hasconditionNodes) {
                FlowJsonUtil.conditionList(childNode, firstId, childNodeListAll, conditionListAll, chilNodeList);
            }
            if (haschildNode) {
                FlowJsonUtil.getchildNode(childNode, firstId, childNodeListAll, conditionListAll, chilNodeList);
            }
        }
    }

    private static void conditionList(ChildNode childNode, String firstId, List<ChildNodeList> childNodeListAll, List<ConditionList> conditionListAll, List<ChildNode> chilNodeList) {
        List<ChildNode> conditionNodes = childNode.getConditionNodes();
        if (conditionNodes.size() > 0) {
            ChildNode childNodeModel = childNode.getChildNode();
            if (childNodeModel != null) {
                firstId = childNodeModel.getNodeId();
            } else {
                ChildNode nodes = chilNodeList.stream().filter(t -> t.getNodeId().equals(childNode.getNodeId())).findFirst().orElse(null);
                if (nodes != null) {
                    firstId = nodes.getChildNode() != null ? childNode.getChildNode().getNodeId() : "";
                }
            }
            for (ChildNode node : conditionNodes) {
                boolean conditionType;
                boolean bl = conditionType = node.getIsInterflow() == null;
                if (conditionType) {
                    FlowJsonUtil.getCondition(node, firstId, childNodeListAll, conditionListAll, chilNodeList);
                    continue;
                }
                FlowJsonUtil.getConditonFlow(node, firstId, childNodeListAll, conditionListAll, chilNodeList);
            }
        }
    }

    private static void getCondition(ChildNode childNode, String firstId, List<ChildNodeList> childNodeListAll, List<ConditionList> conditionListAll, List<ChildNode> chilNodeList) {
        if (childNode != null) {
            String nodeId = childNode.getNodeId();
            String prevId = childNode.getPrevId();
            boolean haschildNode = childNode.getChildNode() != null;
            boolean hasconditionNodes = childNode.getConditionNodes() != null;
            boolean isDefault = childNode.getProperties().getIsDefault() != null ? childNode.getProperties().getIsDefault() : false;
            ConditionList conditionList = new ConditionList();
            conditionList.setNodeId(nodeId);
            conditionList.setPrevId(prevId);
            conditionList.setChild(haschildNode);
            conditionList.setTitle(childNode.getProperties().getTitle());
            conditionList.setConditions(childNode.getProperties().getConditions());
            conditionList.setChildNodeId(haschildNode ? childNode.getChildNode().getNodeId() : "");
            conditionList.setIsDefault(isDefault);
            conditionList.setFirstId(firstId);
            if (hasconditionNodes) {
                boolean isFlow;
                List conditionNodes = childNode.getConditionNodes().stream().filter(t -> t.getIsInterflow() != null).collect(Collectors.toList());
                boolean bl = isFlow = conditionNodes.size() > 0;
                if (isFlow) {
                    conditionList.setFlow(isFlow);
                    List flowIdAll = conditionNodes.stream().map(t -> t.getNodeId()).collect(Collectors.toList());
                    conditionList.setFlowId(String.join((CharSequence)",", flowIdAll));
                }
            }
            conditionListAll.add(conditionList);
            if (hasconditionNodes) {
                FlowJsonUtil.conditionList(childNode, firstId, childNodeListAll, conditionListAll, chilNodeList);
            }
            if (haschildNode) {
                FlowJsonUtil.getchildNode(childNode, firstId, childNodeListAll, conditionListAll, chilNodeList);
            }
        }
    }

    private static void getConditonFlow(ChildNode childNode, String firstId, List<ChildNodeList> childNodeListAll, List<ConditionList> conditionListAll, List<ChildNode> chilNodeList) {
        if (childNode != null) {
            String nodeId = childNode.getNodeId();
            String prevId = childNode.getPrevId();
            boolean haschildNode = childNode.getChildNode() != null;
            boolean hasconditionNodes = childNode.getConditionNodes() != null;
            Properties properties = childNode.getProperties();
            FlowJsonUtil.assignment(properties);
            ChildNodeList childNodeList = new ChildNodeList();
            childNodeList.setProperties(properties);
            DateProperties model = (DateProperties)JsonUtil.getJsonToBean((Object)properties, DateProperties.class);
            childNodeList.setTimer(model);
            Custom customModel = new Custom();
            customModel.setType(childNode.getType());
            customModel.setNum("1");
            customModel.setFirstId(firstId);
            customModel.setChild(haschildNode);
            customModel.setChildNode(haschildNode ? childNode.getChildNode().getNodeId() : "");
            customModel.setNodeId(nodeId);
            customModel.setPrevId(prevId);
            if (hasconditionNodes) {
                boolean isFlow;
                childNodeList.setConditionType("condition");
                List conditionNodes = childNode.getConditionNodes().stream().filter(t -> t.getIsInterflow() != null).collect(Collectors.toList());
                boolean bl = isFlow = conditionNodes.size() > 0;
                if (isFlow) {
                    customModel.setFlow(isFlow);
                    childNodeList.setConditionType("interflow");
                    List flowIdAll = conditionNodes.stream().map(t -> t.getNodeId()).collect(Collectors.toList());
                    customModel.setFlowId(String.join((CharSequence)",", flowIdAll));
                }
            }
            childNodeList.setCustom(customModel);
            childNodeListAll.add(childNodeList);
            if (hasconditionNodes) {
                FlowJsonUtil.conditionList(childNode, firstId, childNodeListAll, conditionListAll, chilNodeList);
            }
            if (haschildNode) {
                FlowJsonUtil.getchildNode(childNode, firstId, childNodeListAll, conditionListAll, chilNodeList);
            }
        }
    }

    public static void assignment(Properties properties) {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowJsonUtil)) {
            return false;
        }
        FlowJsonUtil other = (FlowJsonUtil)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlowJsonUtil;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "FlowJsonUtil()";
    }
}

