/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.engine.util;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.service.FlowTaskNewService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.bringspring.workflow.engine.util.FlowNature;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FlowUtil {
    public static FlowTaskEntity getFlowTaskSubmited(String taskId, SFunction<FlowTaskEntity, ?> ... columns) {
        FlowTaskService flowTaskService = (FlowTaskService)SpringContext.getBean(FlowTaskService.class);
        return flowTaskService.getInfoSubmit(taskId, columns);
    }

    public static List<FlowTaskEntity> getFlowTaskListSubmited(String[] taskIds, SFunction<FlowTaskEntity, ?> ... columns) {
        FlowTaskService flowTaskService = (FlowTaskService)SpringContext.getBean(FlowTaskService.class);
        return flowTaskService.getInfosSubmit(taskIds, columns);
    }

    public static void saveOrSubmit(String flowTaskId, String flowEngineId, String templateId, String processId, Object formEntity, Integer flowStatus, String title) throws WorkFlowException {
        HashMap map = (HashMap)JsonUtil.getJsonToBean((Object)formEntity, HashMap.class);
        String flowName = map.containsKey("flowName") ? map.get("flowName").toString() : null;
        UserProvider userProvider = (UserProvider)SpringContext.getBean(UserProvider.class);
        FlowEngineService flowEngineService = (FlowEngineService)SpringContext.getBean(FlowEngineService.class);
        FlowEngineEntity flowEngineEntity = flowEngineService.getInfo(flowEngineId);
        StringBuilder flowTitle = new StringBuilder();
        flowTitle = new StringBuilder(userProvider.get().getUserName() + "\u63d0\u4ea4\u7684");
        if (StringUtils.isNotEmpty((String)title)) {
            flowTitle.append("\u300a").append(title).append("\u300b");
        }
        if (StringUtils.isNotBlank((CharSequence)flowName)) {
            flowTitle.append(flowName);
        } else {
            flowTitle.append(flowEngineEntity.getFullName());
        }
        title = flowTitle.toString();
        if (ObjectUtil.isNotNull((Object)flowStatus) && flowStatus == FlowTaskStatusEnum.Draft.getCode()) {
            FlowUtil.save(flowTaskId, flowEngineId, templateId, processId, formEntity, title);
        } else if (ObjectUtil.isNotNull((Object)flowStatus) && flowStatus == FlowTaskStatusEnum.Handle.getCode()) {
            FlowUtil.submit(flowTaskId, flowEngineId, templateId, processId, formEntity, title);
        } else {
            throw new WorkFlowException("\u672a\u8bc6\u522b\u64cd\u4f5c\u4e3a\u6682\u5b58\u6216\u63d0\u4ea4");
        }
    }

    public static void saveOrSubmitForUserId(String flowTaskId, String flowEngineId, String templateId, String processId, Object formEntity, Integer flowStatus, String title, String userId) throws WorkFlowException {
        UserEntity userInfo;
        HashMap map = (HashMap)JsonUtil.getJsonToBean((Object)formEntity, HashMap.class);
        String flowName = map.containsKey("flowName") ? map.get("flowName").toString() : null;
        FlowEngineService flowEngineService = (FlowEngineService)SpringContext.getBean(FlowEngineService.class);
        FlowEngineEntity flowEngineEntity = flowEngineService.getInfo(flowEngineId);
        UserProvider userProvider = (UserProvider)SpringContext.getBean(UserProvider.class);
        ServiceAllUtil serviceAllUtil = (ServiceAllUtil)SpringContext.getBean(ServiceAllUtil.class);
        StringBuilder flowTitle = new StringBuilder();
        flowTitle = ObjectUtil.isNotEmpty((Object)userId) ? (ObjectUtil.isNotEmpty((Object)(userInfo = serviceAllUtil.getUserInfo(userId))) ? new StringBuilder(userInfo.getRealName() + "\u63d0\u4ea4\u7684") : new StringBuilder(userProvider.get().getUserName() + "\u63d0\u4ea4\u7684")) : new StringBuilder(userProvider.get().getUserName() + "\u63d0\u4ea4\u7684");
        if (StringUtils.isNotEmpty((String)title)) {
            flowTitle.append("\u300a").append(title).append("\u300b");
        }
        if (StringUtils.isNotBlank((CharSequence)flowName)) {
            flowTitle.append(flowName);
        } else {
            flowTitle.append(flowEngineEntity.getFullName());
        }
        title = flowTitle.toString();
        if (ObjectUtil.isNotNull((Object)flowStatus) && flowStatus == FlowTaskStatusEnum.Draft.getCode()) {
            FlowUtil.save(flowTaskId, flowEngineId, templateId, processId, formEntity, title, userId);
        } else if (ObjectUtil.isNotNull((Object)flowStatus) && flowStatus == FlowTaskStatusEnum.Handle.getCode()) {
            FlowUtil.submit(flowTaskId, flowEngineId, templateId, processId, formEntity, title, userId);
        } else {
            throw new WorkFlowException("\u672a\u8bc6\u522b\u64cd\u4f5c\u4e3a\u6682\u5b58\u6216\u63d0\u4ea4");
        }
    }

    public static void saveOrSubmit(String flowTaskId, String flowEngineId, String templateId, String processId, Object formEntity, Integer flowStatus) throws WorkFlowException {
        HashMap map = (HashMap)JsonUtil.getJsonToBean((Object)formEntity, HashMap.class);
        String titleStr = map.containsKey("title") ? map.get("title").toString() : null;
        String flowName = map.containsKey("flowName") ? map.get("flowName").toString() : null;
        UserProvider userProvider = (UserProvider)SpringContext.getBean(UserProvider.class);
        FlowEngineService flowEngineService = (FlowEngineService)SpringContext.getBean(FlowEngineService.class);
        FlowEngineEntity flowEngineEntity = flowEngineService.getInfo(flowEngineId);
        StringBuilder flowTitle = new StringBuilder();
        flowTitle = new StringBuilder(userProvider.get().getUserName() + "\u63d0\u4ea4\u7684");
        if (StringUtils.isNotEmpty((String)titleStr)) {
            flowTitle.append("\u300a").append(titleStr).append("\u300b");
        }
        if (StringUtils.isNotBlank((CharSequence)flowName)) {
            flowTitle.append(flowName);
        } else {
            flowTitle.append(flowEngineEntity.getFullName());
        }
        titleStr = flowTitle.toString();
        if (ObjectUtil.isNotNull((Object)flowStatus) && flowStatus == FlowTaskStatusEnum.Draft.getCode()) {
            FlowUtil.save(flowTaskId, flowEngineId, templateId, processId, formEntity, titleStr);
        } else if (ObjectUtil.isNotNull((Object)flowStatus) && flowStatus == FlowTaskStatusEnum.Handle.getCode()) {
            FlowUtil.submit(flowTaskId, flowEngineId, templateId, processId, formEntity, titleStr);
        } else {
            throw new WorkFlowException("\u672a\u8bc6\u522b\u64cd\u4f5c\u4e3a\u6682\u5b58\u6216\u63d0\u4ea4");
        }
    }

    public static void save(String flowTaskId, String flowEngineId, String templateId, String processId, Object formEntity, String title) throws WorkFlowException {
        FlowEngineService flowEngineService = (FlowEngineService)SpringContext.getBean(FlowEngineService.class);
        FlowEngineEntity flowEngineEntity = flowEngineService.getInfo(flowEngineId);
        FlowTaskNewService flowTaskNewService = (FlowTaskNewService)SpringContext.getBean(FlowTaskNewService.class);
        UserProvider userProvider = (UserProvider)SpringContext.getBean(UserProvider.class);
        String billNo = DateUtil.getNow();
        FlowModel flowModel = FlowUtil.assignment(flowTaskId, flowEngineId, templateId, processId, title, 1, billNo, formEntity, null, new HashMap<String, List<String>>());
        flowModel.setStatus(FlowTaskStatusEnum.Draft.getCode());
        flowTaskNewService.save(flowModel);
    }

    public static void save(String flowTaskId, String flowEngineId, String templateId, String processId, Object formEntity, String title, String userId) throws WorkFlowException {
        FlowEngineService flowEngineService = (FlowEngineService)SpringContext.getBean(FlowEngineService.class);
        FlowEngineEntity flowEngineEntity = flowEngineService.getInfo(flowEngineId);
        FlowTaskNewService flowTaskNewService = (FlowTaskNewService)SpringContext.getBean(FlowTaskNewService.class);
        UserProvider userProvider = (UserProvider)SpringContext.getBean(UserProvider.class);
        String billNo = DateUtil.getNow();
        FlowModel flowModel = FlowUtil.assignment(flowTaskId, flowEngineId, templateId, processId, title, 1, billNo, formEntity, userId, new HashMap<String, List<String>>());
        flowModel.setStatus(FlowTaskStatusEnum.Draft.getCode());
        flowTaskNewService.save(flowModel);
    }

    public static void save(String id, String flowEngineId, String templateId, String processId, String flowTitle, int flowUrgent, String billNo, Object formEntity) throws WorkFlowException {
        FlowTaskNewService flowTaskNewService = (FlowTaskNewService)SpringContext.getBean(FlowTaskNewService.class);
        FlowModel flowModel = FlowUtil.assignment(id, flowEngineId, templateId, processId, flowTitle, flowUrgent, billNo, formEntity, null, new HashMap<String, List<String>>());
        flowModel.setStatus(FlowTaskStatusEnum.Draft.getCode());
        flowTaskNewService.save(flowModel);
    }

    public static void submit(String flowTaskId, String flowEngineId, String templateId, String processId, Object formEntity, String title) throws WorkFlowException {
        FlowEngineService flowEngineService = (FlowEngineService)SpringContext.getBean(FlowEngineService.class);
        FlowEngineEntity flowEngineEntity = flowEngineService.getInfo(flowEngineId);
        UserProvider userProvider = (UserProvider)SpringContext.getBean(UserProvider.class);
        FlowTaskService flowTaskService = (FlowTaskService)SpringContext.getBean(FlowTaskService.class);
        FlowTaskEntity flowTaskEntity = flowTaskService.getInfoSubmit(flowTaskId, FlowTaskEntity::getId);
        String id = null;
        if (ObjectUtil.isNotNull((Object)flowTaskEntity)) {
            id = flowTaskEntity.getId();
        }
        String billNo = flowEngineEntity.getEnCode() + DateUtil.getNow();
        FlowUtil.submit(id, flowEngineId, templateId, processId, title, 1, billNo, formEntity, null, new HashMap<String, List<String>>());
    }

    public static void submit(String flowTaskId, String flowEngineId, String templateId, String processId, Object formEntity, String title, String userId) throws WorkFlowException {
        FlowEngineService flowEngineService = (FlowEngineService)SpringContext.getBean(FlowEngineService.class);
        FlowEngineEntity flowEngineEntity = flowEngineService.getInfo(flowEngineId);
        UserProvider userProvider = (UserProvider)SpringContext.getBean(UserProvider.class);
        ServiceAllUtil serviceAllUtil = (ServiceAllUtil)SpringContext.getBean(ServiceAllUtil.class);
        FlowTaskService flowTaskService = (FlowTaskService)SpringContext.getBean(FlowTaskService.class);
        FlowTaskEntity flowTaskEntity = flowTaskService.getInfoSubmit(flowTaskId, FlowTaskEntity::getId);
        String id = null;
        if (ObjectUtil.isNotNull((Object)flowTaskEntity)) {
            id = flowTaskEntity.getId();
        }
        String billNo = flowEngineEntity.getEnCode() + DateUtil.getNow();
        FlowUtil.submit(id, flowEngineId, templateId, processId, title, 1, billNo, formEntity, userId, new HashMap<String, List<String>>());
    }

    public static void submit(String id, String flowEngineId, String templateId, String processId, String flowTitle, int flowUrgent, String billNo, Object formEntity, String freeApproverUserId) throws WorkFlowException {
        FlowUtil.submit(id, flowEngineId, processId, templateId, flowTitle, flowUrgent, billNo, formEntity, freeApproverUserId, new HashMap<String, List<String>>());
    }

    public static void submit(String id, String flowEngineId, String templateId, String processId, String flowTitle, int flowUrgent, String billNo, Object formEntity, String freeApproverUserId, Map<String, List<String>> candidateList) throws WorkFlowException {
        FlowTaskNewService flowTaskNewService = (FlowTaskNewService)SpringContext.getBean(FlowTaskNewService.class);
        FlowModel flowModel = FlowUtil.assignment(id, flowEngineId, templateId, processId, flowTitle, flowUrgent, billNo, formEntity, freeApproverUserId, candidateList);
        flowTaskNewService.submit(flowModel);
    }

    private static FlowModel assignment(String id, String flowEngineId, String templateId, String processId, String flowTitle, int flowUrgent, String billNo, Object formEntity, String freeApproverUserId, Map<String, List<String>> candidateList) {
        String copyIds;
        FlowModel flowModel = new FlowModel();
        flowModel.setId(id);
        flowModel.setFlowId(flowEngineId);
        flowModel.setTemplateId(templateId);
        flowModel.setProcessId(processId);
        flowModel.setFlowTitle(flowTitle);
        flowModel.setFlowUrgent(flowUrgent);
        flowModel.setBillNo(billNo);
        Map data = JsonUtil.entityToMap((Object)formEntity);
        if (data.containsKey("copyIds") && ObjectUtil.isNotEmpty((Object)(copyIds = data.get("copyIds").toString()))) {
            flowModel.setCopyIds(copyIds);
        }
        flowModel.setFormData(data);
        flowModel.setFreeApproverUserId(freeApproverUserId);
        if (ObjectUtil.isNotEmpty((Object)flowModel.getFreeApproverUserId())) {
            flowModel.setUserId(flowModel.getFreeApproverUserId());
        }
        flowModel.setParentId(FlowNature.ParentId);
        flowModel.setIsAsync(false);
        flowModel.setCandidateList(candidateList);
        return flowModel;
    }

    public static void delete(String flowTaskId) throws WorkFlowException {
        FlowTaskService flowTaskService = (FlowTaskService)SpringContext.getBean(FlowTaskService.class);
        FlowTaskEntity flowTaskEntity = flowTaskService.getInfo(flowTaskId);
        flowTaskService.delete(flowTaskEntity);
    }

    public static void deleteByProcessId(String processId) throws WorkFlowException {
        FlowTaskService flowTaskService = (FlowTaskService)SpringContext.getBean(FlowTaskService.class);
        FlowTaskEntity flowTaskEntity = flowTaskService.getDraftTaskByProcessId(processId);
        flowTaskService.delete(flowTaskEntity);
    }
}

