/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.engine.service.impl;

import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.model.visiual.FormCloumnUtil;
import com.bringspring.common.model.visiual.FormDataModel;
import com.bringspring.common.model.visiual.RecursionForm;
import com.bringspring.common.model.visiual.TableModel;
import com.bringspring.common.model.visiual.fields.FieLdsModel;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import com.bringspring.workflow.engine.model.DataModel;
import com.bringspring.workflow.engine.model.flowtask.FlowTaskForm;
import com.bringspring.workflow.engine.model.flowtask.FlowTaskInfoVO;
import com.bringspring.workflow.engine.service.FlowDynamicService;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.service.FlowTaskOperatorService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.bringspring.workflow.engine.util.FlowDataUtil;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowDynamicServiceImpl
implements FlowDynamicService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlowDynamicServiceImpl.class);
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private FlowEngineService flowEngineService;
    @Autowired
    private FlowTaskOperatorService flowTaskOperatorService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private FlowDataUtil flowDataUtil;
    @Autowired
    private ServiceAllUtil serviceUtil;

    @Override
    public FlowTaskInfoVO info(FlowTaskEntity entity, String taskOperatorId) throws WorkFlowException {
        FlowEngineEntity flowEntity = this.flowEngineService.getInfo(entity.getFlowId());
        List tableModelList = JsonUtil.getJsonToList((String)flowEntity.getFlowTables(), TableModel.class);
        FlowTaskInfoVO vo = (FlowTaskInfoVO)JsonUtil.getJsonToBean((Object)entity, FlowTaskInfoVO.class);
        FormDataModel formData = (FormDataModel)JsonUtil.getJsonToBean((String)entity.getFlowForm(), FormDataModel.class);
        List list = JsonUtil.getJsonToList((String)formData.getFields(), FieLdsModel.class);
        DbLinkEntity link = this.serviceUtil.getDbLink(flowEntity.getDbLinkId());
        HashMap<String, Object> dataMap = StringUtils.isNotEmpty((String)entity.getFlowFormContentJson()) ? JsonUtil.stringToMap((String)entity.getFlowFormContentJson()) : new HashMap(16);
        DataModel dataModel = DataModel.builder().dataNewMap(dataMap).fieLdsModelList(list).tableModelList(tableModelList).mainId(entity.getProcessId()).link(link).build();
        Map<String, Object> result = this.flowDataUtil.info(dataModel);
        vo.setData(JsonUtil.getObjectToString(result));
        return vo;
    }

    @Override
    public void save(String id, FlowTaskForm flowTaskForm) throws WorkFlowException {
        boolean type;
        String flowId = flowTaskForm.getFlowId();
        String data = flowTaskForm.getData();
        FlowEngineEntity entity = this.flowEngineService.getInfo(flowId);
        UserInfo info = this.userProvider.get();
        String billNo = "\u5355\u636e\u89c4\u5219\u4e0d\u5b58\u5728";
        String title = info.getRealName() + "\u7684" + entity.getFullName();
        String formId = RandomUtil.uuId();
        List tableModelList = JsonUtil.getJsonToList((String)entity.getFlowTables(), TableModel.class);
        FormDataModel formData = (FormDataModel)JsonUtil.getJsonToBean((String)entity.getFormData(), FormDataModel.class);
        List list = JsonUtil.getJsonToList((String)formData.getFields(), FieLdsModel.class);
        RecursionForm recursionForm = new RecursionForm(list, tableModelList);
        ArrayList formAllModel = new ArrayList();
        FormCloumnUtil.recursionForm((RecursionForm)recursionForm, formAllModel);
        HashMap billData = new HashMap(16);
        boolean bl = type = id != null;
        if (type) {
            formId = id;
        }
        Map dataMap = JsonUtil.stringToMap((String)data);
        DbLinkEntity link = this.serviceUtil.getDbLink(entity.getDbLinkId());
        DataModel dataModel = DataModel.builder().dataNewMap(dataMap).fieLdsModelList(list).tableModelList(tableModelList).mainId(formId).link(link).build();
        Map<String, Object> result = type ? this.flowDataUtil.update(dataModel) : this.flowDataUtil.create(dataModel);
        FlowUtil.saveOrSubmit(flowTaskForm.getTaskId(), flowId, flowTaskForm.getTemplateId(), formId, result, FlowTaskStatusEnum.Draft.getCode());
    }

    @Override
    public void submit(String id, FlowTaskForm flowTaskForm) throws WorkFlowException {
        boolean type;
        String flowId = flowTaskForm.getFlowId();
        String data = flowTaskForm.getData();
        String freeUserId = flowTaskForm.getFreeApproverUserId();
        Map<String, List<String>> candidateList = flowTaskForm.getCandidateList();
        FlowEngineEntity entity = this.flowEngineService.getInfo(flowId);
        UserInfo info = this.userProvider.get();
        String billNo = "\u5355\u636e\u89c4\u5219\u4e0d\u5b58\u5728";
        String title = info.getRealName() + "\u7684" + entity.getFullName();
        String formId = RandomUtil.uuId();
        List tableModelList = JsonUtil.getJsonToList((String)entity.getFlowTables(), TableModel.class);
        FormDataModel formData = (FormDataModel)JsonUtil.getJsonToBean((String)entity.getFormData(), FormDataModel.class);
        List list = JsonUtil.getJsonToList((String)formData.getFields(), FieLdsModel.class);
        ArrayList formAllModel = new ArrayList();
        RecursionForm recursionForm = new RecursionForm(list, tableModelList);
        FormCloumnUtil.recursionForm((RecursionForm)recursionForm, formAllModel);
        HashMap billData = new HashMap(16);
        boolean bl = type = id != null;
        if (type) {
            formId = id;
        }
        Map dataMap = JsonUtil.stringToMap((String)data);
        DbLinkEntity link = this.serviceUtil.getDbLink(entity.getDbLinkId());
        DataModel dataModel = DataModel.builder().dataNewMap(dataMap).fieLdsModelList(list).tableModelList(tableModelList).mainId(formId).link(link).build();
        Map<String, Object> result = type ? this.flowDataUtil.update(dataModel) : this.flowDataUtil.create(dataModel);
        FlowUtil.saveOrSubmit(flowTaskForm.getTaskId(), flowId, flowTaskForm.getTemplateId(), formId, result, FlowTaskStatusEnum.Handle.getCode());
    }

    @Override
    public Map<String, Object> getData(String flowId, String id) throws WorkFlowException {
        FlowTaskEntity entity = this.flowTaskService.getInfo(id);
        FlowEngineEntity flowentity = this.flowEngineService.getInfo(flowId);
        List tableModelList = JsonUtil.getJsonToList((String)flowentity.getFlowTables(), TableModel.class);
        FormDataModel formData = (FormDataModel)JsonUtil.getJsonToBean((String)entity.getFlowForm(), FormDataModel.class);
        List list = JsonUtil.getJsonToList((String)formData.getFields(), FieLdsModel.class);
        DbLinkEntity link = this.serviceUtil.getDbLink(flowentity.getDbLinkId());
        HashMap<String, Object> dataMap = StringUtils.isNotEmpty((String)entity.getFlowFormContentJson()) ? JsonUtil.stringToMap((String)entity.getFlowFormContentJson()) : new HashMap(16);
        DataModel dataModel = DataModel.builder().dataNewMap(dataMap).fieLdsModelList(list).tableModelList(tableModelList).mainId(entity.getId()).link(link).convert(true).build();
        Map<String, Object> resultData = this.flowDataUtil.info(dataModel);
        return resultData;
    }
}

