package com.bringspring.workflow.engine.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 流程引擎
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Data
@TableName("FLOW_ENGINE")
public class FlowEngineEntity {
    /**
     * 流程主键
     */
    @TableId("ID")
    private String id;

    /**
     * 流程编码
     */
    @TableField("ENCODE")
    private String enCode;

    /**
     * 流程名称
     */
    @TableField("FULL_NAME")
    private String fullName;

    /**
     * 流程类型(0.发起流程 1.功能流程)
     */
    @TableField("TYPE")
    private Integer type;

    /**
     * 流程分类
     */
    @TableField("CATEGORY")
    private String category;

  /*  *//**
     * 可见类型 0-全部可见、1-指定经办
     *//*
    @TableField("VISIBLE_TYPE")
    private Integer visibleType;*/


    /**
     * 图标
     */
    @TableField("ICON")
    private String icon;

    /**
     * 图标背景色
     */
    @TableField("ICON_BACKGROUND")
    private String iconBackground;

    /**
     * 流程版本
     */
    @TableField("VERSION")
    private String version;

    /**
     * 表单字段
     */
    @TableField("FORM_TEMPLATE_JSON")
    private String formData;

    /**
     * 表单分类(1.系统表单 2.自定义表单)
     */
    @TableField("FORM_TYPE")
    private Integer formType;

    /**
     * 流程引擎
     */
   /* @TableField("FLOW_TEMPLATE_JSON")
    private String flowTemplateJson;*/

    /**
     * 描述
     */
    @TableField("DESCRIPTION")
    private String description;

    /**
     * 列表
     */
    @TableField("TABLES")
    @JSONField(name = "tables")
    private String flowTables;

    /**
     * 数据连接
     */
    @TableField("DB_LINK_ID")
    private String dbLinkId;

    /**
     * app表单路径
     */
    @TableField("APP_FORM_URL")
    private String appFormUrl;

    /**
     * pc表单路径
     */
    @TableField("FORM_URL")
    private String formUrl;

    /**
     * 排序码
     */
    @TableField("SORT_CODE")
    private Long sortCode;

    /**
     * 有效标志
     */
    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID",fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME",fill = FieldFill.UPDATE)
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID",fill = FieldFill.UPDATE)
    private String lastModifyUserId;

    /**
     * 删除标志
     */
    @TableField("DELETE_MARK")
    private Integer deleteMark;

    /**
     * 删除时间
     */
    @TableField("DELETE_TIME")
    private Date deleteTime;

    /**
     * 删除用户
     */
    @TableField("DELETE_USER_ID")
    private String deleteUserId;

    /**
     * 流程引擎下的模板
     */
    @TableField(exist = false)
    private List<FlowEngineTemplateEntity> templateList;


}
