/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.engine.controller;

import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.workflow.engine.entity.FlowDelegateEntity;
import com.bringspring.workflow.engine.model.flowdelegate.FlowDelegatListVO;
import com.bringspring.workflow.engine.model.flowdelegate.FlowDelegateCrForm;
import com.bringspring.workflow.engine.model.flowdelegate.FlowDelegateInfoVO;
import com.bringspring.workflow.engine.model.flowdelegate.FlowDelegateUpForm;
import com.bringspring.workflow.engine.service.FlowDelegateService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u6d41\u7a0b\u59d4\u6258", description="FlowDelegate")
@RestController
@RequestMapping(value={"/api/workflow/Engine/FlowDelegate"})
public class FlowDelegateController {
    @Autowired
    private FlowDelegateService flowDelegateService;
    @Autowired
    private UserProvider userProvider;

    @Operation(summary="\u83b7\u53d6\u6d41\u7a0b\u59d4\u6258\u5217\u8868")
    @GetMapping
    public ActionResult<PageListVO<FlowDelegatListVO>> list(Pagination pagination) {
        List<FlowDelegateEntity> list = this.flowDelegateService.getList(pagination);
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)pagination, PaginationVO.class);
        List listVO = JsonUtil.getJsonToList(list, FlowDelegatListVO.class);
        return ActionResult.page((List)listVO, (PaginationVO)paginationVO);
    }

    @Operation(summary="\u83b7\u53d6\u6d41\u7a0b\u59d4\u6258\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<FlowDelegateInfoVO> info(@PathVariable(value="id") String id) throws DataException {
        FlowDelegateEntity entity = this.flowDelegateService.getInfo(id);
        FlowDelegateInfoVO vo = (FlowDelegateInfoVO)JsonUtilEx.getJsonToBeanEx((Object)entity, FlowDelegateInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u65b0\u5efa\u6d41\u7a0b\u59d4\u6258")
    @PostMapping
    public ActionResult create(@RequestBody @Valid FlowDelegateCrForm flowDelegateCrForm) {
        FlowDelegateEntity entity = (FlowDelegateEntity)JsonUtil.getJsonToBean((Object)flowDelegateCrForm, FlowDelegateEntity.class);
        UserInfo userInfo = this.userProvider.get();
        if (userInfo.getUserId().equals(entity.getToUserid())) {
            return ActionResult.fail((String)"\u59d4\u6258\u4eba\u4e3a\u81ea\u5df1\uff0c\u59d4\u6258\u5931\u8d25");
        }
        this.flowDelegateService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @Operation(summary="\u66f4\u65b0\u6d41\u7a0b\u59d4\u6258")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid FlowDelegateUpForm flowDelegateUpForm) {
        FlowDelegateEntity entity = (FlowDelegateEntity)JsonUtil.getJsonToBean((Object)flowDelegateUpForm, FlowDelegateEntity.class);
        UserInfo userInfo = this.userProvider.get();
        if (userInfo.getUserId().equals(entity.getToUserid())) {
            return ActionResult.fail((String)"\u59d4\u6258\u4eba\u4e3a\u81ea\u5df1\uff0c\u59d4\u6258\u5931\u8d25");
        }
        boolean flag = this.flowDelegateService.update(id, entity);
        if (!flag) {
            return ActionResult.success((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @Operation(summary="\u5220\u9664\u6d41\u7a0b\u59d4\u6258")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        FlowDelegateEntity entity = this.flowDelegateService.getInfo(id);
        if (entity != null) {
            this.flowDelegateService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }
}

