/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.form.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.base.util.RegexUtils;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import com.bringspring.workflow.form.entity.LeaveApplyEntity;
import com.bringspring.workflow.form.model.leaveapply.LeaveApplyForm;
import com.bringspring.workflow.form.model.leaveapply.LeaveApplyInfoVO;
import com.bringspring.workflow.form.service.LeaveApplyService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u8bf7\u5047\u7533\u8bf7")
@RestController
@RequestMapping(value={"/api/workflow/Form/LeaveApply"})
public class LeaveApplyController {
    @Autowired
    private LeaveApplyService leaveApplyService;

    @Operation(summary="\u83b7\u53d6\u8bf7\u5047\u7533\u8bf7\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult info(@PathVariable(value="id") String id) {
        LeaveApplyEntity entity = this.leaveApplyService.getInfo(id);
        LeaveApplyInfoVO vo = (LeaveApplyInfoVO)JsonUtil.getJsonToBean((Object)entity, LeaveApplyInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u65b0\u5efa\u8bf7\u5047\u7533\u8bf7")
    @PostMapping
    public ActionResult create(@RequestBody @Valid LeaveApplyForm leaveApplyForm) throws WorkFlowException {
        if (leaveApplyForm.getLeaveStartTime() > leaveApplyForm.getLeaveEndTime()) {
            return ActionResult.fail((String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u8d77\u59cb\u65f6\u95f4");
        }
        if (!RegexUtils.checkLeave((String)leaveApplyForm.getLeaveDayCount())) {
            return ActionResult.fail((String)"\u8bf7\u5047\u5929\u6570\u53ea\u80fd\u662f0.5\u7684\u500d\u6570");
        }
        if (!RegexUtils.checkLeave((String)leaveApplyForm.getLeaveHour())) {
            return ActionResult.fail((String)"\u8bf7\u5047\u5c0f\u65f6\u53ea\u80fd\u662f0.5\u7684\u500d\u6570");
        }
        LeaveApplyEntity entity = (LeaveApplyEntity)JsonUtil.getJsonToBean((Object)leaveApplyForm, LeaveApplyEntity.class);
        if (FlowTaskStatusEnum.Draft.getCode().equals(leaveApplyForm.getStatus())) {
            this.leaveApplyService.save(entity.getId(), entity);
            return ActionResult.success((String)MsgCode.SU002.get());
        }
        this.leaveApplyService.submit(entity.getId(), entity, leaveApplyForm.getCandidateList());
        return ActionResult.success((String)MsgCode.SU006.get());
    }

    @Operation(summary="\u4fee\u6539\u8bf7\u5047\u7533\u8bf7")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@RequestBody @Valid LeaveApplyForm leaveApplyForm, @PathVariable(value="id") String id) throws WorkFlowException {
        if (leaveApplyForm.getLeaveStartTime() > leaveApplyForm.getLeaveEndTime()) {
            return ActionResult.fail((String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u8d77\u59cb\u65f6\u95f4");
        }
        if (!RegexUtils.checkLeave((String)leaveApplyForm.getLeaveDayCount())) {
            return ActionResult.fail((String)"\u8bf7\u5047\u5929\u6570\u53ea\u80fd\u662f0.5\u7684\u500d\u6570");
        }
        if (!RegexUtils.checkLeave((String)leaveApplyForm.getLeaveHour())) {
            return ActionResult.fail((String)"\u8bf7\u5047\u5c0f\u65f6\u53ea\u80fd\u662f0.5\u7684\u500d\u6570");
        }
        LeaveApplyEntity entity = (LeaveApplyEntity)JsonUtil.getJsonToBean((Object)leaveApplyForm, LeaveApplyEntity.class);
        if (FlowTaskStatusEnum.Draft.getCode().equals(leaveApplyForm.getStatus())) {
            this.leaveApplyService.save(id, entity);
            return ActionResult.success((String)MsgCode.SU002.get());
        }
        this.leaveApplyService.submit(id, entity, leaveApplyForm.getCandidateList());
        return ActionResult.success((String)MsgCode.SU006.get());
    }
}

