package com.bringspring.workflow.form.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 销售订单
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月29日 上午9:18
 */
@Data
@TableName("wform_salesorder")
public class SalesOrderEntity {
    /**
     * 主键
     */
    @TableId("ID")
    private String id;

    /**
     * 流程主键
     */
    @TableField("FLOWID")
    private String flowId;

    /**
     * 流程标题
     */
    @TableField("FLOWTITLE")
    private String flowTitle;

    /**
     * 流程等级
     */
    @TableField("FLOWURGENT")
    private Integer flowUrgent;

    /**
     * 流程单据
     */
    @TableField("BILLNO")
    private String billNo;

    /**
     * 业务人员
     */
    @TableField("SALESMAN")
    private String salesman;

    /**
     * 客户名称
     */
    @TableField("CUSTOMERNAME")
    private String customerName;

    /**
     * 联系人
     */
    @TableField("CONTACTS")
    private String contacts;

    /**
     * 联系电话
     */
    @TableField("CONTACTPHONE")
    private String contactPhone;

    /**
     * 客户地址
     */
    @TableField("CUSTOMERADDRES")
    private String customerAddres;

    /**
     * 发票编码
     */
    @TableField("TICKETNUM")
    private String ticketNum;

    /**
     * 开票日期
     */
    @TableField("TICKETDATE")
    private Date ticketDate;

    /**
     * 发票类型
     */
    @TableField("INVOICETYPE")
    private String invoiceType;

    /**
     * 付款方式
     */
    @TableField("PAYMENTMETHOD")
    private String paymentMethod;

    /**
     * 付款金额
     */
    @TableField("PAYMENTMONEY")
    private BigDecimal paymentMoney;

    /**
     * 销售日期
     */
    @TableField("SALESDATE")
    private Date salesDate;

    /**
     * 相关附件
     */
    @TableField("FILEJSON")
    private String fileJson;

    /**
     * 描述
     */
    @TableField("DESCRIPTION")
    private String description;
}
