package com.bringspring.workflow.engine.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 任务调度注解
 *
 * @author ：RKKJ开发平台组
 * @version: V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date ：2022/3/9 11:28
 */
@Documented
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface FlowCallBackMethod {

    /**
     * id
     */
    String id() default "";

    /**
     * 方法名（必填）
     *
     * @return
     */
    String fullName() default "";

    /**
     * 任务说明
     *
     * @return
     */
    String description() default "";


}
