package com.bringspring.workflow.engine.model.flowdelegate;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import jakarta.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 *
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/15 9:18
 */
@Data
public class FlowDelegateCrForm {
    @Schema(description = "流程分类")
    @NotBlank(message = "必填")
    private String flowCategory;
    @Schema(description = "被委托人")
    @NotBlank(message = "必填")
    private String toUserName;
    @Schema(description = "被委托人id")
    @NotBlank(message = "必填")
    private String toUserId;
    @Schema(description = "描述")
    private String description;
    @Schema(description = "开始日期")
    @NotNull(message = "必填")
    private Long startTime;
    @Schema(description = "结束日期")
    @NotNull(message = "必填")
    private Long endTime;
    @Schema(description = "委托流程id")
    @NotBlank(message = "必填")
    private String flowId;
    @Schema(description = "委托流程名称")
    @NotBlank(message = "必填")
    private String flowName;
}
