/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.engine.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.entity.FlowEngineTemplateEntity;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.entity.FlowTaskNodeEntity;
import com.bringspring.workflow.engine.entity.FlowTaskOperatorEntity;
import com.bringspring.workflow.engine.entity.FlowTaskOperatorRecordEntity;
import com.bringspring.workflow.engine.enums.FlowNodeEnum;
import com.bringspring.workflow.engine.model.FlowHandleModel;
import com.bringspring.workflow.engine.model.flowbefore.FlowBatchModel;
import com.bringspring.workflow.engine.model.flowbefore.FlowBeforeInfoVO;
import com.bringspring.workflow.engine.model.flowbefore.FlowBeforeListVO;
import com.bringspring.workflow.engine.model.flowbefore.FlowSummary;
import com.bringspring.workflow.engine.model.flowcandidate.FlowCandidateUserModel;
import com.bringspring.workflow.engine.model.flowcandidate.FlowCandidateVO;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode.ChildNode;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.nodejson.ChildNodeList;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.nodejson.ConditionList;
import com.bringspring.workflow.engine.model.flowtask.FlowTaskListModel;
import com.bringspring.workflow.engine.model.flowtask.PaginationFlowTask;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.service.FlowEngineTemplateService;
import com.bringspring.workflow.engine.service.FlowTaskNewService;
import com.bringspring.workflow.engine.service.FlowTaskNodeService;
import com.bringspring.workflow.engine.service.FlowTaskOperatorRecordService;
import com.bringspring.workflow.engine.service.FlowTaskOperatorService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.bringspring.workflow.engine.util.FlowJsonUtil;
import com.bringspring.workflow.engine.util.FlowNature;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u5f85\u6211\u5ba1\u6838", description="FlowBefore")
@RestController
@RequestMapping(value={"/api/workflow/Engine/FlowBefore"})
public class FlowBeforeController {
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private FlowTaskOperatorService flowTaskOperatorService;
    @Autowired
    private FlowTaskOperatorRecordService flowTaskOperatorRecordService;
    @Autowired
    private FlowTaskNodeService flowTaskNodeService;
    @Autowired
    private FlowEngineService flowEngineService;
    @Autowired
    private FlowTaskNewService flowTaskNewService;
    @Autowired
    private UserService userService;
    @Autowired
    private FlowEngineTemplateService flowEngineTemplateService;

    @Operation(summary="\u83b7\u53d6\u5f85\u6211\u5ba1\u6838\u5217\u8868(\u6709\u5e26\u5206\u9875)\uff0c1-\u5f85\u529e\u4e8b\u5b9c\uff0c2-\u5df2\u529e\u4e8b\u5b9c\uff0c3-\u6284\u9001\u4e8b\u5b9c,4-\u6279\u91cf\u5ba1\u6279")
    @GetMapping(value={"/List/{category}"})
    public ActionResult list(@PathVariable(value="category") String category, PaginationFlowTask paginationFlowTask) {
        List<Object> data = new ArrayList();
        if (FlowNature.WAIT.equals(category)) {
            data = this.flowTaskService.getWaitList(paginationFlowTask);
        } else if (FlowNature.TRIAL.equals(category)) {
            data = this.flowTaskService.getTrialList(paginationFlowTask);
        } else if (FlowNature.CIRCULATE.equals(category)) {
            data = this.flowTaskService.getCirculateList(paginationFlowTask);
        } else if (FlowNature.BATCH.equals(category)) {
            data = this.flowTaskService.getBatchWaitList(paginationFlowTask);
        }
        LinkedList<FlowBeforeListVO> listVO = new LinkedList<FlowBeforeListVO>();
        List<UserEntity> userList = this.serviceUtil.getUserName(data.stream().map(t -> t.getCreatorUserId()).collect(Collectors.toList()));
        List<FlowEngineEntity> engineList = this.flowEngineService.getFlowList(data.stream().map(t -> t.getFlowId()).collect(Collectors.toList()));
        boolean isBatch = FlowNature.BATCH.equals(category);
        for (FlowTaskListModel flowTaskListModel : data) {
            FlowBeforeListVO vo = (FlowBeforeListVO)JsonUtil.getJsonToBean((Object)flowTaskListModel, FlowBeforeListVO.class);
            UserEntity user = userList.stream().filter(t -> t.getId().equals(vo.getCreatorUserId())).findFirst().orElse(null);
            vo.setUserName(user != null ? user.getRealName() : "");
            FlowEngineEntity engine = engineList.stream().filter(t -> t.getId().equals(vo.getFlowId())).findFirst().orElse(null);
            if (engine != null) {
                vo.setFormType(engine.getFormType());
            }
            if (!ObjectUtil.isNull((Object)user)) {
                String userCompany = this.userService.getUserCompanyShortName(user.getId());
                vo.setCompanyName(userCompany);
            }
            if (isBatch) {
                ChildNodeList childNode = (ChildNodeList)JsonUtil.getJsonToBean((String)vo.getApproversProperties(), ChildNodeList.class);
                vo.setApproversProperties(JsonUtil.getObjectToString((Object)childNode.getProperties()));
            }
            vo.setFlowVersion((String)(StringUtils.isEmpty((String)vo.getFlowVersion()) ? "" : "v" + vo.getFlowVersion()));
            listVO.add(vo);
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)paginationFlowTask), PaginationVO.class);
        return ActionResult.page(listVO, (PaginationVO)paginationVO);
    }

    @Operation(summary="\u83b7\u53d6\u5f85\u6211\u5ba1\u6279\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult info(@PathVariable(value="id") String id, String taskNodeId, String taskOperatorId) throws WorkFlowException {
        FlowBeforeInfoVO vo = this.flowTaskNewService.getBeforeInfo(id, taskNodeId, taskOperatorId);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u83b7\u53d6\u5f85\u6211\u5ba1\u6279\u4fe1\u606f")
    @GetMapping(value={"/getDraftTaskByProcessId/{processId}"})
    public ActionResult getDraftTaskByProcessId(@PathVariable(value="processId") String processId) throws WorkFlowException {
        FlowTaskEntity draftTaskByProcessId = this.flowTaskService.getDraftTaskByProcessId(processId);
        return ActionResult.success((Object)draftTaskByProcessId);
    }

    @Operation(summary="\u5f85\u6211\u5ba1\u6838-\u5ba1\u6838")
    @PostMapping(value={"/Audit/{id}"})
    @RepeatSubmit
    @DSTransactional
    public ActionResult audit(@PathVariable(value="id") String id, @RequestBody FlowHandleModel flowHandleModel) throws WorkFlowException {
        FlowTaskOperatorEntity operator = this.flowTaskOperatorService.getInfo(id);
        FlowTaskEntity flowTask = this.flowTaskService.getInfo(operator.getTaskId());
        this.flowTaskNewService.permissions(operator.getHandleId(), flowTask, operator, "");
        if (FlowNature.ProcessCompletion.equals(operator.getCompletion())) {
            FlowModel flowModel = (FlowModel)JsonUtil.getJsonToBean((Object)((Object)flowHandleModel), FlowModel.class);
            flowModel.setFlowId(String.valueOf(flowModel.getFormData().get("flowId")));
            UserInfo userInfo = this.userProvider.get();
            String rejecttKey = userInfo.getTenantId() + id;
            if (this.cacheUtil.exists("shortCacheSpace", rejecttKey)) {
                throw new WorkFlowException(MsgCode.WF005.get());
            }
            this.cacheUtil.insert("shortCacheSpace", rejecttKey, (Object)id, 10L);
            this.flowTaskNewService.audit(flowTask, operator, flowModel);
            return ActionResult.success((String)"\u5ba1\u6838\u6210\u529f");
        }
        return ActionResult.fail((String)MsgCode.WF005.get());
    }

    @DSTransactional
    @Operation(summary="\u4fdd\u5b58\u8349\u7a3f")
    @PostMapping(value={"/SaveAudit/{id}"})
    public ActionResult saveAudit(@PathVariable(value="id") String id, @RequestBody FlowHandleModel flowHandleModel) throws WorkFlowException {
        FlowTaskOperatorEntity flowTaskOperatorEntity = this.flowTaskOperatorService.getInfo(id);
        if (flowTaskOperatorEntity != null) {
            Object data;
            FlowTaskEntity flowTaskEntity = this.flowTaskService.getInfo(flowTaskOperatorEntity.getTaskId());
            FlowEngineEntity engine = this.flowEngineService.getInfo(flowTaskEntity.getFlowId());
            Map formDataAll = flowHandleModel.getFormData();
            if (FlowNature.CUSTOM.equals(engine.getFormType()) && (data = formDataAll.get("data")) != null) {
                formDataAll = JsonUtil.stringToMap((String)String.valueOf(data));
            }
            flowTaskOperatorEntity.setDraftData(JsonUtil.getObjectToString(formDataAll));
            this.flowTaskOperatorService.updateById(flowTaskOperatorEntity);
            return ActionResult.success((String)MsgCode.SU002.get());
        }
        return ActionResult.fail((String)MsgCode.FA001.get());
    }

    @Operation(summary="\u52a0\u7b7e")
    @PostMapping(value={"/freeApproval/{taskOperatorId}"})
    public ActionResult freeApproval(@PathVariable(value="taskOperatorId") String taskOperatorId, @RequestBody FlowHandleModel flowHandleModel) throws WorkFlowException {
        FlowTaskOperatorEntity operator = this.flowTaskOperatorService.getInfo(taskOperatorId);
        FlowTaskEntity flowTask = this.flowTaskService.getInfo(operator.getTaskId());
        this.flowTaskNewService.permissions(operator.getHandleId(), flowTask, operator, "");
        this.flowTaskNewService.freeApproval(operator, flowHandleModel);
        return ActionResult.success((String)"\u52a0\u7b7e\u6210\u529f");
    }

    @Operation(summary="\u5ba1\u6279\u6c47\u603b")
    @GetMapping(value={"/RecordList/{id}"})
    public ActionResult recordList(@PathVariable(value="id") String id, String category, String type) {
        List<FlowSummary> flowSummaries = this.flowTaskNewService.recordList(id, category, type);
        return ActionResult.success(flowSummaries);
    }

    @Operation(summary="\u5f85\u6211\u5ba1\u6838\u9a73\u56de")
    @RepeatSubmit
    @PostMapping(value={"/Reject/{taskOperatorId}"})
    public ActionResult reject(@PathVariable(value="taskOperatorId") String taskOperatorId, @RequestBody FlowHandleModel flowHandleModel) throws WorkFlowException {
        FlowTaskOperatorEntity operator = this.flowTaskOperatorService.getInfo(taskOperatorId);
        FlowTaskEntity flowTask = this.flowTaskService.getInfo(operator.getTaskId());
        this.flowTaskNewService.permissions(operator.getHandleId(), flowTask, operator, "");
        if (FlowNature.ProcessCompletion.equals(operator.getCompletion())) {
            FlowModel flowModel = (FlowModel)JsonUtil.getJsonToBean((Object)((Object)flowHandleModel), FlowModel.class);
            flowModel.setFlowId(String.valueOf(flowModel.getFormData().get("flowId")));
            UserInfo userInfo = this.userProvider.get();
            String rejecttKey = userInfo.getTenantId() + taskOperatorId;
            if (this.cacheUtil.exists("shortCacheSpace", rejecttKey)) {
                throw new WorkFlowException(MsgCode.WF112.get());
            }
            this.cacheUtil.insert("shortCacheSpace", rejecttKey, (Object)taskOperatorId, 10L);
            flowModel.setProcessId(flowTask.getProcessId());
            this.flowTaskNewService.reject(flowTask, operator, flowModel);
            return ActionResult.success((String)"\u9a73\u56de\u6210\u529f");
        }
        return ActionResult.fail((String)"\u5df2\u5ba1\u6838\u5b8c\u6210");
    }

    @Operation(summary="\u5f85\u6211\u5ba1\u6838\u8f6c\u529e")
    @PostMapping(value={"/Transfer/{taskOperatorId}"})
    public ActionResult transfer(@PathVariable(value="taskOperatorId") String taskOperatorId, @RequestBody FlowHandleModel flowHandleModel) throws WorkFlowException {
        FlowTaskOperatorEntity operator = this.flowTaskOperatorService.getInfo(taskOperatorId);
        FlowTaskEntity flowTask = this.flowTaskService.getInfo(operator.getTaskId());
        this.flowTaskNewService.permissions(operator.getHandleId(), flowTask, operator, "");
        operator.setHandleId(flowHandleModel.getFreeApproverUserId());
        operator.setHandleOpinion(flowHandleModel.getHandleOpinion());
        this.flowTaskNewService.transfer(operator);
        return ActionResult.success((String)"\u8f6c\u529e\u6210\u529f");
    }

    @Operation(summary="\u5f85\u6211\u5ba1\u6838\u64a4\u56de\u5ba1\u6838")
    @PostMapping(value={"/Recall/{id}"})
    public ActionResult recall(@PathVariable(value="id") String id, @RequestBody FlowHandleModel flowHandleModel) throws WorkFlowException {
        FlowTaskOperatorRecordEntity operatorRecord = this.flowTaskOperatorRecordService.getInfo(id);
        List nodeList = this.flowTaskNodeService.getList(operatorRecord.getTaskId()).stream().filter(t -> FlowNodeEnum.Process.getCode().equals(t.getState())).collect(Collectors.toList());
        FlowTaskNodeEntity taskNode = nodeList.stream().filter(t -> t.getId().equals(operatorRecord.getTaskNodeId())).findFirst().orElse(null);
        if (taskNode != null) {
            FlowModel flowModel = (FlowModel)JsonUtil.getJsonToBean((Object)((Object)flowHandleModel), FlowModel.class);
            flowModel.setFlowId(String.valueOf(flowModel.getFormData().get("flowId")));
            this.flowTaskNewService.recall(id, operatorRecord, flowModel);
            return ActionResult.success((String)"\u64a4\u56de\u6210\u529f");
        }
        return ActionResult.fail((String)"\u64a4\u56de\u5931\u8d25");
    }

    @Operation(summary="\u5f85\u6211\u5ba1\u6838\u7ec8\u6b62\u5ba1\u6838")
    @PostMapping(value={"/Cancel/{taskId}"})
    public ActionResult cancel(@PathVariable(value="taskId") String taskId, @RequestBody FlowHandleModel flowHandleModel) throws WorkFlowException {
        FlowTaskEntity flowTaskEntity = this.flowTaskService.getInfo(taskId);
        if (flowTaskEntity != null) {
            FlowModel flowModel = (FlowModel)JsonUtil.getJsonToBean((Object)((Object)flowHandleModel), FlowModel.class);
            flowModel.setFlowId(flowTaskEntity.getFlowId());
            this.flowTaskNewService.cancel(flowTaskEntity, flowModel);
            return ActionResult.success((String)MsgCode.SU009.get());
        }
        return ActionResult.fail((String)MsgCode.FA009.get());
    }

    @Operation(summary="\u6307\u6d3e\u4eba")
    @PostMapping(value={"/Assign/{id}"})
    public ActionResult assign(@PathVariable(value="id") String id, @RequestBody FlowHandleModel flowHandleModel) throws WorkFlowException {
        FlowModel flowModel = (FlowModel)JsonUtil.getJsonToBean((Object)((Object)flowHandleModel), FlowModel.class);
        boolean isOk = this.flowTaskNewService.assign(id, flowModel);
        return isOk ? ActionResult.success((String)"\u6307\u6d3e\u6210\u529f") : ActionResult.fail((String)"\u6307\u6d3e\u5931\u8d25");
    }

    @Operation(summary="\u83b7\u53d6\u5019\u9009\u4eba\u8282\u70b9")
    @PostMapping(value={"/Candidates/{id}"})
    public ActionResult candidates(@PathVariable(value="id") String id, @RequestBody FlowHandleModel flowHandleModel) throws WorkFlowException {
        List<FlowCandidateVO> candidate = this.flowTaskNewService.candidates(id, flowHandleModel);
        return ActionResult.success(candidate);
    }

    @Operation(summary="\u83b7\u53d6\u5019\u9009\u4eba")
    @PostMapping(value={"/CandidateUser/{id}"})
    public ActionResult candidateUser(@PathVariable(value="id") String id, @RequestBody FlowHandleModel flowHandleModel) throws WorkFlowException {
        List<FlowCandidateUserModel> candidate = this.flowTaskNewService.candidateUser(id, flowHandleModel);
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)flowHandleModel), PaginationVO.class);
        return ActionResult.page(candidate, (PaginationVO)paginationVO);
    }

    @Operation(summary="\u6279\u91cf\u5ba1\u6279\u5f15\u64ce")
    @GetMapping(value={"/BatchFlowSelector"})
    public ActionResult batchFlowSelector() {
        List<FlowBatchModel> batchFlowList = this.flowTaskService.batchFlowSelector();
        return ActionResult.success(batchFlowList);
    }

    @Operation(summary="\u5f15\u64ce\u8282\u70b9")
    @GetMapping(value={"/NodeSelector/{id}"})
    public ActionResult nodeSelector(@PathVariable(value="id") String id, @RequestParam(value="templateId") String templateId) throws WorkFlowException {
        FlowEngineEntity engine = this.flowEngineService.getInfo(id);
        FlowEngineTemplateEntity template = (FlowEngineTemplateEntity)this.flowEngineTemplateService.getById((Serializable)((Object)templateId));
        ArrayList<FlowBatchModel> batchList = new ArrayList<FlowBatchModel>();
        ChildNode childNodeAll = (ChildNode)JsonUtil.getJsonToBean((String)template.getFlowTemplateJson(), ChildNode.class);
        ArrayList<ChildNodeList> nodeListAll = new ArrayList<ChildNodeList>();
        ArrayList<ConditionList> conditionListAll = new ArrayList<ConditionList>();
        FlowJsonUtil.getTemplateAll(childNodeAll, nodeListAll, conditionListAll);
        for (ChildNodeList childNodeList : nodeListAll) {
            if (FlowNature.NodeStart.equals(childNodeList.getCustom().getType())) continue;
            FlowBatchModel batchModel = new FlowBatchModel();
            batchModel.setFullName(childNodeList.getProperties().getTitle());
            batchModel.setId(childNodeList.getCustom().getNodeId());
            batchList.add(batchModel);
        }
        return ActionResult.success(batchList);
    }

    @Operation(summary="\u6279\u91cf\u5ba1\u6279")
    @PostMapping(value={"/BatchOperation"})
    public ActionResult batchOperation(@RequestBody FlowHandleModel flowHandleModel) throws WorkFlowException {
        this.flowTaskNewService.batch(flowHandleModel);
        return ActionResult.success((String)"\u6279\u91cf\u64cd\u4f5c\u5b8c\u6210");
    }

    @Operation(summary="\u6279\u91cf\u83b7\u53d6\u5019\u9009\u4eba")
    @GetMapping(value={"/BatchCandidate"})
    public ActionResult batchCandidate(String flowId, String taskOperatorId) throws WorkFlowException {
        List<FlowCandidateVO> candidate = this.flowTaskNewService.batchCandidates(flowId, taskOperatorId);
        return ActionResult.success(candidate);
    }

    @Operation(summary="\u6d88\u606f\u8df3\u8f6c\u5de5\u4f5c\u6d41")
    @GetMapping(value={"/{id}/Info"})
    public ActionResult taskOperatorId(@PathVariable(value="id") String id) throws WorkFlowException {
        FlowTaskOperatorEntity operator = this.flowTaskOperatorService.getInfo(id);
        FlowTaskEntity flowTask = this.flowTaskService.getInfo(operator.getTaskId());
        this.flowTaskNewService.permissions(operator.getHandleId(), flowTask, operator, "");
        return ActionResult.success();
    }
}

