/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.engine.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.workflow.engine.entity.FlowDelegateEntity;
import com.bringspring.workflow.engine.mapper.FlowDelegateMapper;
import com.bringspring.workflow.engine.service.FlowDelegateService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowDelegateServiceImpl
extends ServiceImpl<FlowDelegateMapper, FlowDelegateEntity>
implements FlowDelegateService {
    @Autowired
    private UserProvider userProvider;

    @Override
    public List<FlowDelegateEntity> getList(Pagination pagination) {
        boolean flag = false;
        String userId = this.userProvider.get().getUserId();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowDelegateEntity::getCreatorUserId, (Object)userId);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)pagination.getKeyword())) {
            flag = true;
            queryWrapper.lambda().and(t -> ((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(FlowDelegateEntity::getFlowName, (Object)pagination.getKeyword())).or()).like(FlowDelegateEntity::getToUserName, (Object)pagination.getKeyword()));
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(FlowDelegateEntity::getFSortCode)).orderByDesc(FlowDelegateEntity::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(FlowDelegateEntity::getLastModifyTime);
        }
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage flowDelegateEntityPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(flowDelegateEntityPage.getRecords(), page.getTotal());
    }

    @Override
    public List<FlowDelegateEntity> getList() {
        String userId = this.userProvider.get().getUserId();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowDelegateEntity::getCreatorUserId, (Object)userId);
        return ((FlowDelegateMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public FlowDelegateEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowDelegateEntity::getId, (Object)id);
        return (FlowDelegateEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void delete(FlowDelegateEntity entity) {
        this.removeById((Serializable)((Object)entity.getId()));
    }

    @Override
    public void create(FlowDelegateEntity entity) {
        entity.setId(RandomUtil.uuId());
        entity.setFSortCode(RandomUtil.parses());
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        this.save(entity);
    }

    @Override
    public List<FlowDelegateEntity> getUser(String userId) {
        return this.getUser(userId, null, null);
    }

    @Override
    public List<FlowDelegateEntity> getUser(String userId, String flowId, String creatorUserId) {
        Date thisTime = DateUtil.getNowDate();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().le(FlowDelegateEntity::getStartTime, (Object)thisTime)).ge(FlowDelegateEntity::getEndTime, (Object)thisTime);
        if (StringUtils.isNotEmpty((String)userId)) {
            queryWrapper.lambda().eq(FlowDelegateEntity::getToUserid, (Object)userId);
        }
        if (StringUtils.isNotEmpty((String)flowId)) {
            queryWrapper.lambda().eq(FlowDelegateEntity::getFlowId, (Object)flowId);
        }
        if (StringUtils.isNotEmpty((String)creatorUserId)) {
            queryWrapper.lambda().eq(FlowDelegateEntity::getCreatorUserId, (Object)creatorUserId);
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public boolean update(String id, FlowDelegateEntity entity) {
        entity.setId(id);
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(this.userProvider.get().getUserId());
        return this.updateById(entity);
    }
}

