/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.form.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import com.bringspring.workflow.form.entity.SalesOrderEntity;
import com.bringspring.workflow.form.entity.SalesOrderEntryEntity;
import com.bringspring.workflow.form.mapper.SalesOrderMapper;
import com.bringspring.workflow.form.model.salesorder.SalesOrderForm;
import com.bringspring.workflow.form.service.SalesOrderEntryService;
import com.bringspring.workflow.form.service.SalesOrderService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SalesOrderServiceImpl
extends ServiceImpl<SalesOrderMapper, SalesOrderEntity>
implements SalesOrderService {
    @Autowired
    private ServiceAllUtil serviceAllUtil;
    @Autowired
    private SalesOrderEntryService salesOrderEntryService;

    @Override
    public List<SalesOrderEntryEntity> getSalesEntryList(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(SalesOrderEntryEntity::getSalesOrderId, (Object)id)).orderByDesc(SalesOrderEntryEntity::getSortCode);
        return this.salesOrderEntryService.list((Wrapper)queryWrapper);
    }

    @Override
    public SalesOrderEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SalesOrderEntity::getId, (Object)id);
        return (SalesOrderEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void save(String id, SalesOrderEntity entity, List<SalesOrderEntryEntity> salesOrderEntryEntityList) throws WorkFlowException {
        if (id == null) {
            entity.setId(RandomUtil.uuId());
            for (int i = 0; i < salesOrderEntryEntityList.size(); ++i) {
                salesOrderEntryEntityList.get(i).setId(RandomUtil.uuId());
                salesOrderEntryEntityList.get(i).setSalesOrderId(entity.getId());
                salesOrderEntryEntityList.get(i).setSortCode(Long.parseLong("" + i));
                this.salesOrderEntryService.save(salesOrderEntryEntityList.get(i));
            }
            this.save(entity);
            this.serviceAllUtil.useBillNumber("WF_SalesOrderNo");
        } else {
            entity.setId(id);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(SalesOrderEntryEntity::getSalesOrderId, (Object)entity.getId());
            this.salesOrderEntryService.remove((Wrapper)queryWrapper);
            for (int i = 0; i < salesOrderEntryEntityList.size(); ++i) {
                salesOrderEntryEntityList.get(i).setId(RandomUtil.uuId());
                salesOrderEntryEntityList.get(i).setSalesOrderId(entity.getId());
                salesOrderEntryEntityList.get(i).setSortCode(Long.parseLong("" + i));
                this.salesOrderEntryService.save(salesOrderEntryEntityList.get(i));
            }
            this.updateById(entity);
        }
        FlowUtil.save(id, entity.getFlowId(), null, entity.getId(), entity.getFlowTitle(), entity.getFlowUrgent(), entity.getBillNo(), entity);
    }

    @Override
    @DSTransactional
    public void submit(String id, SalesOrderEntity entity, List<SalesOrderEntryEntity> salesOrderEntryEntityList, Map<String, List<String>> candidateList) throws WorkFlowException {
        if (id == null) {
            entity.setId(RandomUtil.uuId());
            for (int i = 0; i < salesOrderEntryEntityList.size(); ++i) {
                salesOrderEntryEntityList.get(i).setId(RandomUtil.uuId());
                salesOrderEntryEntityList.get(i).setSalesOrderId(entity.getId());
                salesOrderEntryEntityList.get(i).setSortCode(Long.parseLong("" + i));
                this.salesOrderEntryService.save(salesOrderEntryEntityList.get(i));
            }
            this.save(entity);
            this.serviceAllUtil.useBillNumber("WF_SalesOrderNo");
        } else {
            entity.setId(id);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(SalesOrderEntryEntity::getSalesOrderId, (Object)entity.getId());
            this.salesOrderEntryService.remove((Wrapper)queryWrapper);
            for (int i = 0; i < salesOrderEntryEntityList.size(); ++i) {
                salesOrderEntryEntityList.get(i).setId(RandomUtil.uuId());
                salesOrderEntryEntityList.get(i).setSalesOrderId(entity.getId());
                salesOrderEntryEntityList.get(i).setSortCode(Long.parseLong("" + i));
                this.salesOrderEntryService.save(salesOrderEntryEntityList.get(i));
            }
            this.updateById(entity);
        }
        FlowUtil.submit(id, entity.getFlowId(), null, entity.getId(), entity.getFlowTitle(), entity.getFlowUrgent(), entity.getBillNo(), entity, null, candidateList);
    }

    @Override
    public void data(String id, String data) {
        SalesOrderForm salesOrderForm = (SalesOrderForm)JsonUtil.getJsonToBean((String)data, SalesOrderForm.class);
        SalesOrderEntity entity = (SalesOrderEntity)JsonUtil.getJsonToBean((Object)salesOrderForm, SalesOrderEntity.class);
        ArrayList entryList = salesOrderForm.getEntryList() != null ? salesOrderForm.getEntryList() : new ArrayList();
        List salesOrderEntryEntityList = JsonUtil.getJsonToList(entryList, SalesOrderEntryEntity.class);
        entity.setId(id);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SalesOrderEntryEntity::getSalesOrderId, (Object)entity.getId());
        this.salesOrderEntryService.remove((Wrapper)queryWrapper);
        for (int i = 0; i < salesOrderEntryEntityList.size(); ++i) {
            ((SalesOrderEntryEntity)salesOrderEntryEntityList.get(i)).setId(RandomUtil.uuId());
            ((SalesOrderEntryEntity)salesOrderEntryEntityList.get(i)).setSalesOrderId(entity.getId());
            ((SalesOrderEntryEntity)salesOrderEntryEntityList.get(i)).setSortCode(Long.parseLong("" + i));
            this.salesOrderEntryService.save((SalesOrderEntryEntity)salesOrderEntryEntityList.get(i));
        }
        this.saveOrUpdate(entity);
    }
}

