package com.bringspring.workflow.engine.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.filter.RepeatSubmit;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.entity.FlowTaskOperatorEntity;
import com.bringspring.workflow.engine.model.FlowHandleModel;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import com.bringspring.workflow.engine.model.flowlaunch.FlowLaunchListVO;
import com.bringspring.workflow.engine.model.flowtask.PaginationFlowTask;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.service.FlowTaskNewService;
import com.bringspring.workflow.engine.service.FlowTaskOperatorService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.bringspring.workflow.engine.util.FlowNature;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 流程发起
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Api(tags = "流程发起", value = "FlowLaunch")
@RestController
@RequestMapping("/api/workflow/Engine/FlowLaunch")
public class FlowLaunchController {

    @Autowired
    private FlowEngineService flowEngineService;
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private FlowTaskNewService flowTaskNewService;

    @Autowired
    private FlowTaskOperatorService flowTaskOperatorService;
    @Autowired
    private UserService userService;

    /**
     * 获取流程发起列表
     *
     * @param paginationFlowTask
     * @return
     */
    @ApiOperation("获取流程发起列表(带分页)")
    @GetMapping
    public ActionResult<PageListVO<FlowLaunchListVO>> list(PaginationFlowTask paginationFlowTask) {
        List<FlowTaskEntity> data = flowTaskService.getLaunchList(paginationFlowTask);
        List<FlowEngineEntity> engineList = flowEngineService.getFlowList(data.stream().map(t -> t.getFlowId()).collect(Collectors.toList()));
        List<FlowLaunchListVO> listVO = new LinkedList<>();
        for (FlowTaskEntity taskEntity : data) {
            //用户名称赋值
            FlowLaunchListVO vo = JsonUtil.getJsonToBean(taskEntity, FlowLaunchListVO.class);
            FlowEngineEntity entity = engineList.stream().filter(t -> t.getId().equals(taskEntity.getFlowId())).findFirst().orElse(null);
            if (entity != null) {
//                vo.setFormData(entity.getFormData());
                vo.setFormType(entity.getFormType());
            }
            List<FlowTaskOperatorEntity> operatorList = flowTaskOperatorService.getListByNode(taskEntity.getId(),taskEntity.getThisStepId());
            if (CollectionUtil.isNotEmpty(operatorList) && !taskEntity.getStatus().equals(2)){
                if (operatorList.size()>1)
                {
                    List<String> strings = new ArrayList<>();
                    operatorList.stream().forEach(operator->{
                        UserEntity userInfo = userService.getInfo(operator.getHandleId());
                        strings.add(userInfo.getRealName());
                    });
                    String handleName = strings.stream().collect(Collectors.joining(","));
                    vo.setThisStep(vo.getThisStep()+"-"+handleName);

                }else {
                    UserEntity userEntity = userService.getInfo(operatorList.get(0).getHandleId());
                    if (ObjectUtil.isNotEmpty(userEntity) &&!vo.getThisStep().equals(userEntity.getRealName())){
                        vo.setThisStep(vo.getThisStep()+"-"+userEntity.getRealName());
                    }
                }
            }
            listVO.add(vo);
        }
        PaginationVO paginationVO = JsonUtil.getJsonToBean(paginationFlowTask, PaginationVO.class);
        return ActionResult.page(listVO, paginationVO);
    }

    /**
     * 删除流程发起
     *
     * @param id 主键值
     * @return
     */
    @ApiOperation("删除流程发起")
    @DeleteMapping("/{id}")
    public ActionResult delete(@PathVariable("id") String id) throws WorkFlowException {
        FlowTaskEntity entity = flowTaskService.getInfo(id);
        if (entity != null) {
//            if (entity.getFlowType() == 1) {
//                return ActionResult.fail("功能流程不能删除");
//            }
            if (!FlowNature.ParentId.equals(entity.getParentId()) && StringUtils.isNotEmpty(entity.getParentId())) {
                return ActionResult.fail("子表数据不能删除");
            }
            flowTaskService.delete(entity);
            return ActionResult.success(MsgCode.SU003.get());
        }
        return ActionResult.fail(MsgCode.FA003.get());
    }

    /**
     * 待我审核催办
     *
     * @param taskId 任务主键值
     * @return
     */
    @ApiOperation("发起催办")
    @PostMapping("/Press/{taskId}")
    public ActionResult press(@PathVariable("taskId") String taskId) throws WorkFlowException {
        boolean flag = flowTaskNewService.press(taskId);
        if (flag) {
            return ActionResult.success("催办成功");
        }
        return ActionResult.fail("未找到催办人");
    }

    /**
     * 撤回流程发起
     * 注意：在撤销流程时要保证你的下一节点没有处理这条记录；如已处理则无法撤销流程。
     *
     * @param id              主键值
     * @param flowHandleModel 经办记录
     * @return
     */
    @ApiOperation("撤回流程发起")
    @RepeatSubmit
    @PutMapping("/{id}/Actions/Withdraw")
    public ActionResult revoke(@PathVariable("id") String id, @RequestBody FlowHandleModel flowHandleModel) throws WorkFlowException {
        FlowTaskEntity flowTaskEntity = flowTaskService.getInfo(id);
        if (ObjectUtil.isNotEmpty(flowTaskEntity) && flowTaskEntity.getStatus().equals(1)){
            FlowModel flowModel = JsonUtil.getJsonToBean(flowHandleModel, FlowModel.class);
            flowModel.setFlowId(flowTaskEntity.getFlowId());
            flowModel.setProcessId(flowTaskEntity.getProcessId());
            flowTaskNewService.revoke(flowTaskEntity, flowModel);
            return ActionResult.success("撤回成功");
        }else {
            return ActionResult.fail("当前流程状态已经改变，无法撤回！");
        }

    }
}
