package com.bringspring.workflow.engine.controller;


import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.entity.FlowEngineTemplateEntity;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.model.flowmonitor.FlowMonitorListVO;
import com.bringspring.workflow.engine.model.flowrelation.FlowRelationListVO;
import com.bringspring.workflow.engine.model.flowtask.FlowDeleteModel;
import com.bringspring.workflow.engine.model.flowtask.FlowTaskListModel;
import com.bringspring.workflow.engine.model.flowtask.PaginationFlowTask;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.service.FlowEngineTemplateService;
import com.bringspring.workflow.engine.service.FlowTaskOperatorService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 流程监控
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Api(tags = "流程监控", value = "FlowRelation")
@RestController
@RequestMapping("/api/workflow/Engine/FlowRelation")
public class FlowRelationController {
    @Autowired
    private FlowEngineService flowEngineService;
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private FlowEngineTemplateService flowEngineTemplateService;
    @Autowired
    private UserService userService;
    @Autowired
    private FlowTaskOperatorService flowTaskOperatorService;


    /**
     * 获取流程监控列表
     *
     * @param paginationFlowTask
     * @return
     */
    @ApiOperation("获取流程与我相关列表")
    @GetMapping
    public ActionResult<PageListVO<FlowRelationListVO>> list(PaginationFlowTask paginationFlowTask) {
        List<FlowTaskEntity> listByRelation = flowTaskService.getListByRelation(paginationFlowTask);
        List<FlowTaskListModel> modelList = JsonUtil.getJsonToList(listByRelation, FlowTaskListModel.class);
        List<FlowEngineEntity> engineList = flowEngineService.getFlowList(listByRelation.stream().map(t -> t.getFlowId()).collect(Collectors.toList()));
        List<UserEntity> userList = serviceUtil.getUserName(listByRelation.stream().map(t -> t.getCreatorUserId()).collect(Collectors.toList()));
        List<FlowRelationListVO> listVO = new LinkedList<>();
        for (FlowTaskListModel taskEntity : modelList) {
            //用户名称赋值
            FlowRelationListVO vo = JsonUtil.getJsonToBean(taskEntity, FlowRelationListVO.class);
            UserEntity user = userList.stream().filter(t -> t.getId().equals(taskEntity.getCreatorUserId())).findFirst().orElse(null);
            vo.setUserName(user != null ? user.getRealName(): "");
            FlowEngineEntity engine = engineList.stream().filter(t -> t.getId().equals(taskEntity.getFlowId())).findFirst().orElse(null);
            if (engine != null) {
//                vo.setFormData(engine.getFormData());
                vo.setFormType(engine.getFormType());
                listVO.add(vo);
            }
        }
        PaginationVO paginationVO = JsonUtil.getJsonToBean(paginationFlowTask, PaginationVO.class);
        return ActionResult.page(listVO,paginationVO);
    }


}
