package com.bringspring.workflow.engine.controller;


import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.entity.FlowEngineTemplateEntity;
import com.bringspring.workflow.engine.model.flowengine.FlowPagination;
import com.bringspring.workflow.engine.model.flowenginetemplate.FlowTemplatePageListVO;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.service.FlowEngineTemplateService;
import com.bringspring.workflow.engine.service.FlowEngineTemplateVersionService;
import com.bringspring.workflow.engine.service.FlowEngineVisibleService;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 流程设计
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2025年8月18日 上午9:18
 */
@Api(tags = "流程模板", value = "FlowEngineTemplate")
@RestController
@RequestMapping("/api/workflow/Engine/FlowEngineTemplate")
public class FlowTemplateController {

    @Autowired
    private FlowEngineService flowEngineService;

    @Autowired
    private UserProvider userProvider;

    @Autowired
    private FlowEngineTemplateService flowEngineTemplateService;

    @Autowired
    private FlowEngineVisibleService flowEngineVisibleService;

    @Autowired
    private FlowEngineTemplateVersionService flowEngineTemplateVersionService;

    @Autowired
    private ServiceAllUtil serviceUtil;

    @Autowired
    private BaseDataUtil baseDataUtil;


    /**
     * 获取流程设计列表
     *
     * @return
     */
    @ApiOperation("获取流程模板列表")
    @GetMapping
    public ActionResult list(FlowPagination pagination) {
        List<FlowEngineTemplateEntity> pageList = flowEngineTemplateService.getPageList(pagination);
        PaginationVO paginationVO = JsonUtil.getJsonToBean(pagination, PaginationVO.class);
        List<FlowTemplatePageListVO> listVO = JsonUtil.getJsonToList(pageList, FlowTemplatePageListVO.class);
        for (FlowTemplatePageListVO templatePageListVO : listVO) {
            FlowEngineEntity engineEntity = flowEngineService.getById(templatePageListVO.getFlowId());
            if (ObjectUtil.isNotEmpty(engineEntity)) {
                templatePageListVO.setFormType(engineEntity.getFormType());
                templatePageListVO.setType(engineEntity.getType());
                templatePageListVO.setFlowEngineName(engineEntity.getFullName());
                templatePageListVO.setCategory(engineEntity.getCategory());
                templatePageListVO.setCategoryName(baseDataUtil.getDictName(templatePageListVO.getCategory(),"WorkFlowCategory"));
            }
            OrganizeEntity organizeInfo = serviceUtil.getOrganizeInfo(templatePageListVO.getCompanyId());
            if (ObjectUtil.isNotEmpty(organizeInfo)){
                templatePageListVO.setCompanyName(organizeInfo.getShortName());
            }
            if (ObjectUtil.isNotEmpty(templatePageListVO.getLastModifyUserId())) {
                UserEntity userInfo = serviceUtil.getUserInfo(templatePageListVO.getLastModifyUserId());
                if (ObjectUtil.isNotEmpty(userInfo)) {
                    templatePageListVO.setLastModifyUserName(userInfo.getRealName());
                }
            }
        }
        return ActionResult.page(listVO, paginationVO);
    }
}
