package com.bringspring.workflow.engine.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.*;
import com.bringspring.common.util.enums.FileTypeEnum;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.entity.FlowEngineTemplateEntity;
import com.bringspring.workflow.engine.model.flowengine.FlowPagination;
import com.bringspring.workflow.engine.model.flowenginetemplate.FlowTemplatePageListVO;
import com.bringspring.workflow.engine.model.flowtimeanalyze.FlowTimeAnalyzeExportModel;
import com.bringspring.workflow.engine.model.flowtimeanalyze.FlowTimeAnalyzeModel;
import com.bringspring.workflow.engine.service.*;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.Cleanup;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 流程审核时效表
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2025年11月4日 上午9:18
 */
@Api(tags = "流程模板", value = "FlowTimeAnalyze")
@Slf4j
@RestController
@RequestMapping("/api/workflow/Engine/FlowTimeAnalyze")
public class FlowTimeAnalyzeController {
    @Autowired
    private FlowEngineService flowEngineService;

    @Autowired
    private UserProvider userProvider;

    @Autowired
    private FlowEngineTemplateService flowEngineTemplateService;

    @Autowired
    private FlowEngineVisibleService flowEngineVisibleService;

    @Autowired
    private FlowEngineTemplateVersionService flowEngineTemplateVersionService;

    @Autowired
    private ServiceAllUtil serviceUtil;

    @Autowired
    private BaseDataUtil baseDataUtil;

    @Autowired
    private FlowTimeAnalyzeService flowTimeAnalyzeService;

    @Autowired
    private ConfigValueUtil configValueUtil;

    /**
     * 获取流程设计列表
     *
     * @return
     */
    @ApiOperation("获取流程模板列表")
    @GetMapping
    public ActionResult list(FlowPagination pagination) {
        List<FlowTimeAnalyzeModel> pageList = flowTimeAnalyzeService.getPageList(pagination);
        PaginationVO paginationVO = JsonUtil.getJsonToBean(pagination, PaginationVO.class);

        for (FlowTimeAnalyzeModel templatePageListVO : pageList) {
            FlowEngineEntity engineEntity = flowEngineService.getById(templatePageListVO.getFlowId());
            if (ObjectUtil.isNotEmpty(engineEntity)) {

                templatePageListVO.setFlowEngineName(engineEntity.getFullName());
                templatePageListVO.setCategory(engineEntity.getCategory());
                templatePageListVO.setCategoryName(baseDataUtil.getDictName(templatePageListVO.getCategory(),"WorkFlowCategory"));
            }
            OrganizeEntity organizeInfo = serviceUtil.getOrganizeInfo(templatePageListVO.getCompanyId());
            if (ObjectUtil.isNotEmpty(organizeInfo)){
                templatePageListVO.setCompanyName(organizeInfo.getShortName());
            }
            if (ObjectUtil.isNotEmpty(templatePageListVO.getHandleId())){
                UserEntity userInfo = serviceUtil.getUserInfo(templatePageListVO.getHandleId());
                if (ObjectUtil.isNotEmpty(userInfo)){
                    templatePageListVO.setHandleName(userInfo.getRealName());
                    templatePageListVO.setLongestApprovalNode(templatePageListVO.getLongestApprovalNode()+"-"+userInfo.getRealName());
                }
            }
        }
        return ActionResult.page(pageList, paginationVO);
    }

    /**
     * 导出Excel
     *
     * @return
     */
    @ApiOperation("导出Excel")
    @PostMapping("/Actions/Export")
    public ActionResult Export(@RequestBody FlowTimeAnalyzeExportModel flowTimeAnalyzeExportModel) throws IOException {
        if (StringUtils.isEmpty(flowTimeAnalyzeExportModel.getSelectKey())) {
            return ActionResult.fail("请选择导出字段");
        }
        FlowPagination flowPagination = JsonUtil.getJsonToBean(flowTimeAnalyzeExportModel, FlowPagination.class);
        List<FlowTimeAnalyzeModel> exportList = flowTimeAnalyzeService.getExportList(flowPagination, flowTimeAnalyzeExportModel.getDataType());
        for (FlowTimeAnalyzeModel templatePageListVO : exportList) {
            FlowEngineEntity engineEntity = flowEngineService.getById(templatePageListVO.getFlowId());
            if (ObjectUtil.isNotEmpty(engineEntity)) {

                templatePageListVO.setFlowEngineName(engineEntity.getFullName());
                templatePageListVO.setCategory(engineEntity.getCategory());
                templatePageListVO.setCategoryName(baseDataUtil.getDictName(templatePageListVO.getCategory(),"WorkFlowCategory"));
            }
            OrganizeEntity organizeInfo = serviceUtil.getOrganizeInfo(templatePageListVO.getCompanyId());
            if (ObjectUtil.isNotEmpty(organizeInfo)){
                templatePageListVO.setCompanyName(organizeInfo.getShortName());
            }
            if (ObjectUtil.isNotEmpty(templatePageListVO.getHandleId())){
                UserEntity userInfo = serviceUtil.getUserInfo(templatePageListVO.getHandleId());
                if (ObjectUtil.isNotEmpty(userInfo)){
                    templatePageListVO.setHandleName(userInfo.getRealName());
                    templatePageListVO.setLongestApprovalNode(templatePageListVO.getLongestApprovalNode()+"-"+userInfo.getRealName());
                }
            }
            if (ObjectUtil.isEmpty(templatePageListVO.getApprovalStopRate())){
                templatePageListVO.setApprovalStopRate(BigDecimal.ZERO);
            }
        }
        //转换为map输出
        List<Map<String, Object>> mapList = JsonUtil.getJsonToListMap(JsonUtil.getObjectToStringDateFormat(exportList, "yyyy-MM-dd"));
        String[] keys = !StringUtils.isEmpty(flowTimeAnalyzeExportModel.getSelectKey()) ? flowTimeAnalyzeExportModel.getSelectKey().split(",") : new String[0];
        UserInfo userInfo = userProvider.get();
        DownloadVO vo = this.creatModelExcel(configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success(vo);


    }

    //导出表格
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        List<ExcelExportEntity> entitys = new ArrayList<>();
        if (keys.length > 0) {
            for (String key : keys) {
                switch (key) {
                    case "companyName":
                        entitys.add(new ExcelExportEntity("所属公司", "companyName"));
                        break;
                    case "fullName":
                        entitys.add(new ExcelExportEntity("模板名称", "fullName"));
                        break;
                    case "flowEngineName":
                        entitys.add(new ExcelExportEntity("所属流程", "flowEngineName"));
                        break;
                    case "enCode" :
                        entitys.add(new ExcelExportEntity("流程编码" ,"enCode"));
                        break;
                    case "categoryName":
                        entitys.add(new ExcelExportEntity("流程分类", "categoryName"));
                        break;
                    case "useFrequency":
                        entitys.add(new ExcelExportEntity("使用频次", "useFrequency"));
                        break;
                    case "averageApprovalTime" :
                        entitys.add(new ExcelExportEntity("平均审批时长（分钟）" ,"averageApprovalTime"));
                        break;
                    case "longestApprovalNode":
                        entitys.add(new ExcelExportEntity("耗时最长审核节点", "longestApprovalNode"));
                        break;
                    case "longestApprovalTime":
                        entitys.add(new ExcelExportEntity("耗时最长审核节点时长（分钟）", "longestApprovalTime"));
                        break;
                    case "approvalStopRate":
                        entitys.add(new ExcelExportEntity("审批停滞率（%）", "approvalStopRate"));
                        break;
                    default:
                        break;
                }
            }
        }

        ExportParams exportParams = new ExportParams(null, "模板时效分析");
        exportParams.setType(ExcelType.XSSF);
        try {
            @Cleanup Workbook workbook = new HSSFWorkbook();
            if (entitys.size() > 0) {
                workbook = ExcelExportUtil.exportExcel(exportParams, entitys, list);
            }
            String name = "模板时效分析" + DateUtil.dateNow("yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
            String fileName = configValueUtil.getTemporaryFilePath() + name;
            @Cleanup FileOutputStream output = new FileOutputStream(XSSEscape.escapePath(fileName));
            workbook.write(output);
            //上传文件
            UploadUtil.uploadFile(configValueUtil.getFileType(), fileName, FileTypeEnum.TEMPORARY, name);

            vo.setName(name);
            vo.setUrl(UploaderUtil.uploaderFile(userInfo.getId() + "#" + name + "#" + "Temporary"));
        } catch (Exception e) {
            log.error("信息导出Excel错误:{}", e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }




}
