package com.bringspring.workflow.engine.entity;


import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 流程引擎版本号
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2025年7月23日 上午10:37
 */
@Data
@TableName("FLOW_ENGINE_TEMPLATE_VERSION")
public class FlowEngineTemplateVersionEntity {
    /**
     * 主键id
     */
    @TableId("ID")
    private String id;

    @TableField("FLOW_ID")
    private String flowId;

    /**
     * 模板id
     */
    @TableField("TEMPLATE_ID")
    private String templateId;

    /**
     * 版本号编码
     */
    @TableField("VERSION_CODE")
    private String versionCode;

    /**
     * 流程模板
     */
    @TableField("FLOW_TEMPLATE_JSON")
    private String flowTemplateJson;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME",fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID",fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME",fill = FieldFill.UPDATE)
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID",fill = FieldFill.UPDATE)
    private String lastModifyUserId;


}
