package com.bringspring.workflow.engine.model.flowmessage;

import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.entity.FlowTaskOperatorRecordEntity;
import com.bringspring.workflow.engine.enums.FlowMessageEnum;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode.MsgConfig;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class FlowMessageModel {
    private String title = "";
    private Integer type =  FlowMessageEnum.wait.getCode();
    private Integer status;
    private MsgConfig msgConfig = new MsgConfig();
    private List<String> userList = new ArrayList<>();
    private Map<String, Object> data = new HashMap<>();
    private Map<String, String> contMsg = new HashMap<>();
    private String  fullName;
    private String flowType;
    private String creatorUser;
    private FlowTaskOperatorRecordEntity recordEntity;
    private FlowTaskEntity taskEntity;
    private HashMap pageParameters;
    private String pcUrl; // ""  null  “”
    private String appUrl;  // null  ""   ""
    private String termType; // 1:支持appUrl  2:支持pcUrl  3:支持appUrl和pcUrl
    private String termTypeDesc;  // 请用手机端打开链接
}
