package com.bringspring.workflow.engine.model.flowmessage;

import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.entity.FlowTaskCirculateEntity;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.entity.FlowTaskNodeEntity;
import com.bringspring.workflow.engine.entity.FlowTaskOperatorEntity;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.nodejson.ChildNodeList;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Map;

/**
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/7/14 9:17
 */
@Data
@NoArgsConstructor
public class FlowMsgModel {
    private String title;
    private FlowEngineEntity engine;
    private FlowTaskEntity taskEntity;
    private FlowTaskNodeEntity taskNodeEntity;
    private List<FlowTaskNodeEntity> nodeList;
    private List<FlowTaskOperatorEntity> operatorList;
    private List<FlowTaskCirculateEntity> circulateList;
    private Map<String, Object> data;
    private FlowTaskOperatorEntity operator;
    //代办 (通知代办)
    private boolean wait = true;
    //同意
    private boolean approve = false;
    //拒绝
    private boolean reject = false;
    //抄送人
    private boolean copy = false;
    //结束 (通知发起人)
    private boolean end = false;
    //子流程通知
    private boolean launch = false;
    //拒绝发起节点
    private boolean start = false;
    //加签拒绝
    private boolean refuse = false;

    /**
     * 被退回的节点重新提交时的方式
     */
    private String rejectAuditType = "0";

    /**
     * 被驳回的节点
     */
    private String rejectCode;
}
