package com.bringspring.workflow.engine.model.flowtimeanalyze;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class FlowTimeAnalyzeModel {
    @ApiModelProperty(value = "编码")
    private String enCode;
    @ApiModelProperty(value = "名称")
    private String fullName;
    @ApiModelProperty(value = "主键")
    private String id;
    @ApiModelProperty(value = "引擎Id")
    private String flowId;
    @ApiModelProperty(value = "引擎名称")
    private String flowEngineName;
    @ApiModelProperty(value = "公司Id")
    private String companyId;
    @ApiModelProperty(value = "公司名称")
    private String companyName;
    @ApiModelProperty(value = "流程分类")
    private String category;
    @ApiModelProperty(value = "流程分类名称")
    private String categoryName;
    @ApiModelProperty(value = "使用频次")
    private Integer useFrequency;
    @ApiModelProperty(value = "平均审批时长")
    private String averageApprovalTime;
    @ApiModelProperty(value = "耗时最长审核节点名称")
    private String longestApprovalNode;
    @ApiModelProperty(value = "耗时最长审核节点耗时")
    private Long longestApprovalTime;
    private String handleId;
    private String handleName;
    private String taskNodeId;
    @ApiModelProperty(value = "审批停止率")
    private BigDecimal approvalStopRate;



}
