package com.bringspring.workflow.engine.service.impl;


import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.entity.FlowEngineTemplateEntity;
import com.bringspring.workflow.engine.entity.FlowEngineTemplateVersionEntity;
import com.bringspring.workflow.engine.entity.FlowEngineVisibleEntity;
import com.bringspring.workflow.engine.mapper.FlowEngineTemplateMapper;
import com.bringspring.workflow.engine.model.flowengine.FlowPagination;
import com.bringspring.workflow.engine.model.flowengine.PaginationFlowEngine;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.service.FlowEngineTemplateService;
import com.bringspring.workflow.engine.service.FlowEngineTemplateVersionService;
import com.bringspring.workflow.engine.service.FlowEngineVisibleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;


/**
 * 流程模板
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2024年8月7日 上午10:46
 */
@Service
public class FlowEngineTemplateServiceImpl extends ServiceImpl<FlowEngineTemplateMapper, FlowEngineTemplateEntity> implements FlowEngineTemplateService {
    @Autowired
    private UserProvider userProvider;

    @Autowired
    private FlowEngineVisibleService flowEngineVisibleService;

    @Autowired
    private FlowEngineService flowEngineService;

    @Autowired
    private FlowEngineTemplateVersionService flowEngineTemplateVersionService;

    @Override
    public List<FlowEngineTemplateEntity> getListByFlowId(String flowId) {
        QueryWrapper<FlowEngineTemplateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(FlowEngineTemplateEntity::getFlowId, flowId);
        return this.list(queryWrapper);
    }

    @Override
    public List<FlowEngineTemplateEntity> getListByFlowIdAndCompanyId(String flowId, String companyId) {
        QueryWrapper<FlowEngineTemplateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(FlowEngineTemplateEntity::getFlowId, flowId)
                .eq(FlowEngineTemplateEntity::getCompanyId, companyId);
        return this.list(queryWrapper);
    }

    @Override
    public List<FlowEngineTemplateEntity> getListByCompanyId(String companyId) {
        QueryWrapper<FlowEngineTemplateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(FlowEngineTemplateEntity::getCompanyId, companyId);
        return this.list(queryWrapper);
    }

    @Override
    public Boolean deleteByTemplateId(String templateId) {
        QueryWrapper<FlowEngineTemplateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(FlowEngineTemplateEntity::getId, templateId);
        return this.remove(queryWrapper);
    }

    @Override
    public List<FlowEngineTemplateEntity> getPageList(FlowPagination pagination) {
        UserInfo userInfo = userProvider.get();
        // 定义变量判断是否需要使用修改时间倒序
        boolean flag = false;
        List<String> idList = flowEngineVisibleService.getAllCompanyVisibleFlowList(userInfo.getUserId(), pagination.getMenuId()).stream()
                .map(FlowEngineVisibleEntity::getTemplateId).collect(Collectors.toList());
        QueryWrapper<FlowEngineTemplateEntity> queryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(pagination.getKeyword())) {
            flag = true;
            queryWrapper.lambda().like(FlowEngineTemplateEntity::getFullName, pagination.getKeyword());
        }
        if (ObjectUtil.isNotEmpty(pagination.getUserId())){
            flag = true;
            QueryWrapper<FlowEngineTemplateVersionEntity> wrapper = new QueryWrapper<>();
            wrapper.apply("JSON_UNQUOTE(`flow_template_json`) LIKE '%" + pagination.getUserId() + "%'");
            List<FlowEngineTemplateVersionEntity> versionList = flowEngineTemplateVersionService.list(wrapper);
            if (CollectionUtil.isNotEmpty(versionList)){
                List<String> templateIdList = versionList.stream().map(FlowEngineTemplateVersionEntity::getTemplateId).collect(Collectors.toList());
                queryWrapper.lambda().in(FlowEngineTemplateEntity::getId, templateIdList);
            }
        }

        if (ObjectUtil.isNotEmpty(pagination.getRoleId())){
            flag = true;
            QueryWrapper<FlowEngineTemplateVersionEntity> wrapper = new QueryWrapper<>();
            wrapper.apply("JSON_UNQUOTE(`flow_template_json`) LIKE '%" + pagination.getRoleId() + "%'");
            List<FlowEngineTemplateVersionEntity> versionList = flowEngineTemplateVersionService.list(wrapper);
            if (CollectionUtil.isNotEmpty(versionList)){
                List<String> templateIdList = versionList.stream().map(FlowEngineTemplateVersionEntity::getTemplateId).collect(Collectors.toList());
                queryWrapper.lambda().in(FlowEngineTemplateEntity::getId, templateIdList);
            }
        }

        if (ObjectUtil.isNotEmpty(pagination.getFormType())) {
            flag = true;
            List<FlowEngineEntity> listByKeyWord = flowEngineService.getListByKeyWord(pagination.getFormType());
            if (CollectionUtil.isNotEmpty(listByKeyWord)){
                List<String> collect = listByKeyWord.stream().map(FlowEngineEntity::getId).collect(Collectors.toList());
                queryWrapper.lambda().in(FlowEngineTemplateEntity::getFlowId, collect);
            }
        }

        if (StringUtils.isNotEmpty(pagination.getCategory())) {
            flag = true;
            List<FlowEngineEntity> listByKeyWord = flowEngineService.getListByKeyWord(pagination.getCategory());
            if (CollectionUtil.isNotEmpty(listByKeyWord)){
                List<String> collect = listByKeyWord.stream().map(FlowEngineEntity::getId).collect(Collectors.toList());
                queryWrapper.lambda().in(FlowEngineTemplateEntity::getFlowId, collect);
            }
        }

        if (ObjectUtil.isNotEmpty(pagination.getEngineName())){
            List<FlowEngineEntity> listByKeyWord = flowEngineService.getListByKeyWord(pagination.getEngineName());
            if (CollectionUtil.isNotEmpty(listByKeyWord)){
                List<String> collect = listByKeyWord.stream().map(FlowEngineEntity::getId).collect(Collectors.toList());
                queryWrapper.lambda().in(FlowEngineTemplateEntity::getFlowId, collect);
            }
        }

        if (ObjectUtil.isNotEmpty(pagination.getCompanyId())){
            flag = true;
            queryWrapper.lambda().eq(FlowEngineTemplateEntity::getCompanyId, pagination.getCompanyId());
        }


        if (idList.size() > 0) {
            queryWrapper.lambda().in(FlowEngineTemplateEntity::getId, idList);
        }
        if (!userInfo.getIsAdministrator() && ObjectUtil.isEmpty(idList)) {
            return new ArrayList<>();
        }
        //排序
        queryWrapper.lambda().orderByDesc(FlowEngineTemplateEntity::getCreatorTime)
               .isNotNull(FlowEngineTemplateEntity::getFlowId);

        if (flag) {
            queryWrapper.lambda().orderByDesc(FlowEngineTemplateEntity::getLastModifyTime);
        }


        Page<FlowEngineTemplateEntity> page = new Page<>(pagination.getCurrentPage(), pagination.getPageSize());
        IPage<FlowEngineTemplateEntity> userPage = this.page(page, queryWrapper);
        return pagination.setData(userPage.getRecords(), page.getTotal());
    }

    @Override
    public List<FlowEngineTemplateEntity> getList(PaginationFlowEngine pagination) {
        // 定义变量判断是否需要使用修改时间倒序
        boolean flag = false;
        QueryWrapper<FlowEngineTemplateEntity> queryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(pagination.getKeyword())) {
            flag = true;
            queryWrapper.lambda().like(FlowEngineTemplateEntity::getFullName, pagination.getKeyword());
        }

        //排序
        queryWrapper.lambda().orderByAsc(FlowEngineTemplateEntity::getSortCode).orderByDesc(FlowEngineTemplateEntity::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(FlowEngineTemplateEntity::getLastModifyTime);
        }

        return this.list(queryWrapper);

    }
}
