package com.bringspring.workflow.engine.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.*;
import com.bringspring.workflow.engine.entity.FlowEngineTemplateEntity;
import com.bringspring.workflow.engine.entity.FlowEngineVisibleEntity;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.entity.FlowTaskOperatorRecordEntity;
import com.bringspring.workflow.engine.mapper.FlowEngineTemplateMapper;
import com.bringspring.workflow.engine.model.flowengine.FlowPagination;
import com.bringspring.workflow.engine.model.flowtimeanalyze.FlowTimeAnalyzeModel;
import com.bringspring.workflow.engine.model.flowtimeanalyze.LongestNodeDurationVO;
import com.bringspring.workflow.engine.service.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

@Slf4j
@Service
public class FlowTimeAnalyzeServiceImpl extends ServiceImpl<FlowEngineTemplateMapper, FlowEngineTemplateEntity> implements FlowTimeAnalyzeService {

    @Autowired
    private UserProvider userProvider;

    @Autowired
    private FlowEngineVisibleService flowEngineVisibleService;

    @Autowired
    private FlowEngineService flowEngineService;

    @Autowired
    private FlowEngineTemplateVersionService flowEngineTemplateVersionService;

    @Autowired
    private FlowEngineTemplateService flowEngineTemplateService;

    @Autowired
    private FlowTaskService flowTaskService;

    @Autowired
    private FlowTaskOperatorRecordService flowTaskOperatorRecordService;

    @Autowired
    private FlowEngineTemplateMapper flowEngineTemplateMapper;


    @Override
    public List<FlowTimeAnalyzeModel> getPageList(FlowPagination pagination) {
        List<FlowTimeAnalyzeModel> resultList = appendWrapper(pagination);

        return pagination.setData(PageUtil.getPage((int) pagination.getCurrentPage(), (int) pagination.getPageSize(), resultList), resultList.size());
    }

    private List<FlowTimeAnalyzeModel> appendWrapper(FlowPagination pagination) {
        UserInfo userInfo = userProvider.get();

        List<Date> dateList = pagination.getDateList().stream()
                .map(Date::new) // 直接使用 Date 的构造函数
                .collect(Collectors.toList());

        // 定义变量判断是否需要使用修改时间倒序

        List<String> idList = flowEngineVisibleService.getAllCompanyVisibleFlowList(userInfo.getUserId(), pagination.getMenuId()).stream()
                .map(FlowEngineVisibleEntity::getTemplateId).collect(Collectors.toList());
        Map<String, Object> queryParam = new HashMap<>(16);
        StringBuilder dbSql = new StringBuilder();
        String keyWord = pagination.getKeyword() != null ? pagination.getKeyword() : null;
        if (StringUtils.isNotEmpty(pagination.getKeyword())) {

            dbSql.append(" AND t.Full_Name like '%" + keyWord + "%' ");
        }


        String companyId = pagination.getCompanyId() != null ? pagination.getCompanyId() : null;
        if (ObjectUtil.isNotEmpty(pagination.getCompanyId())) {

            dbSql.append(" AND t.COMPANY_ID = '" + companyId + "' ");
        }

        //所属分类
        String flowCategory = pagination.getCategory() != null ? pagination.getCategory() : null;
        if (ObjectUtil.isNotEmpty(flowCategory)) {
            dbSql.append(" AND t.FLOW_CATEGORY = '" + flowCategory + "' ");
        }

        queryParam.put("startTime", dateList.get(0));
        queryParam.put("endTime", dateList.get(1));
        String sortField = pagination.getSidx();
        String sortOrder = pagination.getSort();
        StringBuilder orderBySql = new StringBuilder();
        Map<String, String> allowedSortFields = new HashMap<>();
        allowedSortFields.put("useFrequency", "use_frequency");
        allowedSortFields.put("averageApprovalTime", "average_approval_time");
        allowedSortFields.put("longestApprovalTime", "longest_node_duration_minutes");
        allowedSortFields.put("approvalStopRate", "stagnation_rate_percentage");
        if (ObjectUtil.isNotEmpty(sortField) && allowedSortFields.containsKey(sortField)) {
            String dbColumn = allowedSortFields.get(sortField);
            String order = "asc".equalsIgnoreCase(sortOrder) ? "ASC" : "DESC";
            orderBySql.append(dbColumn).append(" ").append(order);
        }
        queryParam.put("orderByClause", orderBySql.toString());
        queryParam.put("sql", dbSql.toString());



        if (!userInfo.getIsAdministrator() && ObjectUtil.isEmpty(idList)) {
            return new ArrayList<>();
        }
        List<FlowTimeAnalyzeModel> modelList = flowEngineTemplateMapper.getFlowTimeAnalyze(queryParam);
        List<FlowTimeAnalyzeModel> resultList = new ArrayList<>();
        if (idList.size() > 0) {
            resultList = modelList.stream().filter(t -> idList.contains(t.getId())).collect(Collectors.toList());
        }else {
            resultList = modelList;
        }
        return resultList;
/*        List<FlowEngineTemplateEntity> templateList = flowEngineTemplateService.list(queryWrapper);
        List<FlowTimeAnalyzeModel> timeAnalyzeList = JsonUtil.getJsonToList(templateList, FlowTimeAnalyzeModel.class);
        timeAnalyzeList.stream().forEach(template -> {
            //查询时间范围内的所有流程任务
            List<FlowTaskEntity> listByTemplateId = flowTaskService.getListByTemplateId(template.getId(), dateRangeList);
            //使用频次
            template.setUseFrequency(listByTemplateId.size());
            //获取平均审批时长
            List<FlowTaskEntity> endRoundTaskList = listByTemplateId.stream().filter(task -> task.getStatus().equals(2)).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(endRoundTaskList)) {
                OptionalDouble avgDurationMillisOptional = endRoundTaskList.stream()
                        .filter(task -> task.getStartTime() != null && task.getEndTime() != null)
                        .mapToLong(task -> task.getEndTime().getTime() - task.getStartTime().getTime())
                        .average();
                if (avgDurationMillisOptional.isPresent()) {
                    double avgDurationMillis = avgDurationMillisOptional.getAsDouble();
                    // 将毫秒转成分钟
                    double avgDurationMinutes = avgDurationMillis / (1000.0 * 60);
                    String formattedTime = String.format("%.2f", avgDurationMinutes);
                    template.setAverageApprovalTime(formattedTime);
                } else {
                    template.setAverageApprovalTime("0");
                }
            } else {
                template.setAverageApprovalTime("0");
            }
            AtomicLong totalOvertimeNodeCount = new AtomicLong(0L);
//            if (CollectionUtil.isNotEmpty(taskIds)) {
                List<FlowTaskOperatorRecordEntity> allRecords = flowTaskOperatorRecordService.getListByTemplateId(template.getId());
                if (CollectionUtil.isNotEmpty(allRecords)){
                Map<String, List<FlowTaskOperatorRecordEntity>> recordsByTaskId = allRecords.stream()
                        .collect(Collectors.groupingBy(FlowTaskOperatorRecordEntity::getTaskId));
                    recordsByTaskId.forEach((taskId, recordList) -> {
//                    List<FlowTaskOperatorRecordEntity> recordList = recordsByTaskId.get(task.getId());
                    if (CollectionUtil.isEmpty(recordList)) {
                        return;
                    }
                    LongestNodeDurationVO longestNode = new LongestNodeDurationVO();
                    longestNode.setDurationMinutes(0L);

                    for (int i = 0; i < recordList.size(); i++) {
                        FlowTaskOperatorRecordEntity currentRecord = recordList.get(i);
                        long currentDuration = 0L;
                        if (i > 0) {
                            if (!currentRecord.getNodeName().equals("开始")){
                                FlowTaskOperatorRecordEntity previousRecord = recordList.get(i - 1);
                                currentDuration = DateUtil.between(
                                        previousRecord.getHandleTime(),
                                        currentRecord.getHandleTime(),
                                        DateUnit.MINUTE
                                );
                            }
                        }

                        if (currentDuration > longestNode.getDurationMinutes()) {
                            longestNode.setNodeName(currentRecord.getNodeName());
                            longestNode.setTaskNodeId(currentRecord.getTaskNodeId());
                            longestNode.setHandleId(currentRecord.getHandleId());
                            longestNode.setDurationMinutes(currentDuration);
                        }
                        if (currentDuration>1440L){
                            totalOvertimeNodeCount.incrementAndGet();
                        }

                    }
                    if (totalOvertimeNodeCount.get() > 0){
//                        BigDecimal totalCount = BigDecimal.valueOf(totalOvertimeNodeCount.get());
//                        BigDecimal taskCount = BigDecimal.valueOf(taskIds.size());
//                        BigDecimal averageOvertimeRates = totalCount.divide(taskCount, 4, RoundingMode.HALF_UP);
//                        template.setApprovalStopRate(averageOvertimeRates);
                    }
                    if (ObjectUtil.isEmpty(template.getLongestApprovalTime())){
                        template.setLongestApprovalTime(0L);
                    }
                    if (longestNode.getDurationMinutes()>template.getLongestApprovalTime()){
                        template.setLongestApprovalNode(longestNode.getNodeName());
                        template.setLongestApprovalTime(longestNode.getDurationMinutes());
                        template.setTaskNodeId(longestNode.getTaskNodeId());
                        template.setHandleId(longestNode.getHandleId());
                    }


                });
            }
        });
        //排序
        List<FlowTimeAnalyzeModel> sortedList = timeAnalyzeList.stream()
                .sorted(Comparator.comparingInt(FlowTimeAnalyzeModel::getUseFrequency).reversed())
                .collect(Collectors.toList());
        return sortedList;*/
    }


    @Override
    public List<FlowTimeAnalyzeModel> getExportList(FlowPagination pagination, String dataType) {
        List<FlowTimeAnalyzeModel> resultList = appendWrapper(pagination);
        if ("0".equals(dataType)) {
            return pagination.setData(PageUtil.getPage((int) pagination.getCurrentPage(), (int) pagination.getPageSize(), resultList), resultList.size());
        } else {
            return resultList;
        }

    }
}
