package com.bringspring.workflow.form.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import com.bringspring.workflow.form.entity.SalesOrderEntity;
import com.bringspring.workflow.form.entity.SalesOrderEntryEntity;
import com.bringspring.workflow.form.model.salesorder.SalesOrderEntryEntityInfoModel;
import com.bringspring.workflow.form.model.salesorder.SalesOrderForm;
import com.bringspring.workflow.form.model.salesorder.SalesOrderInfoVO;
import com.bringspring.workflow.form.service.SalesOrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 销售订单
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月29日 上午9:18
 */
@Api(tags = "销售订单", value = "SalesOrder")
@RestController
@RequestMapping("/api/workflow/Form/SalesOrder")
public class SalesOrderController {

    @Autowired
    private SalesOrderService salesOrderService;

    /**
     * 获取销售订单信息
     *
     * @param id 主键值
     * @return
     */
    @ApiOperation("获取销售订单信息")
    @GetMapping("/{id}")
    public ActionResult info(@PathVariable("id") String id){
        SalesOrderEntity entity = salesOrderService.getInfo(id);
        List<SalesOrderEntryEntity> entityList = salesOrderService.getSalesEntryList(id);
        SalesOrderInfoVO vo = JsonUtil.getJsonToBean(entity, SalesOrderInfoVO.class);
        vo.setEntryList(JsonUtil.getJsonToList(entityList, SalesOrderEntryEntityInfoModel.class));
        return ActionResult.success(vo);
    }

    /**
     * 新建销售订单
     *
     * @param salesOrderForm 表单对象
     * @return
     * @throws WorkFlowException
     */
    @ApiOperation("新建销售订单")
    @PostMapping
    public ActionResult create(@RequestBody SalesOrderForm salesOrderForm) throws WorkFlowException, DataException {
        SalesOrderEntity sales = JsonUtil.getJsonToBean(salesOrderForm, SalesOrderEntity.class);
        List<SalesOrderEntryEntity> salesEntryList = JsonUtil.getJsonToList(salesOrderForm.getEntryList(), SalesOrderEntryEntity.class);
        if (FlowTaskStatusEnum.Draft.getCode().equals(salesOrderForm.getStatus())) {
            salesOrderService.save(sales.getId(), sales, salesEntryList);
            return ActionResult.success(MsgCode.SU002.get());
        }
        salesOrderService.submit(sales.getId(), sales, salesEntryList,salesOrderForm.getCandidateList());
        return ActionResult.success(MsgCode.SU006.get());
    }

    /**
     * 修改销售订单
     *
     * @param salesOrderForm 表单对象
     * @param id             主键
     * @return
     * @throws WorkFlowException
     */
    @ApiOperation("修改销售订单")
    @PutMapping("/{id}")
    public ActionResult update(@RequestBody SalesOrderForm salesOrderForm, @PathVariable("id") String id) throws WorkFlowException, DataException {
        SalesOrderEntity sales = JsonUtil.getJsonToBean(salesOrderForm, SalesOrderEntity.class);
        List<SalesOrderEntryEntity> salesEntryList = JsonUtil.getJsonToList(salesOrderForm.getEntryList(), SalesOrderEntryEntity.class);
        if (FlowTaskStatusEnum.Draft.getCode().equals(salesOrderForm.getStatus())) {
            salesOrderService.save(id, sales, salesEntryList);
            return ActionResult.success(MsgCode.SU002.get());
        }
        salesOrderService.submit(id, sales, salesEntryList,salesOrderForm.getCandidateList());
        return ActionResult.success(MsgCode.SU006.get());
    }
}
