/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.engine.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import com.bringspring.workflow.engine.model.flowtask.FlowTaskForm;
import com.bringspring.workflow.engine.model.flowtask.FlowTaskInfoVO;
import com.bringspring.workflow.engine.service.FlowDynamicService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6d41\u7a0b\u5f15\u64ce"}, value="FlowTask")
@RestController
@RequestMapping(value={"/api/workflow/Engine/FlowTask"})
public class FlowTaskController {
    @Autowired
    private FlowDynamicService flowDynamicService;
    @Autowired
    private FlowTaskService flowTaskService;

    @ApiOperation(value="\u52a8\u6001\u8868\u5355\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<FlowTaskInfoVO> dataInfo(@PathVariable(value="id") String id, String taskOperatorId) throws WorkFlowException {
        FlowTaskEntity entity = this.flowTaskService.getInfo(id);
        FlowTaskInfoVO vo = this.flowDynamicService.info(entity, taskOperatorId);
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u4fdd\u5b58")
    @PostMapping
    public ActionResult save(@RequestBody FlowTaskForm flowTaskForm) throws WorkFlowException, DataException {
        if (FlowTaskStatusEnum.Draft.getCode().equals(flowTaskForm.getStatus())) {
            this.flowDynamicService.save(null, flowTaskForm);
            return ActionResult.success((String)MsgCode.SU002.get());
        }
        this.flowDynamicService.submit(null, flowTaskForm);
        return ActionResult.success((String)MsgCode.SU006.get());
    }

    @ApiOperation(value="\u63d0\u4ea4")
    @PutMapping(value={"/{id}"})
    public ActionResult submit(@RequestBody FlowTaskForm flowTaskForm, @PathVariable(value="id") String id) throws WorkFlowException, DataException {
        if (FlowTaskStatusEnum.Draft.getCode().equals(flowTaskForm.getStatus())) {
            this.flowDynamicService.save(id, flowTaskForm);
            return ActionResult.success((String)MsgCode.SU002.get());
        }
        this.flowDynamicService.submit(id, flowTaskForm);
        return ActionResult.success((String)MsgCode.SU006.get());
    }

    @ApiOperation(value="\u52a8\u6001\u8868\u5355\u4fe1\u606f")
    @GetMapping(value={"/{flowId}/{id}"})
    public ActionResult<Map<String, Object>> info(@PathVariable(value="flowId") String flowId, @PathVariable(value="id") String id) throws WorkFlowException {
        Map<String, Object> data = this.flowDynamicService.getData(flowId, id);
        return ActionResult.success(data);
    }
}

