/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.engine.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.model.flowengine.FlowPagination;
import com.bringspring.workflow.engine.model.flowtimeanalyze.FlowTimeAnalyzeExportModel;
import com.bringspring.workflow.engine.model.flowtimeanalyze.FlowTimeAnalyzeModel;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.service.FlowEngineTemplateService;
import com.bringspring.workflow.engine.service.FlowEngineTemplateVersionService;
import com.bringspring.workflow.engine.service.FlowEngineVisibleService;
import com.bringspring.workflow.engine.service.FlowTimeAnalyzeService;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6d41\u7a0b\u6a21\u677f"}, value="FlowTimeAnalyze")
@RestController
@RequestMapping(value={"/api/workflow/Engine/FlowTimeAnalyze"})
public class FlowTimeAnalyzeController {
    private static final Logger log = LoggerFactory.getLogger(FlowTimeAnalyzeController.class);
    @Autowired
    private FlowEngineService flowEngineService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private FlowEngineTemplateService flowEngineTemplateService;
    @Autowired
    private FlowEngineVisibleService flowEngineVisibleService;
    @Autowired
    private FlowEngineTemplateVersionService flowEngineTemplateVersionService;
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private FlowTimeAnalyzeService flowTimeAnalyzeService;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u6a21\u677f\u5217\u8868")
    @GetMapping
    public ActionResult list(FlowPagination pagination) {
        List<FlowTimeAnalyzeModel> pageList = this.flowTimeAnalyzeService.getPageList(pagination);
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        for (FlowTimeAnalyzeModel templatePageListVO : pageList) {
            UserEntity userInfo;
            OrganizeEntity organizeInfo;
            FlowEngineEntity engineEntity = (FlowEngineEntity)this.flowEngineService.getById((Serializable)((Object)templatePageListVO.getFlowId()));
            if (ObjectUtil.isNotEmpty((Object)engineEntity)) {
                templatePageListVO.setFlowEngineName(engineEntity.getFullName());
                templatePageListVO.setCategory(engineEntity.getCategory());
                templatePageListVO.setCategoryName(this.baseDataUtil.getDictName(templatePageListVO.getCategory(), "WorkFlowCategory"));
            }
            if (ObjectUtil.isNotEmpty((Object)(organizeInfo = this.serviceUtil.getOrganizeInfo(templatePageListVO.getCompanyId())))) {
                templatePageListVO.setCompanyName(organizeInfo.getShortName());
            }
            if (!ObjectUtil.isNotEmpty((Object)templatePageListVO.getHandleId()) || !ObjectUtil.isNotEmpty((Object)(userInfo = this.serviceUtil.getUserInfo(templatePageListVO.getHandleId())))) continue;
            templatePageListVO.setHandleName(userInfo.getRealName());
            templatePageListVO.setLongestApprovalNode(templatePageListVO.getLongestApprovalNode() + "-" + userInfo.getRealName());
        }
        return ActionResult.page(pageList, (PaginationVO)paginationVO);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @PostMapping(value={"/Actions/Export"})
    public ActionResult Export(@RequestBody FlowTimeAnalyzeExportModel flowTimeAnalyzeExportModel) throws IOException {
        if (StringUtils.isEmpty((String)flowTimeAnalyzeExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        FlowPagination flowPagination = (FlowPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)flowTimeAnalyzeExportModel), FlowPagination.class));
        List<FlowTimeAnalyzeModel> exportList = this.flowTimeAnalyzeService.getExportList(flowPagination, flowTimeAnalyzeExportModel.getDataType());
        for (FlowTimeAnalyzeModel templatePageListVO : exportList) {
            UserEntity userInfo;
            OrganizeEntity organizeInfo;
            FlowEngineEntity engineEntity = (FlowEngineEntity)this.flowEngineService.getById((Serializable)((Object)templatePageListVO.getFlowId()));
            if (ObjectUtil.isNotEmpty((Object)engineEntity)) {
                templatePageListVO.setFlowEngineName(engineEntity.getFullName());
                templatePageListVO.setCategory(engineEntity.getCategory());
                templatePageListVO.setCategoryName(this.baseDataUtil.getDictName(templatePageListVO.getCategory(), "WorkFlowCategory"));
            }
            if (ObjectUtil.isNotEmpty((Object)(organizeInfo = this.serviceUtil.getOrganizeInfo(templatePageListVO.getCompanyId())))) {
                templatePageListVO.setCompanyName(organizeInfo.getShortName());
            }
            if (ObjectUtil.isNotEmpty((Object)templatePageListVO.getHandleId()) && ObjectUtil.isNotEmpty((Object)(userInfo = this.serviceUtil.getUserInfo(templatePageListVO.getHandleId())))) {
                templatePageListVO.setHandleName(userInfo.getRealName());
                templatePageListVO.setLongestApprovalNode(templatePageListVO.getLongestApprovalNode() + "-" + userInfo.getRealName());
            }
            if (!ObjectUtil.isEmpty((Object)templatePageListVO.getApprovalStopRate())) continue;
            templatePageListVO.setApprovalStopRate(BigDecimal.ZERO);
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat(exportList, (String)"yyyy-MM-dd"));
        String[] keys = !StringUtils.isEmpty((String)flowTimeAnalyzeExportModel.getSelectKey()) ? flowTimeAnalyzeExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block32: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "companyName": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u516c\u53f8", (Object)"companyName"));
                        continue block32;
                    }
                    case "fullName": {
                        entitys.add(new ExcelExportEntity("\u6a21\u677f\u540d\u79f0", (Object)"fullName"));
                        continue block32;
                    }
                    case "flowEngineName": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u6d41\u7a0b", (Object)"flowEngineName"));
                        continue block32;
                    }
                    case "enCode": {
                        entitys.add(new ExcelExportEntity("\u6d41\u7a0b\u7f16\u7801", (Object)"enCode"));
                        continue block32;
                    }
                    case "categoryName": {
                        entitys.add(new ExcelExportEntity("\u6d41\u7a0b\u5206\u7c7b", (Object)"categoryName"));
                        continue block32;
                    }
                    case "useFrequency": {
                        entitys.add(new ExcelExportEntity("\u4f7f\u7528\u9891\u6b21", (Object)"useFrequency"));
                        continue block32;
                    }
                    case "averageApprovalTime": {
                        entitys.add(new ExcelExportEntity("\u5e73\u5747\u5ba1\u6279\u65f6\u957f\uff08\u5206\u949f\uff09", (Object)"averageApprovalTime"));
                        continue block32;
                    }
                    case "longestApprovalNode": {
                        entitys.add(new ExcelExportEntity("\u8017\u65f6\u6700\u957f\u5ba1\u6838\u8282\u70b9", (Object)"longestApprovalNode"));
                        continue block32;
                    }
                    case "longestApprovalTime": {
                        entitys.add(new ExcelExportEntity("\u8017\u65f6\u6700\u957f\u5ba1\u6838\u8282\u70b9\u65f6\u957f\uff08\u5206\u949f\uff09", (Object)"longestApprovalTime"));
                        continue block32;
                    }
                    case "approvalStopRate": {
                        entitys.add(new ExcelExportEntity("\u5ba1\u6279\u505c\u6ede\u7387\uff08%\uff09", (Object)"approvalStopRate"));
                        continue block32;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u6a21\u677f\u65f6\u6548\u5206\u6790");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u6a21\u677f\u65f6\u6548\u5206\u6790" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }
}

