/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.engine.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.entity.FlowEngineTemplateEntity;
import com.bringspring.workflow.engine.entity.FlowEngineTemplateVersionEntity;
import com.bringspring.workflow.engine.entity.FlowEngineVisibleEntity;
import com.bringspring.workflow.engine.mapper.FlowEngineTemplateMapper;
import com.bringspring.workflow.engine.model.flowengine.FlowPagination;
import com.bringspring.workflow.engine.model.flowengine.PaginationFlowEngine;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.service.FlowEngineTemplateService;
import com.bringspring.workflow.engine.service.FlowEngineTemplateVersionService;
import com.bringspring.workflow.engine.service.FlowEngineVisibleService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowEngineTemplateServiceImpl
extends ServiceImpl<FlowEngineTemplateMapper, FlowEngineTemplateEntity>
implements FlowEngineTemplateService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private FlowEngineVisibleService flowEngineVisibleService;
    @Autowired
    private FlowEngineService flowEngineService;
    @Autowired
    private FlowEngineTemplateVersionService flowEngineTemplateVersionService;

    @Override
    public List<FlowEngineTemplateEntity> getListByFlowId(String flowId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowEngineTemplateEntity::getFlowId, (Object)flowId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<FlowEngineTemplateEntity> getListByFlowIdAndCompanyId(String flowId, String companyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(FlowEngineTemplateEntity::getFlowId, (Object)flowId)).eq(FlowEngineTemplateEntity::getCompanyId, (Object)companyId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<FlowEngineTemplateEntity> getListByCompanyId(String companyId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowEngineTemplateEntity::getCompanyId, (Object)companyId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public Boolean deleteByTemplateId(String templateId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(FlowEngineTemplateEntity::getId, (Object)templateId);
        return this.remove((Wrapper)queryWrapper);
    }

    @Override
    public List<FlowEngineTemplateEntity> getPageList(FlowPagination pagination) {
        List collect;
        List<FlowEngineEntity> listByKeyWord;
        List templateIdList;
        List versionList;
        QueryWrapper wrapper;
        UserInfo userInfo = this.userProvider.get();
        boolean flag = false;
        List idList = this.flowEngineVisibleService.getAllCompanyVisibleFlowList(userInfo.getUserId(), pagination.getMenuId()).stream().map(FlowEngineVisibleEntity::getTemplateId).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)pagination.getKeyword())) {
            flag = true;
            queryWrapper.lambda().like(FlowEngineTemplateEntity::getFullName, (Object)pagination.getKeyword());
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getUserId())) {
            flag = true;
            wrapper = new QueryWrapper();
            wrapper.apply("JSON_UNQUOTE(`flow_template_json`) LIKE '%" + pagination.getUserId() + "%'", new Object[0]);
            versionList = this.flowEngineTemplateVersionService.list((Wrapper)wrapper);
            if (CollectionUtil.isNotEmpty((Collection)versionList)) {
                templateIdList = versionList.stream().map(FlowEngineTemplateVersionEntity::getTemplateId).collect(Collectors.toList());
                queryWrapper.lambda().in(FlowEngineTemplateEntity::getId, templateIdList);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getRoleId())) {
            flag = true;
            wrapper = new QueryWrapper();
            wrapper.apply("JSON_UNQUOTE(`flow_template_json`) LIKE '%" + pagination.getRoleId() + "%'", new Object[0]);
            versionList = this.flowEngineTemplateVersionService.list((Wrapper)wrapper);
            if (CollectionUtil.isNotEmpty((Collection)versionList)) {
                templateIdList = versionList.stream().map(FlowEngineTemplateVersionEntity::getTemplateId).collect(Collectors.toList());
                queryWrapper.lambda().in(FlowEngineTemplateEntity::getId, templateIdList);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getFormType())) {
            flag = true;
            listByKeyWord = this.flowEngineService.getListByKeyWord(pagination.getFormType());
            if (CollectionUtil.isNotEmpty(listByKeyWord)) {
                collect = listByKeyWord.stream().map(FlowEngineEntity::getId).collect(Collectors.toList());
                queryWrapper.lambda().in(FlowEngineTemplateEntity::getFlowId, collect);
            }
        }
        if (StringUtils.isNotEmpty((String)pagination.getCategory())) {
            flag = true;
            listByKeyWord = this.flowEngineService.getListByKeyWord(pagination.getCategory());
            if (CollectionUtil.isNotEmpty(listByKeyWord)) {
                collect = listByKeyWord.stream().map(FlowEngineEntity::getId).collect(Collectors.toList());
                queryWrapper.lambda().in(FlowEngineTemplateEntity::getFlowId, collect);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getEngineName()) && CollectionUtil.isNotEmpty(listByKeyWord = this.flowEngineService.getListByKeyWord(pagination.getEngineName()))) {
            collect = listByKeyWord.stream().map(FlowEngineEntity::getId).collect(Collectors.toList());
            queryWrapper.lambda().in(FlowEngineTemplateEntity::getFlowId, collect);
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getCompanyId())) {
            flag = true;
            queryWrapper.lambda().eq(FlowEngineTemplateEntity::getCompanyId, (Object)pagination.getCompanyId());
        }
        if (idList.size() > 0) {
            queryWrapper.lambda().in(FlowEngineTemplateEntity::getId, idList);
        }
        if (!userInfo.getIsAdministrator().booleanValue() && ObjectUtil.isEmpty(idList)) {
            return new ArrayList<FlowEngineTemplateEntity>();
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByDesc(FlowEngineTemplateEntity::getCreatorTime)).isNotNull(FlowEngineTemplateEntity::getFlowId);
        if (flag) {
            queryWrapper.lambda().orderByDesc(FlowEngineTemplateEntity::getLastModifyTime);
        }
        Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
        IPage userPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return pagination.setData(userPage.getRecords(), page.getTotal());
    }

    @Override
    public List<FlowEngineTemplateEntity> getList(PaginationFlowEngine pagination) {
        boolean flag = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)pagination.getKeyword())) {
            flag = true;
            queryWrapper.lambda().like(FlowEngineTemplateEntity::getFullName, (Object)pagination.getKeyword());
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(FlowEngineTemplateEntity::getSortCode)).orderByDesc(FlowEngineTemplateEntity::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(FlowEngineTemplateEntity::getLastModifyTime);
        }
        return this.list((Wrapper)queryWrapper);
    }
}

