/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.engine.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.FormAllModel;
import com.bringspring.common.model.FormEnum;
import com.bringspring.common.model.visiual.FormCloumnUtil;
import com.bringspring.common.model.visiual.FormDataModel;
import com.bringspring.common.model.visiual.RecursionForm;
import com.bringspring.common.model.visiual.TableModel;
import com.bringspring.common.model.visiual.fields.FieLdsModel;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ReflectionUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.common.util.wxutil.HttpUtil;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowCandidatesEntity;
import com.bringspring.workflow.engine.entity.FlowDelegateEntity;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.entity.FlowEngineTemplateEntity;
import com.bringspring.workflow.engine.entity.FlowEngineTemplateVersionEntity;
import com.bringspring.workflow.engine.entity.FlowTaskCirculateEntity;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.entity.FlowTaskNodeEntity;
import com.bringspring.workflow.engine.entity.FlowTaskOperatorEntity;
import com.bringspring.workflow.engine.entity.FlowTaskOperatorRecordEntity;
import com.bringspring.workflow.engine.enums.FlowNodeEnum;
import com.bringspring.workflow.engine.enums.FlowRecordEnum;
import com.bringspring.workflow.engine.enums.FlowRecordListEnum;
import com.bringspring.workflow.engine.enums.FlowTaskOperatorEnum;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import com.bringspring.workflow.engine.model.DataModel;
import com.bringspring.workflow.engine.model.FlowHandleModel;
import com.bringspring.workflow.engine.model.flowbefore.FlowAutoAgreeModel;
import com.bringspring.workflow.engine.model.flowbefore.FlowBeforeInfoVO;
import com.bringspring.workflow.engine.model.flowbefore.FlowSummary;
import com.bringspring.workflow.engine.model.flowbefore.FlowTaskModel;
import com.bringspring.workflow.engine.model.flowbefore.FlowTaskNodeModel;
import com.bringspring.workflow.engine.model.flowbefore.FlowTaskOperatorModel;
import com.bringspring.workflow.engine.model.flowbefore.FlowTaskOperatorRecordModel;
import com.bringspring.workflow.engine.model.flowcandidate.FlowCandidateUserModel;
import com.bringspring.workflow.engine.model.flowcandidate.FlowCandidateVO;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import com.bringspring.workflow.engine.model.flowengine.FlowOperatordModel;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode.AgreeRule;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode.ChildNode;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode.FlowAssignModel;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode.FormOperates;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode.Properties;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.nodejson.ChildNodeList;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.nodejson.ConditionList;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.nodejson.Custom;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.nodejson.DateProperties;
import com.bringspring.workflow.engine.model.flowmessage.FlowMsgModel;
import com.bringspring.workflow.engine.model.flowtask.FlowConditionModel;
import com.bringspring.workflow.engine.model.flowtask.method.TaskHandleIdStatus;
import com.bringspring.workflow.engine.model.flowtask.method.TaskOperatoUser;
import com.bringspring.workflow.engine.model.flowtask.method.TaskOperator;
import com.bringspring.workflow.engine.service.FlowCandidatesService;
import com.bringspring.workflow.engine.service.FlowDelegateService;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.service.FlowEngineTemplateService;
import com.bringspring.workflow.engine.service.FlowEngineTemplateVersionService;
import com.bringspring.workflow.engine.service.FlowTaskCirculateService;
import com.bringspring.workflow.engine.service.FlowTaskNewService;
import com.bringspring.workflow.engine.service.FlowTaskNodeService;
import com.bringspring.workflow.engine.service.FlowTaskOperatorRecordService;
import com.bringspring.workflow.engine.service.FlowTaskOperatorService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.bringspring.workflow.engine.util.FlowDataUtil;
import com.bringspring.workflow.engine.util.FlowJsonUtil;
import com.bringspring.workflow.engine.util.FlowMsgUtil;
import com.bringspring.workflow.engine.util.FlowNature;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowTaskNewServiceImpl
implements FlowTaskNewService {
    private static final Logger log = LoggerFactory.getLogger(FlowTaskNewServiceImpl.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private FlowCandidatesService flowCandidatesService;
    @Autowired
    private FlowTaskNodeService flowTaskNodeService;
    @Autowired
    private FlowTaskOperatorService flowTaskOperatorService;
    @Autowired
    private FlowTaskOperatorRecordService flowTaskOperatorRecordService;
    @Autowired
    private FlowTaskCirculateService flowTaskCirculateService;
    @Autowired
    private FlowEngineService flowEngineService;
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private FlowDataUtil flowDataUtil;
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private FlowMsgUtil flowMsgUtil;
    @Autowired
    private FlowDelegateService flowDelegateService;
    @Autowired
    private FlowEngineTemplateService flowEngineTemplateService;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private FlowEngineTemplateVersionService flowEngineTemplateVersionService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private RoleService roleService;
    private String taskNodeId = "taskNodeId";
    private String taskId = "taskId";
    private String user = "admin";

    @Override
    @DSTransactional
    public FlowTaskEntity save(FlowModel flowModel) throws WorkFlowException {
        String flowId = flowModel.getFlowId();
        UserInfo userInfo = this.userProvider.get();
        flowModel.setStatus(flowModel.getStatus());
        String userId = StringUtils.isNotEmpty((String)flowModel.getUserId()) ? flowModel.getUserId() : userInfo.getUserId();
        FlowEngineEntity engine = this.flowEngineService.getInfo(flowId);
        boolean flag = flowModel.getId() == null;
        FlowTaskEntity taskEntity = new FlowTaskEntity();
        if (!flag && !FlowNature.ParentId.equals((taskEntity = this.flowTaskService.getInfo(flowModel.getId())).getParentId())) {
            flowModel.setParentId(taskEntity.getParentId());
            flowModel.setFlowTitle(taskEntity.getFullName());
            flowModel.setIsAsync(FlowNature.ChildAsync.equals(taskEntity.getIsAsync()));
        }
        this.task(taskEntity, engine, flowModel, userId);
        if (flag) {
            this.flowTaskService.create(taskEntity);
        } else {
            this.flowTaskService.update(taskEntity);
        }
        return taskEntity;
    }

    @Override
    public void submit(FlowModel flowModel) throws WorkFlowException {
        FlowAutoAgreeModel flowAutoAgreeModel = this.submitFlowTask(flowModel);
        this.isAutoAgree(flowAutoAgreeModel.getNextChildNodeList(), flowAutoAgreeModel.getFlowTask(), flowAutoAgreeModel.getFlowModel(), flowAutoAgreeModel.getFlowMsgModel());
    }

    @Override
    @DSTransactional
    public FlowAutoAgreeModel submitFlowTask(FlowModel flowModel) throws WorkFlowException {
        boolean isEnd;
        Iterator<FlowTaskOperatorEntity> rejectOptional;
        FlowTaskOperatorEntity rejectOperator;
        Optional<FlowTaskOperatorEntity> firstNode;
        UserInfo userInfo = this.userProvider.get();
        flowModel.setStatus(FlowTaskStatusEnum.Handle.getCode());
        FlowTaskEntity flowTask = this.save(flowModel);
        FlowEngineEntity engine = this.flowEngineService.getInfo(flowTask.getFlowId());
        flowTask.setStartTime(new Date());
        flowModel.setOperatorId(FlowNature.ParentId);
        LinkedList<FlowTaskNodeEntity> taskNodeList = new LinkedList<FlowTaskNodeEntity>();
        ArrayList<FlowTaskOperatorEntity> operatorList = new ArrayList<FlowTaskOperatorEntity>();
        FlowEngineTemplateVersionEntity versionEntity = (FlowEngineTemplateVersionEntity)this.flowEngineTemplateVersionService.getById((Serializable)((Object)flowTask.getVersionId()));
        String formDataJson = versionEntity.getFlowTemplateJson();
        ChildNode childNodeAll = (ChildNode)JsonUtil.getJsonToBean((String)formDataJson, ChildNode.class);
        ArrayList<ChildNodeList> nodeListAll = new ArrayList<ChildNodeList>();
        ArrayList<ConditionList> conditionListAll = new ArrayList<ConditionList>();
        this.updateNodeList(flowTask, childNodeAll, nodeListAll, conditionListAll, taskNodeList);
        this.nodeListAll(taskNodeList, flowModel, true);
        Optional<FlowTaskNodeEntity> first = taskNodeList.stream().filter(t -> FlowNature.NodeStart.equals(t.getNodeType())).findFirst();
        if (!first.isPresent()) {
            throw new WorkFlowException(MsgCode.COD001.get());
        }
        FlowTaskNodeEntity startNode = first.get();
        List<FlowTaskOperatorEntity> operatedList = this.flowTaskOperatorService.getList(flowTask.getId());
        ChildNodeList rejectNode = null;
        boolean rejectCodeIsExist = false;
        if (CollectionUtil.isNotEmpty(operatedList)) {
            firstNode = operatedList.stream().filter(t -> t.getHandleStatus() != null).filter(t -> t.getHandleStatus().equals(0)).filter(t -> t.getCompletion().equals(-1)).findFirst();
            rejectOperator = firstNode.get();
            String nodeCode = rejectOperator.getNodeCode();
            List<FlowTaskNodeEntity> oldTaskNodeList = this.flowTaskNodeService.getList(flowTask.getId());
            rejectOptional = oldTaskNodeList.stream().filter(t -> t.getNodeCode().equals(nodeCode)).filter(t -> t.getState().equals(-1)).findFirst();
            FlowTaskNodeEntity rejectNodeEntity = ((Optional)((Object)rejectOptional)).get();
            rejectNode = (ChildNodeList)JsonUtil.getJsonToBean((String)rejectNodeEntity.getNodePropertyJson(), ChildNodeList.class);
            boolean bl = rejectCodeIsExist = taskNodeList.stream().filter(t -> t.getState().equals(0)).filter(t -> t.getNodeCode().equals(nodeCode)).collect(Collectors.toList()).size() > 0;
        }
        if (CollectionUtil.isNotEmpty(operatedList) && rejectNode != null && !rejectNode.getProperties().getRejectAuditType().equals("0") && rejectCodeIsExist) {
            boolean isEnd2;
            FlowTaskNodeEntity nodeEntity;
            Iterator<Object> operatorEntity2;
            FlowTaskNodeEntity node;
            firstNode = operatedList.stream().filter(t -> t.getHandleStatus() != null).filter(t -> t.getHandleStatus().equals(0)).filter(t -> t.getCompletion().equals(-1)).findFirst();
            rejectOperator = firstNode.get();
            String rejectCode = rejectOperator.getNodeCode();
            List<FlowTaskOperatorEntity> listByNode = this.flowTaskOperatorService.getAllByNodeId(flowTask.getId(), rejectOperator.getTaskNodeId());
            rejectOptional = taskNodeList.iterator();
            while (rejectOptional.hasNext() && !(node = (FlowTaskNodeEntity)rejectOptional.next()).getNodeCode().equals(rejectCode)) {
                if (node.getNodeCode().equals(startNode.getNodeCode())) continue;
                if (listByNode.size() > 1) {
                    ArrayList newOperatorList = new ArrayList();
                    listByNode.stream().forEach(operatorEntity -> {
                        operatorEntity.setId(RandomUtil.uuId());
                        operatorEntity.setTaskId(flowTask.getId());
                        operatorEntity.setParentId("0");
                        operatorEntity.setTaskNodeId(node.getId());
                        operatorEntity.setHandleStatus(1);
                        operatorEntity.setHandleTime(new Date());
                        operatorEntity.setNodeCode(node.getNodeCode());
                        operatorEntity.setState(0);
                        operatorEntity.setCompletion(1);
                    });
                    operatorList.addAll(newOperatorList);
                    continue;
                }
                operatorEntity2 = new FlowTaskOperatorEntity();
                ((FlowTaskOperatorEntity)((Object)operatorEntity2)).setId(RandomUtil.uuId());
                ((FlowTaskOperatorEntity)((Object)operatorEntity2)).setTaskId(flowTask.getId());
                ((FlowTaskOperatorEntity)((Object)operatorEntity2)).setParentId("0");
                ((FlowTaskOperatorEntity)((Object)operatorEntity2)).setTaskNodeId(node.getId());
                ((FlowTaskOperatorEntity)((Object)operatorEntity2)).setHandleStatus(1);
                ((FlowTaskOperatorEntity)((Object)operatorEntity2)).setHandleTime(new Date());
                ((FlowTaskOperatorEntity)((Object)operatorEntity2)).setNodeCode(node.getNodeCode());
                ((FlowTaskOperatorEntity)((Object)operatorEntity2)).setState(0);
                ((FlowTaskOperatorEntity)((Object)operatorEntity2)).setCompletion(1);
                operatorList.add((FlowTaskOperatorEntity)((Object)operatorEntity2));
            }
            for (FlowTaskOperatorEntity oldOperated : operatedList) {
                for (FlowTaskOperatorEntity newOperator : operatorList) {
                    if (!oldOperated.getNodeCode().equals(newOperator.getNodeCode())) continue;
                    newOperator.setHandleId(oldOperated.getHandleId());
                    newOperator.setHandleType(oldOperated.getHandleType());
                    newOperator.setNodeName(oldOperated.getNodeName());
                    newOperator.setType(oldOperated.getType());
                    newOperator.setDescription(oldOperated.getDescription());
                }
            }
            List<ChildNodeList> rejectNodeList = nodeListAll.stream().filter(t -> t.getCustom().getNodeId().equals(rejectCode)).collect(Collectors.toList());
            Map<String, List<String>> nodeIdAll = this.nextOperator(operatorList, rejectNodeList, flowTask, flowModel);
            this.flowTaskOperatorService.create(operatorList);
            operatorEntity2 = taskNodeList.iterator();
            while (operatorEntity2.hasNext() && !(nodeEntity = (FlowTaskNodeEntity)operatorEntity2.next()).getNodeCode().equals(rejectCode)) {
                nodeEntity.setCompletion(1);
            }
            this.flowTaskNodeService.updateBatchById(taskNodeList);
            for (String nodeId : nodeIdAll.keySet()) {
                FlowTaskNodeEntity entity = this.flowTaskNodeService.getInfo(nodeId);
                if (entity == null) continue;
                ChildNodeList childNodeList = (ChildNodeList)JsonUtil.getJsonToBean((String)entity.getNodePropertyJson(), ChildNodeList.class);
                childNodeList.getCustom().setTaskId(nodeIdAll.get(nodeId));
                entity.setNodePropertyJson(JsonUtil.getObjectToString((Object)childNodeList));
                this.flowTaskNodeService.update(entity);
            }
            ChildNodeList start = (ChildNodeList)JsonUtil.getJsonToBean((String)startNode.getNodePropertyJson(), ChildNodeList.class);
            boolean request = this.requestData(start, flowModel.getFormData());
            if (request) {
                throw new WorkFlowException(MsgCode.WF001.get());
            }
            FlowTaskOperatorEntity operator = new FlowTaskOperatorEntity();
            operator.setTaskId(flowTask.getId());
            operator.setNodeCode(start.getCustom().getNodeId());
            FlowTaskOperatorRecordEntity operatorRecord = new FlowTaskOperatorRecordEntity();
            FlowOperatordModel flowOperatordModel = new FlowOperatordModel();
            flowOperatordModel.setStatus(FlowRecordEnum.submit.getCode());
            flowOperatordModel.setFlowModel(flowModel);
            if (ObjectUtil.isNotEmpty((Object)flowModel.getUserId())) {
                flowOperatordModel.setUserId(flowModel.getUserId());
            } else {
                flowOperatordModel.setUserId(userInfo.getUserId());
            }
            flowOperatordModel.setOperator(operator);
            this.operatorRecord(operatorRecord, flowOperatordModel);
            this.flowTaskOperatorRecordService.create(operatorRecord);
            FlowTaskOperatorEntity startOperator = new FlowTaskOperatorEntity();
            startOperator.setTaskId(start.getTaskId());
            startOperator.setTaskNodeId(start.getTaskNodeId());
            DateProperties timer = start.getTimer();
            ArrayList<Date> dateList = new ArrayList<Date>();
            if (timer.getTime().booleanValue()) {
                Date date = new Date();
                date = DateUtil.dateAddDays((Date)date, (int)timer.getDay());
                date = DateUtil.dateAddHours((Date)date, (int)timer.getHour());
                date = DateUtil.dateAddMinutes((Date)date, (int)timer.getMinute());
                date = DateUtil.dateAddSeconds((Date)date, (int)timer.getSecond());
                dateList.add(date);
            }
            startOperator.setDescription(JsonUtil.getObjectToString(dateList));
            List<FlowTaskOperatorEntity> operatorAll = this.timer(startOperator, taskNodeList, operatorList);
            for (FlowTaskOperatorEntity operatorTime : operatorAll) {
                List dateAll = JsonUtil.getJsonToList((String)operatorTime.getDescription(), Date.class);
                if (dateAll.size() > 0) {
                    Date max = (Date)Collections.max(dateAll);
                    operatorTime.setCreatorTime(max);
                }
                this.flowTaskOperatorService.update(operatorTime);
            }
            this.flowMsgUtil.event(1, start, operatorRecord, flowModel);
            if (StringUtils.isEmpty((String)flowTask.getThisStepId())) {
                this.getNextStepId(rejectNodeList, taskNodeList, flowTask, flowModel);
            }
            if (isEnd2 = rejectCode.equals(FlowNature.NodeEnd)) {
                this.endround(flowTask, (ChildNodeList)nodeListAll.get(0), flowModel);
            }
            this.flowTaskService.update(flowTask);
            FlowMsgModel flowMsgModel = new FlowMsgModel();
            flowMsgModel.setRejectAuditType(rejectNode.getProperties().getRejectAuditType());
            flowMsgModel.setRejectCode(rejectCode);
            flowMsgModel.setCirculateList(new ArrayList<FlowTaskCirculateEntity>());
            flowMsgModel.setNodeList(taskNodeList);
            flowMsgModel.setOperatorList(operatorList);
            flowMsgModel.setData(flowModel.getFormData());
            flowMsgModel.setTaskEntity(flowTask);
            if (isEnd2) {
                flowMsgModel.setTaskNodeEntity(startNode);
            }
            flowMsgModel.setEngine(engine);
            FlowAutoAgreeModel flowAutoAgreeModel = new FlowAutoAgreeModel(flowModel, flowTask, rejectNodeList, flowMsgModel);
            return flowAutoAgreeModel;
        }
        List<String> nodeList = Arrays.asList(startNode.getNodeNext().split(","));
        List<ChildNodeList> nextChildNodeList = nodeListAll.stream().filter(t -> nodeList.contains(t.getCustom().getNodeId())).collect(Collectors.toList());
        Map<String, List<String>> nodeIdAll = this.nextOperator(operatorList, nextChildNodeList, flowTask, flowModel);
        this.flowTaskOperatorService.create(operatorList);
        for (String nodeId : nodeIdAll.keySet()) {
            FlowTaskNodeEntity entity = this.flowTaskNodeService.getInfo(nodeId);
            if (entity == null) continue;
            ChildNodeList childNodeList = (ChildNodeList)JsonUtil.getJsonToBean((String)entity.getNodePropertyJson(), ChildNodeList.class);
            childNodeList.getCustom().setTaskId(nodeIdAll.get(nodeId));
            entity.setNodePropertyJson(JsonUtil.getObjectToString((Object)childNodeList));
            this.flowTaskNodeService.update(entity);
        }
        ChildNodeList start = (ChildNodeList)JsonUtil.getJsonToBean((String)startNode.getNodePropertyJson(), ChildNodeList.class);
        boolean request = this.requestData(start, flowModel.getFormData());
        if (request) {
            throw new WorkFlowException(MsgCode.WF001.get());
        }
        FlowTaskOperatorEntity operator = new FlowTaskOperatorEntity();
        operator.setTaskId(flowTask.getId());
        operator.setNodeCode(start.getCustom().getNodeId());
        FlowTaskOperatorRecordEntity operatorRecord = new FlowTaskOperatorRecordEntity();
        FlowOperatordModel flowOperatordModel = new FlowOperatordModel();
        flowOperatordModel.setStatus(FlowRecordEnum.submit.getCode());
        flowOperatordModel.setFlowModel(flowModel);
        if (ObjectUtil.isNotEmpty((Object)flowModel.getUserId())) {
            flowOperatordModel.setUserId(flowModel.getUserId());
        } else {
            flowOperatordModel.setUserId(userInfo.getUserId());
        }
        flowOperatordModel.setOperator(operator);
        this.operatorRecord(operatorRecord, flowOperatordModel);
        this.flowTaskOperatorRecordService.create(operatorRecord);
        FlowTaskOperatorEntity startOperator = new FlowTaskOperatorEntity();
        startOperator.setTaskId(start.getTaskId());
        startOperator.setTaskNodeId(start.getTaskNodeId());
        DateProperties timer = start.getTimer();
        ArrayList<Date> dateList = new ArrayList<Date>();
        if (timer.getTime().booleanValue()) {
            Date date = new Date();
            date = DateUtil.dateAddDays((Date)date, (int)timer.getDay());
            date = DateUtil.dateAddHours((Date)date, (int)timer.getHour());
            date = DateUtil.dateAddMinutes((Date)date, (int)timer.getMinute());
            date = DateUtil.dateAddSeconds((Date)date, (int)timer.getSecond());
            dateList.add(date);
        }
        startOperator.setDescription(JsonUtil.getObjectToString(dateList));
        List<FlowTaskOperatorEntity> operatorAll = this.timer(startOperator, taskNodeList, operatorList);
        for (FlowTaskOperatorEntity operatorTime : operatorAll) {
            List dateAll = JsonUtil.getJsonToList((String)operatorTime.getDescription(), Date.class);
            if (dateAll.size() > 0) {
                Date max = (Date)Collections.max(dateAll);
                operatorTime.setCreatorTime(max);
            }
            this.flowTaskOperatorService.update(operatorTime);
        }
        this.flowMsgUtil.event(1, start, operatorRecord, flowModel);
        if (StringUtils.isEmpty((String)flowTask.getThisStepId())) {
            this.getNextStepId(nextChildNodeList, taskNodeList, flowTask, flowModel);
        }
        if (isEnd = nodeList.contains(FlowNature.NodeEnd)) {
            this.endround(flowTask, (ChildNodeList)nodeListAll.get(0), flowModel);
        }
        this.flowTaskService.update(flowTask);
        ArrayList<FlowTaskCirculateEntity> circulateList = new ArrayList<FlowTaskCirculateEntity>();
        this.circulateList(start, circulateList, flowModel);
        this.flowTaskCirculateService.create(circulateList);
        FlowMsgModel flowMsgModel = new FlowMsgModel();
        flowMsgModel.setCirculateList(circulateList);
        if (CollectionUtil.isNotEmpty(circulateList)) {
            flowMsgModel.setCopy(true);
        }
        flowMsgModel.setNodeList(taskNodeList);
        flowMsgModel.setOperatorList(operatorList);
        flowMsgModel.setData(flowModel.getFormData());
        flowMsgModel.setTaskEntity(flowTask);
        if (isEnd) {
            flowMsgModel.setTaskNodeEntity(startNode);
        }
        flowMsgModel.setEngine(engine);
        FlowAutoAgreeModel flowAutoAgreeModel = new FlowAutoAgreeModel(flowModel, flowTask, nextChildNodeList, flowMsgModel);
        return flowAutoAgreeModel;
    }

    @Override
    public void audit(String id, FlowModel flowModel) throws WorkFlowException {
        FlowTaskOperatorEntity operator = this.flowTaskOperatorService.getInfo(id);
        if (operator != null && FlowNature.ProcessCompletion.equals(operator.getCompletion())) {
            FlowTaskEntity flowTask = this.flowTaskService.getInfo(operator.getTaskId());
            this.audit(flowTask, operator, flowModel);
        }
    }

    @Override
    public void audit(FlowTaskEntity flowTask, FlowTaskOperatorEntity operator, FlowModel flowModel) throws WorkFlowException {
        FlowAutoAgreeModel flowAutoAgreeModel = this.auditFlowTask(flowTask, operator, flowModel);
        this.isAutoAgree(flowAutoAgreeModel.getNextChildNodeList(), flowAutoAgreeModel.getFlowTask(), flowAutoAgreeModel.getFlowModel(), flowAutoAgreeModel.getFlowMsgModel());
    }

    @Override
    @DSTransactional
    public FlowAutoAgreeModel auditFlowTask(FlowTaskEntity flowTask, FlowTaskOperatorEntity operator, FlowModel flowModel) throws WorkFlowException {
        Object candidatesList;
        FlowTaskOperatorRecordEntity record;
        HashSet<String> nodeCode;
        boolean isUpdate;
        FlowTaskNodeEntity info = this.flowTaskNodeService.getInfo(operator.getTaskNodeId());
        UserInfo userInfo = this.userProvider.get();
        FlowEngineEntity engine = this.flowEngineService.getInfo(flowTask.getFlowId());
        flowModel.setProcessId(flowTask.getProcessId());
        flowModel.setId(flowTask.getId());
        Map dataAll = JsonUtil.stringToMap((String)flowTask.getFlowFormContentJson());
        dataAll.put("flowId", flowTask.getFlowId());
        if (FlowNature.CUSTOM.equals(engine.getFormType())) {
            Map<String, Object> formDataAll = flowModel.getFormData();
            flowModel.setFormData(dataAll);
            if (formDataAll.get("data") != null) {
                Map data = JsonUtil.stringToMap((String)String.valueOf(formDataAll.get("data")));
                flowModel.setFormData(data);
            } else {
                String objectToString = JsonUtil.getObjectToString(formDataAll);
                Map stringObjectMap = JsonUtil.stringToMap((String)String.valueOf(objectToString));
                flowModel.setFormData(stringObjectMap);
            }
        }
        String flowTemplateJson = "";
        if (ObjectUtil.isNotEmpty((Object)flowTask.getVersionId())) {
            FlowEngineTemplateVersionEntity versionEntity = (FlowEngineTemplateVersionEntity)this.flowEngineTemplateVersionService.getById((Serializable)((Object)flowTask.getVersionId()));
            flowTemplateJson = versionEntity.getFlowTemplateJson();
        } else if (ObjectUtil.isNotEmpty((Object)flowTask.getFlowTemplateJson())) {
            flowTemplateJson = flowTask.getFlowTemplateJson();
        }
        ChildNode childNodeAll = (ChildNode)JsonUtil.getJsonToBean((String)flowTemplateJson, ChildNode.class);
        ArrayList<ChildNodeList> nodeListAll = new ArrayList<ChildNodeList>();
        ArrayList<ConditionList> conditionListAll = new ArrayList<ConditionList>();
        ArrayList<FlowTaskNodeEntity> taskNodeLisAll = new ArrayList<FlowTaskNodeEntity>();
        flowTask.setFlowFormContentJson(JsonUtil.getObjectToString(flowModel.getFormData()));
        this.updateNodeList(flowTask, childNodeAll, nodeListAll, conditionListAll, taskNodeLisAll);
        boolean bl = isUpdate = conditionListAll.stream().filter(t -> t.getPrevId().equals(info.getNodeCode())).count() > 0L;
        if (isUpdate) {
            nodeCode = new HashSet<String>();
            nodeCode.add(info.getNodeCode());
            nodeCode.add(info.getNodeNext());
            this.nodeList(taskNodeLisAll, info.getNodeCode(), info.getSortCode());
            FlowConditionModel conditionModel = new FlowConditionModel();
            conditionModel.setNodeId(info.getNodeCode());
            conditionModel.setChildNodeListAll(nodeListAll);
            conditionModel.setConditionListAll(conditionListAll);
            conditionModel.setData(flowTask.getFlowFormContentJson());
            conditionModel.setUserInfo(userInfo);
            conditionModel.setFlowTaskEntity(flowTask);
            FlowConditionModel newFlowConditionModel = new FlowConditionModel();
            BeanUtils.copyProperties((Object)conditionModel, (Object)newFlowConditionModel);
            String nextNode = FlowJsonUtil.getNextNode(conditionModel);
            nodeCode.add(nextNode);
            if (!nextNode.equals(info.getNodeNext())) {
                for (FlowTaskNodeEntity taskNodeEntity : taskNodeLisAll) {
                    if (!taskNodeEntity.getNodeCode().equals(nextNode) || taskNodeEntity.getCompletion() != 0 || !ObjectUtil.isNotEmpty((Object)taskNodeEntity.getNodeNext())) continue;
                    nodeCode.add(taskNodeEntity.getNodeNext());
                }
            }
            List<FlowTaskNodeEntity> taskNodeLis = taskNodeLisAll.stream().filter(t -> nodeCode.contains(t.getNodeCode())).collect(Collectors.toList());
            this.updateTaskNode(taskNodeLis);
        } else {
            boolean isNodeNextCondition;
            nodeCode = new HashSet();
            nodeCode.add(info.getNodeCode());
            nodeCode.add(info.getNodeNext());
            this.nodeList(taskNodeLisAll, info.getNodeCode(), info.getSortCode());
            boolean bl2 = isNodeNextCondition = conditionListAll.stream().filter(t -> t.getPrevId().equals(info.getNodeNext())).count() > 0L;
            if (!isNodeNextCondition) {
                for (FlowTaskNodeEntity taskNodeEntity : taskNodeLisAll) {
                    if (!taskNodeEntity.getNodeCode().equals(info.getNodeNext()) || taskNodeEntity.getCompletion() != 0 || !ObjectUtil.isNotEmpty((Object)taskNodeEntity.getNodeNext())) continue;
                    nodeCode.add(taskNodeEntity.getNodeNext());
                }
            }
            List<FlowTaskNodeEntity> taskNodeLis = taskNodeLisAll.stream().filter(t -> nodeCode.contains(t.getNodeCode())).collect(Collectors.toList());
            if (!StrUtil.contains((CharSequence)info.getNodeName(), (CharSequence)"\u52a0\u7b7e")) {
                this.updateTaskNode(taskNodeLis);
            }
        }
        if (!FlowNature.ProcessCompletion.equals(operator.getCompletion())) {
            throw new WorkFlowException(MsgCode.WF005.get());
        }
        flowModel.setOperatorId(operator.getId());
        String userId = StringUtils.isNotEmpty((String)flowModel.getUserId()) ? flowModel.getUserId() : userInfo.getUserId();
        List<FlowTaskNodeEntity> flowTaskNodeAll = this.flowTaskNodeService.getList(flowTask.getId());
        List<FlowTaskNodeEntity> taskNodeList = flowTaskNodeAll.stream().filter(t -> FlowNodeEnum.Process.getCode().equals(t.getState())).collect(Collectors.toList());
        Optional<FlowTaskNodeEntity> first = taskNodeList.stream().filter(m -> m.getId().equals(operator.getTaskNodeId())).findFirst();
        if (!first.isPresent()) {
            throw new WorkFlowException(MsgCode.COD001.get());
        }
        FlowTaskNodeEntity taskNode = first.get();
        ChildNodeList nodeModel = (ChildNodeList)JsonUtil.getJsonToBean((String)taskNode.getNodePropertyJson(), ChildNodeList.class);
        boolean request = this.requestData(nodeModel, flowModel.getFormData());
        if (request) {
            throw new WorkFlowException(MsgCode.WF001.get());
        }
        ArrayList<FlowTaskCirculateEntity> circulateList = new ArrayList<FlowTaskCirculateEntity>();
        this.circulateList(nodeModel, circulateList, flowModel);
        this.flowTaskCirculateService.create(circulateList);
        FlowTaskOperatorRecordEntity operatorRecord = new FlowTaskOperatorRecordEntity();
        operator.setHandleOpinion(flowModel.getHandleOpinion());
        FlowOperatordModel flowOperatordModel = new FlowOperatordModel();
        flowOperatordModel.setStatus(FlowRecordEnum.audit.getCode());
        flowOperatordModel.setFlowModel(flowModel);
        flowOperatordModel.setUserId(userId);
        flowOperatordModel.setOperator(operator);
        this.operatorRecord(operatorRecord, flowOperatordModel);
        if (!flowModel.getIsAsync().booleanValue()) {
            this.flowTaskOperatorRecordService.create(operatorRecord);
        }
        TaskHandleIdStatus handleIdStatus = new TaskHandleIdStatus();
        handleIdStatus.setStatus(1);
        handleIdStatus.setNodeModel(nodeModel);
        handleIdStatus.setUserInfo(userInfo);
        handleIdStatus.setTaskNodeList(taskNodeList);
        handleIdStatus.setFlowModel(flowModel);
        this.handleIdStatus(operator, handleIdStatus);
        if (StringUtils.isNotEmpty((String)operator.getId())) {
            this.flowTaskOperatorService.update(operator);
        }
        ArrayList<FlowTaskOperatorEntity> operatorList = new ArrayList<FlowTaskOperatorEntity>();
        List<FlowTaskNodeEntity> nextNode = taskNodeList.stream().filter(t -> taskNode.getNodeNext().contains(t.getNodeCode())).collect(Collectors.toList());
        ArrayList<ChildNodeList> nextChildNodeList = new ArrayList<ChildNodeList>();
        List<FlowTaskNodeEntity> result = this.isNextAll(taskNodeList, nextNode, taskNode, flowModel);
        for (FlowTaskNodeEntity entity2 : result) {
            ChildNodeList node = (ChildNodeList)JsonUtil.getJsonToBean((String)entity2.getNodePropertyJson(), ChildNodeList.class);
            nextChildNodeList.add(node);
        }
        flowModel.setFlowId(flowTask.getFlowId());
        this.flowMsgUtil.event(4, nodeModel, operatorRecord, flowModel);
        Map<String, Object> data = this.createData(engine, flowTask, flowModel);
        this.getNextStepId(nextChildNodeList, taskNodeList, flowTask, flowModel);
        flowTask.setFlowFormContentJson(JsonUtil.getObjectToString(data));
        this.flowTaskService.update(flowTask);
        HashMap candidateList = flowModel.getCandidateList() != null ? flowModel.getCandidateList() : new HashMap();
        for (String key : candidateList.keySet()) {
            FlowTaskNodeEntity taskNodeEntity = taskNodeList.stream().filter(t -> t.getNodeCode().equals(key)).findFirst().orElse(null);
            if (taskNodeEntity == null) continue;
            List list = (List)candidateList.get(key);
            FlowCandidatesEntity flowCandidatesEntity = new FlowCandidatesEntity();
            flowCandidatesEntity.setHandleId(userInfo.getUserId());
            flowCandidatesEntity.setTaskId(taskNodeEntity.getTaskId());
            flowCandidatesEntity.setTaskNodeId(taskNodeEntity.getId());
            flowCandidatesEntity.setAccount(userInfo.getUserAccount());
            flowCandidatesEntity.setCandidates(JsonUtil.getObjectToString((Object)list));
            flowCandidatesEntity.setOperatorId(operator.getId());
            this.flowCandidatesService.create(flowCandidatesEntity);
        }
        if (StrUtil.contains((CharSequence)operator.getNodeName(), (CharSequence)"\u52a0\u7b7e") && ObjectUtil.isNotNull((Object)(record = this.flowTaskOperatorRecordService.getInfoNotHandleStatus(operator.getTaskId(), operator.getTaskNodeId(), operator.getHandleId()))) && StrUtil.isNotEmpty((CharSequence)record.getHandleId())) {
            flowModel.setFreeApproverUserId(record.getHandleId());
        }
        String nextNodeId = "";
        Map<String, List<String>> nodeIdAll = this.nextOperator(operatorList, nextChildNodeList, flowTask, flowModel);
        if (CollectionUtil.isNotEmpty(operatorList)) {
            nextNodeId = ((FlowTaskOperatorEntity)operatorList.get(0)).getTaskNodeId();
        }
        if (CollectionUtil.isNotEmpty(operatorList) && StrUtil.contains((CharSequence)operator.getNodeName(), (CharSequence)"\u52a0\u7b7e") && FlowTaskOperatorEnum.FreeApprover.getCode().equals(((FlowTaskOperatorEntity)operatorList.get(0)).getType()) && CollectionUtil.isNotEmpty((Collection)(candidatesList = this.flowCandidatesService.getlist(nextNodeId)))) {
            String[] stringArray = ((FlowCandidatesEntity)candidatesList.get(0)).getCandidates().replace("\"", "").replace("[", "").replace("]", "").split(",");
            List<String> list = Arrays.asList(stringArray);
            if (list.size() == operatorList.size()) {
                for (int i = 0; i < list.size(); ++i) {
                    ((FlowTaskOperatorEntity)operatorList.get(i)).setHandleId(list.get(i));
                }
            } else {
                ChildNodeList childNode = (ChildNodeList)nextChildNodeList.get(0);
                Properties properties = childNode.getProperties();
                if (FlowNature.FixedJointlyApprover.equals(properties.getCounterSign())) {
                    List filteredHandleIdList;
                    ArrayList<FlowTaskOperatorEntity> operatorListTemp = new ArrayList<FlowTaskOperatorEntity>();
                    List<FlowTaskOperatorEntity> historyOperator = this.flowTaskOperatorService.getAllByNodeId(((FlowTaskOperatorEntity)operatorList.get(0)).getTaskId(), ((FlowTaskOperatorEntity)operatorList.get(0)).getTaskNodeId());
                    List handleIdList = historyOperator.stream().map(FlowTaskOperatorEntity::getHandleId).collect(Collectors.toList());
                    List list2 = filteredHandleIdList = list.stream().filter(handleId -> !handleIdList.contains(handleId)).collect(Collectors.toList());
                    for (String handleId2 : list2) {
                        if (list2.size() == operatorListTemp.size()) break;
                        FlowTaskOperatorEntity operatorEntity = (FlowTaskOperatorEntity)JsonUtil.getJsonToBean(operatorList.get(0), FlowTaskOperatorEntity.class);
                        operatorEntity.setId(RandomUtil.uuId());
                        operatorEntity.setHandleId(handleId2);
                        operatorEntity.setCreatorTime(new Date());
                        operatorListTemp.add(operatorEntity);
                    }
                    operatorList = operatorListTemp;
                }
            }
        }
        this.flowTaskOperatorService.create(operatorList);
        for (String string : nodeIdAll.keySet()) {
            FlowTaskNodeEntity flowTaskNodeEntity = this.flowTaskNodeService.getInfo(string);
            if (flowTaskNodeEntity == null) continue;
            ChildNodeList childNodeList = (ChildNodeList)JsonUtil.getJsonToBean((String)flowTaskNodeEntity.getNodePropertyJson(), ChildNodeList.class);
            childNodeList.getCustom().setTaskId(nodeIdAll.get(string));
            flowTaskNodeEntity.setNodePropertyJson(JsonUtil.getObjectToString((Object)childNodeList));
            this.flowTaskNodeService.update(flowTaskNodeEntity);
        }
        List<FlowTaskOperatorEntity> operatorAll = this.timer(operator, taskNodeList, operatorList);
        for (FlowTaskOperatorEntity flowTaskOperatorEntity : operatorAll) {
            List dateAll = JsonUtil.getJsonToList((String)flowTaskOperatorEntity.getDescription(), Date.class);
            if (dateAll.size() > 0) {
                Date max = (Date)Collections.max(dateAll);
                flowTaskOperatorEntity.setCreatorTime(max);
            }
            this.flowTaskOperatorService.update(flowTaskOperatorEntity);
        }
        FlowMsgModel flowMsgModel = new FlowMsgModel();
        flowMsgModel.setCopy(true);
        flowMsgModel.setNodeList(taskNodeList);
        for (FlowTaskOperatorEntity operatorEntity : operatorList) {
            if (!StrUtil.contains((CharSequence)operator.getNodeName(), (CharSequence)"\u52a0\u7b7e")) continue;
            operatorEntity.setTaskNodeId(nextNodeId);
        }
        flowMsgModel.setOperatorList(operatorList);
        flowMsgModel.setCirculateList(circulateList);
        flowMsgModel.setData(flowModel.getFormData());
        flowMsgModel.setTaskNodeEntity(taskNode);
        flowMsgModel.setTaskEntity(flowTask);
        flowMsgModel.setEngine(engine);
        flowMsgModel.setTitle(StringUtils.isNotEmpty((String)flowModel.getFreeApproverUserId()) ? "\u5df2\u88ab\u3010\u6307\u6d3e\u3011" : "");
        FlowAutoAgreeModel flowAutoAgreeModel = new FlowAutoAgreeModel(flowModel, flowTask, nextChildNodeList, flowMsgModel);
        return flowAutoAgreeModel;
    }

    private static List<String> getNextConditionNode(String nodeCode, List<FlowTaskNodeEntity> taskNodeList) {
        ArrayList<String> nodeCodeList = new ArrayList<String>();
        return nodeCodeList;
    }

    @Override
    @DSTransactional
    public void freeApproval(final FlowTaskOperatorEntity taskOperator, FlowHandleModel flowHandleModel) throws WorkFlowException {
        List<FlowTaskNodeEntity> taskNodeList = this.flowTaskNodeService.getList(taskOperator.getTaskId());
        FlowTaskNodeEntity taskNode = taskNodeList.stream().filter(t -> t.getId().equals(taskOperator.getTaskNodeId())).findFirst().orElse(null);
        FlowTaskNodeEntity addApprovalNode = new FlowTaskNodeEntity();
        FlowTaskEntity flowTask = this.flowTaskService.getInfo(taskNode.getTaskId());
        FlowEngineTemplateVersionEntity versionEntity = (FlowEngineTemplateVersionEntity)this.flowEngineTemplateVersionService.getById((Serializable)((Object)flowTask.getVersionId()));
        ChildNode childNodeAll = new ChildNode();
        if (ObjectUtil.isNotEmpty((Object)versionEntity)) {
            childNodeAll = (ChildNode)JsonUtil.getJsonToBean((String)versionEntity.getFlowTemplateJson(), ChildNode.class);
        } else if (ObjectUtil.isNotEmpty((Object)flowTask.getFlowTemplateJson())) {
            childNodeAll = (ChildNode)JsonUtil.getJsonToBean((String)flowTask.getFlowTemplateJson(), ChildNode.class);
        }
        String nodeCode = RandomUtil.enUuid();
        childNodeAll = FlowJsonUtil.addFreeApprovalNode(childNodeAll, taskOperator.getNodeCode(), flowHandleModel.getFreeApproverType(), flowHandleModel.getFreeApproverUserId(), nodeCode, flowHandleModel.getCounterSign());
        if (StringUtils.isNotEmpty((String)flowHandleModel.getFreeApproverType()) && flowHandleModel.getFreeApproverType().equals("before")) {
            addApprovalNode.setId(RandomUtil.uuId());
            addApprovalNode.setTaskId(taskNode.getTaskId());
            addApprovalNode.setNodeName("\u524d\u7f6e\u52a0\u7b7e");
            addApprovalNode.setNodeCode(nodeCode);
            addApprovalNode.setNodeType("approver");
            addApprovalNode.setSortCode(taskNode.getSortCode());
            addApprovalNode.setNodeUp("0");
            addApprovalNode.setNodeNext(taskNode.getNodeCode());
            addApprovalNode.setCompletion(0);
            addApprovalNode.setState(0);
            ChildNodeList nodeModel = new ChildNodeList();
            nodeModel.setTaskId(taskNode.getTaskId());
            nodeModel.setTaskNodeId(addApprovalNode.getId());
            nodeModel.getCustom().setChildNode(taskNode.getNodeCode());
            nodeModel.getCustom().setNodeId(nodeCode);
            nodeModel.getProperties().setAssigneeType(FlowTaskOperatorEnum.FreeApprover.getCode());
            if (flowHandleModel.getCounterSign().equals(1)) {
                nodeModel.getProperties().setCounterSign(flowHandleModel.getCounterSign());
            }
            addApprovalNode.setNodePropertyJson(JsonUtil.getObjectToString((Object)nodeModel));
            if (ObjectUtil.isNotEmpty((Object)versionEntity)) {
                FlowEngineTemplateVersionEntity templateVersionEntity = new FlowEngineTemplateVersionEntity();
                templateVersionEntity.setId(RandomUtil.uuId());
                templateVersionEntity.setFlowId(versionEntity.getFlowId());
                templateVersionEntity.setTemplateId(versionEntity.getTemplateId());
                templateVersionEntity.setFlowTemplateJson(JsonUtil.getObjectToString((Object)childNodeAll));
                templateVersionEntity.setVersionCode(versionEntity.getVersionCode() + "temp");
                templateVersionEntity.setCreatorUserId(this.userProvider.get().getUserId());
                templateVersionEntity.setCreatorTime(new Date());
                this.flowEngineTemplateVersionService.save(templateVersionEntity);
                flowTask.setVersionId(templateVersionEntity.getId());
            } else {
                flowTask.setFlowTemplateJson(JsonUtil.getObjectToString((Object)childNodeAll));
            }
            flowTask.setThisStep("\u524d\u7f6e\u52a0\u7b7e");
            flowTask.setThisStepId(addApprovalNode.getId());
            this.flowTaskService.update(flowTask);
            this.flowTaskNodeService.create(addApprovalNode);
            FlowTaskNodeEntity taskNodeBefore = taskNodeList.stream().filter(t -> t.getNodeNext().contains(taskNode.getNodeCode())).findFirst().orElse(null);
            ChildNodeList beforeNodeModel = (ChildNodeList)JsonUtil.getJsonToBean((String)taskNodeBefore.getNodePropertyJson(), ChildNodeList.class);
            beforeNodeModel.getCustom().setChildNode(nodeCode);
            taskNodeBefore.setNodePropertyJson(JsonUtil.getObjectToString((Object)beforeNodeModel));
            this.flowTaskNodeService.update(taskNodeBefore);
            List updateSortCodeList = taskNodeList.stream().filter(t -> t.getSortCode() >= addApprovalNode.getSortCode() && !t.getId().equals(addApprovalNode.getId())).collect(Collectors.toList());
            for (FlowTaskNodeEntity flowTaskNodeEntity : updateSortCodeList) {
                flowTaskNodeEntity.setSortCode(flowTaskNodeEntity.getSortCode() + 1L);
                this.flowTaskNodeService.update(flowTaskNodeEntity);
            }
            List<String> list = Arrays.asList(flowHandleModel.getFreeApproverUserId().split(","));
            this.flowTaskOperatorService.deleteByNodeId(taskNode.getId());
            list.stream().forEach(user -> {
                taskOperator.setId(RandomUtil.uuId());
                taskOperator.setTaskNodeId(addApprovalNode.getId());
                taskOperator.setHandleId((String)user);
                taskOperator.setNodeCode(addApprovalNode.getNodeCode());
                taskOperator.setNodeName("\u524d\u7f6e\u52a0\u7b7e");
                taskOperator.setCompletion(FlowNature.ProcessCompletion);
                this.flowTaskOperatorService.create(taskOperator);
            });
            UserInfo userInfo = this.userProvider.get();
            FlowModel flowModel = new FlowModel();
            final FlowTaskOperatorRecordEntity operatorRecord = new FlowTaskOperatorRecordEntity();
            FlowTaskOperatorEntity operator = new FlowTaskOperatorEntity();
            operator.setTaskId(taskOperator.getTaskId());
            operator.setNodeCode(taskOperator.getNodeCode());
            operator.setTaskNodeId(taskOperator.getTaskNodeId());
            operator.setNodeName(taskOperator.getNodeName());
            list.stream().forEach(user -> {
                FlowOperatordModel flowOperatordModel = new FlowOperatordModel();
                flowOperatordModel.setStatus(FlowRecordEnum.copyId.getCode());
                flowOperatordModel.setFlowModel(flowModel);
                flowOperatordModel.setUserId(userInfo.getUserId());
                flowOperatordModel.setOperator(operator);
                flowOperatordModel.setOperatorId((String)user);
                this.operatorRecord(operatorRecord, flowOperatordModel);
                operatorRecord.setHandleOpinion(flowHandleModel.getHandleOpinion());
                this.flowTaskOperatorRecordService.create(operatorRecord);
            });
            FlowEngineEntity engine = this.flowEngineService.getInfo(flowTask.getFlowId());
            ArrayList operatorList = new ArrayList(){
                {
                    FlowTaskOperatorEntity operatorEntity = new FlowTaskOperatorEntity();
                    operatorEntity.setId(taskOperator.getId());
                    operatorEntity.setTaskId(operatorRecord.getTaskId());
                    operatorEntity.setHandleId(taskOperator.getHandleId());
                    operatorEntity.setTaskNodeId(operatorRecord.getTaskNodeId());
                    this.add(operatorEntity);
                }
            };
            FlowMsgModel flowMsgModel = new FlowMsgModel();
            flowMsgModel.setCirculateList(new ArrayList<FlowTaskCirculateEntity>());
            flowMsgModel.setTitle("\u5df2\u88ab\u3010\u52a0\u7b7e\u3011");
            flowMsgModel.setNodeList(taskNodeList);
            flowMsgModel.setOperatorList(operatorList);
            flowMsgModel.setData(JsonUtil.stringToMap((String)flowTask.getFlowFormContentJson()));
            flowMsgModel.setTaskNodeEntity(taskNode);
            flowMsgModel.setTaskEntity(flowTask);
            flowMsgModel.setEngine(engine);
            this.flowMsgUtil.message(flowMsgModel);
        }
        if (StringUtils.isNotEmpty((String)flowHandleModel.getFreeApproverType()) && flowHandleModel.getFreeApproverType().equals("after")) {
            FlowModel flowModel = (FlowModel)JsonUtil.getJsonToBean((Object)((Object)flowHandleModel), FlowModel.class);
            this.audit(flowTask, taskOperator, flowModel);
            addApprovalNode.setId(RandomUtil.uuId());
            addApprovalNode.setTaskId(taskNode.getTaskId());
            addApprovalNode.setNodeName("\u540e\u7f6e\u52a0\u7b7e");
            addApprovalNode.setNodeCode(nodeCode);
            addApprovalNode.setNodeType("approver");
            addApprovalNode.setSortCode(taskNode.getSortCode() + 1L);
            addApprovalNode.setNodeUp("0");
            addApprovalNode.setNodeNext(taskNode.getNodeNext());
            addApprovalNode.setCompletion(0);
            addApprovalNode.setState(0);
            ChildNodeList nodeModel = new ChildNodeList();
            nodeModel.setTaskId(taskNode.getTaskId());
            nodeModel.setTaskNodeId(addApprovalNode.getId());
            nodeModel.getCustom().setChildNode(taskNode.getNodeNext());
            nodeModel.getCustom().setNodeId(nodeCode);
            nodeModel.getProperties().setAssigneeType(FlowTaskOperatorEnum.FreeApprover.getCode());
            addApprovalNode.setNodePropertyJson(JsonUtil.getObjectToString((Object)nodeModel));
            this.flowTaskNodeService.create(addApprovalNode);
            ChildNodeList currTaskNode = (ChildNodeList)JsonUtil.getJsonToBean((String)taskNode.getNodePropertyJson(), ChildNodeList.class);
            FlowTaskNodeEntity taskNodeBefore = taskNodeList.stream().filter(t -> t.getNodeCode().equals(currTaskNode.getCustom().getNodeId())).findFirst().orElse(null);
            ChildNodeList beforeNodeModel = (ChildNodeList)JsonUtil.getJsonToBean((String)taskNodeBefore.getNodePropertyJson(), ChildNodeList.class);
            currTaskNode.getCustom().setChildNode(nodeCode);
            taskNodeBefore.setNodePropertyJson(JsonUtil.getObjectToString((Object)beforeNodeModel));
            taskNodeBefore.setNodeNext(nodeCode);
            taskNodeBefore.setCompletion(FlowNature.AuditCompletion);
            this.flowTaskNodeService.update(taskNodeBefore);
            List updateSortCodeList = taskNodeList.stream().filter(t -> t.getSortCode() >= addApprovalNode.getSortCode() && !t.getId().equals(addApprovalNode.getId())).collect(Collectors.toList());
            for (FlowTaskNodeEntity flowTaskNodeEntity : updateSortCodeList) {
                flowTaskNodeEntity.setSortCode(flowTaskNodeEntity.getSortCode() + 1L);
                this.flowTaskNodeService.update(flowTaskNodeEntity);
            }
            FlowEngineTemplateVersionEntity templateVersionEntity = new FlowEngineTemplateVersionEntity();
            templateVersionEntity.setId(RandomUtil.uuId());
            templateVersionEntity.setFlowId(versionEntity.getFlowId());
            templateVersionEntity.setTemplateId(versionEntity.getTemplateId());
            templateVersionEntity.setFlowTemplateJson(JsonUtil.getObjectToString((Object)childNodeAll));
            templateVersionEntity.setVersionCode(versionEntity.getVersionCode() + "temp");
            templateVersionEntity.setCreatorUserId(this.userProvider.get().getUserId());
            templateVersionEntity.setCreatorTime(new Date());
            this.flowEngineTemplateVersionService.save(templateVersionEntity);
            flowTask.setVersionId(templateVersionEntity.getId());
            flowTask.setThisStep("\u540e\u7f6e\u52a0\u7b7e");
            flowTask.setThisStepId(addApprovalNode.getId());
            this.flowTaskService.update(flowTask);
            List<String> list = Arrays.asList(flowHandleModel.getFreeApproverUserId().split(","));
            list.stream().forEach(user -> {
                taskOperator.setId(RandomUtil.uuId());
                taskOperator.setTaskNodeId(addApprovalNode.getId());
                taskOperator.setHandleId((String)user);
                taskOperator.setNodeCode(addApprovalNode.getNodeCode());
                taskOperator.setNodeName("\u540e\u7f6e\u52a0\u7b7e");
                taskOperator.setCompletion(FlowNature.ProcessCompletion);
                ArrayList<FlowTaskOperatorEntity> taskOperatorList = new ArrayList<FlowTaskOperatorEntity>();
                taskOperatorList.add(taskOperator);
                this.flowTaskOperatorService.create(taskOperatorList);
            });
            UserInfo userInfo = this.userProvider.get();
            final FlowTaskOperatorRecordEntity operatorRecord = new FlowTaskOperatorRecordEntity();
            FlowTaskOperatorEntity operator = new FlowTaskOperatorEntity();
            operator.setTaskId(taskOperator.getTaskId());
            operator.setNodeCode(taskOperator.getNodeCode());
            operator.setTaskNodeId(taskOperator.getTaskNodeId());
            operator.setNodeName(taskOperator.getNodeName());
            list.stream().forEach(user -> {
                FlowOperatordModel flowOperatordModel = new FlowOperatordModel();
                flowOperatordModel.setStatus(FlowRecordEnum.copyId.getCode());
                flowOperatordModel.setFlowModel(flowModel);
                flowOperatordModel.setUserId((String)user);
                flowOperatordModel.setOperator(operator);
                flowOperatordModel.setOperatorId(taskOperator.getHandleId());
                this.operatorRecord(operatorRecord, flowOperatordModel);
                this.flowTaskOperatorRecordService.create(operatorRecord);
            });
            FlowEngineEntity engine = this.flowEngineService.getInfo(flowTask.getFlowId());
            ArrayList operatorList = new ArrayList(){
                {
                    FlowTaskOperatorEntity operatorEntity = new FlowTaskOperatorEntity();
                    operatorEntity.setId(taskOperator.getId());
                    operatorEntity.setTaskId(operatorRecord.getTaskId());
                    operatorEntity.setHandleId(taskOperator.getHandleId());
                    operatorEntity.setTaskNodeId(operatorRecord.getTaskNodeId());
                    this.add(operatorEntity);
                }
            };
            FlowMsgModel flowMsgModel = new FlowMsgModel();
            flowMsgModel.setCirculateList(new ArrayList<FlowTaskCirculateEntity>());
            flowMsgModel.setTitle("\u5df2\u88ab\u3010\u52a0\u7b7e\u3011");
            flowMsgModel.setNodeList(taskNodeList);
            flowMsgModel.setOperatorList(operatorList);
            flowMsgModel.setData(JsonUtil.stringToMap((String)flowTask.getFlowFormContentJson()));
            flowMsgModel.setTaskNodeEntity(taskNode);
            flowMsgModel.setTaskEntity(flowTask);
            flowMsgModel.setEngine(engine);
            this.flowMsgUtil.message(flowMsgModel);
        }
    }

    @Override
    @DSTransactional
    public void refuse(FlowTaskEntity flowTask, FlowTaskOperatorEntity operator, FlowModel flowModel) throws WorkFlowException {
        FlowTaskNodeEntity info = this.flowTaskNodeService.getInfo(operator.getTaskNodeId());
        FlowEngineEntity engine = this.flowEngineService.getInfo(flowTask.getFlowId());
        UserInfo userInfo = this.userProvider.get();
        flowModel.setProcessId(flowTask.getProcessId());
        flowModel.setId(flowTask.getId());
        String flowTemplateJson = flowTask.getFlowTemplateJson();
        if (StringUtils.isEmpty((String)flowTemplateJson)) {
            FlowEngineTemplateVersionEntity versionEntity = (FlowEngineTemplateVersionEntity)this.flowEngineTemplateVersionService.getById((Serializable)((Object)flowTask.getVersionId()));
            flowTemplateJson = versionEntity.getFlowTemplateJson();
        }
        ChildNode childNodeAll = (ChildNode)JsonUtil.getJsonToBean((String)flowTemplateJson, ChildNode.class);
        ArrayList<ChildNodeList> nodeListAll = new ArrayList<ChildNodeList>();
        ArrayList<ConditionList> conditionListAll = new ArrayList<ConditionList>();
        ArrayList<FlowTaskNodeEntity> taskNodeLisAll = new ArrayList<FlowTaskNodeEntity>();
        this.updateNodeList(flowTask, childNodeAll, nodeListAll, conditionListAll, taskNodeLisAll);
        List<FlowTaskNodeEntity> flowTaskNodeAll = this.flowTaskNodeService.getList(flowTask.getId());
        List<FlowTaskNodeEntity> taskNodeList = flowTaskNodeAll.stream().filter(t -> FlowNodeEnum.Process.getCode().equals(t.getState())).collect(Collectors.toList());
        Optional<FlowTaskNodeEntity> first = taskNodeList.stream().filter(m -> m.getId().equals(operator.getTaskNodeId())).findFirst();
        if (!first.isPresent()) {
            throw new WorkFlowException(MsgCode.COD001.get());
        }
        FlowTaskNodeEntity taskNode = first.get();
        ChildNodeList nodeModel = (ChildNodeList)JsonUtil.getJsonToBean((String)taskNode.getNodePropertyJson(), ChildNodeList.class);
        FlowTaskOperatorRecordEntity operatorRecord = new FlowTaskOperatorRecordEntity();
        operator.setHandleOpinion(flowModel.getHandleOpinion());
        FlowOperatordModel flowOperatordModel = new FlowOperatordModel();
        flowOperatordModel.setStatus(FlowRecordEnum.refuse.getCode());
        flowOperatordModel.setFlowModel(flowModel);
        flowOperatordModel.setUserId(userInfo.getUserId());
        flowOperatordModel.setOperator(operator);
        this.operatorRecord(operatorRecord, flowOperatordModel);
        TaskHandleIdStatus handleIdStatus = new TaskHandleIdStatus();
        handleIdStatus.setStatus(1);
        handleIdStatus.setNodeModel(nodeModel);
        handleIdStatus.setUserInfo(userInfo);
        handleIdStatus.setTaskNodeList(taskNodeList);
        handleIdStatus.setFlowModel(flowModel);
        this.handleIdStatus(operator, handleIdStatus);
        if (!flowModel.getIsAsync().booleanValue()) {
            this.flowTaskOperatorRecordService.create(operatorRecord);
        }
        ArrayList<FlowTaskOperatorEntity> operatorList = new ArrayList<FlowTaskOperatorEntity>();
        List<FlowTaskNodeEntity> nextNode = taskNodeList.stream().filter(t -> taskNode.getNodeNext().contains(t.getNodeCode())).collect(Collectors.toList());
        ArrayList<ChildNodeList> nextChildNodeList = new ArrayList<ChildNodeList>();
        List<FlowTaskNodeEntity> result = this.isNextAll(taskNodeList, nextNode, taskNode, flowModel);
        for (FlowTaskNodeEntity flowTaskNodeEntity : result) {
            ChildNodeList childNodeList = (ChildNodeList)JsonUtil.getJsonToBean((String)flowTaskNodeEntity.getNodePropertyJson(), ChildNodeList.class);
            nextChildNodeList.add(childNodeList);
        }
        flowModel.setFlowId(flowTask.getFlowId());
        this.getNextStepId(nextChildNodeList, taskNodeList, flowTask, flowModel);
        this.flowTaskService.update(flowTask);
        String nextNodeId = "";
        this.nextOperator(operatorList, nextChildNodeList, flowTask, flowModel);
        if (CollectionUtil.isNotEmpty(operatorList)) {
            nextNodeId = ((FlowTaskOperatorEntity)operatorList.get(0)).getTaskNodeId();
        }
        this.flowTaskOperatorService.create(operatorList);
        for (FlowTaskOperatorEntity flowTaskOperatorEntity : operatorList) {
            if (!StrUtil.contains((CharSequence)operator.getNodeName(), (CharSequence)"\u52a0\u7b7e")) continue;
            flowTaskOperatorEntity.setTaskNodeId(nextNodeId);
        }
        List<FlowTaskNodeEntity> list = this.flowTaskNodeService.getList(flowTask.getId());
        for (FlowTaskNodeEntity node : list) {
            if (node.getSortCode() > info.getSortCode()) {
                node.setSortCode(node.getSortCode() - 1L);
                this.flowTaskNodeService.update(node);
            }
            if (!node.getNodeCode().equals(info.getNodeCode())) continue;
            node.setState(-1);
            node.setSortCode(-2L);
            this.flowTaskNodeService.update(node);
        }
        FlowMsgModel flowMsgModel = new FlowMsgModel();
        flowMsgModel.setRefuse(true);
        flowMsgModel.setWait(false);
        flowMsgModel.setNodeList(taskNodeList);
        flowMsgModel.setOperatorList(operatorList);
        flowMsgModel.setCirculateList(new ArrayList<FlowTaskCirculateEntity>());
        flowMsgModel.setData(flowModel.getFormData());
        flowMsgModel.setTaskNodeEntity(taskNode);
        flowMsgModel.setTaskEntity(flowTask);
        flowMsgModel.setEngine(engine);
        this.flowMsgUtil.message(flowMsgModel);
    }

    @Override
    @DSTransactional
    public void isAutoAgree(List<ChildNodeList> nextChildNodeList, FlowTaskEntity flowTask, FlowModel flowModel, FlowMsgModel flowMsgModel) throws WorkFlowException {
        try {
            for (ChildNodeList nodeModel : nextChildNodeList) {
                if (nodeModel.getProperties().getIsAutoAgree().booleanValue()) {
                    Optional<String> any;
                    String lastUserId;
                    if (!ObjectUtil.isNotEmpty(nodeModel.getProperties().getAgreeRules())) continue;
                    TaskOperator taskOperator = new TaskOperator();
                    taskOperator.setChildNode(nodeModel);
                    taskOperator.setTaskEntity(flowTask);
                    taskOperator.setFlowModel(flowModel);
                    taskOperator.setDetails(true);
                    taskOperator.setId(flowModel.getOperatorId());
                    ArrayList<FlowTaskOperatorEntity> operatorList = new ArrayList<FlowTaskOperatorEntity>();
                    taskOperator.setChildNode(nodeModel);
                    taskOperator.setTaskEntity(flowTask);
                    taskOperator.setFlowModel(flowModel);
                    taskOperator.setDetails(false);
                    taskOperator.setId(FlowNature.ParentId);
                    List<UserEntity> userEntities = this.operator(operatorList, taskOperator);
                    List nextUserIds = userEntities.stream().map(UserEntity::getId).collect(Collectors.toList());
                    HashSet<String> userIds = new HashSet<String>();
                    if (nodeModel.getProperties().getAgreeRules().contains(AgreeRule.isCreator.getRule()) && StringUtils.isNotEmpty((String)flowTask.getCreatorUserId())) {
                        userIds.add(flowTask.getCreatorUserId());
                    }
                    String string = lastUserId = StringUtils.isNotEmpty((String)flowModel.getUserId()) ? flowModel.getUserId() : this.userProvider.get().getUserId();
                    if (nodeModel.getProperties().getAgreeRules().contains(AgreeRule.isPreviousApprover.getRule()) && StringUtils.isNotEmpty((String)lastUserId)) {
                        userIds.add(lastUserId);
                    }
                    if (nodeModel.getProperties().getAgreeRules().contains(AgreeRule.isApprover.getRule())) {
                        List<FlowTaskOperatorRecordEntity> flowTaskOperatorRecordList = this.flowTaskOperatorRecordService.getList(flowTask.getId());
                        List rejectAuditTypeList = flowTaskOperatorRecordList.stream().filter(t -> ObjectUtil.isNotEmpty((Object)t.getRejectAuditType()) && t.getRejectAuditType().equals("1")).collect(Collectors.toList());
                        List<Object> agreeUserIds = new ArrayList();
                        agreeUserIds = CollectionUtil.isNotEmpty(rejectAuditTypeList) ? flowTaskOperatorRecordList.stream().filter(record -> record.getHandleStatus().equals(FlowRecordEnum.audit.getCode()) && (record.getStatus().equals(0) || record.getStatus().equals(3)) && ObjectUtil.isNotEmpty((Object)record.getTaskNodeId())).map(record -> record.getHandleId()).collect(Collectors.toList()) : flowTaskOperatorRecordList.stream().filter(record -> record.getHandleStatus().equals(FlowRecordEnum.audit.getCode()) && record.getStatus().equals(0)).map(record -> record.getHandleId()).collect(Collectors.toList());
                        if (ObjectUtil.isNotEmpty(agreeUserIds)) {
                            userIds.addAll(agreeUserIds);
                        }
                    }
                    boolean isAutoAgree = false;
                    if (nodeModel.getProperties().getAgreeRules().contains(AgreeRule.noApprover.getRule()) && ObjectUtil.isEmpty(nextUserIds)) {
                        isAutoAgree = true;
                    }
                    if ((any = nextUserIds.stream().filter(userIds::contains).findAny()).isPresent() || isAutoAgree) {
                        FlowTaskNodeEntity taskNodeEntity = this.flowTaskNodeService.getInfo(nodeModel.getTaskNodeId());
                        FlowTaskOperatorEntity operatorEntity = this.flowTaskOperatorService.getInfoBy(flowTask.getId(), taskNodeEntity.getNodeCode());
                        if (ObjectUtil.isEmpty((Object)operatorEntity) || CollectionUtil.isEmpty(operatorList)) {
                            this.nextOperator(operatorList, nextChildNodeList, flowTask, flowModel);
                            if (ObjectUtil.isEmpty((Object)operatorEntity) && CollectionUtil.isEmpty(operatorList)) {
                                TaskOperatoUser taskOperatoUser = new TaskOperatoUser();
                                taskOperatoUser.setHandLeId("");
                                taskOperatoUser.setChildNode(taskOperator.getChildNode());
                                taskOperatoUser.setDate(new Date());
                                this.operatorUser(operatorList, taskOperatoUser);
                                this.flowTaskOperatorService.create(operatorList);
                            }
                            operatorEntity = operatorList.stream().filter(operator -> operator.getNodeCode().equals(taskNodeEntity.getNodeCode()) && operator.getCompletion().equals(FlowNature.ProcessCompletion)).findFirst().orElse(null);
                        }
                        if (!ObjectUtil.isNotNull((Object)flowTask) || !ObjectUtil.isNotNull((Object)operatorEntity) || !ObjectUtil.isNotNull((Object)flowModel)) continue;
                        if (nodeModel.getProperties().getAgreeRules().contains(AgreeRule.noApprover.getRule())) {
                            flowModel.setHandleOpinion("\u81ea\u52a8\u8df3\u8fc7\u8282\u70b9");
                        }
                        flowModel.setHandleOpinion("\u81ea\u52a8\u5ba1\u6279\u901a\u8fc7");
                        flowModel.setUserId(operatorEntity.getHandleId());
                        this.audit(flowTask, operatorEntity, flowModel);
                        flowMsgModel.setWait(false);
                        this.flowMsgUtil.message(flowMsgModel);
                        break;
                    }
                    this.flowMsgUtil.message(flowMsgModel);
                    continue;
                }
                this.flowMsgUtil.message(flowMsgModel);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void reject(String id, FlowModel flowModel) throws WorkFlowException {
        FlowTaskOperatorEntity operator = this.flowTaskOperatorService.getInfo(id);
        if (operator != null && FlowNature.ProcessCompletion.equals(operator.getCompletion())) {
            FlowTaskEntity flowTaskEntity = this.flowTaskService.getInfo(operator.getTaskId());
            this.reject(flowTaskEntity, operator, flowModel);
        }
    }

    @Override
    @DSTransactional
    public void reject(FlowTaskEntity flowTask, FlowTaskOperatorEntity operator, FlowModel flowModel) throws WorkFlowException {
        boolean isStart;
        boolean isNext;
        UserInfo userInfo = this.userProvider.get();
        flowModel.setFlowId(flowTask.getFlowId());
        flowModel.setProcessId(flowTask.getProcessId());
        String userId = StringUtils.isNotEmpty((String)flowModel.getUserId()) ? flowModel.getUserId() : userInfo.getUserId();
        List<FlowTaskNodeEntity> flowTaskNodeAll = this.flowTaskNodeService.getList(flowTask.getId());
        List<FlowTaskNodeEntity> taskNodeList = flowTaskNodeAll.stream().filter(t -> FlowNodeEnum.Process.getCode().equals(t.getState())).collect(Collectors.toList());
        Optional<FlowTaskNodeEntity> first = taskNodeList.stream().filter(m -> m.getId().equals(operator.getTaskNodeId())).findFirst();
        if (!first.isPresent()) {
            throw new WorkFlowException(MsgCode.COD001.get());
        }
        FlowTaskNodeEntity taskNode = first.get();
        FlowEngineEntity engine = this.flowEngineService.getInfo(flowTask.getFlowId());
        ChildNodeList nodeModel = (ChildNodeList)JsonUtil.getJsonToBean((String)taskNode.getNodePropertyJson(), ChildNodeList.class);
        FlowTaskOperatorRecordEntity operatorRecord = new FlowTaskOperatorRecordEntity();
        operator.setHandleOpinion(flowModel.getHandleOpinion());
        FlowOperatordModel flowOperatordModel = new FlowOperatordModel();
        flowOperatordModel.setStatus(FlowRecordEnum.reject.getCode());
        flowOperatordModel.setFlowModel(flowModel);
        flowOperatordModel.setUserId(userId);
        flowOperatordModel.setOperator(operator);
        this.operatorRecord(operatorRecord, flowOperatordModel);
        this.flowTaskOperatorRecordService.create(operatorRecord);
        TaskHandleIdStatus handleIdStatus = new TaskHandleIdStatus();
        handleIdStatus.setStatus(0);
        handleIdStatus.setNodeModel(nodeModel);
        handleIdStatus.setUserInfo(userInfo);
        handleIdStatus.setTaskNodeList(taskNodeList);
        this.handleIdStatus(operator, handleIdStatus);
        this.flowTaskOperatorService.update(operator);
        List<FlowTaskEntity> childList = this.flowTaskService.getChildList(operatorRecord.getTaskId(), FlowTaskEntity::getId);
        boolean bl = isNext = childList.size() > 0;
        if (isNext) {
            throw new WorkFlowException(MsgCode.WF110.get());
        }
        boolean isReject = this.isReject(taskNode);
        ArrayList<ChildNodeList> nextOperatorList = new ArrayList<ChildNodeList>();
        HashSet<FlowTaskNodeEntity> thisStepAll = new HashSet<FlowTaskNodeEntity>();
        ArrayList<String> rejectList = new ArrayList<String>();
        String[] thisStepId = flowTask.getThisStepId().split(",");
        List<FlowTaskNodeEntity> upAll = this.isUpAll(taskNodeList, taskNode, isReject, thisStepAll, rejectList, thisStepId, engine, flowModel);
        for (FlowTaskNodeEntity entity : upAll) {
            ChildNodeList node = (ChildNodeList)JsonUtil.getJsonToBean((String)entity.getNodePropertyJson(), ChildNodeList.class);
            nextOperatorList.add(node);
        }
        ArrayList<FlowTaskOperatorEntity> operatorList = new ArrayList<FlowTaskOperatorEntity>();
        boolean bl2 = isStart = nextOperatorList.stream().filter(t -> FlowNature.NodeStart.equals(t.getCustom().getType())).count() > 0L;
        if (!isStart) {
            flowModel.setProcessId(flowTask.getProcessId());
            flowModel.setId(flowTask.getId());
            Map data = JsonUtil.stringToMap((String)flowTask.getFlowFormContentJson());
            flowModel.setFormData(data);
            this.nextOperator(operatorList, nextOperatorList, flowTask, flowModel);
            this.flowTaskNodeService.updateCompletion(rejectList, FlowNature.ProcessCompletion);
            Set<String> uptList = upAll.stream().map(FlowTaskNodeEntity::getId).collect(Collectors.toSet());
            this.flowTaskOperatorRecordService.updateStatus(uptList, flowTask.getId());
        } else {
            this.flowTaskNodeService.update(flowTask.getId());
            this.flowTaskOperatorService.update(flowTask.getId());
            this.flowTaskOperatorRecordService.update(flowTask.getId());
        }
        ArrayList<String> stepIdList = new ArrayList<String>();
        ArrayList<String> stepNameList = new ArrayList<String>();
        ArrayList<String> progressList = new ArrayList<String>();
        for (FlowTaskNodeEntity taskNodes : thisStepAll) {
            ChildNodeList childNode = (ChildNodeList)JsonUtil.getJsonToBean((String)taskNodes.getNodePropertyJson(), ChildNodeList.class);
            Properties properties = childNode.getProperties();
            String progress = properties.getProgress();
            if (StringUtils.isNotEmpty((String)progress)) {
                progressList.add(progress);
            }
            stepIdList.add(taskNodes.getId());
            stepNameList.add(taskNodes.getNodeName());
        }
        if (thisStepAll.size() > 0) {
            Collections.sort(progressList);
            flowTask.setCompletion(progressList.size() > 0 ? Integer.parseInt((String)progressList.get(0)) : 0);
            flowTask.setThisStepId(String.join((CharSequence)",", stepIdList));
            flowTask.setThisStep(String.join((CharSequence)",", stepNameList));
            flowTask.setStatus(isStart ? FlowTaskStatusEnum.Reject.getCode() : flowTask.getStatus());
            HashSet<String> rejectNodeList = new HashSet<String>();
            this.upAll(rejectNodeList, rejectList, taskNodeList);
            this.flowTaskOperatorService.updateReject(flowTask.getId(), rejectNodeList);
            if (isStart) {
                flowTask.setCompletion(0);
                flowTask.setThisStepId(String.join((CharSequence)",", new ArrayList()));
                flowTask.setThisStep(String.join((CharSequence)",", new ArrayList()));
            }
            ArrayList<String> candidates = new ArrayList<String>();
            candidates.addAll(rejectNodeList);
            this.flowCandidatesService.deleteTaskNodeId(candidates);
        }
        this.flowTaskService.update(flowTask);
        this.flowTaskOperatorRecordService.update(operatorRecord.getId(), operatorRecord);
        this.flowTaskOperatorService.create(operatorList);
        ArrayList<FlowTaskCirculateEntity> circulateList = new ArrayList<FlowTaskCirculateEntity>();
        this.circulateList(nodeModel, circulateList, flowModel);
        this.flowTaskCirculateService.create(circulateList);
        this.flowMsgUtil.event(5, nodeModel, operatorRecord, flowModel);
        FlowMsgModel flowMsgModel = new FlowMsgModel();
        flowMsgModel.setCirculateList(circulateList);
        flowMsgModel.setNodeList(taskNodeList);
        for (FlowTaskOperatorEntity operatorEntity : operatorList) {
            operatorEntity.setTaskNodeId(taskNode.getId());
        }
        flowMsgModel.setOperatorList(operatorList);
        flowMsgModel.setReject(true);
        flowMsgModel.setCopy(true);
        flowMsgModel.setStart(isStart);
        flowMsgModel.setData(JsonUtil.stringToMap((String)flowTask.getFlowFormContentJson()));
        flowMsgModel.setTaskNodeEntity(taskNode);
        flowMsgModel.setTaskEntity(flowTask);
        flowMsgModel.setEngine(engine);
        this.flowMsgUtil.message(flowMsgModel);
    }

    private void upAll(Set<String> rejectNodeList, List<String> rejectList, List<FlowTaskNodeEntity> taskNodeList) {
        List nodeList = taskNodeList.stream().filter(t -> rejectList.contains(t.getId())).collect(Collectors.toList());
        for (FlowTaskNodeEntity taskNode : nodeList) {
            ArrayList list = StringUtils.isNotEmpty((String)taskNode.getNodeNext()) ? Arrays.asList(taskNode.getNodeNext().split(",")) : new ArrayList();
            List taskList = taskNodeList.stream().filter(t -> list.contains(t.getNodeCode())).collect(Collectors.toList());
            List<String> rejectListAll = taskList.stream().map(t -> t.getId()).collect(Collectors.toList());
            rejectNodeList.add(taskNode.getId());
            this.upAll(rejectNodeList, rejectListAll, taskNodeList);
        }
    }

    @Override
    @DSTransactional
    public void recall(String id, FlowTaskOperatorRecordEntity operatorRecord, FlowModel flowModel) throws WorkFlowException {
        boolean isNext;
        boolean isRecall;
        UserInfo userInfo = this.userProvider.get();
        FlowTaskOperatorEntity operatorEntity = this.flowTaskOperatorService.getInfo(operatorRecord.getTaskOperatorId());
        if (FlowNodeEnum.Futility.getCode().equals(operatorEntity.getState())) {
            throw new WorkFlowException(MsgCode.WF104.get());
        }
        FlowTaskNodeEntity flowTaskNodeEntity = this.flowTaskNodeService.getInfo(operatorRecord.getTaskNodeId());
        FlowTaskEntity flowTaskEntity = this.flowTaskService.getInfo(operatorRecord.getTaskId());
        FlowEngineEntity engine = this.flowEngineService.getInfo(flowTaskEntity.getFlowId());
        List flowTaskNodeEntityList = this.flowTaskNodeService.getList(operatorRecord.getTaskId()).stream().filter(t -> FlowNodeEnum.Process.getCode().equals(t.getState())).collect(Collectors.toList());
        List flowTaskOperatorEntityList = this.flowTaskOperatorService.getList(operatorRecord.getTaskId()).stream().filter(t -> FlowNodeEnum.Process.getCode().equals(t.getState())).collect(Collectors.toList());
        ChildNodeList nodeModel = (ChildNodeList)JsonUtil.getJsonToBean((String)flowTaskNodeEntity.getNodePropertyJson(), ChildNodeList.class);
        if (FlowNature.ProcessCompletion.equals(operatorEntity.getHandleStatus())) {
            throw new WorkFlowException(MsgCode.WF104.get());
        }
        if (flowTaskEntity.getEnabledMark() != 1 || !FlowTaskStatusEnum.Handle.getCode().equals(flowTaskEntity.getStatus())) {
            throw new WorkFlowException(MsgCode.WF105.get());
        }
        List recallNextOperatorList = flowTaskOperatorEntityList.stream().filter(x -> flowTaskNodeEntity.getNodeNext().contains(x.getNodeCode())).collect(Collectors.toList());
        boolean bl = isRecall = recallNextOperatorList.stream().filter(t -> FlowNature.AuditCompletion.equals(t.getCompletion()) && FlowNodeEnum.Process.getCode().equals(t.getState())).count() > 0L;
        if (isRecall) {
            throw new WorkFlowException(MsgCode.WF106.get());
        }
        List<FlowTaskEntity> childList = this.flowTaskService.getChildList(operatorRecord.getTaskId(), FlowTaskEntity::getId);
        boolean bl2 = isNext = childList.size() > 0;
        if (isNext) {
            throw new WorkFlowException(MsgCode.WF107.get());
        }
        HashSet<FlowTaskOperatorEntity> operatorList = new HashSet<FlowTaskOperatorEntity>();
        this.getOperator(operatorEntity.getId(), operatorList);
        operatorEntity.setHandleStatus(null);
        operatorEntity.setHandleTime(null);
        operatorEntity.setCompletion(FlowNature.ProcessCompletion);
        operatorEntity.setState(FlowNodeEnum.Process.getCode());
        operatorList.add(operatorEntity);
        ArrayList<String> delOperatorRecordIds = new ArrayList<String>();
        for (FlowTaskOperatorEntity item : operatorList) {
            FlowTaskOperatorRecordEntity record = this.flowTaskOperatorRecordService.getInfo(item.getTaskId(), item.getTaskNodeId(), item.getId());
            if (record == null) continue;
            delOperatorRecordIds.add(record.getId());
        }
        if (FlowNature.AuditCompletion.equals(flowTaskNodeEntity.getCompletion())) {
            List idAll = recallNextOperatorList.stream().map(FlowTaskOperatorEntity::getId).collect(Collectors.toList());
            this.flowTaskOperatorService.updateTaskOperatorState(idAll);
            List hanleOperatorList = flowTaskOperatorEntityList.stream().filter(x -> x.getTaskNodeId().equals(operatorRecord.getTaskNodeId()) && Objects.isNull(x.getHandleStatus()) && Objects.isNull(x.getHandleTime()) && Objects.isNull(x.getParentId())).collect(Collectors.toList());
            for (FlowTaskOperatorEntity taskOperator : hanleOperatorList) {
                taskOperator.setCompletion(FlowNature.ProcessCompletion);
            }
            operatorList.addAll(hanleOperatorList);
            ArrayList<String> stepIdList = new ArrayList<String>();
            ArrayList<String> stepNameList = new ArrayList<String>();
            ArrayList<String> progressList = new ArrayList<String>();
            List recallNodeList = flowTaskNodeEntityList.stream().filter(x -> flowTaskNodeEntity.getSortCode().equals(x.getSortCode())).collect(Collectors.toList());
            for (FlowTaskNodeEntity taskNodeEntity : recallNodeList) {
                ChildNodeList childNode = (ChildNodeList)JsonUtil.getJsonToBean((String)taskNodeEntity.getNodePropertyJson(), ChildNodeList.class);
                Properties properties = childNode.getProperties();
                String progress = properties.getProgress();
                if (StringUtils.isNotEmpty((String)progress)) {
                    progressList.add(progress);
                }
                stepIdList.add(taskNodeEntity.getNodeCode());
                stepNameList.add(taskNodeEntity.getNodeName());
                taskNodeEntity.setCompletion(FlowNature.ProcessCompletion);
                if (!operatorRecord.getTaskNodeId().equals(taskNodeEntity.getId())) continue;
                this.flowTaskNodeService.update(taskNodeEntity);
            }
            flowTaskEntity.setCompletion(progressList.size() > 0 ? Integer.parseInt((String)progressList.get(0)) : 0);
            flowTaskEntity.setThisStepId(String.join((CharSequence)",", stepIdList));
            flowTaskEntity.setThisStep(String.join((CharSequence)",", stepNameList));
            flowTaskEntity.setStatus(FlowTaskStatusEnum.Handle.getCode());
            this.flowTaskService.update(flowTaskEntity);
        }
        for (FlowTaskOperatorEntity taskOperator : operatorList) {
            this.flowTaskOperatorService.update(taskOperator);
        }
        List<String> nextNodeList = flowTaskNodeEntityList.stream().filter(t -> t.getSortCode().equals(flowTaskNodeEntity.getSortCode() + 1L)).map(FlowTaskNodeEntity::getId).collect(Collectors.toList());
        String handId = userInfo.getUserId();
        this.flowCandidatesService.delete(nextNodeList, handId, operatorRecord.getTaskOperatorId());
        delOperatorRecordIds.add(operatorRecord.getId());
        this.flowTaskOperatorRecordService.updateStatus(delOperatorRecordIds);
        FlowTaskOperatorEntity operator = (FlowTaskOperatorEntity)JsonUtil.getJsonToBean((Object)operatorRecord, FlowTaskOperatorEntity.class);
        operator.setId(operatorRecord.getTaskOperatorId());
        FlowOperatordModel flowOperatordModel = new FlowOperatordModel();
        flowOperatordModel.setStatus(FlowRecordEnum.revoke.getCode());
        flowOperatordModel.setFlowModel(flowModel);
        flowOperatordModel.setUserId(userInfo.getUserId());
        flowOperatordModel.setOperator(operator);
        this.operatorRecord(operatorRecord, flowOperatordModel);
        this.flowTaskOperatorRecordService.create(operatorRecord);
        flowModel.setFormData(JsonUtil.stringToMap((String)flowTaskEntity.getFlowFormContentJson()));
        this.flowMsgUtil.event(6, nodeModel, operatorRecord, flowModel);
    }

    @Override
    @DSTransactional
    public void revoke(FlowTaskEntity flowTask, FlowModel flowModel) throws WorkFlowException {
        List<FlowTaskEntity> childList = this.flowTaskService.getChildList(flowTask.getId(), FlowTaskEntity::getId);
        if (childList.size() > 0) {
            throw new WorkFlowException(MsgCode.WF107.get());
        }
        UserInfo userInfo = this.userProvider.get();
        List<FlowTaskNodeEntity> list = this.flowTaskNodeService.getList(flowTask.getId());
        FlowTaskNodeEntity start = list.stream().filter(t -> FlowNature.NodeStart.equals(String.valueOf(t.getNodeType()))).findFirst().orElse(null);
        this.flowTaskNodeService.deleteByTaskId(flowTask.getId());
        this.flowTaskOperatorService.deleteByTaskId(flowTask.getId());
        this.flowCandidatesService.deleteByTaskId(flowTask.getId());
        List<String> recordListAll = this.flowTaskOperatorRecordService.getList(flowTask.getId()).stream().map(FlowTaskOperatorRecordEntity::getId).collect(Collectors.toList());
        this.flowTaskOperatorRecordService.updateStatus(recordListAll);
        flowTask.setThisStepId(start.getId());
        flowTask.setThisStep(start.getNodeName());
        flowTask.setCompletion(FlowNature.ProcessCompletion);
        flowTask.setStatus(FlowTaskStatusEnum.Revoke.getCode());
        flowTask.setStartTime(null);
        flowTask.setEndTime(null);
        flowTask.setThisStepId(String.join((CharSequence)",", new ArrayList()));
        flowTask.setThisStep(String.join((CharSequence)",", new ArrayList()));
        this.flowTaskService.update(flowTask);
        FlowTaskOperatorRecordEntity operatorRecord = new FlowTaskOperatorRecordEntity();
        operatorRecord.setTaskId(flowTask.getId());
        operatorRecord.setHandleStatus(FlowRecordEnum.revoke.getCode());
        FlowTaskOperatorEntity operator = (FlowTaskOperatorEntity)JsonUtil.getJsonToBean((Object)operatorRecord, FlowTaskOperatorEntity.class);
        operator.setHandleOpinion(flowModel.getHandleOpinion());
        FlowOperatordModel flowOperatordModel = new FlowOperatordModel();
        flowOperatordModel.setStatus(FlowRecordEnum.revoke.getCode());
        flowOperatordModel.setFlowModel(flowModel);
        flowOperatordModel.setUserId(userInfo.getUserId());
        flowOperatordModel.setOperator(operator);
        this.operatorRecord(operatorRecord, flowOperatordModel);
        this.flowTaskOperatorRecordService.create(operatorRecord);
        ChildNodeList nodeModel = (ChildNodeList)JsonUtil.getJsonToBean((String)start.getNodePropertyJson(), ChildNodeList.class);
        flowModel.setFormData(JsonUtil.stringToMap((String)flowTask.getFlowFormContentJson()));
        operatorRecord.setHandleStatus(FlowTaskStatusEnum.Revoke.getCode());
        this.flowMsgUtil.event(3, nodeModel, operatorRecord, flowModel);
        this.flowTaskService.deleteChild(flowTask);
    }

    @Override
    @DSTransactional
    public void cancel(FlowTaskEntity flowTask, FlowModel flowModel) {
        UserInfo userInfo = this.userProvider.get();
        FlowTaskOperatorRecordEntity operatorRecord = new FlowTaskOperatorRecordEntity();
        FlowTaskOperatorEntity operator = new FlowTaskOperatorEntity();
        operator.setTaskId(flowTask.getId());
        operator.setNodeCode(flowTask.getThisStepId());
        operator.setNodeName(flowTask.getThisStep());
        FlowOperatordModel flowOperatordModel = new FlowOperatordModel();
        flowOperatordModel.setStatus(FlowRecordEnum.cancel.getCode());
        flowOperatordModel.setFlowModel(flowModel);
        flowOperatordModel.setUserId(userInfo.getUserId());
        flowOperatordModel.setOperator(operator);
        this.operatorRecord(operatorRecord, flowOperatordModel);
        this.flowTaskOperatorRecordService.create(operatorRecord);
        flowTask.setStatus(FlowTaskStatusEnum.Cancel.getCode());
        flowTask.setEndTime(new Date());
        this.flowTaskService.update(flowTask);
    }

    @Override
    @DSTransactional
    public boolean assign(String id, FlowModel flowModel) throws WorkFlowException {
        boolean isOk;
        List list = this.flowTaskOperatorService.getList(id).stream().filter(t -> FlowNodeEnum.Process.getCode().equals(t.getState()) && flowModel.getNodeCode().equals(t.getNodeCode()) && FlowNature.ParentId.equals(t.getParentId())).collect(Collectors.toList());
        boolean bl = isOk = list.size() > 0;
        if (list.size() > 0) {
            FlowTaskOperatorEntity entity = (FlowTaskOperatorEntity)list.get(0);
            entity.setHandleStatus(null);
            entity.setHandleTime(null);
            entity.setCompletion(FlowNature.ProcessCompletion);
            entity.setCreatorTime(new Date());
            entity.setDraftData(null);
            entity.setHandleId(flowModel.getFreeApproverUserId());
            List<String> idAll = list.stream().map(FlowTaskOperatorEntity::getId).collect(Collectors.toList());
            this.flowTaskOperatorService.deleteList(idAll);
            ArrayList<FlowTaskOperatorEntity> operatorList = new ArrayList<FlowTaskOperatorEntity>();
            operatorList.add(entity);
            this.flowTaskOperatorService.create(operatorList);
            UserInfo userInfo = this.userProvider.get();
            FlowTaskOperatorRecordEntity operatorRecord = new FlowTaskOperatorRecordEntity();
            FlowTaskOperatorEntity operator = new FlowTaskOperatorEntity();
            operator.setTaskId(entity.getTaskId());
            operator.setNodeCode(entity.getNodeCode());
            operator.setNodeName(entity.getNodeName());
            FlowOperatordModel flowOperatordModel = new FlowOperatordModel();
            flowOperatordModel.setStatus(FlowRecordEnum.assign.getCode());
            flowOperatordModel.setFlowModel(flowModel);
            flowOperatordModel.setUserId(userInfo.getUserId());
            flowOperatordModel.setOperator(operator);
            flowOperatordModel.setOperatorId(entity.getHandleId());
            this.operatorRecord(operatorRecord, flowOperatordModel);
            this.flowTaskOperatorRecordService.create(operatorRecord);
            List<FlowTaskNodeEntity> taskNodeList = this.flowTaskNodeService.getList(entity.getTaskId());
            FlowTaskNodeEntity taskNode = taskNodeList.stream().filter(t -> t.getId().equals(entity.getTaskNodeId())).findFirst().orElse(null);
            FlowTaskEntity flowTask = this.flowTaskService.getInfoSubmit(entity.getTaskId(), new SFunction[0]);
            FlowEngineEntity engine = this.flowEngineService.getInfo(flowTask.getFlowId());
            FlowMsgModel flowMsgModel = new FlowMsgModel();
            flowMsgModel.setCirculateList(new ArrayList<FlowTaskCirculateEntity>());
            flowMsgModel.setTitle("\u5df2\u88ab\u3010\u6307\u6d3e\u3011");
            flowMsgModel.setData(JsonUtil.stringToMap((String)flowTask.getFlowFormContentJson()));
            flowMsgModel.setNodeList(taskNodeList);
            flowMsgModel.setOperatorList(operatorList);
            flowMsgModel.setTaskNodeEntity(taskNode);
            flowMsgModel.setTaskEntity(flowTask);
            flowMsgModel.setEngine(engine);
            this.flowMsgUtil.message(flowMsgModel);
        }
        return isOk;
    }

    @Override
    @DSTransactional
    public void transfer(final FlowTaskOperatorEntity taskOperator) throws WorkFlowException {
        this.flowTaskOperatorService.update(taskOperator);
        UserInfo userInfo = this.userProvider.get();
        FlowModel flowModel = new FlowModel();
        final FlowTaskOperatorRecordEntity operatorRecord = new FlowTaskOperatorRecordEntity();
        FlowTaskOperatorEntity operator = new FlowTaskOperatorEntity();
        operator.setTaskId(taskOperator.getTaskId());
        operator.setNodeCode(taskOperator.getNodeCode());
        operator.setTaskNodeId(taskOperator.getTaskNodeId());
        operator.setNodeName(taskOperator.getNodeName());
        operator.setHandleOpinion(taskOperator.getHandleOpinion());
        FlowOperatordModel flowOperatordModel = new FlowOperatordModel();
        flowOperatordModel.setStatus(FlowRecordEnum.transfer.getCode());
        flowOperatordModel.setFlowModel(flowModel);
        flowOperatordModel.setUserId(userInfo.getUserId());
        flowOperatordModel.setOperator(operator);
        flowOperatordModel.setOperatorId(taskOperator.getHandleId());
        this.operatorRecord(operatorRecord, flowOperatordModel);
        this.flowTaskOperatorRecordService.create(operatorRecord);
        List<FlowTaskNodeEntity> taskNodeList = this.flowTaskNodeService.getList(taskOperator.getTaskId());
        FlowTaskNodeEntity taskNode = taskNodeList.stream().filter(t -> t.getId().equals(taskOperator.getTaskNodeId())).findFirst().orElse(null);
        FlowTaskEntity flowTask = this.flowTaskService.getInfoSubmit(taskNode.getTaskId(), FlowTaskEntity::getId, FlowTaskEntity::getFlowId, FlowTaskEntity::getFullName, FlowTaskEntity::getCreatorUserId, FlowTaskEntity::getStatus, FlowTaskEntity::getThisStepId, FlowTaskEntity::getFlowFormContentJson, FlowTaskEntity::getTemplateId);
        FlowEngineEntity engine = this.flowEngineService.getInfo(flowTask.getFlowId());
        ArrayList operatorList = new ArrayList(){
            {
                FlowTaskOperatorEntity operatorEntity = new FlowTaskOperatorEntity();
                operatorEntity.setId(taskOperator.getId());
                operatorEntity.setTaskId(operatorRecord.getTaskId());
                operatorEntity.setHandleId(taskOperator.getHandleId());
                operatorEntity.setTaskNodeId(operatorRecord.getTaskNodeId());
                this.add(operatorEntity);
            }
        };
        FlowMsgModel flowMsgModel = new FlowMsgModel();
        flowMsgModel.setCirculateList(new ArrayList<FlowTaskCirculateEntity>());
        flowMsgModel.setTitle("\u5df2\u88ab\u3010\u8f6c\u529e\u3011");
        flowMsgModel.setNodeList(taskNodeList);
        flowMsgModel.setOperatorList(operatorList);
        flowMsgModel.setData(JsonUtil.stringToMap((String)flowTask.getFlowFormContentJson()));
        flowMsgModel.setTaskNodeEntity(taskNode);
        flowMsgModel.setTaskEntity(flowTask);
        flowMsgModel.setEngine(engine);
        this.flowMsgUtil.message(flowMsgModel);
    }

    @Override
    public FlowBeforeInfoVO getBeforeInfo(String id, String taskNodeId, String taskOperatorId) throws WorkFlowException, BaseException {
        FlowTaskOperatorEntity operator;
        FlowEngineTemplateVersionEntity versionEntity;
        Object childNode;
        FlowBeforeInfoVO vo = new FlowBeforeInfoVO();
        FlowTaskEntity taskEntity = this.flowTaskService.getInfo(id);
        FlowEngineTemplateEntity flowTemplate = (FlowEngineTemplateEntity)this.flowEngineTemplateService.getById((Serializable)((Object)taskEntity.getTemplateId()));
        List taskNodeAllList = this.flowTaskNodeService.getList(taskEntity.getId()).stream().filter(t -> FlowNodeEnum.Process.getCode().equals(t.getState())).collect(Collectors.toList());
        List taskNodeList = taskNodeAllList.stream().sorted(Comparator.comparing(FlowTaskNodeEntity::getSortCode)).collect(Collectors.toList());
        List taskOperatorList = this.flowTaskOperatorService.getList(taskEntity.getId()).stream().filter(t -> FlowNodeEnum.Process.getCode().equals(t.getState())).collect(Collectors.toList());
        List<FlowTaskOperatorRecordEntity> operatorRecordList = this.flowTaskOperatorRecordService.getList(taskEntity.getId());
        List<FlowTaskCirculateEntity> copyList = this.flowTaskCirculateService.getCopyList(id);
        List objectIdList = copyList.stream().map(x -> x.getObjectId()).collect(Collectors.toList());
        boolean colorFlag = true;
        ArrayList<FlowTaskOperatorRecordModel> recordList = new ArrayList<FlowTaskOperatorRecordModel>();
        ArrayList<String> userIdAll = new ArrayList<String>();
        operatorRecordList.stream().forEach(t -> {
            userIdAll.add(t.getHandleId());
            if (StringUtils.isNotEmpty((String)t.getOperatorId())) {
                userIdAll.add(t.getOperatorId());
            }
        });
        userIdAll.addAll(taskOperatorList.stream().map(FlowTaskOperatorEntity::getHandleId).collect(Collectors.toList()));
        userIdAll.add(taskEntity.getCreatorUserId());
        userIdAll.addAll(objectIdList);
        List<UserEntity> userList = this.serviceUtil.getUserName(userIdAll);
        for (FlowTaskOperatorRecordEntity entity : operatorRecordList) {
            copyList.stream().forEach(copy -> {
                FlowTaskNodeEntity nodeEntity;
                ArrayList<String> list = new ArrayList<String>();
                if (copy.getTaskNodeId().equals(entity.getTaskNodeId())) {
                    if (CollectionUtil.isEmpty(entity.getObjectId())) {
                        list.add(copy.getObjectId());
                        entity.setObjectId(list);
                    } else {
                        entity.getObjectId().add(copy.getObjectId());
                    }
                } else if (entity.getNodeName().equals("\u5f00\u59cb") && ObjectUtil.isEmpty((Object)entity.getTaskNodeId()) && ObjectUtil.isNotEmpty((Object)(nodeEntity = this.flowTaskNodeService.getInfo(copy.getTaskNodeId()))) && nodeEntity.getNodeType().equals("start")) {
                    if (CollectionUtil.isEmpty(entity.getObjectId())) {
                        list.add(copy.getObjectId());
                        entity.setObjectId(list);
                    } else {
                        entity.getObjectId().add(copy.getObjectId());
                    }
                }
            });
            UserEntity userName = userList.stream().filter(t -> t.getId().equals(entity.getHandleId())).findFirst().orElse(null);
            FlowTaskOperatorRecordModel infoModel = (FlowTaskOperatorRecordModel)JsonUtil.getJsonToBean((Object)entity, FlowTaskOperatorRecordModel.class);
            infoModel.setUserName(userName != null ? userName.getRealName() : "");
            UserEntity operatorName = userList.stream().filter(t -> t.getId().equals(entity.getOperatorId())).findFirst().orElse(null);
            infoModel.setOperatorId(operatorName != null ? operatorName.getRealName() : "");
            if (CollectionUtil.isNotEmpty(entity.getObjectId())) {
                Map<String, String> userMap = userList.stream().filter(x -> entity.getObjectId().contains(x.getId())).collect(Collectors.toMap(UserEntity::getId, UserEntity::getRealName));
                infoModel.setObjectIdsMap(userMap);
                String collect = userMap.values().stream().collect(Collectors.joining(","));
                String collect1 = userMap.keySet().stream().collect(Collectors.joining(","));
                infoModel.setObjectId(collect);
                infoModel.setObjectIds(collect1);
            }
            infoModel.setHandleFiles(entity.getHandleFiles());
            FlowTaskNodeEntity nodeInfo = this.flowTaskNodeService.getInfo(infoModel.getTaskNodeId());
            if (ObjectUtil.isNotEmpty((Object)nodeInfo)) {
                infoModel.setNodeName(nodeInfo.getNodeName());
            }
            recordList.add(infoModel);
        }
        vo.setFlowTaskOperatorRecordList(recordList);
        String[] tepId = taskEntity.getThisStepId() != null ? taskEntity.getThisStepId().split(",") : new String[]{};
        List<String> tepIdAll = Arrays.asList(tepId);
        List flowTaskNodeListAll = JsonUtil.getJsonToList(taskNodeList, FlowTaskNodeModel.class);
        for (FlowTaskNodeModel model : flowTaskNodeListAll) {
            if ((colorFlag || model.getCompletion() == 1) && model.getSortCode() != -2L) {
                model.setType("0");
            }
            if (tepIdAll.contains(model.getId())) {
                model.setType("1");
                colorFlag = false;
                if (FlowNature.NodeEnd.equals(model.getId())) {
                    model.setType("0");
                }
            }
            ChildNodeList childNode2 = (ChildNodeList)JsonUtil.getJsonToBean((String)model.getNodePropertyJson(), ChildNodeList.class);
            Custom custom = childNode2.getCustom();
            Properties properties = childNode2.getProperties();
            String assigneeType = properties.getAssigneeType();
            ArrayList<FlowTaskOperatorEntity> operatorList = new ArrayList<FlowTaskOperatorEntity>();
            FlowModel flowModel = new FlowModel();
            TaskOperator taskOperator = new TaskOperator();
            taskOperator.setChildNode(childNode2);
            taskOperator.setTaskEntity(taskEntity);
            taskOperator.setFlowModel(flowModel);
            taskOperator.setDetails(false);
            taskOperator.setId(FlowNature.ParentId);
            List<UserEntity> operatorUser = this.operator(operatorList, taskOperator);
            ArrayList<String> userName = new ArrayList<String>();
            ArrayList approveName = new ArrayList();
            if (FlowNature.NodeStart.equals(custom.getType())) {
                UserEntity startUser = userList.stream().filter(t -> t.getId().equals(taskEntity.getCreatorUserId())).findFirst().orElse(null);
                userName.add(startUser != null ? startUser.getRealName() : "");
            } else if (FlowNature.NodeSubFlow.equals(custom.getType())) {
                List<UserEntity> list = this.childSaveList(childNode2, taskEntity);
                ArrayList<String> nameList = new ArrayList<String>();
                for (UserEntity userEntity : list) {
                    nameList.add(userEntity.getRealName());
                }
                userName.addAll(nameList);
            } else if (FlowTaskOperatorEnum.FreeApprover.getCode().equals(assigneeType)) {
                List operatorUserList = taskOperatorList.stream().filter(t -> t.getNodeCode().equals(custom.getNodeId()) && FlowNature.ParentId.equals(t.getParentId())).map(FlowTaskOperatorEntity::getHandleId).collect(Collectors.toList());
                List userListAll = userList.stream().filter(t -> operatorUserList.contains(t.getId())).collect(Collectors.toList());
                ArrayList<String> nameList = new ArrayList<String>();
                for (UserEntity operator2 : userListAll) {
                    nameList.add(operator2.getRealName());
                }
                userName.addAll(nameList);
            } else if (!FlowNature.NodeEnd.equals(custom.getNodeId())) {
                boolean isShow = true;
                if (FlowTaskOperatorEnum.Tache.getCode().equals(assigneeType)) {
                    boolean completion;
                    boolean bl = completion = "0".equals(model.getType()) || "1".equals(model.getType());
                    if (!completion) {
                        isShow = false;
                    }
                }
                if (isShow) {
                    ArrayList<String> nameList = new ArrayList<String>();
                    ArrayList<String> approveList = new ArrayList<String>();
                    for (UserEntity operator2 : operatorUser) {
                        nameList.add(operator2.getRealName());
                    }
                    List<FlowTaskOperatorEntity> list = this.flowTaskOperatorService.getAllByNodeId(model.getTaskId(), model.getId());
                    if (CollectionUtil.isNotEmpty(list)) {
                        for (FlowTaskOperatorEntity operator3 : list) {
                            for (UserEntity user : operatorUser) {
                                if (!user.getId().equals(operator3.getHandleId()) || operator3.getCompletion() == 1) continue;
                                approveList.add(user.getRealName());
                            }
                        }
                    }
                    userName.addAll(nameList);
                    approveName.addAll(approveList);
                }
            }
            model.setUserName(String.join((CharSequence)",", userName));
            model.setApproveName(String.join((CharSequence)",", approveName));
        }
        vo.setFlowTaskNodeList(flowTaskNodeListAll);
        FlowTaskModel inof = (FlowTaskModel)JsonUtil.getJsonToBean((Object)taskEntity, FlowTaskModel.class);
        if (ObjectUtil.isNotEmpty((Object)flowTemplate)) {
            inof.setTemplateCompanyId(flowTemplate.getCompanyId());
        }
        if (ObjectUtil.isEmpty((Object)taskEntity.getFlowTemplateJson()) && ObjectUtil.isNotEmpty((Object)taskEntity.getVersionId())) {
            FlowEngineTemplateVersionEntity versionEntity2 = (FlowEngineTemplateVersionEntity)this.flowEngineTemplateVersionService.getById((Serializable)((Object)taskEntity.getVersionId()));
            inof.setFlowTemplateJson(versionEntity2.getFlowTemplateJson());
        }
        FlowEngineEntity engine = this.flowEngineService.getInfo(taskEntity.getFlowId());
        inof.setAppFormUrl(engine.getAppFormUrl());
        inof.setFormUrl(engine.getFormUrl());
        inof.setType(engine.getType());
        vo.setFlowTaskInfo(inof);
        for (FlowTaskOperatorEntity operatorEntity : taskOperatorList) {
            UserEntity userInfo = this.serviceUtil.getUserInfo(operatorEntity.getHandleId());
            if (userInfo == null) continue;
            operatorEntity.setHandleName(userInfo.getRealName());
        }
        vo.setFlowTaskOperatorList(JsonUtil.getJsonToList(taskOperatorList, FlowTaskOperatorModel.class));
        vo.setFlowFormInfo(taskEntity.getFlowForm());
        Properties approversProperties = new Properties();
        if (StringUtils.isNotEmpty((String)taskNodeId)) {
            FlowTaskNodeEntity taskNode = this.flowTaskNodeService.getInfo(taskNodeId);
            vo.setFormOperates(new ArrayList<FormOperates>());
            if (taskNode != null) {
                childNode = (ChildNodeList)JsonUtil.getJsonToBean((String)taskNode.getNodePropertyJson(), ChildNodeList.class);
                approversProperties = ((ChildNodeList)childNode).getProperties();
                vo.setFormOperates(((ChildNodeList)childNode).getProperties().getFormOperates());
            }
        } else if (ObjectUtil.isNotEmpty((Object)flowTemplate) && ObjectUtil.isNotEmpty((Object)(versionEntity = (FlowEngineTemplateVersionEntity)this.flowEngineTemplateVersionService.getById((Serializable)((Object)flowTemplate.getVersionId()))))) {
            childNode = (ChildNode)JsonUtil.getJsonToBean((String)versionEntity.getFlowTemplateJson(), ChildNode.class);
            Properties properties = ((ChildNode)childNode).getProperties();
            approversProperties = ((ChildNode)childNode).getProperties();
            vo.setFormOperates(properties.getFormOperates());
        }
        FlowJsonUtil.assignment(approversProperties);
        vo.setApproversProperties(approversProperties);
        if (StringUtils.isNotEmpty((String)taskOperatorId) && (operator = (FlowTaskOperatorEntity)taskOperatorList.stream().filter(t -> t.getId().equals(taskOperatorId)).findFirst().orElse(null)) != null && StringUtils.isNotEmpty((String)operator.getDraftData())) {
            vo.setDraftData(JsonUtil.stringToMap((String)operator.getDraftData()));
        }
        return vo;
    }

    @Override
    public List<FlowSummary> recordList(String id, String category, String type) {
        LinkedList<FlowTaskOperatorRecordEntity> operator;
        List userAll;
        Object objectId;
        List<UserRelationEntity> relationList;
        List<String> userId;
        ArrayList<Integer> handleStatus = new ArrayList<Integer>();
        if (!"0".equals(type)) {
            handleStatus.add(0);
            handleStatus.add(1);
        }
        List<FlowTaskOperatorRecordEntity> recordListAll = this.flowTaskOperatorRecordService.getRecordList(id, handleStatus);
        ArrayList<String> userIdAll = new ArrayList<String>();
        List userIdList = recordListAll.stream().map(FlowTaskOperatorRecordEntity::getHandleId).collect(Collectors.toList());
        List operatorId = recordListAll.stream().filter(t -> StringUtils.isNotEmpty((String)t.getOperatorId())).map(FlowTaskOperatorRecordEntity::getOperatorId).collect(Collectors.toList());
        userIdAll.addAll(userIdList);
        userIdAll.addAll(operatorId);
        List<UserEntity> userList = this.serviceUtil.getUserName(userIdAll);
        ArrayList<FlowSummary> list = new ArrayList<FlowSummary>();
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap operatorAll = new HashMap();
        if (FlowRecordListEnum.position.getCode().equals(category)) {
            userId = userList.stream().map(UserEntity::getId).collect(Collectors.toList());
            relationList = this.serviceUtil.getListByUserIdAll(userId);
            objectId = relationList.stream().map(UserRelationEntity::getObjectId).collect(Collectors.toList());
            List<PositionEntity> positionListAll = this.serviceUtil.getPositionName((List<String>)objectId);
            for (PositionEntity positionEntity : positionListAll) {
                map.put(positionEntity.getId(), positionEntity.getFullName());
                userAll = relationList.stream().filter(t -> t.getObjectId().equals(entity.getId())).map(UserRelationEntity::getUserId).collect(Collectors.toList());
                operator = new LinkedList<FlowTaskOperatorRecordEntity>();
                for (FlowTaskOperatorRecordEntity recordEntity : recordListAll) {
                    if (!userAll.contains(recordEntity.getHandleId())) continue;
                    operator.add(recordEntity);
                }
                operatorAll.put(positionEntity.getId(), operator);
            }
        } else if (FlowRecordListEnum.role.getCode().equals(category)) {
            userId = userList.stream().map(UserEntity::getId).collect(Collectors.toList());
            relationList = this.serviceUtil.getListByUserIdAll(userId);
            objectId = relationList.stream().map(UserRelationEntity::getObjectId).collect(Collectors.toList());
            List<RoleEntity> roleListAll = this.serviceUtil.getListByIds((List<String>)objectId);
            for (RoleEntity roleEntity : roleListAll) {
                map.put(roleEntity.getId(), roleEntity.getFullName());
                userAll = relationList.stream().filter(t -> t.getObjectId().equals(roleEntity.getId())).map(UserRelationEntity::getUserId).collect(Collectors.toList());
                operator = new LinkedList();
                for (FlowTaskOperatorRecordEntity recordEntity : recordListAll) {
                    if (!userAll.contains(recordEntity.getHandleId())) continue;
                    operator.add(recordEntity);
                }
                operatorAll.put(roleEntity.getId(), operator);
            }
        } else if (FlowRecordListEnum.department.getCode().equals(category)) {
            List<String> organizeList = userList.stream().map(UserEntity::getOrganizeId).collect(Collectors.toList());
            List<OrganizeEntity> organizeListAll = this.serviceUtil.getOrganizeName(organizeList);
            for (OrganizeEntity entity : organizeListAll) {
                map.put(entity.getId(), entity.getFullName());
                List userAll2 = userList.stream().filter(t -> t.getOrganizeId().equals(entity.getId())).map(UserEntity::getId).collect(Collectors.toList());
                LinkedList<FlowTaskOperatorRecordEntity> linkedList = new LinkedList<FlowTaskOperatorRecordEntity>();
                for (FlowTaskOperatorRecordEntity recordEntity : recordListAll) {
                    if (!userAll2.contains(recordEntity.getHandleId())) continue;
                    linkedList.add(recordEntity);
                }
                operatorAll.put(entity.getId(), linkedList);
            }
        }
        for (String key : map.keySet()) {
            String fullName = (String)map.get(key);
            FlowSummary summary = new FlowSummary();
            summary.setId(key);
            summary.setFullName(fullName);
            List recordList = (List)operatorAll.get(key);
            ArrayList<FlowSummary> arrayList = new ArrayList<FlowSummary>();
            for (FlowTaskOperatorRecordEntity entity : recordList) {
                FlowSummary childSummary = (FlowSummary)JsonUtil.getJsonToBean((Object)entity, FlowSummary.class);
                UserEntity user = userList.stream().filter(t -> t.getId().equals(entity.getHandleId())).findFirst().orElse(null);
                childSummary.setUserName(user != null ? user.getRealName() : "");
                UserEntity userEntity = userList.stream().filter(t -> t.getId().equals(entity.getOperatorId())).findFirst().orElse(null);
                childSummary.setOperatorId(userEntity != null ? userEntity.getRealName() : "");
                arrayList.add(childSummary);
            }
            summary.setList(arrayList);
            list.add(summary);
        }
        return list;
    }

    @Override
    public boolean press(String taskId) throws WorkFlowException {
        FlowTaskEntity flowTaskEntity = this.flowTaskService.getInfo(taskId);
        FlowEngineEntity engine = this.flowEngineService.getInfo(flowTaskEntity.getFlowId());
        List<FlowTaskOperatorEntity> operatorList = this.flowTaskOperatorService.press(taskId);
        boolean flag = operatorList.size() > 0;
        Map data = JsonUtil.stringToMap((String)flowTaskEntity.getFlowFormContentJson());
        List<FlowTaskNodeEntity> taskNodeList = this.flowTaskNodeService.getList(taskId);
        FlowMsgModel flowMsgModel = new FlowMsgModel();
        flowMsgModel.setCirculateList(new ArrayList<FlowTaskCirculateEntity>());
        flowMsgModel.setNodeList(taskNodeList);
        flowMsgModel.setOperatorList(operatorList);
        flowMsgModel.setTaskEntity(flowTaskEntity);
        flowMsgModel.setData(data);
        flowMsgModel.setEngine(engine);
        flowMsgModel.setTitle("\u5df2\u88ab\u3010\u50ac\u529e\u3011");
        this.flowMsgUtil.message(flowMsgModel);
        return flag;
    }

    @Override
    public List<FlowCandidateVO> candidates(String id, FlowHandleModel flowCandidateModel) throws WorkFlowException {
        List<ChildNodeList> childNodeListAll = this.childNodeListAll(id, flowCandidateModel);
        ArrayList<FlowCandidateVO> listVO = new ArrayList<FlowCandidateVO>();
        for (ChildNodeList childNodeList : childNodeListAll) {
            Properties properties = childNodeList.getProperties();
            String nodeId = childNodeList.getCustom().getNodeId();
            String nodeName = properties.getTitle();
            String type = properties.getAssigneeType();
            if (!FlowTaskOperatorEnum.FreeApprover.getCode().equals(type)) continue;
            FlowCandidateVO candidateVO = new FlowCandidateVO();
            candidateVO.setNodeName(nodeName);
            candidateVO.setNodeId(nodeId);
            listVO.add(candidateVO);
        }
        return listVO;
    }

    @Override
    public List<FlowCandidateUserModel> candidateUser(String id, FlowHandleModel flowCandidateModel) throws WorkFlowException {
        ArrayList<FlowCandidateUserModel> dataList = new ArrayList<FlowCandidateUserModel>();
        FlowTaskEntity task = this.flowTaskService.getInfo(id);
        Map<String, Object> formData = flowCandidateModel.getFormData();
        formData.put("templateId", task.getTemplateId());
        List<ChildNodeList> childNodeListAll = this.childNodeListAll(id, flowCandidateModel);
        for (ChildNodeList childNodeList : childNodeListAll) {
            Properties properties = childNodeList.getProperties();
            List<String> positionList = properties.getApproverPos();
            List<String> roleList = properties.getApproverRole();
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(positionList);
            list.addAll(roleList);
            List<UserRelationEntity> listByObjectIdAll = this.serviceUtil.getListByObjectIdAll(list);
            List<String> userId = listByObjectIdAll.stream().map(UserRelationEntity::getUserId).collect(Collectors.toList());
            userId.addAll(properties.getApprovers());
            Pagination pagination = (Pagination)JsonUtil.getJsonToBean((Object)((Object)flowCandidateModel), Pagination.class);
            List<UserEntity> userName = this.serviceUtil.getUserName(userId, pagination);
            flowCandidateModel.setTotal(pagination.getTotal());
            for (UserEntity userEntity : userName) {
                FlowCandidateUserModel userModel = new FlowCandidateUserModel();
                userModel.setUserId(userEntity.getId());
                userModel.setUserName(userEntity.getRealName());
                dataList.add(userModel);
            }
        }
        return dataList;
    }

    @Override
    @DSTransactional
    public void batch(FlowHandleModel flowHandleModel) throws WorkFlowException {
        ArrayList idList = flowHandleModel.getIds() != null ? flowHandleModel.getIds() : new ArrayList();
        Integer batchType = flowHandleModel.getBatchType();
        UserInfo userInfo = this.userProvider.get();
        for (String id : idList) {
            String rejecttKey = userInfo.getTenantId() + id;
            if (this.cacheUtil.exists("shortCacheSpace", rejecttKey)) {
                throw new WorkFlowException(MsgCode.WF005.get());
            }
            this.cacheUtil.insert("shortCacheSpace", rejecttKey, (Object)id, 10L);
            FlowTaskOperatorEntity operator = this.flowTaskOperatorService.getInfo(id);
            FlowTaskEntity taskEntity = this.flowTaskService.getInfo(operator.getTaskId());
            flowHandleModel.setFormData(JsonUtil.stringToMap((String)taskEntity.getFlowFormContentJson()));
            FlowModel flowModel = (FlowModel)JsonUtil.getJsonToBean((Object)((Object)flowHandleModel), FlowModel.class);
            switch (batchType) {
                case 0: {
                    this.audit(id, flowModel);
                }
                case 1: {
                    this.reject(id, flowModel);
                    break;
                }
                case 2: {
                    operator.setHandleId(flowHandleModel.getFreeApproverUserId());
                    this.transfer(operator);
                }
            }
        }
    }

    @Override
    public List<FlowCandidateVO> batchCandidates(String flowId, String operatorId) throws WorkFlowException {
        FlowEngineEntity flowEngine = this.flowEngineService.getInfo(flowId);
        FlowTaskOperatorEntity operator = this.flowTaskOperatorService.getInfo(operatorId);
        FlowTaskNodeEntity taskNode = this.flowTaskNodeService.getInfo(operator.getTaskNodeId());
        FlowTaskEntity task = this.flowTaskService.getInfo(operator.getTaskId());
        FlowEngineTemplateEntity flowTemplate = (FlowEngineTemplateEntity)this.flowEngineTemplateService.getById((Serializable)((Object)task.getTemplateId()));
        ChildNode childNodeAll = new ChildNode();
        FlowEngineTemplateVersionEntity versionEntity = (FlowEngineTemplateVersionEntity)this.flowEngineTemplateVersionService.getById((Serializable)((Object)flowTemplate.getVersionId()));
        if (ObjectUtil.isNotEmpty((Object)versionEntity)) {
            childNodeAll = (ChildNode)JsonUtil.getJsonToBean((String)versionEntity.getFlowTemplateJson(), ChildNode.class);
        }
        ArrayList<ChildNodeList> nodeListAll = new ArrayList<ChildNodeList>();
        ArrayList<ConditionList> conditionListAll = new ArrayList<ConditionList>();
        FlowJsonUtil.getTemplateAll(childNodeAll, nodeListAll, conditionListAll);
        boolean isCondition = conditionListAll.stream().filter(t -> operator.getNodeCode().equals(t.getPrevId())).count() > 0L;
        boolean isNext = false;
        if (isCondition) {
            ArrayList nodeNext = StringUtils.isNotEmpty((String)taskNode.getNodeNext()) ? Arrays.asList(taskNode.getNodeNext().split(",")) : new ArrayList();
            boolean bl = isNext = nodeListAll.stream().filter(t -> nodeNext.contains(t.getCustom().getNodeId()) && FlowTaskOperatorEnum.FreeApprover.getCode().equals(t.getProperties().getAssigneeType())).count() > 0L;
        }
        if (isNext) {
            throw new WorkFlowException("\u6761\u4ef6\u6d41\u7a0b\u5305\u542b\u5019\u9009\u4eba\u65e0\u6cd5\u6279\u91cf\u901a\u8fc7");
        }
        FlowHandleModel flowCandidateModel = new FlowHandleModel();
        Map objectMap = JsonUtil.stringToMap((String)task.getFlowFormContentJson());
        objectMap.put("flowId", task.getFlowId());
        objectMap.put("templateId", task.getTemplateId());
        flowCandidateModel.setFormData(objectMap);
        return this.candidates(operatorId, flowCandidateModel);
    }

    @Override
    public void permissions(String userId, FlowTaskEntity flowTask, FlowTaskOperatorEntity operator, String msg) throws WorkFlowException {
        UserInfo userInfo = this.userProvider.get();
        if (operator == null || FlowNodeEnum.Futility.getCode().equals(operator.getState())) {
            throw new WorkFlowException(StringUtils.isEmpty((String)msg) ? MsgCode.WF122.get() : msg);
        }
        if (!FlowNature.ProcessCompletion.equals(operator.getCompletion())) {
            throw new WorkFlowException(StringUtils.isEmpty((String)msg) ? MsgCode.WF124.get() : msg);
        }
        List flowDelegateList = this.flowDelegateService.getUser(userInfo.getUserId(), flowTask.getFlowId(), userId).stream().map(FlowDelegateEntity::getToUserid).collect(Collectors.toList());
        flowDelegateList.add(userId);
        if (!flowDelegateList.contains(userInfo.getUserId())) {
            throw new WorkFlowException(MsgCode.WF122.get());
        }
        if (FlowTaskStatusEnum.Cancel.getCode().equals(flowTask.getStatus())) {
            throw new WorkFlowException(MsgCode.WF121.get());
        }
        if (FlowTaskStatusEnum.Revoke.getCode().equals(flowTask.getStatus())) {
            throw new WorkFlowException(MsgCode.WF120.get());
        }
    }

    private void candidate(List<FlowTaskNodeEntity> taskNodeList, List<ChildNodeList> childNodeListAll, String nodeCode, boolean isNext) {
        List nodeList = taskNodeList.stream().filter(t -> t.getNodeCode().equals(nodeCode)).collect(Collectors.toList());
        for (FlowTaskNodeEntity taskNodeEntity : nodeList) {
            if (isNext) {
                List<String> nextNodeList = Arrays.asList(taskNodeEntity.getNodeNext().split(","));
                List nextTaskNodeList = taskNodeList.stream().filter(t -> nextNodeList.contains(t.getNodeCode())).collect(Collectors.toList());
                for (FlowTaskNodeEntity nodeEntity : nextTaskNodeList) {
                    String nodeType = nodeEntity.getNodeType();
                    String code = nodeEntity.getNodeCode();
                    if (FlowNature.NodeSubFlow.equals(nodeType)) {
                        this.candidate(taskNodeList, childNodeListAll, code, true);
                        continue;
                    }
                    ChildNodeList childNodeList = (ChildNodeList)JsonUtil.getJsonToBean((String)nodeEntity.getNodePropertyJson(), ChildNodeList.class);
                    childNodeListAll.add(childNodeList);
                }
                continue;
            }
            ChildNodeList childNodeList = (ChildNodeList)JsonUtil.getJsonToBean((String)taskNodeEntity.getNodePropertyJson(), ChildNodeList.class);
            childNodeListAll.add(childNodeList);
        }
    }

    private List<ChildNodeList> childNodeListAll(String id, FlowHandleModel flowCandidateModel) throws WorkFlowException {
        ArrayList<ChildNodeList> childNodeListAll = new ArrayList<ChildNodeList>();
        ArrayList<FlowTaskNodeEntity> taskNodeList = new ArrayList<FlowTaskNodeEntity>();
        String nodeCode = "";
        FlowTaskOperatorEntity operatorEntity = this.flowTaskOperatorService.getOperatorInfo(id);
        UserInfo userInfo = this.userProvider.get();
        boolean isNodeCode = StringUtils.isNotEmpty((String)flowCandidateModel.getNodeCode());
        boolean parentId = false;
        boolean operator = operatorEntity != null;
        Map formData = flowCandidateModel.getFormData();
        Object flowId = formData.get("flowId");
        String templateId = formData.get("templateId").toString();
        if (ObjectUtil.isNotNull((Object)flowId)) {
            Map<String, Object> formDataAll;
            Object data;
            FlowEngineEntity engine = this.flowEngineService.getInfo(String.valueOf(flowId));
            if (FlowNature.CUSTOM.equals(engine.getFormType()) && (data = (formDataAll = flowCandidateModel.getFormData()).get("data")) != null) {
                formData = JsonUtil.stringToMap((String)String.valueOf(data));
            }
            ArrayList<ChildNodeList> nodeListAll = new ArrayList<ChildNodeList>();
            ArrayList<ConditionList> conditionListAll = new ArrayList<ConditionList>();
            FlowTaskEntity flowTask = new FlowTaskEntity();
            if (operator) {
                flowTask = this.flowTaskService.getInfo(operatorEntity.getTaskId());
            } else {
                flowTask.setId(RandomUtil.uuId());
                flowTask.setCreatorUserId(userInfo.getUserId());
                flowTask.setCreatorTime(new Date());
            }
            FlowEngineTemplateEntity flowTemplate = (FlowEngineTemplateEntity)this.flowEngineTemplateService.getById((Serializable)((Object)templateId));
            ChildNode childNodeAll = new ChildNode();
            FlowEngineTemplateVersionEntity versionEntity = (FlowEngineTemplateVersionEntity)this.flowEngineTemplateVersionService.getById((Serializable)((Object)flowTemplate.getVersionId()));
            if (ObjectUtil.isNotEmpty((Object)versionEntity)) {
                childNodeAll = (ChildNode)JsonUtil.getJsonToBean((String)versionEntity.getFlowTemplateJson(), ChildNode.class);
            }
            flowTask.setFlowFormContentJson(JsonUtil.getObjectToString((Object)formData));
            this.updateNodeList(flowTask, childNodeAll, nodeListAll, conditionListAll, taskNodeList);
            Optional<FlowTaskNodeEntity> first = taskNodeList.stream().filter(t -> FlowNature.NodeStart.equals(t.getNodeType())).findFirst();
            if (!first.isPresent()) {
                throw new WorkFlowException(MsgCode.COD001.get());
            }
            FlowTaskNodeEntity startNodes = first.get();
            nodeCode = startNodes.getNodeCode();
            this.nodeList(taskNodeList, nodeCode, 1L);
        }
        if (operator) {
            nodeCode = operatorEntity.getNodeCode();
            boolean bl = parentId = !FlowNature.ParentId.equals(operatorEntity.getParentId());
        }
        if (isNodeCode) {
            nodeCode = flowCandidateModel.getNodeCode();
        }
        this.candidate(taskNodeList, childNodeListAll, nodeCode, !isNodeCode);
        if (parentId) {
            childNodeListAll = new ArrayList();
        }
        return childNodeListAll;
    }

    private void task(FlowTaskEntity taskEntity, FlowEngineEntity engine, FlowModel flowModel, String userId) throws WorkFlowException {
        if (flowModel.getId() != null && !this.checkStatus(taskEntity.getStatus())) {
            throw new WorkFlowException(MsgCode.WF108.get());
        }
        FlowEngineTemplateEntity flowTemplate = (FlowEngineTemplateEntity)this.flowEngineTemplateService.getById((Serializable)((Object)flowModel.getTemplateId()));
        FlowEngineTemplateVersionEntity versionEntity = (FlowEngineTemplateVersionEntity)this.flowEngineTemplateVersionService.getById((Serializable)((Object)flowTemplate.getVersionId()));
        if (StringUtils.isEmpty((String)taskEntity.getId())) {
            taskEntity.setId(RandomUtil.uuId());
        }
        taskEntity.setProcessId(flowModel.getProcessId());
        taskEntity.setEnCode(flowModel.getBillNo());
        taskEntity.setFullName(flowModel.getFlowTitle());
        taskEntity.setFlowUrgent(flowModel.getFlowUrgent() != null ? flowModel.getFlowUrgent() : 1);
        taskEntity.setFlowId(engine.getId());
        taskEntity.setFlowCode(engine.getEnCode() != null ? engine.getEnCode() : MsgCode.WF109.get());
        taskEntity.setTemplateId(flowModel.getTemplateId());
        taskEntity.setFlowName(engine.getFullName());
        taskEntity.setFlowType(engine.getType());
        taskEntity.setFlowCategory(engine.getCategory());
        if (ObjectUtil.isEmpty((Object)taskEntity.getOaCode())) {
            String oaFlowCode = null;
            try {
                oaFlowCode = this.baseDataUtil.getBillNumber("oaFlowCode", Boolean.valueOf(false));
            }
            catch (DataException e) {
                throw new RuntimeException(e);
            }
            String flowCategoryPrefix = this.getFlowCategoryPrefix(taskEntity.getFlowCategory());
            String newFlowCode = oaFlowCode;
            int index = oaFlowCode.indexOf("OA");
            if (index != -1) {
                String part1 = oaFlowCode.substring(0, index);
                String part2 = oaFlowCode.substring(index, index + 2);
                String part3 = oaFlowCode.substring(index + 2);
                newFlowCode = part1 + part2 + flowCategoryPrefix + part3;
            }
            taskEntity.setOaCode(newFlowCode);
        }
        taskEntity.setFlowForm(engine.getFormData());
        if (ObjectUtil.isNotEmpty((Object)versionEntity)) {
            taskEntity.setVersionId(versionEntity.getId());
        }
        taskEntity.setFlowVersion(engine.getVersion());
        taskEntity.setStatus(flowModel.getStatus());
        taskEntity.setCompletion(FlowNature.ProcessCompletion);
        taskEntity.setCreatorTime(new Date());
        taskEntity.setEnabledMark(1);
        taskEntity.setCreatorUserId(userId);
        taskEntity.setLastModifyUserId(userId);
        taskEntity.setLastModifyTime(new Date());
        taskEntity.setFlowFormContentJson(flowModel.getFormData() != null ? JsonUtilEx.getObjectToString(flowModel.getFormData()) : "{}");
        taskEntity.setParentId(flowModel.getParentId() != null ? flowModel.getParentId() : FlowNature.ParentId);
        taskEntity.setIsAsync(flowModel.getIsAsync() != false ? FlowNature.ChildAsync : FlowNature.ChildSync);
        ChildNode childNode = new ChildNode();
        if (ObjectUtil.isNotEmpty((Object)versionEntity)) {
            childNode = (ChildNode)JsonUtil.getJsonToBean((String)versionEntity.getFlowTemplateJson(), ChildNode.class);
        }
        boolean isBatchApproval = false;
        if (ObjectUtil.isNotEmpty((Object)childNode.getProperties().getIsBatchApproval()) && childNode.getProperties().getIsBatchApproval().booleanValue()) {
            isBatchApproval = true;
        }
        taskEntity.setIsBatch(isBatchApproval ? 1 : 0);
    }

    private String getFlowCategoryPrefix(String category) {
        String prefix = "";
        switch (category) {
            case "ecsReimbManager": {
                prefix = "F";
                break;
            }
            case "saleManage": {
                prefix = "Q";
                break;
            }
            case "contractManage": {
                prefix = "X";
                break;
            }
            case "crm": {
                prefix = "K";
                break;
            }
            case "personnelManager": {
                prefix = "R";
                break;
            }
            case "assetManagement": {
                prefix = "Z";
                break;
            }
            case "purchasingManagement": {
                prefix = "G";
                break;
            }
            case "financialManagement": {
                prefix = "C";
                break;
            }
            case "administration": {
                prefix = "X";
                break;
            }
            case "projectManage": {
                prefix = "M";
                break;
            }
            case "InvestmentManager": {
                prefix = "T";
                break;
            }
            case "systemManager": {
                prefix = "S";
                break;
            }
            default: {
                prefix = "";
            }
        }
        return prefix;
    }

    private boolean checkStatus(int status) {
        return status == FlowTaskStatusEnum.Draft.getCode() || status == FlowTaskStatusEnum.Reject.getCode() || status == FlowTaskStatusEnum.Revoke.getCode();
    }

    private void nodeListAll(List<FlowTaskNodeEntity> dataAll, FlowModel flowModel, boolean isAdd) throws WorkFlowException {
        UserInfo userInfo = this.userProvider.get();
        Optional<FlowTaskNodeEntity> first = dataAll.stream().filter(t -> FlowNature.NodeStart.equals(t.getNodeType())).findFirst();
        if (!first.isPresent()) {
            throw new WorkFlowException(MsgCode.COD001.get());
        }
        FlowTaskNodeEntity startNodes = first.get();
        long num = 1L;
        this.nodeList(dataAll, startNodes.getNodeCode(), num);
        String nodeNext = FlowNature.NodeEnd;
        String type = "endround";
        long maxNum = 1L;
        HashMap candidateList = flowModel.getCandidateList() != null ? flowModel.getCandidateList() : new HashMap();
        ArrayList<FlowCandidatesEntity> candidateListAll = new ArrayList<FlowCandidatesEntity>();
        for (FlowTaskNodeEntity entity : dataAll) {
            ArrayList list;
            if (StringUtils.isEmpty((String)entity.getNodeNext())) {
                entity.setNodeNext(nodeNext);
            }
            if (entity.getSortCode() != null && entity.getSortCode() > maxNum) {
                maxNum = entity.getSortCode();
            }
            if ("timer".equals(entity.getNodeType()) || (list = candidateList.get(entity.getNodeCode()) != null ? (List)candidateList.get(entity.getNodeCode()) : new ArrayList()).size() <= 0) continue;
            FlowCandidatesEntity flowCandidatesEntity = new FlowCandidatesEntity();
            flowCandidatesEntity.setHandleId(userInfo.getId());
            flowCandidatesEntity.setTaskNodeId(entity.getId());
            flowCandidatesEntity.setTaskId(entity.getTaskId());
            flowCandidatesEntity.setAccount(userInfo.getUserAccount());
            flowCandidatesEntity.setCandidates(JsonUtil.getObjectToString(list));
            flowCandidatesEntity.setOperatorId(FlowNature.ParentId);
            candidateListAll.add(flowCandidatesEntity);
        }
        FlowTaskNodeEntity endround = new FlowTaskNodeEntity();
        endround.setId(RandomUtil.uuId());
        endround.setNodeCode(nodeNext);
        endround.setNodeName(MsgCode.WF007.getDesc());
        endround.setCompletion(FlowNature.ProcessCompletion);
        endround.setCreatorTime(new Date());
        endround.setSortCode(999L);
        endround.setTaskId(startNodes.getTaskId());
        ChildNodeList endNode = (ChildNodeList)JsonUtil.getJsonToBean((String)startNodes.getNodePropertyJson(), ChildNodeList.class);
        endNode.getCustom().setNodeId(nodeNext);
        endNode.setTaskNodeId(endround.getId());
        endNode.getCustom().setType(type);
        endround.setNodePropertyJson(JsonUtil.getObjectToString((Object)endNode));
        endround.setNodeType(type);
        endround.setState(FlowNodeEnum.Process.getCode());
        dataAll.add(endround);
        if (isAdd) {
            for (FlowTaskNodeEntity flowTaskNodeEntity : dataAll) {
                this.flowTaskNodeService.create(flowTaskNodeEntity);
            }
            for (FlowCandidatesEntity flowCandidatesEntity : candidateListAll) {
                this.flowCandidatesService.create(flowCandidatesEntity);
            }
        }
    }

    private void nodeList(List<FlowTaskNodeEntity> dataAll, String node, long num) {
        List<String> nodeAll = Arrays.asList(node.split(","));
        List nodeList = dataAll.stream().filter(t -> nodeAll.contains(t.getNodeCode())).collect(Collectors.toList());
        for (FlowTaskNodeEntity entity : nodeList) {
            entity.setSortCode(num);
            entity.setState(FlowNodeEnum.Process.getCode());
        }
        List nextNode = nodeList.stream().filter(t -> t.getNodeNext() != null).map(FlowTaskNodeEntity::getNodeNext).collect(Collectors.toList());
        if (nextNode.size() > 0) {
            String nodes = String.join((CharSequence)",", nextNode);
            this.nodeList(dataAll, nodes, ++num);
        }
    }

    private void createNodeList(FlowTaskEntity flowTask, List<ChildNodeList> nodeListAll, List<ConditionList> conditionListAll, List<FlowTaskNodeEntity> taskNodeList) {
        UserInfo userInfo = this.userProvider.get();
        ArrayList<FlowTaskNodeEntity> timerList = new ArrayList<FlowTaskNodeEntity>();
        ArrayList<FlowTaskNodeEntity> emptyList = new ArrayList<FlowTaskNodeEntity>();
        UserEntity userEntity = this.serviceUtil.getUserInfo(flowTask.getCreatorUserId());
        flowTask.setLastModifyUserId(userInfo.getUserId());
        flowTask.setLastModifyTime(new Date());
        for (ChildNodeList childNode : nodeListAll) {
            FlowTaskNodeEntity taskNode = new FlowTaskNodeEntity();
            String nodeId = childNode.getCustom().getNodeId();
            Properties properties = childNode.getProperties();
            String dataJson = flowTask.getFlowFormContentJson();
            String type = childNode.getCustom().getType();
            taskNode.setId(RandomUtil.uuId());
            childNode.setTaskNodeId(taskNode.getId());
            childNode.setTaskId(flowTask.getId());
            taskNode.setCreatorTime(new Date());
            taskNode.setTaskId(flowTask.getId());
            taskNode.setNodeCode(nodeId);
            taskNode.setNodeType(type);
            taskNode.setState(FlowNodeEnum.Futility.getCode());
            taskNode.setSortCode(-2L);
            taskNode.setNodeUp(properties.getRejectStep());
            FlowConditionModel conditionModel = FlowConditionModel.builder().conditionListAll(conditionListAll).childNodeListAll(nodeListAll).flowTaskEntity(flowTask).data(dataJson).nodeId(nodeId).build();
            conditionModel.setUserEntity(userEntity);
            conditionModel.setFlowTaskEntity(flowTask);
            conditionModel.setUserInfo(userInfo);
            taskNode.setNodeNext(FlowJsonUtil.getNextNode(conditionModel));
            taskNode.setNodePropertyJson(JsonUtilEx.getObjectToString((Object)childNode));
            boolean isStart = FlowNature.NodeStart.equals(childNode.getCustom().getType());
            taskNode.setCompletion(isStart ? FlowNature.AuditCompletion : FlowNature.ProcessCompletion);
            taskNode.setNodeName(isStart ? MsgCode.WF006.getDesc() : properties.getTitle());
            taskNodeList.add(taskNode);
            if ("empty".equals(type)) {
                emptyList.add(taskNode);
            }
            if (!"timer".equals(type)) continue;
            timerList.add(taskNode);
        }
        for (FlowTaskNodeEntity empty : emptyList) {
            List noxtEmptyList = taskNodeList.stream().filter(t -> t.getNodeNext().contains(empty.getNodeCode())).collect(Collectors.toList());
            for (FlowTaskNodeEntity entity : noxtEmptyList) {
                entity.setNodeNext(empty.getNodeNext());
            }
        }
        for (FlowTaskNodeEntity timer : timerList) {
            ChildNodeList timerlList = (ChildNodeList)JsonUtil.getJsonToBean((String)timer.getNodePropertyJson(), ChildNodeList.class);
            DateProperties timers = timerlList.getTimer();
            timers.setNodeId(timer.getNodeCode());
            timers.setTime(true);
            List upEmptyList = taskNodeList.stream().filter(t -> t.getNodeNext().contains(timer.getNodeCode())).collect(Collectors.toList());
            for (FlowTaskNodeEntity entity : upEmptyList) {
                ChildNodeList modelList = (ChildNodeList)JsonUtil.getJsonToBean((String)entity.getNodePropertyJson(), ChildNodeList.class);
                modelList.setTimer(timers);
                entity.setNodeNext(timer.getNodeNext());
                entity.setNodePropertyJson(JsonUtilEx.getObjectToString((Object)modelList));
            }
        }
    }

    private Map<String, List<String>> nextOperator(List<FlowTaskOperatorEntity> operatorListAll, List<ChildNodeList> nodeList, FlowTaskEntity flowTask, FlowModel flowModel) throws WorkFlowException {
        HashMap<String, List<String>> taskNode = new HashMap<String, List<String>>(16);
        try {
            for (ChildNodeList childNode : nodeList) {
                ArrayList<FlowTaskOperatorEntity> operatorList = new ArrayList<FlowTaskOperatorEntity>();
                Custom custom = childNode.getCustom();
                Properties properties = childNode.getProperties();
                String type = custom.getType();
                String flowId = properties.getFlowId();
                List<FlowAssignModel> assignList = childNode.getProperties().getAssignList();
                boolean isChild = FlowNature.NodeSubFlow.equals(type);
                if (isChild) {
                    FlowEngineEntity parentEngine = this.flowEngineService.getInfo(flowTask.getFlowId());
                    boolean isCustom = FlowNature.CUSTOM.equals(parentEngine.getFormType());
                    ArrayList<String> taskNodeList = new ArrayList<String>();
                    FlowEngineEntity engine = this.flowEngineService.getInfo(flowId);
                    Map<String, Object> data = this.childData(engine, flowModel, assignList, isCustom);
                    data.put("flowId", flowId);
                    List<UserEntity> list = this.childSaveList(childNode, flowTask);
                    List<FlowTaskNodeEntity> childTaskNodeAll = this.flowTaskNodeService.getList(flowTask.getId());
                    ArrayList<FlowTaskOperatorEntity> childOperatorList = new ArrayList<FlowTaskOperatorEntity>();
                    FlowMsgModel flowMsgModel = new FlowMsgModel();
                    flowMsgModel.setCirculateList(new ArrayList<FlowTaskCirculateEntity>());
                    flowMsgModel.setNodeList(childTaskNodeAll);
                    flowMsgModel.setData(flowModel.getFormData());
                    flowMsgModel.setWait(false);
                    flowMsgModel.setLaunch(true);
                    boolean isAsync = properties.getIsAsync();
                    FlowTaskNodeEntity taskNodeEntity = this.flowTaskNodeService.getInfo(childNode.getTaskNodeId());
                    if (isAsync) {
                        FlowModel parentModel = new FlowModel();
                        parentModel.setUserId("");
                        parentModel.setFormData(data);
                        parentModel.setIsAsync(properties.getIsAsync());
                        FlowTaskOperatorEntity parentOperator = new FlowTaskOperatorEntity();
                        this.parentOperator(parentOperator, taskNodeEntity);
                        this.audit(flowTask, parentOperator, parentModel);
                        taskNodeEntity.setCompletion(FlowNature.AuditCompletion);
                        this.flowTaskNodeService.update(taskNodeEntity);
                    }
                    for (UserEntity entity : list) {
                        String title = entity.getRealName() + "\u7684" + engine.getFullName() + "(\u5b50\u6d41\u7a0b)";
                        FlowModel nextFlowModel = this.assignment(data, parentEngine, flowTask.getId(), title);
                        nextFlowModel.setUserId(entity.getId());
                        nextFlowModel.setFlowTitle(title);
                        nextFlowModel.setFormData(data);
                        nextFlowModel.setIsAsync(properties.getIsAsync());
                        nextFlowModel.setFlowId(engine.getId());
                        FlowTaskEntity childTaskEntity = this.save(nextFlowModel);
                        this.createData(engine, childTaskEntity, nextFlowModel);
                        FlowTaskOperatorEntity parentOperator = new FlowTaskOperatorEntity();
                        this.parentOperator(parentOperator, taskNodeEntity);
                        if (!isAsync) {
                            taskNodeList.add(nextFlowModel.getProcessId());
                        }
                        parentOperator.setHandleId(entity.getId());
                        parentOperator.setTaskId(nextFlowModel.getProcessId());
                        childOperatorList.add(parentOperator);
                        ArrayList<FlowTaskOperatorEntity> launchList = new ArrayList<FlowTaskOperatorEntity>();
                        FlowTaskEntity taskEntity = new FlowTaskEntity();
                        taskEntity.setFullName(title);
                        launchList.add(parentOperator);
                        flowMsgModel.setOperatorList(launchList);
                        flowMsgModel.setEngine(engine);
                        flowMsgModel.setTaskEntity(taskEntity);
                        this.flowMsgUtil.message(flowMsgModel);
                    }
                    taskNode.put(childNode.getTaskNodeId(), taskNodeList);
                } else if (!FlowNature.NodeEnd.equals(childNode.getCustom().getNodeId())) {
                    TaskOperator taskOperator = new TaskOperator();
                    taskOperator.setChildNode(childNode);
                    taskOperator.setTaskEntity(flowTask);
                    taskOperator.setFlowModel(flowModel);
                    taskOperator.setDetails(true);
                    taskOperator.setId(flowModel.getOperatorId());
                    this.operator(operatorList, taskOperator);
                }
                operatorListAll.addAll(operatorList);
            }
        }
        catch (BaseException | WorkFlowException e) {
            log.error("\u4e0b\u4e00\u5ba1\u6279\u4eba\u5f02\u5e38:{}", (Object)e.getMessage());
            throw new WorkFlowException(e.getMessage());
        }
        return taskNode;
    }

    private List<UserEntity> operator(List<FlowTaskOperatorEntity> operatorList, TaskOperator taskOperator) throws BaseException {
        List userPosition;
        List<UserRelationEntity> listByObjectIdAll;
        ChildNodeList childNode = taskOperator.getChildNode();
        FlowTaskEntity taskEntity = taskOperator.getTaskEntity();
        FlowModel flowModel = taskOperator.getFlowModel();
        ArrayList<String> userIdAll = new ArrayList<String>();
        ArrayList<UserEntity> userAll = new ArrayList<UserEntity>();
        String createUserId = taskEntity.getCreatorUserId();
        Date date = new Date();
        ArrayList<FlowTaskOperatorEntity> nextList = new ArrayList<FlowTaskOperatorEntity>();
        Properties properties = childNode.getProperties();
        String type = properties.getAssigneeType();
        String userId = "";
        String freeApproverUserId = flowModel.getFreeApproverUserId();
        TaskOperatoUser taskOperatoUser = new TaskOperatoUser();
        taskOperatoUser.setDate(date);
        taskOperatoUser.setChildNode(childNode);
        boolean isStatus = StringUtils.isNotEmpty((String)freeApproverUserId);
        taskOperatoUser.setId(FlowNature.ParentId);
        if (isStatus) {
            if (FlowNature.FixedJointlyApprover.equals(properties.getCounterSign())) {
                List<FlowTaskOperatorEntity> historyList = this.flowTaskOperatorService.getAllByNodeId(taskEntity.getId(), childNode.getTaskNodeId());
                List handledIdList = historyList.stream().filter(t -> t.getHandleStatus().equals(1)).map(FlowTaskOperatorEntity::getHandleId).collect(Collectors.toList());
                ArrayList<String> allHandleIdList = new ArrayList<String>();
                if (properties.getApprovers().size() > 0) {
                    allHandleIdList.addAll(properties.getApprovers());
                }
                if (properties.getApproverRole().size() > 0) {
                    listByObjectIdAll = this.serviceUtil.getListByObjectIdAll(properties.getApproverRole());
                    userPosition = listByObjectIdAll.stream().map(UserRelationEntity::getUserId).collect(Collectors.toList());
                    allHandleIdList.addAll(userPosition);
                }
                if (allHandleIdList.size() > 1) {
                    if (historyList.size() > 0) {
                        List filteredHandleIdList = allHandleIdList.stream().filter(handleId -> !handledIdList.contains(handleId)).collect(Collectors.toList());
                        userIdAll.addAll(filteredHandleIdList);
                    } else {
                        userIdAll.addAll(allHandleIdList);
                    }
                } else {
                    userIdAll.add(freeApproverUserId);
                }
            } else {
                userIdAll.add(freeApproverUserId);
            }
        } else {
            Map dataAll;
            Object data;
            UserEntity userEntity;
            UserEntity info;
            if (FlowTaskOperatorEnum.LaunchCharge.getCode().equals(type) && (info = this.serviceUtil.getUserInfo(createUserId)) != null) {
                userId = this.getManagerByLevel(info.getManagerId(), properties.getManagerLevel().intValue(), new ArrayList<UserEntity>());
                userIdAll.add(userId);
            }
            if (FlowTaskOperatorEnum.DepartmentCharge.getCode().equals(type) && (userEntity = this.serviceUtil.getUserInfo(createUserId)) != null) {
                OrganizeEntity organizeEntity = this.serviceUtil.getOrganizeInfo(userEntity.getOrganizeId());
                String organizeIdTree = organizeEntity.getOrganizeIdTree();
                String[] split = organizeIdTree.split(",");
                String companyId = "";
                if (split.length > 1) {
                    companyId = split[1];
                }
                if (organizeEntity != null) {
                    if (!organizeEntity.getParentId().equals(companyId) || userEntity.getManagerId().equals(organizeEntity.getManagerId())) {
                        userId = this.getDepartmentByLevel(organizeEntity.getManagerId(), properties.getDepartmentLevel().intValue(), new ArrayList<UserEntity>());
                        userIdAll.add(userId);
                    } else {
                        userId = this.getDepartmentByLevel(userEntity.getId(), properties.getDepartmentLevel().intValue(), new ArrayList<UserEntity>());
                        userIdAll.add(userId);
                    }
                }
            }
            if (FlowTaskOperatorEnum.InitiatorMe.getCode().equals(type)) {
                userIdAll.add(createUserId);
            }
            if (FlowTaskOperatorEnum.Tache.getCode().equals(type)) {
                List operatorUserList = this.flowTaskOperatorRecordService.getList(taskEntity.getId()).stream().filter(t -> properties.getNodeId().equals(t.getNodeCode()) && FlowRecordEnum.audit.getCode().equals(t.getHandleStatus()) && FlowNodeEnum.Process.getCode().equals(t.getStatus())).collect(Collectors.toList());
                List handleId2 = operatorUserList.stream().map(FlowTaskOperatorRecordEntity::getHandleId).collect(Collectors.toList());
                userIdAll.addAll(handleId2);
            }
            if (FlowTaskOperatorEnum.Variate.getCode().equals(type) && (data = (dataAll = JsonUtil.stringToMap((String)taskEntity.getFlowFormContentJson())).get(properties.getFormField())) != null) {
                String formFieldType = properties.getFormFieldType();
                ArrayList<String> handleIdAll = new ArrayList<String>();
                if ("1".equals(formFieldType)) {
                    try {
                        handleIdAll.addAll(JsonUtil.getJsonToList((String)String.valueOf(data), String.class));
                    }
                    catch (Exception companyId) {
                        // empty catch block
                    }
                    if (data instanceof List) {
                        handleIdAll.addAll((List)data);
                    } else {
                        handleIdAll.addAll(Arrays.asList(String.valueOf(data).split(",")));
                    }
                } else {
                    ArrayList<String> list = new ArrayList<String>();
                    try {
                        list.addAll(JsonUtil.getJsonToList((String)String.valueOf(data), String.class));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (data instanceof List) {
                        list.addAll((List)data);
                    } else {
                        list.addAll(Arrays.asList(String.valueOf(data).split(",")));
                    }
                    List<UserRelationEntity> listByObjectIdAll2 = this.serviceUtil.getListByObjectIdAll(list);
                    List userPosition2 = listByObjectIdAll2.stream().map(UserRelationEntity::getUserId).collect(Collectors.toList());
                    handleIdAll.addAll(userPosition2);
                }
                userIdAll.addAll(handleIdAll);
            }
            if (FlowTaskOperatorEnum.Serve.getCode().equals(type)) {
                String pc = this.sysConfigService.getSystemAddress("pc");
                if (properties.getGetUserUrl().contains("https://gl.bringspring.com/jsbos-web")) {
                    properties.setGetUserUrl(properties.getGetUserUrl().trim().replace("https://gl.bringspring.com/jsbos-web", ""));
                }
                String url = pc + properties.getGetUserUrl() + "?" + this.taskNodeId + "=" + childNode.getTaskNodeId() + "&" + this.taskId + "=" + childNode.getTaskId() + "&createUserId=" + createUserId;
                log.info("flowTaskServeUrl:{}", (Object)url);
                String token = UserProvider.getToken();
                JSONObject object = HttpUtil.httpRequest((String)url, (String)"GET", null, (String[])new String[]{token});
                if (object != null) {
                    log.info("\u67e5\u8be2\u5230\u6570\u636e:{}", (Object)JsonUtil.getObjectToString((Object)object));
                    if (object.get((Object)"data") != null) {
                        JSONObject data2 = object.getJSONObject("data");
                        ArrayList handleId3 = StringUtils.isNotEmpty((String)data2.getString("handleId")) ? Arrays.asList(data2.getString("handleId").split(",")) : new ArrayList();
                        userIdAll.addAll(handleId3);
                    }
                } else {
                    log.info("\u672a\u67e5\u8be2\u5230\u6570\u636e");
                }
            }
            if (FlowTaskOperatorEnum.FreeApprover.getCode().equals(type)) {
                String nodeId = childNode.getTaskNodeId();
                List<FlowCandidatesEntity> candidatesList = this.flowCandidatesService.getlist(nodeId);
                candidatesList.stream().forEach(t -> {
                    List candidates = StringUtils.isNotEmpty((String)t.getCandidates()) ? JsonUtil.getJsonToList((String)t.getCandidates(), String.class) : new ArrayList();
                    userIdAll.addAll(candidates);
                });
            } else {
                userIdAll.addAll(properties.getApprovers());
                List<String> positionList = properties.getApproverPos();
                List<String> roleList = properties.getApproverRole();
                ArrayList<String> list = new ArrayList<String>();
                list.addAll(positionList);
                list.addAll(roleList);
                listByObjectIdAll = this.serviceUtil.getListByObjectIdAll(list);
                userPosition = listByObjectIdAll.stream().map(UserRelationEntity::getUserId).collect(Collectors.toList());
                userIdAll.addAll(userPosition);
            }
        }
        userAll.addAll(this.serviceUtil.getUserName(userIdAll));
        for (UserEntity entity : userAll) {
            taskOperatoUser.setHandLeId(entity.getId());
            this.operatorUser(nextList, taskOperatoUser);
        }
        operatorList.addAll(nextList);
        return userAll;
    }

    private String getManagerByLevel(String managerId, long level, List<UserEntity> userList) {
        if (--level == 0L) {
            return managerId;
        }
        UserEntity userEntity = userList.stream().filter(t -> t.getId().equals(managerId)).findFirst().orElse(null);
        if (userEntity == null && (userEntity = this.serviceUtil.getUserInfo(managerId)) != null) {
            userList.add(userEntity);
        }
        return userEntity != null ? this.getManagerByLevel(userEntity.getManagerId(), level, userList) : "";
    }

    private String getDepartmentByLevel(String managerId, long level, List<UserEntity> userList) {
        if (--level == 0L) {
            return managerId;
        }
        UserEntity userEntity = userList.stream().filter(t -> t.getId().equals(managerId)).findFirst().orElse(null);
        if (ObjectUtil.isEmpty((Object)userEntity)) {
            userEntity = this.serviceUtil.getUserInfo(managerId);
            OrganizeEntity organizeInfo = this.serviceUtil.getOrganizeInfo(userEntity.getOrganizeId());
            String organizeIdTree = organizeInfo.getOrganizeIdTree();
            String[] split = organizeIdTree.split(",");
            String companyId = "";
            if (split.length > 1) {
                companyId = split[1];
            }
            if (ObjectUtil.isNotEmpty((Object)userEntity)) {
                userList.add(userEntity);
            }
            if (organizeInfo.getParentId().equals(companyId)) {
                return "";
            }
        }
        return userEntity != null ? this.getDepartmentByLevel(userEntity.getManagerId(), level, userList) : "";
    }

    private void operatorUser(List<FlowTaskOperatorEntity> nextList, TaskOperatoUser taskOperatoUser) {
        String handLeId = taskOperatoUser.getHandLeId();
        Date date = taskOperatoUser.getDate();
        ChildNodeList childNode = taskOperatoUser.getChildNode();
        Properties properties = childNode.getProperties();
        Custom custom = childNode.getCustom();
        String type = properties.getAssigneeType();
        FlowTaskOperatorEntity operator = new FlowTaskOperatorEntity();
        operator.setId(RandomUtil.uuId());
        operator.setHandleType(type);
        operator.setHandleId(StringUtils.isEmpty((String)handLeId) ? this.user : handLeId);
        operator.setTaskNodeId(childNode.getTaskNodeId());
        operator.setTaskId(childNode.getTaskId());
        operator.setNodeCode(custom.getNodeId());
        operator.setNodeName(properties.getTitle());
        operator.setDescription(JsonUtil.getObjectToString(new ArrayList()));
        operator.setCreatorTime(date);
        operator.setCompletion(FlowNature.ProcessCompletion);
        operator.setType(type);
        operator.setState(FlowNodeEnum.Process.getCode());
        operator.setParentId(taskOperatoUser.getId());
        nextList.add(operator);
    }

    private void handleIdStatus(FlowTaskOperatorEntity operator, TaskHandleIdStatus handStatus) {
        int status = handStatus.getStatus();
        ChildNodeList nodeModel = handStatus.getNodeModel();
        FlowModel flowModel = handStatus.getFlowModel();
        Properties properties = nodeModel.getProperties();
        Integer counterSign = properties.getCounterSign();
        operator.setHandleTime(new Date());
        operator.setHandleStatus(status);
        String type = properties.getAssigneeType();
        boolean isApprover = FlowNature.FixedJointlyApprover.equals(counterSign);
        ArrayList<String> userIdListAll = new ArrayList<String>();
        if (status == 1) {
            boolean hasFreeApprover = StringUtils.isEmpty((String)flowModel.getFreeApproverUserId());
            if (isApprover) {
                this.flowTaskOperatorService.update(operator.getTaskNodeId(), userIdListAll, "1");
            } else if (hasFreeApprover) {
                this.flowTaskOperatorService.updateByCounterSign(operator.getTaskNodeId());
            }
            operator.setCompletion(FlowNature.AuditCompletion);
            List list = JsonUtil.getJsonToList((String)operator.getDescription(), Date.class);
            DateProperties timer = nodeModel.getTimer();
            if (timer.getTime().booleanValue()) {
                Date date = new Date();
                date = DateUtil.dateAddDays((Date)date, (int)timer.getDay());
                date = DateUtil.dateAddHours((Date)date, (int)timer.getHour());
                date = DateUtil.dateAddMinutes((Date)date, (int)timer.getMinute());
                date = DateUtil.dateAddSeconds((Date)date, (int)timer.getSecond());
                list.add(date);
                operator.setDescription(JsonUtil.getObjectToString((Object)list));
            }
        } else {
            if (isApprover) {
                this.flowTaskOperatorService.update(operator.getTaskNodeId(), userIdListAll, "-1");
            } else {
                this.flowTaskOperatorService.update(operator.getTaskNodeId(), type);
            }
            operator.setCompletion(FlowNature.RejectCompletion);
        }
    }

    private List<FlowTaskNodeEntity> isNextAll(List<FlowTaskNodeEntity> nodeListAll, List<FlowTaskNodeEntity> nextNodeEntity, FlowTaskNodeEntity taskNode, FlowModel flowModel) {
        ArrayList<FlowTaskNodeEntity> result = new ArrayList<FlowTaskNodeEntity>();
        boolean hasFreeApprover = StringUtils.isNotEmpty((String)flowModel.getFreeApproverUserId());
        ChildNodeList nodeModel = (ChildNodeList)JsonUtil.getJsonToBean((String)taskNode.getNodePropertyJson(), ChildNodeList.class);
        Properties properties = nodeModel.getProperties();
        boolean isCountersign = true;
        boolean fixed = FlowNature.FixedJointlyApprover.equals(properties.getCounterSign());
        long pass = properties.getCountersignRatio();
        String type = properties.getAssigneeType();
        if (fixed) {
            List<FlowTaskOperatorEntity> operatorList = this.flowTaskOperatorService.getList(taskNode.getTaskId()).stream().filter(t -> t.getTaskNodeId().equals(taskNode.getId()) && FlowNodeEnum.Process.getCode().equals(t.getState())).collect(Collectors.toList());
            double total = operatorList.stream().filter(t -> FlowNature.ParentId.equals(t.getParentId())).count();
            List<FlowTaskOperatorEntity> passNumList = this.passNum(operatorList, FlowNature.AuditCompletion);
            double passNum = passNumList.size();
            isCountersign = this.isCountersign(pass, total, passNum);
        }
        if (isCountersign) {
            if (fixed) {
                this.flowTaskOperatorService.update(nodeModel.getTaskNodeId(), type);
            }
            taskNode.setCompletion(FlowNature.AuditCompletion);
            this.flowTaskNodeService.update(taskNode);
            boolean isShunt = this.isShunt(nodeListAll, nextNodeEntity, taskNode);
            if (isShunt) {
                result.addAll(nextNodeEntity);
            }
        }
        return result;
    }

    private boolean isCountersign(long pass, double total, double passNum) {
        int scale = (int)(passNum / total * 100.0);
        return (long)scale >= pass;
    }

    private List<FlowTaskOperatorEntity> passNum(List<FlowTaskOperatorEntity> operatorList, Integer completion) {
        HashSet idAll = new HashSet();
        List idListAll = operatorList.stream().filter(t -> FlowNature.ParentId.equals(t.getParentId())).map(FlowTaskOperatorEntity::getId).collect(Collectors.toList());
        List childList = operatorList.stream().filter(t -> !FlowNature.ParentId.equals(t.getParentId())).map(FlowTaskOperatorEntity::getParentId).collect(Collectors.toList());
        idListAll.removeAll(childList);
        idAll.addAll(idListAll);
        List parentList = operatorList.stream().filter(t -> !FlowNature.ParentId.equals(t.getParentId())).map(FlowTaskOperatorEntity::getId).collect(Collectors.toList());
        parentList.removeAll(childList);
        idAll.addAll(parentList);
        List<FlowTaskOperatorEntity> passListAll = operatorList.stream().filter(t -> idAll.contains(t.getId()) && completion.equals(t.getCompletion())).collect(Collectors.toList());
        return passListAll;
    }

    private boolean isShunt(List<FlowTaskNodeEntity> nodeListAll, List<FlowTaskNodeEntity> nextNodeEntity, FlowTaskNodeEntity taskNode) {
        boolean isNext = true;
        for (FlowTaskNodeEntity nodeEntity : nextNodeEntity) {
            String nextNode = nodeEntity.getNodeCode();
            List interflowAll = nodeListAll.stream().filter(t -> String.valueOf(t.getNodeNext()).contains(nextNode) && FlowNodeEnum.Process.getCode().equals(t.getState())).collect(Collectors.toList());
            List flowAll = interflowAll.stream().filter(t -> !FlowNature.AuditCompletion.equals(t.getCompletion())).collect(Collectors.toList());
            if (flowAll.size() <= 0) continue;
            isNext = false;
            break;
        }
        return isNext;
    }

    private void circulateList(ChildNodeList nodeModel, List<FlowTaskCirculateEntity> circulateList, FlowModel flowModel) {
        Properties circleproperties = nodeModel.getProperties();
        ArrayList<String> userIdAll = new ArrayList<String>();
        userIdAll.addAll(circleproperties.getCirculateUser());
        List<String> roleList = circleproperties.getCirculateRole();
        List<String> posList = circleproperties.getCirculatePosition();
        ArrayList<String> objectList = new ArrayList<String>();
        objectList.addAll(roleList);
        objectList.addAll(posList);
        List<UserRelationEntity> listByObjectIdAll = this.serviceUtil.getListByObjectIdAll(objectList);
        List userPosition = listByObjectIdAll.stream().map(UserRelationEntity::getUserId).collect(Collectors.toList());
        userIdAll.addAll(userPosition);
        String[] copyIds = StringUtils.isNotEmpty((String)flowModel.getCopyIds()) ? flowModel.getCopyIds().split(",") : new String[]{};
        List<String> id = Arrays.asList(copyIds);
        userIdAll.addAll(id);
        if (circleproperties.getIsStartCopy().booleanValue()) {
            FlowTaskEntity taskEntity = (FlowTaskEntity)this.flowTaskService.getById((Serializable)((Object)nodeModel.getTaskId()));
            userIdAll.add(taskEntity.getCreatorUserId());
        }
        List<Object> list = this.serviceUtil.getUserName(userIdAll);
        list = list.stream().filter(t -> t.getEnabledMark().equals(1)).collect(Collectors.toList());
        for (UserEntity userEntity : list) {
            FlowTaskCirculateEntity flowTask = new FlowTaskCirculateEntity();
            flowTask.setId(RandomUtil.uuId());
            flowTask.setObjectId(userEntity.getId());
            flowTask.setNodeCode(nodeModel.getCustom().getNodeId());
            flowTask.setNodeName(nodeModel.getProperties().getTitle());
            flowTask.setTaskNodeId(nodeModel.getTaskNodeId());
            flowTask.setTaskId(nodeModel.getTaskId());
            flowTask.setCreatorTime(new Date());
            circulateList.add(flowTask);
        }
    }

    private boolean endround(FlowTaskEntity flowTask, ChildNodeList childNode, FlowModel flowModel) throws WorkFlowException {
        flowTask.setStatus(FlowTaskStatusEnum.Adopt.getCode());
        flowTask.setCompletion(100);
        flowTask.setEndTime(DateUtil.getNowDate());
        flowTask.setThisStepId(childNode.getTaskNodeId());
        flowTask.setThisStep("\u7ed3\u675f");
        FlowTaskOperatorRecordEntity operatorRecord = new FlowTaskOperatorRecordEntity();
        operatorRecord.setTaskId(flowTask.getId());
        operatorRecord.setHandleStatus(flowTask.getStatus());
        flowModel.setFlowId(flowTask.getFlowId());
        this.flowMsgUtil.event(2, childNode, operatorRecord, flowModel);
        this.flowTaskService.update(flowTask);
        FlowEngineEntity engine = this.flowEngineService.getInfo(flowTask.getFlowId());
        List<FlowTaskNodeEntity> taskNodeList = this.flowTaskNodeService.getList(flowTask.getId());
        FlowMsgModel flowMsgModel = new FlowMsgModel();
        flowMsgModel.setEnd(true);
        flowMsgModel.setCirculateList(new ArrayList<FlowTaskCirculateEntity>());
        flowMsgModel.setNodeList(taskNodeList);
        flowMsgModel.setOperatorList(new ArrayList<FlowTaskOperatorEntity>());
        flowMsgModel.setTaskEntity(flowTask);
        FlowTaskNodeEntity taskNodeEntity = new FlowTaskNodeEntity();
        taskNodeEntity.setNodePropertyJson(JsonUtil.getObjectToString((Object)childNode));
        flowMsgModel.setTaskNodeEntity(taskNodeEntity);
        flowMsgModel.setEngine(engine);
        flowMsgModel.setData(JsonUtil.stringToMap((String)flowTask.getFlowFormContentJson()));
        this.flowMsgUtil.message(flowMsgModel);
        boolean isEnd = this.isNext(flowTask);
        return isEnd;
    }

    private void updateTaskNode(List<FlowTaskNodeEntity> taskNodeLis) {
        for (FlowTaskNodeEntity taskNodeLi : taskNodeLis) {
            String nodeNext = StringUtils.isNotEmpty((String)taskNodeLi.getNodeNext()) ? taskNodeLi.getNodeNext() : FlowNature.NodeEnd;
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.lambda().eq(FlowTaskNodeEntity::getTaskId, (Object)taskNodeLi.getTaskId());
            updateWrapper.lambda().eq(FlowTaskNodeEntity::getNodeCode, (Object)taskNodeLi.getNodeCode());
            updateWrapper.lambda().ne(FlowTaskNodeEntity::getCompletion, (Object)-1);
            updateWrapper.lambda().set(FlowTaskNodeEntity::getNodeNext, (Object)nodeNext);
            updateWrapper.lambda().set(FlowTaskNodeEntity::getSortCode, (Object)taskNodeLi.getSortCode());
            updateWrapper.lambda().set(FlowTaskNodeEntity::getState, (Object)taskNodeLi.getState());
            this.flowTaskNodeService.update((Wrapper)updateWrapper);
        }
    }

    private List<FlowTaskNodeEntity> isUpAll(List<FlowTaskNodeEntity> nodeListAll, FlowTaskNodeEntity taskNode, boolean isReject, Set<FlowTaskNodeEntity> thisStepAll, List<String> rejectList, String[] thisStepId, FlowEngineEntity engine, FlowModel flowModel) throws WorkFlowException {
        List<FlowTaskNodeEntity> result = new ArrayList<FlowTaskNodeEntity>();
        ArrayList<String> thisStepIdAll = new ArrayList<String>(Arrays.asList(thisStepId));
        ChildNodeList nodeModel = (ChildNodeList)JsonUtil.getJsonToBean((String)taskNode.getNodePropertyJson(), ChildNodeList.class);
        if (ObjectUtil.isNotEmpty((Object)flowModel.getRejectAgreeStep())) {
            nodeModel.getProperties().setRejectAgreeStep(flowModel.getRejectAgreeStep());
            if (nodeModel.getProperties().getRejectAuditType().equals("1")) {
                flowModel.setRejectAuditType(nodeModel.getProperties().getRejectAuditType());
            }
            if (!flowModel.getRejectAuditType().equals(nodeModel.getProperties().getRejectAuditType())) {
                nodeModel.getProperties().setRejectAuditType(flowModel.getRejectAuditType());
                String updateProperties = JsonUtil.getObjectToString((Object)nodeModel);
                taskNode.setNodePropertyJson(updateProperties);
                this.flowTaskNodeService.updateById(taskNode);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)flowModel.getRejectAgreeStep())) {
            boolean isUp = FlowNature.UP.equals(nodeModel.getProperties().getRejectAgreeStep());
            boolean isStart = FlowNature.START.equals(nodeModel.getProperties().getRejectAgreeStep());
            if (FlowNature.START.equals(nodeModel.getProperties().getRejectAgreeStep())) {
                List startNode = nodeListAll.stream().filter(t -> FlowNature.NodeStart.equals(t.getNodeType())).collect(Collectors.toList());
                result.addAll(startNode);
                thisStepAll.addAll(result);
            } else if (FlowNature.UP.equals(nodeModel.getProperties().getRejectAgreeStep())) {
                List nodeList = nodeListAll.stream().filter(t -> StringUtils.isNotEmpty((String)t.getNodeNext()) && t.getNodeNext().contains(taskNode.getNodeCode())).collect(Collectors.toList());
                result.addAll(nodeList);
                for (FlowTaskNodeEntity taskNodeEntity : nodeList) {
                    List<String> next = Arrays.asList(taskNodeEntity.getNodeNext().split(","));
                    thisStepIdAll.removeAll(next);
                }
                List stepId = nodeListAll.stream().filter(t -> thisStepIdAll.contains(t.getNodeCode())).collect(Collectors.toList());
                thisStepAll.addAll(result);
                thisStepAll.addAll(stepId);
            } else {
                List<Object> taskNodeList = new ArrayList();
                FlowTaskNodeEntity taskNodeEntity = nodeListAll.stream().filter(t -> t.getNodeCode().equals(nodeModel.getProperties().getRejectAgreeStep())).findFirst().orElse(null);
                if (taskNodeEntity != null) {
                    taskNodeList = nodeListAll.stream().filter(t -> t.getSortCode().equals(taskNodeEntity.getSortCode())).collect(Collectors.toList());
                }
                result.addAll(taskNodeList);
                thisStepAll.addAll(result);
            }
            result = result.stream().sorted(Comparator.comparing(FlowTaskNodeEntity::getSortCode).reversed()).collect(Collectors.toList());
            boolean isChild = result.stream().anyMatch(t -> FlowNature.NodeSubFlow.equals(t.getNodeType()));
            if (isChild) {
                throw new WorkFlowException(MsgCode.WF114.get());
            }
            Long nodeSortCode = result.size() > 0 ? result.stream().min(Comparator.comparing(FlowTaskNodeEntity::getSortCode)).get().getSortCode() : 0L;
            if (isUp) {
                rejectList.addAll(result.stream().map(FlowTaskNodeEntity::getId).collect(Collectors.toList()));
            } else if (isStart) {
                rejectList.addAll(result.stream().filter(t -> t.getSortCode() >= nodeSortCode).map(FlowTaskNodeEntity::getId).collect(Collectors.toList()));
            } else {
                rejectList.addAll(nodeListAll.stream().filter(t -> t.getSortCode() >= nodeSortCode).filter(t -> t.getSortCode() < taskNode.getSortCode()).map(FlowTaskNodeEntity::getId).collect(Collectors.toList()));
            }
        } else if (isReject) {
            boolean isUp = FlowNature.UP.equals(taskNode.getNodeUp());
            if (FlowNature.START.equals(taskNode.getNodeUp())) {
                List startNode = nodeListAll.stream().filter(t -> FlowNature.NodeStart.equals(t.getNodeType())).collect(Collectors.toList());
                result.addAll(startNode);
                thisStepAll.addAll(result);
            } else if (FlowNature.UP.equals(taskNode.getNodeUp())) {
                List nodeList = nodeListAll.stream().filter(t -> StringUtils.isNotEmpty((String)t.getNodeNext()) && t.getNodeNext().contains(taskNode.getNodeCode())).collect(Collectors.toList());
                result.addAll(nodeList);
                for (FlowTaskNodeEntity taskNodeEntity : nodeList) {
                    List<String> next = Arrays.asList(taskNodeEntity.getNodeNext().split(","));
                    thisStepIdAll.removeAll(next);
                }
                List stepId = nodeListAll.stream().filter(t -> thisStepIdAll.contains(t.getNodeCode())).collect(Collectors.toList());
                thisStepAll.addAll(result);
                thisStepAll.addAll(stepId);
            } else {
                List<Object> taskNodeList = new ArrayList();
                FlowTaskNodeEntity taskNodeEntity = nodeListAll.stream().filter(t -> t.getNodeCode().equals(taskNode.getNodeUp())).findFirst().orElse(null);
                if (taskNodeEntity != null) {
                    taskNodeList = nodeListAll.stream().filter(t -> t.getSortCode().equals(taskNodeEntity.getSortCode())).collect(Collectors.toList());
                }
                result.addAll(taskNodeList);
                thisStepAll.addAll(result);
            }
            result = result.stream().sorted(Comparator.comparing(FlowTaskNodeEntity::getSortCode).reversed()).collect(Collectors.toList());
            boolean isChild = result.stream().anyMatch(t -> FlowNature.NodeSubFlow.equals(t.getNodeType()));
            if (isChild) {
                throw new WorkFlowException(MsgCode.WF114.get());
            }
            Long nodeSortCode = result.size() > 0 ? result.stream().min(Comparator.comparing(FlowTaskNodeEntity::getSortCode)).get().getSortCode() : 0L;
            if (isUp) {
                rejectList.addAll(result.stream().map(FlowTaskNodeEntity::getId).collect(Collectors.toList()));
            } else {
                rejectList.addAll(result.stream().filter(t -> t.getSortCode() >= nodeSortCode).map(FlowTaskNodeEntity::getId).collect(Collectors.toList()));
            }
        }
        return result;
    }

    private boolean isReject(FlowTaskNodeEntity taskNode) {
        List<FlowTaskOperatorEntity> operatorList = this.flowTaskOperatorService.getList(taskNode.getTaskId()).stream().filter(t -> t.getTaskNodeId().equals(taskNode.getId()) && FlowNodeEnum.Process.getCode().equals(t.getState())).collect(Collectors.toList());
        ChildNodeList nodeModel = (ChildNodeList)JsonUtil.getJsonToBean((String)taskNode.getNodePropertyJson(), ChildNodeList.class);
        Properties properties = nodeModel.getProperties();
        long pass = 100L - properties.getCountersignRatio();
        double total = operatorList.stream().filter(t -> FlowNature.ParentId.equals(t.getParentId())).count();
        List<FlowTaskOperatorEntity> passNumList = this.passNum(operatorList, FlowNature.RejectCompletion);
        double passNum = passNumList.size();
        boolean isCountersign = this.isCountersign(pass, total, passNum);
        return isCountersign;
    }

    private Map<String, Object> createData(FlowEngineEntity engine, FlowTaskEntity taskEntity, FlowModel flowModel) throws WorkFlowException {
        Map<String, Object> resultData = flowModel.getFormData();
        try {
            Map<String, Object> dataMap = flowModel.getFormData();
            String formId = taskEntity.getProcessId();
            if (FlowNature.CUSTOM.equals(engine.getFormType())) {
                List tableModelList = JsonUtil.getJsonToList((String)engine.getFlowTables(), TableModel.class);
                DbLinkEntity link = this.serviceUtil.getDbLink(engine.getDbLinkId());
                FormDataModel formData = (FormDataModel)JsonUtil.getJsonToBean((String)taskEntity.getFlowForm(), FormDataModel.class);
                List list = JsonUtil.getJsonToList((String)formData.getFields(), FieLdsModel.class);
                DataModel dataModel = DataModel.builder().dataNewMap(dataMap).fieLdsModelList(list).tableModelList(tableModelList).mainId(formId).link(link).build();
                resultData = StringUtils.isNotEmpty((String)flowModel.getId()) ? this.flowDataUtil.update(dataModel) : this.flowDataUtil.create(dataModel);
            } else {
                String dataAll = JsonUtil.getObjectToString(dataMap);
                if (engine.getType() != 1) {
                    String coed = engine.getEnCode();
                    this.formData(coed, flowModel.getProcessId(), dataAll);
                }
            }
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u6570\u636e\u5931\u8d25:{}", (Object)e.getMessage());
            throw new WorkFlowException("\u65b0\u589e\u6570\u636e\u5931\u8d25");
        }
        return resultData;
    }

    private boolean isNext(FlowTaskEntity flowTask) throws WorkFlowException {
        boolean isEnd = true;
        if (!FlowNature.ParentId.equals(flowTask.getParentId()) && StringUtils.isNotEmpty((String)flowTask.getParentId())) {
            boolean isNext;
            List<FlowTaskEntity> parentList = this.flowTaskService.getChildList(flowTask.getParentId(), FlowTaskEntity::getId, FlowTaskEntity::getThisStepId);
            boolean bl = isNext = parentList.stream().filter(t -> !FlowNature.NodeEnd.equals(t.getThisStepId())).count() == 0L;
            if (isNext) {
                FlowTaskEntity parentFlowTask = this.flowTaskService.getInfo(flowTask.getParentId());
                List<FlowTaskNodeEntity> parentNodeAll = this.flowTaskNodeService.getList(parentFlowTask.getId());
                FlowTaskOperatorEntity parentOperator = new FlowTaskOperatorEntity();
                boolean isNode = this.updateTaskNode(parentList, parentNodeAll, parentOperator);
                FlowModel parentModel = new FlowModel();
                parentModel.setUserId("");
                parentModel.setIsAsync(true);
                HashMap<String, Object> data = new HashMap<String, Object>(16);
                parentModel.setFormData(data);
                if (isNode) {
                    this.audit(parentFlowTask, parentOperator, parentModel);
                }
            }
        }
        return isEnd;
    }

    private List<UserEntity> childSaveList(ChildNodeList childNode, FlowTaskEntity taskEntity) {
        List handleId;
        Map dataAll;
        Object data;
        UserEntity info;
        OrganizeEntity organizeEntity;
        UserEntity userEntity;
        String createUserId = taskEntity.getCreatorUserId();
        Properties properties = childNode.getProperties();
        String type = properties.getInitiateType();
        ArrayList<String> userIdAll = new ArrayList<String>();
        String userId = "";
        Date date = new Date();
        TaskOperatoUser taskOperatoUser = new TaskOperatoUser();
        taskOperatoUser.setDate(date);
        taskOperatoUser.setChildNode(childNode);
        if (FlowTaskOperatorEnum.DepartmentCharge.getCode().equals(type) && (userEntity = this.serviceUtil.getUserInfo(createUserId)) != null && (organizeEntity = this.serviceUtil.getOrganizeInfo(userEntity.getOrganizeId())) != null) {
            userId = this.getDepartmentByLevel(organizeEntity.getManagerId(), properties.getDepartmentLevel().intValue(), new ArrayList<UserEntity>());
            userIdAll.add(userId);
        }
        if (FlowTaskOperatorEnum.LaunchCharge.getCode().equals(type) && (info = this.serviceUtil.getUserInfo(createUserId)) != null) {
            userId = this.getManagerByLevel(info.getManagerId(), properties.getManagerLevel().intValue(), new ArrayList<UserEntity>());
            userIdAll.add(userId);
        }
        if (FlowTaskOperatorEnum.InitiatorMe.getCode().equals(type)) {
            userIdAll.add(createUserId);
        }
        if (FlowTaskOperatorEnum.Variate.getCode().equals(type) && (data = (dataAll = JsonUtil.stringToMap((String)taskEntity.getFlowFormContentJson())).get(properties.getFormField())) != null) {
            String formFieldType = properties.getFormFieldType();
            ArrayList<String> handleIdAll = new ArrayList<String>();
            if ("1".equals(formFieldType)) {
                try {
                    handleIdAll.addAll(JsonUtil.getJsonToList((String)String.valueOf(data), String.class));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (data instanceof List) {
                    handleIdAll.addAll((List)data);
                } else {
                    handleIdAll.addAll(Arrays.asList(String.valueOf(data).split(",")));
                }
            } else {
                ArrayList<String> list = new ArrayList<String>();
                try {
                    list.addAll(JsonUtil.getJsonToList((String)String.valueOf(data), String.class));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (data instanceof List) {
                    list.addAll((List)data);
                } else {
                    list.addAll(Arrays.asList(String.valueOf(data).split(",")));
                }
                List<UserRelationEntity> listByObjectIdAll = this.serviceUtil.getListByObjectIdAll(list);
                List userPosition = listByObjectIdAll.stream().map(UserRelationEntity::getUserId).collect(Collectors.toList());
                handleIdAll.addAll(userPosition);
            }
            userIdAll.addAll(handleIdAll);
        }
        if (FlowTaskOperatorEnum.Tache.getCode().equals(type)) {
            List operatorUserList = this.flowTaskOperatorRecordService.getList(taskEntity.getId()).stream().filter(t -> properties.getNodeId().equals(t.getNodeCode()) && FlowRecordEnum.audit.getCode().equals(t.getHandleStatus()) && FlowNodeEnum.Process.getCode().equals(t.getStatus())).collect(Collectors.toList());
            List handleId2 = operatorUserList.stream().map(FlowTaskOperatorRecordEntity::getHandleId).collect(Collectors.toList());
            userIdAll.addAll(handleId2);
        }
        if (FlowTaskOperatorEnum.Serve.getCode().equals(type)) {
            String url = properties.getGetUserUrl() + "?" + this.taskNodeId + "=" + childNode.getTaskNodeId() + "&" + this.taskId + "=" + childNode.getTaskId() + "&createUserId=" + createUserId;
            log.info("flowTaskServeUrl:{}", (Object)url);
            String token = UserProvider.getToken();
            JSONObject object = HttpUtil.httpRequest((String)url, (String)"GET", null, (String[])new String[]{token});
            if (object != null) {
                log.info("\u67e5\u8be2\u5230\u6570\u636e:{}", (Object)JsonUtil.getObjectToString((Object)object));
                if (object.get((Object)"data") != null) {
                    JSONObject data2 = object.getJSONObject("data");
                    handleId = StringUtils.isNotEmpty((String)data2.getString("handleId")) ? Arrays.asList(data2.getString("handleId").split(",")) : new ArrayList();
                    userIdAll.addAll(handleId);
                }
            } else {
                log.info("\u672a\u67e5\u8be2\u5230\u6570\u636e");
            }
        }
        userIdAll.addAll(properties.getInitiator());
        List<String> positionList = properties.getInitiatePos();
        List<String> roleList = properties.getInitiateRole();
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(positionList);
        list.addAll(roleList);
        List<UserRelationEntity> listByObjectIdAll = this.serviceUtil.getListByObjectIdAll(list);
        handleId = listByObjectIdAll.stream().map(UserRelationEntity::getUserId).collect(Collectors.toList());
        userIdAll.addAll(handleId);
        List<UserEntity> userList = this.serviceUtil.getUserName(userIdAll);
        return userList;
    }

    private FlowModel assignment(Map<String, Object> data, FlowEngineEntity engine, String parentId, String title) {
        FlowModel flowModel = new FlowModel();
        String billNo = "\u5355\u636e\u89c4\u5219\u4e0d\u5b58\u5728";
        if (FlowNature.CUSTOM.equals(engine.getFormType())) {
            FormDataModel formData = (FormDataModel)JsonUtil.getJsonToBean((String)engine.getFormData(), FormDataModel.class);
            List list = JsonUtil.getJsonToList((String)formData.getFields(), FieLdsModel.class);
            ArrayList formAllModel = new ArrayList();
            List tableModelList = JsonUtil.getJsonToList((String)engine.getFlowTables(), TableModel.class);
            RecursionForm recursionForm = new RecursionForm(list, tableModelList);
            FormCloumnUtil.recursionForm((RecursionForm)recursionForm, formAllModel);
            List mastForm = formAllModel.stream().filter(t -> FormEnum.mast.getMessage().equals(t.getKeyName())).collect(Collectors.toList());
            FormAllModel formModel = mastForm.stream().filter(t -> "billRule".equals(t.getFormColumnModel().getFieLdsModel().getConfig().getKeyName())).findFirst().orElse(null);
            try {
                if (formModel != null) {
                    FieLdsModel fieLdsModel = formModel.getFormColumnModel().getFieLdsModel();
                    String ruleKey = fieLdsModel.getConfig().getRule();
                    billNo = this.serviceUtil.getBillNumber(ruleKey);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        flowModel.setFormData(data);
        flowModel.setParentId(parentId);
        flowModel.setProcessId(RandomUtil.uuId());
        flowModel.setBillNo(billNo);
        flowModel.setFlowTitle(title);
        return flowModel;
    }

    private Map<String, Object> childData(FlowEngineEntity engine, FlowModel flowModel, List<FlowAssignModel> assignList, boolean isCustom) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        if (engine != null) {
            Map<String, Object> formData = flowModel.getFormData();
            for (FlowAssignModel assignMode : assignList) {
                String childField = assignMode.getChildField();
                String parentField = assignMode.getParentField();
                result.put(childField, formData.get(parentField));
            }
        }
        return result;
    }

    private boolean updateTaskNode(List<FlowTaskEntity> parentList, List<FlowTaskNodeEntity> parentNodeAll, FlowTaskOperatorEntity parentOperator) {
        HashSet<FlowTaskNodeEntity> taskNodeList = new HashSet<FlowTaskNodeEntity>();
        List taskId = parentList.stream().map(FlowTaskEntity::getId).collect(Collectors.toList());
        for (FlowTaskNodeEntity nodeEntity : parentNodeAll) {
            ChildNodeList parentNode = (ChildNodeList)JsonUtil.getJsonToBean((String)nodeEntity.getNodePropertyJson(), ChildNodeList.class);
            List<String> taskIdAll = parentNode.getCustom().getTaskId();
            boolean isNum = taskIdAll.stream().filter(t -> taskId.contains(t)).count() > 0L;
            if (!isNum) continue;
            this.parentOperator(parentOperator, nodeEntity);
            taskNodeList.add(nodeEntity);
        }
        for (FlowTaskNodeEntity taskNodeEntity : taskNodeList) {
            taskNodeEntity.setCompletion(FlowNature.AuditCompletion);
            this.flowTaskNodeService.update(taskNodeEntity);
        }
        return taskNodeList.size() > 0;
    }

    private void parentOperator(FlowTaskOperatorEntity parentOperator, FlowTaskNodeEntity nodeEntity) {
        parentOperator.setTaskNodeId(nodeEntity.getId());
        parentOperator.setDescription(JsonUtil.getObjectToString(new ArrayList()));
        parentOperator.setNodeCode(nodeEntity.getNodeCode());
        parentOperator.setNodeName(nodeEntity.getNodeName());
        parentOperator.setTaskId(nodeEntity.getTaskId());
        parentOperator.setCompletion(FlowNature.ProcessCompletion);
    }

    private void getOperator(String id, Set<FlowTaskOperatorEntity> operatorList) {
        if (StringUtils.isNotEmpty((String)id)) {
            List<FlowTaskOperatorEntity> operatorListAll = this.flowTaskOperatorService.getParentId(id);
            for (FlowTaskOperatorEntity operatorEntity : operatorListAll) {
                operatorEntity.setState(FlowNodeEnum.Futility.getCode());
                operatorList.add(operatorEntity);
                this.getOperator(operatorEntity.getId(), operatorList);
            }
        }
    }

    private boolean getNextStepId(List<ChildNodeList> nextOperatorList, List<FlowTaskNodeEntity> flowTaskNodeList, FlowTaskEntity flowTask, FlowModel flowModel) throws WorkFlowException {
        boolean isEnd = false;
        HashSet delNodeList = new HashSet();
        ArrayList<String> progressList = new ArrayList<String>();
        ArrayList<String> nextOperator = new ArrayList<String>();
        ChildNodeList end = nextOperatorList.stream().filter(t -> t.getCustom().getNodeId().contains(FlowNature.NodeEnd)).findFirst().orElse(null);
        for (ChildNodeList childNode : nextOperatorList) {
            String[] properties = childNode.getProperties();
            String id = childNode.getTaskNodeId();
            String progress = properties.getProgress();
            List taskNodeList = flowTaskNodeList.stream().filter(t -> t.getNodeNext() != null).filter(t -> t.getNodeNext().contains(id)).collect(Collectors.toList());
            List nodeList = taskNodeList.stream().map(FlowTaskNodeEntity::getNodeCode).collect(Collectors.toList());
            nextOperatorList.stream().filter(t -> t.getProperties().getProgress() != null).map(t -> t.getProperties().getProgress()).collect(Collectors.toList());
            delNodeList.addAll(nodeList);
            nextOperator.add(id);
            if (!StringUtils.isNotEmpty((String)progress)) continue;
            progressList.add(progress);
        }
        String[] thisNode = flowTask.getThisStepId() != null ? flowTask.getThisStepId().split(",") : new String[]{};
        HashSet<String> thisStepId = new HashSet<String>();
        for (String id : thisNode) {
            boolean isStepId;
            boolean bl = isStepId = flowTaskNodeList.stream().filter(t -> t.getId().equals(id) && FlowNature.ProcessCompletion.equals(t.getCompletion())).count() > 0L;
            if (!isStepId) continue;
            thisStepId.add(id);
        }
        thisStepId.removeAll(delNodeList);
        thisStepId.addAll(nextOperator);
        ArrayList thisNodeName = new ArrayList();
        for (String id : thisStepId) {
            List nodeList = flowTaskNodeList.stream().filter(t -> t.getId().equals(id)).map(FlowTaskNodeEntity::getNodeName).collect(Collectors.toList());
            thisNodeName.addAll(nodeList);
        }
        flowTask.setThisStepId(String.join((CharSequence)",", thisStepId));
        flowTask.setThisStep(String.join((CharSequence)",", thisNodeName));
        Collections.sort(progressList);
        flowTask.setCompletion(progressList.size() > 0 ? Integer.valueOf((String)progressList.get(0)) : null);
        if (end != null && (isEnd = this.endround(flowTask, end, flowModel))) {
            List<FlowTaskNodeEntity> nodeList = this.flowTaskNodeService.getList(flowTask.getId());
            List deleteIdList = nodeList.stream().filter(t -> t.getState().equals(-1)).map(FlowTaskNodeEntity::getId).collect(Collectors.toList());
            deleteIdList.stream().forEach(t -> this.flowTaskNodeService.removeById((Serializable)((Object)t)));
        }
        return isEnd;
    }

    private void operatorRecord(FlowTaskOperatorRecordEntity record, FlowOperatordModel operatordModel) {
        int status = operatordModel.getStatus();
        FlowModel flowModel = operatordModel.getFlowModel();
        String userId = operatordModel.getUserId();
        FlowTaskOperatorEntity operator = operatordModel.getOperator();
        String operatorId = operatordModel.getOperatorId();
        record.setHandleOpinion(flowModel.getHandleOpinion());
        record.setHandleId(userId);
        record.setHandleTime(new Date());
        record.setTemplateId(flowModel.getTemplateId());
        record.setHandleStatus(status);
        record.setOperatorId(operatorId);
        record.setNodeCode(operator.getNodeCode());
        record.setNodeName(operator.getNodeName() != null ? operator.getNodeName() : "\u5f00\u59cb");
        record.setTaskOperatorId(operator.getId());
        record.setTaskNodeId(operator.getTaskNodeId());
        List<FlowTaskOperatorRecordEntity> operatorRecordList = this.flowTaskOperatorRecordService.getList(operator.getTaskId());
        if (CollectionUtil.isNotEmpty(operatorRecordList)) {
            FlowTaskOperatorRecordEntity flowTaskOperatorRecordEntity = operatorRecordList.get(operatorRecordList.size() - 1);
            if (ObjectUtil.isNotEmpty((Object)flowTaskOperatorRecordEntity.getHandleTime())) {
                if (ObjectUtil.isNotEmpty((Object)record.getTaskNodeId())) {
                    Instant lastInstant = flowTaskOperatorRecordEntity.getHandleTime().toInstant();
                    Instant nowInstant = record.getHandleTime().toInstant();
                    Duration between = Duration.between(lastInstant, nowInstant);
                    long minutes = between.toMinutes();
                    record.setAuditTime((int)minutes);
                }
            } else {
                record.setAuditTime(0);
            }
        }
        record.setTaskId(operator.getTaskId());
        record.setSignImg(flowModel.getSignImg());
        record.setHandleFiles(JsonUtil.getObjectToString(flowModel.getHandleFiles()));
        record.setHandleOpinion(operatordModel.getOperator().getHandleOpinion());
        record.setRejectAuditType(flowModel.getRejectAuditType());
        boolean freeApprover = !FlowNature.ParentId.equals(operator.getParentId());
        record.setStatus(freeApprover ? FlowNodeEnum.FreeApprover.getCode() : FlowNodeEnum.Process.getCode());
    }

    private void formData(String code, String id, String data) throws WorkFlowException {
        Map objectData = JsonUtil.stringToMap((String)data);
        if (objectData.size() > 0) {
            try {
                Class[] types = new Class[]{String.class, String.class};
                Object[] datas = new Object[]{id, data};
                Object service = SpringContext.getBean((String)(code + "ServiceImpl"));
                ReflectionUtil.invokeMethod((Object)service, (String)"data", (Class[])types, (Object[])datas);
            }
            catch (Exception e) {
                log.error(MsgCode.WF119.get() + ":{}", (Object)e.getMessage());
                throw new WorkFlowException(MsgCode.WF119.get());
            }
        }
    }

    private List<FlowTaskOperatorEntity> timer(FlowTaskOperatorEntity taskOperator, List<FlowTaskNodeEntity> taskNodeList, List<FlowTaskOperatorEntity> operatorList) {
        ArrayList<FlowTaskOperatorEntity> operatorListAll = new ArrayList<FlowTaskOperatorEntity>();
        FlowTaskNodeEntity taskNode = taskNodeList.stream().filter(t -> t.getId().equals(taskOperator.getTaskNodeId())).findFirst().orElse(null);
        if (taskNode != null) {
            List nodeList = taskNodeList.stream().filter(t -> t.getSortCode().equals(taskNode.getSortCode())).map(FlowTaskNodeEntity::getId).collect(Collectors.toList());
            List<FlowTaskOperatorEntity> operatorAll = this.flowTaskOperatorService.getList(taskOperator.getTaskId());
            HashSet dateListAll = new HashSet();
            List list = operatorAll.stream().filter(t -> nodeList.contains(t.getTaskNodeId())).collect(Collectors.toList());
            for (FlowTaskOperatorEntity operator : list) {
                if (!StringUtils.isNotEmpty((String)operator.getDescription())) continue;
                List dateList = JsonUtil.getJsonToList((String)operator.getDescription(), Date.class);
                dateListAll.addAll(dateList);
            }
            if (StringUtils.isNotEmpty((String)taskOperator.getDescription())) {
                List date = JsonUtil.getJsonToList((String)taskOperator.getDescription(), Date.class);
                dateListAll.addAll(date);
            }
            for (FlowTaskOperatorEntity operator : operatorList) {
                operator.setDescription(JsonUtil.getObjectToString(dateListAll));
                operatorListAll.add(operator);
            }
        }
        return operatorListAll;
    }

    private boolean requestData(ChildNodeList nodeModel, Map<String, Object> formData) {
        boolean flag = false;
        return flag;
    }

    private void updateNodeList(FlowTaskEntity flowTask, ChildNode childNodeAll, List<ChildNodeList> nodeListAll, List<ConditionList> conditionListAll, List<FlowTaskNodeEntity> taskNodeList) {
        FlowJsonUtil.getTemplateAll(childNodeAll, nodeListAll, conditionListAll);
        this.createNodeList(flowTask, nodeListAll, conditionListAll, taskNodeList);
    }
}

