/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.engine.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.PageUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.workflow.engine.entity.FlowEngineTemplateEntity;
import com.bringspring.workflow.engine.entity.FlowEngineVisibleEntity;
import com.bringspring.workflow.engine.mapper.FlowEngineTemplateMapper;
import com.bringspring.workflow.engine.model.flowengine.FlowPagination;
import com.bringspring.workflow.engine.model.flowtimeanalyze.FlowTimeAnalyzeModel;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.service.FlowEngineTemplateService;
import com.bringspring.workflow.engine.service.FlowEngineTemplateVersionService;
import com.bringspring.workflow.engine.service.FlowEngineVisibleService;
import com.bringspring.workflow.engine.service.FlowTaskOperatorRecordService;
import com.bringspring.workflow.engine.service.FlowTaskService;
import com.bringspring.workflow.engine.service.FlowTimeAnalyzeService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowTimeAnalyzeServiceImpl
extends ServiceImpl<FlowEngineTemplateMapper, FlowEngineTemplateEntity>
implements FlowTimeAnalyzeService {
    private static final Logger log = LoggerFactory.getLogger(FlowTimeAnalyzeServiceImpl.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private FlowEngineVisibleService flowEngineVisibleService;
    @Autowired
    private FlowEngineService flowEngineService;
    @Autowired
    private FlowEngineTemplateVersionService flowEngineTemplateVersionService;
    @Autowired
    private FlowEngineTemplateService flowEngineTemplateService;
    @Autowired
    private FlowTaskService flowTaskService;
    @Autowired
    private FlowTaskOperatorRecordService flowTaskOperatorRecordService;
    @Autowired
    private FlowEngineTemplateMapper flowEngineTemplateMapper;

    @Override
    public List<FlowTimeAnalyzeModel> getPageList(FlowPagination pagination) {
        List<FlowTimeAnalyzeModel> resultList = this.appendWrapper(pagination);
        return pagination.setData(PageUtil.getPage((int)((int)pagination.getCurrentPage()), (int)((int)pagination.getPageSize()), resultList), resultList.size());
    }

    private List<FlowTimeAnalyzeModel> appendWrapper(FlowPagination pagination) {
        String flowCategory;
        String companyId;
        String keyWord;
        UserInfo userInfo = this.userProvider.get();
        List dateList = pagination.getDateList().stream().map(Date::new).collect(Collectors.toList());
        List idList = this.flowEngineVisibleService.getAllCompanyVisibleFlowList(userInfo.getUserId(), pagination.getMenuId()).stream().map(FlowEngineVisibleEntity::getTemplateId).collect(Collectors.toList());
        HashMap<String, Object> queryParam = new HashMap<String, Object>(16);
        StringBuilder dbSql = new StringBuilder();
        String string = keyWord = pagination.getKeyword() != null ? pagination.getKeyword() : null;
        if (StringUtils.isNotEmpty((String)pagination.getKeyword())) {
            dbSql.append(" AND t.Full_Name like '%" + keyWord + "%' ");
        }
        String string2 = companyId = pagination.getCompanyId() != null ? pagination.getCompanyId() : null;
        if (ObjectUtil.isNotEmpty((Object)pagination.getCompanyId())) {
            dbSql.append(" AND t.COMPANY_ID = '" + companyId + "' ");
        }
        String string3 = flowCategory = pagination.getCategory() != null ? pagination.getCategory() : null;
        if (ObjectUtil.isNotEmpty((Object)flowCategory)) {
            dbSql.append(" AND t.FLOW_CATEGORY = '" + flowCategory + "' ");
        }
        queryParam.put("startTime", dateList.get(0));
        queryParam.put("endTime", dateList.get(1));
        String sortField = pagination.getSidx();
        String sortOrder = pagination.getSort();
        StringBuilder orderBySql = new StringBuilder();
        HashMap<String, String> allowedSortFields = new HashMap<String, String>();
        allowedSortFields.put("useFrequency", "use_frequency");
        allowedSortFields.put("averageApprovalTime", "average_approval_time");
        allowedSortFields.put("longestApprovalTime", "longest_node_duration_minutes");
        allowedSortFields.put("approvalStopRate", "stagnation_rate_percentage");
        if (ObjectUtil.isNotEmpty((Object)sortField) && allowedSortFields.containsKey(sortField)) {
            String dbColumn = (String)allowedSortFields.get(sortField);
            String order = "asc".equalsIgnoreCase(sortOrder) ? "ASC" : "DESC";
            orderBySql.append(dbColumn).append(" ").append(order);
        }
        queryParam.put("orderByClause", orderBySql.toString());
        queryParam.put("sql", dbSql.toString());
        if (!userInfo.getIsAdministrator().booleanValue() && ObjectUtil.isEmpty(idList)) {
            return new ArrayList<FlowTimeAnalyzeModel>();
        }
        List<FlowTimeAnalyzeModel> modelList = this.flowEngineTemplateMapper.getFlowTimeAnalyze(queryParam);
        List<Object> resultList = new ArrayList();
        resultList = idList.size() > 0 ? modelList.stream().filter(t -> idList.contains(t.getId())).collect(Collectors.toList()) : modelList;
        return resultList;
    }

    @Override
    public List<FlowTimeAnalyzeModel> getExportList(FlowPagination pagination, String dataType) {
        List<FlowTimeAnalyzeModel> resultList = this.appendWrapper(pagination);
        if ("0".equals(dataType)) {
            return pagination.setData(PageUtil.getPage((int)((int)pagination.getCurrentPage()), (int)((int)pagination.getPageSize()), resultList), resultList.size());
        }
        return resultList;
    }
}

