/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workflow.form.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.workflow.engine.util.FlowUtil;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import com.bringspring.workflow.form.entity.LeaveApplyEntity;
import com.bringspring.workflow.form.mapper.LeaveApplyMapper;
import com.bringspring.workflow.form.model.leaveapply.LeaveApplyForm;
import com.bringspring.workflow.form.service.LeaveApplyService;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LeaveApplyServiceImpl
extends ServiceImpl<LeaveApplyMapper, LeaveApplyEntity>
implements LeaveApplyService {
    @Autowired
    private ServiceAllUtil serviceAllUtil;

    @Override
    public LeaveApplyEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(LeaveApplyEntity::getId, (Object)id);
        return (LeaveApplyEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void save(String id, LeaveApplyEntity entity) throws WorkFlowException, DataException {
        if (id == null) {
            entity.setId(RandomUtil.uuId());
            this.save(entity);
            this.serviceAllUtil.useBillNumber("WCREATOR_TIMELeaveApplyNo");
        } else {
            entity.setId(id);
            this.updateById(entity);
        }
        FlowUtil.save(id, entity.getFlowId(), null, entity.getId(), entity.getFlowTitle(), entity.getFlowUrgent(), entity.getBillNo(), entity);
    }

    @Override
    @DSTransactional
    public void submit(String id, LeaveApplyEntity entity, Map<String, List<String>> candidateList) throws WorkFlowException, DataException {
        if (id == null) {
            entity.setId(RandomUtil.uuId());
            this.save(entity);
            this.serviceAllUtil.useBillNumber("WF_LeaveApplyNo");
        } else {
            entity.setId(id);
            this.updateById(entity);
        }
        FlowUtil.submit(id, entity.getFlowId(), null, entity.getId(), entity.getFlowTitle(), entity.getFlowUrgent(), entity.getBillNo(), entity, null, candidateList);
    }

    @Override
    public void data(String id, String data) {
        LeaveApplyForm leaveApplyForm = (LeaveApplyForm)JsonUtil.getJsonToBean((String)data, LeaveApplyForm.class);
        LeaveApplyEntity entity = (LeaveApplyEntity)JsonUtil.getJsonToBean((Object)leaveApplyForm, LeaveApplyEntity.class);
        entity.setId(id);
        this.saveOrUpdate(entity);
    }
}

