/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.duty.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.duty.entity.OmDutyApplyEntity;
import com.bringspring.duty.entity.OmDutyEntity;
import com.bringspring.duty.model.omdutyapply.OmDutyApplyCrForm;
import com.bringspring.duty.model.omdutyapply.OmDutyApplyInfoVO;
import com.bringspring.duty.model.omdutyapply.OmDutyApplyPagination;
import com.bringspring.duty.model.omdutyapply.OmDutyApplyUpForm;
import com.bringspring.duty.service.OmDutyApplyService;
import com.bringspring.duty.service.OmDutyService;
import com.bringspring.duty.util.DutyEnableMarkEnum;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.entity.FlowTaskEntity;
import com.bringspring.workflow.engine.util.FlowUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6362\u73ed\u7533\u8bf7"}, value="duty")
@RequestMapping(value={"/api/duty/OmDutyApply"})
public class OmDutyApplyController {
    private static final Logger log = LoggerFactory.getLogger(OmDutyApplyController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OmDutyApplyService omDutyApplyService;
    @Autowired
    private OmDutyService omDutyService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OmDutyApplyPagination omDutyApplyPagination) throws IOException {
        List<OmDutyApplyEntity> list = this.omDutyApplyService.getList(omDutyApplyPagination);
        List listVO = JsonUtil.getJsonToList(list, OmDutyApplyCrForm.class);
        this.omDutyApplyService.selectValues(listVO);
        for (OmDutyApplyCrForm vo : listVO) {
            FlowTaskEntity flowTaskEntity = FlowUtil.getFlowTaskSubmited((String)vo.getId(), (SFunction[])new SFunction[]{FlowTaskEntity::getStatus});
            if (flowTaskEntity != null) {
                vo.setFlowState(flowTaskEntity.getStatus());
                continue;
            }
            vo.setFlowState(null);
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)omDutyApplyPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid Map<String, Object> crData) throws DataException, WorkFlowException {
        OmDutyApplyCrForm omDutyApplyCrForm = (OmDutyApplyCrForm)((Object)JsonUtil.getJsonToBean(crData, OmDutyApplyCrForm.class));
        String flowEngineId = "476046482529693701";
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        OmDutyApplyEntity entity = (OmDutyApplyEntity)JsonUtil.getJsonToBean((Object)((Object)omDutyApplyCrForm), OmDutyApplyEntity.class);
        entity.setId(mainId);
        entity.setDutyUserId(userInfo.getUserId());
        entity.setEnabledMark("1");
        this.omDutyApplyService.save(entity);
        OmDutyEntity omDutyEntity = new OmDutyEntity();
        omDutyEntity.setEnabledMark(DutyEnableMarkEnum.applyDuty.getCode());
        this.omDutyService.update(entity.getDutyId(), omDutyEntity);
        FlowUtil.saveOrSubmit((String)omDutyApplyCrForm.getTaskId(), (String)flowEngineId, (String)omDutyApplyCrForm.getTemplateId(), (String)mainId, (Object)((Object)omDutyApplyCrForm), (Integer)omDutyApplyCrForm.getStatus(), (String)omDutyApplyCrForm.getDutyUserName());
        return ActionResult.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OmDutyApplyInfoVO> info(@PathVariable(value="id") String id) {
        OmDutyApplyEntity entity = this.omDutyApplyService.getInfo(id);
        OmDutyApplyInfoVO vo = (OmDutyApplyInfoVO)JsonUtil.getJsonToBean((Object)entity, OmDutyApplyInfoVO.class);
        vo.setDutyUserName(this.baseDataUtil.userSelectValueNoAccount(vo.getDutyUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid Map<String, Object> upData) throws DataException, WorkFlowException {
        OmDutyApplyUpForm omDutyApplyUpForm = (OmDutyApplyUpForm)((Object)JsonUtil.getJsonToBean(upData, OmDutyApplyUpForm.class));
        String flowEngineId = "476046482529693701";
        UserInfo userInfo = this.userProvider.get();
        OmDutyApplyEntity entity = this.omDutyApplyService.getInfo(id);
        if (entity != null) {
            OmDutyApplyEntity subentity = (OmDutyApplyEntity)JsonUtil.getJsonToBean((Object)((Object)omDutyApplyUpForm), OmDutyApplyEntity.class);
            this.omDutyApplyService.update(id, subentity);
            FlowUtil.saveOrSubmit((String)omDutyApplyUpForm.getTaskId(), (String)flowEngineId, (String)omDutyApplyUpForm.getTemplateId(), (String)id, (Object)((Object)omDutyApplyUpForm), (Integer)omDutyApplyUpForm.getStatus(), (String)omDutyApplyUpForm.getId());
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OmDutyApplyEntity entity = this.omDutyApplyService.getInfo(id);
        if (entity != null) {
            FlowTaskEntity taskEntity = FlowUtil.getFlowTaskSubmited((String)id, (SFunction[])new SFunction[]{FlowTaskEntity::getId, FlowTaskEntity::getStatus});
            if (taskEntity != null) {
                try {
                    FlowUtil.deleteByProcessId((String)id);
                }
                catch (WorkFlowException e) {
                    e.printStackTrace();
                }
            }
            this.omDutyApplyService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

