/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.duty.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.duty.entity.OmDutyEntity;
import com.bringspring.duty.model.omduty.OmDutyCrForm;
import com.bringspring.duty.model.omduty.OmDutyInfoVO;
import com.bringspring.duty.model.omduty.OmDutyListVO;
import com.bringspring.duty.model.omduty.OmDutyPagination;
import com.bringspring.duty.model.omduty.OmDutyUpForm;
import com.bringspring.duty.service.OmDutyService;
import com.bringspring.duty.util.DutyEnableMarkEnum;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u503c\u73ed\u8bb0\u5f55\u8868"}, value="duty")
@RequestMapping(value={"/api/duty/OmDuty"})
public class OmDutyController {
    private static final Logger log = LoggerFactory.getLogger(OmDutyController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OmDutyService omDutyService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OmDutyPagination omDutyPagination) throws IOException {
        List<OmDutyEntity> list = this.omDutyService.getList(omDutyPagination);
        List listVO = JsonUtil.getJsonToList(list, OmDutyListVO.class);
        PageListVO vo = new PageListVO();
        this.omDutyService.selectValues(listVO);
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)omDutyPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OmDutyCrForm omDutyCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        OmDutyEntity entity = (OmDutyEntity)JsonUtil.getJsonToBean((Object)omDutyCrForm, OmDutyEntity.class);
        entity.setId(mainId);
        this.omDutyService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OmDutyListVO> info(@PathVariable(value="id") String id) {
        OmDutyEntity entity = this.omDutyService.getInfo(id);
        OmDutyListVO vo = (OmDutyListVO)JsonUtil.getJsonToBean((Object)entity, OmDutyListVO.class);
        ArrayList<OmDutyListVO> listVO = new ArrayList<OmDutyListVO>();
        listVO.add(vo);
        this.omDutyService.selectValues(listVO);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OmDutyInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OmDutyEntity entity = this.omDutyService.getInfo(id);
        OmDutyInfoVO vo = (OmDutyInfoVO)JsonUtil.getJsonToBean((Object)entity, OmDutyInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/dutyEnableMarkEnum"})
    public ActionResult<DutyEnableMarkEnum[]> dutyPlanTypeEnum() {
        return ActionResult.success((Object)DutyEnableMarkEnum.values());
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OmDutyUpForm omDutyUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        OmDutyEntity entity = this.omDutyService.getInfo(id);
        if (entity != null) {
            OmDutyEntity subentity = (OmDutyEntity)JsonUtil.getJsonToBean((Object)omDutyUpForm, OmDutyEntity.class);
            this.omDutyService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OmDutyEntity entity = this.omDutyService.getInfo(id);
        if (entity != null) {
            this.omDutyService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

