/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.duty.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.duty.entity.OmDutyPlanEntity;
import com.bringspring.duty.model.omdutyplan.OmDutyPlanCrForm;
import com.bringspring.duty.model.omdutyplan.OmDutyPlanInfoVO;
import com.bringspring.duty.model.omdutyplan.OmDutyPlanPagination;
import com.bringspring.duty.service.OmDutyPlanService;
import com.bringspring.duty.util.DutyPlanTypeEnum;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6392\u73ed\u8ba1\u5212"}, value="duty")
@RequestMapping(value={"/api/duty/OmDutyPlan"})
public class OmDutyPlanController {
    private static final Logger log = LoggerFactory.getLogger(OmDutyPlanController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OmDutyPlanService omDutyPlanService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OmDutyPlanPagination omDutyPlanPagination) throws IOException {
        List<OmDutyPlanEntity> list = this.omDutyPlanService.getList(omDutyPlanPagination);
        List listVO = JsonUtil.getJsonToList(list, OmDutyPlanCrForm.class);
        this.omDutyPlanService.selectValues(listVO);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)omDutyPlanPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OmDutyPlanCrForm omDutyPlanCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        OmDutyPlanEntity entity = (OmDutyPlanEntity)JsonUtil.getJsonToBean((Object)omDutyPlanCrForm, OmDutyPlanEntity.class);
        entity.setId(mainId);
        this.omDutyPlanService.create(omDutyPlanCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OmDutyPlanInfoVO> info(@PathVariable(value="id") String id) {
        OmDutyPlanEntity entity = this.omDutyPlanService.getInfo(id);
        OmDutyPlanInfoVO vo = (OmDutyPlanInfoVO)JsonUtil.getJsonToBean((Object)entity, OmDutyPlanInfoVO.class);
        ArrayList<OmDutyPlanInfoVO> infoVO = new ArrayList<OmDutyPlanInfoVO>();
        infoVO.add(vo);
        this.omDutyPlanService.selectValue(infoVO);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OmDutyPlanInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OmDutyPlanEntity entity = this.omDutyPlanService.getInfo(id);
        OmDutyPlanInfoVO vo = (OmDutyPlanInfoVO)JsonUtil.getJsonToBean((Object)entity, OmDutyPlanInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/dutyPlanTypeEnum"})
    public ActionResult<DutyPlanTypeEnum[]> dutyPlanTypeEnum() {
        return ActionResult.success((Object)DutyPlanTypeEnum.values());
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OmDutyPlanCrForm omDutyPlanCrForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        OmDutyPlanEntity entity = this.omDutyPlanService.getInfo(id);
        if (entity != null) {
            this.omDutyPlanService.update(id, omDutyPlanCrForm);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OmDutyPlanEntity entity = this.omDutyPlanService.getInfo(id);
        if (entity != null) {
            this.omDutyPlanService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

