/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.duty.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.duty.entity.OmDutyPlanUserEntity;
import com.bringspring.duty.model.omdutyplanuser.OmDutyPlanUserCrForm;
import com.bringspring.duty.model.omdutyplanuser.OmDutyPlanUserInfoVO;
import com.bringspring.duty.model.omdutyplanuser.OmDutyPlanUserListVO;
import com.bringspring.duty.model.omdutyplanuser.OmDutyPlanUserPagination;
import com.bringspring.duty.model.omdutyplanuser.OmDutyPlanUserUpForm;
import com.bringspring.duty.service.OmDutyPlanUserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u503c\u73ed\u4eba\u5458"}, value="duty")
@RequestMapping(value={"/api/duty/OmDutyPlanUser"})
public class OmDutyPlanUserController {
    private static final Logger log = LoggerFactory.getLogger(OmDutyPlanUserController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OmDutyPlanUserService omDutyPlanUserService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OmDutyPlanUserPagination omDutyPlanUserPagination) throws IOException {
        List<OmDutyPlanUserEntity> list = this.omDutyPlanUserService.getList(omDutyPlanUserPagination);
        List listVO = JsonUtil.getJsonToList(list, OmDutyPlanUserListVO.class);
        PageListVO vo = new PageListVO();
        this.omDutyPlanUserService.selectValues(listVO);
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)omDutyPlanUserPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OmDutyPlanUserCrForm omDutyPlanUserCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        OmDutyPlanUserEntity entity = (OmDutyPlanUserEntity)JsonUtil.getJsonToBean((Object)omDutyPlanUserCrForm, OmDutyPlanUserEntity.class);
        entity.setId(mainId);
        this.omDutyPlanUserService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OmDutyPlanUserInfoVO> info(@PathVariable(value="id") String id) {
        OmDutyPlanUserEntity entity = this.omDutyPlanUserService.getInfo(id);
        OmDutyPlanUserInfoVO vo = (OmDutyPlanUserInfoVO)JsonUtil.getJsonToBean((Object)entity, OmDutyPlanUserInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OmDutyPlanUserInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OmDutyPlanUserEntity entity = this.omDutyPlanUserService.getInfo(id);
        OmDutyPlanUserInfoVO vo = (OmDutyPlanUserInfoVO)JsonUtil.getJsonToBean((Object)entity, OmDutyPlanUserInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OmDutyPlanUserUpForm omDutyPlanUserUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        OmDutyPlanUserEntity entity = this.omDutyPlanUserService.getInfo(id);
        if (entity != null) {
            OmDutyPlanUserEntity subentity = (OmDutyPlanUserEntity)JsonUtil.getJsonToBean((Object)omDutyPlanUserUpForm, OmDutyPlanUserEntity.class);
            this.omDutyPlanUserService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OmDutyPlanUserEntity entity = this.omDutyPlanUserService.getInfo(id);
        if (entity != null) {
            this.omDutyPlanUserService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

