/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.duty.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.duty.entity.OmDutyApplyEntity;
import com.bringspring.duty.entity.OmDutyEntity;
import com.bringspring.duty.mapper.OmDutyApplyMapper;
import com.bringspring.duty.model.omdutyapply.OmDutyApplyCrForm;
import com.bringspring.duty.model.omdutyapply.OmDutyApplyPagination;
import com.bringspring.duty.service.OmDutyApplyService;
import com.bringspring.duty.service.OmDutyService;
import com.bringspring.duty.util.DutyEnableMarkEnum;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workflow.engine.model.flowengine.FlowModel;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OmDutyApplyServiceImpl
extends ServiceImpl<OmDutyApplyMapper, OmDutyApplyEntity>
implements OmDutyApplyService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private OmDutyService omDutyService;

    @Override
    public List<OmDutyApplyEntity> getList(OmDutyApplyPagination omDutyApplyPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int omDutyApplyNum = 0;
        QueryWrapper omDutyApplyQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)omDutyApplyPagination.getDutyUserId())) {
            ++omDutyApplyNum;
            omDutyApplyQueryWrapper.lambda().like(OmDutyApplyEntity::getDutyUserId, (Object)omDutyApplyPagination.getDutyUserId());
        }
        if (StringUtils.isNotEmpty((String)omDutyApplyPagination.getChangeDutyUserId())) {
            ++omDutyApplyNum;
            omDutyApplyQueryWrapper.lambda().like(OmDutyApplyEntity::getChangeDutyUserId, (Object)omDutyApplyPagination.getChangeDutyUserId());
        }
        if (StringUtils.isNotEmpty((String)omDutyApplyPagination.getDutyId())) {
            ++omDutyApplyNum;
            omDutyApplyQueryWrapper.lambda().like(OmDutyApplyEntity::getDutyId, (Object)omDutyApplyPagination.getDutyId());
        }
        if (StringUtils.isNotEmpty((String)omDutyApplyPagination.getDescription())) {
            ++omDutyApplyNum;
            omDutyApplyQueryWrapper.lambda().like(OmDutyApplyEntity::getDescription, (Object)omDutyApplyPagination.getDescription());
        }
        if (StringUtils.isNotEmpty((String)omDutyApplyPagination.getEnabledMark())) {
            ++omDutyApplyNum;
            omDutyApplyQueryWrapper.lambda().like(OmDutyApplyEntity::getEnabledMark, (Object)omDutyApplyPagination.getEnabledMark());
        }
        if (AllIdList.size() > 0) {
            omDutyApplyQueryWrapper.lambda().in(OmDutyApplyEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)omDutyApplyPagination.getSidx())) {
            omDutyApplyQueryWrapper.lambda().orderByDesc(OmDutyApplyEntity::getId);
        } else {
            try {
                String sidx = omDutyApplyPagination.getSidx();
                OmDutyApplyEntity omDutyApplyEntity = new OmDutyApplyEntity();
                Field declaredField = omDutyApplyEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                omDutyApplyQueryWrapper = "asc".equals(omDutyApplyPagination.getSort().toLowerCase()) ? (QueryWrapper)omDutyApplyQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)omDutyApplyQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(omDutyApplyPagination.getCurrentPage(), omDutyApplyPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)omDutyApplyQueryWrapper);
            return omDutyApplyPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return omDutyApplyPagination.setData(list, list.size());
    }

    @Override
    public void selectValues(List<OmDutyApplyCrForm> outputVo) {
        if (ObjectUtil.isNull(outputVo)) {
            return;
        }
        outputVo.stream().forEach(item -> {
            item.setDutyUserName(this.baseDataUtil.userSelectValueNoAccount(item.getDutyUserId()));
            item.setChangeDutyUserName(this.baseDataUtil.userSelectValueNoAccount(item.getChangeDutyUserId()));
            OmDutyEntity info = this.omDutyService.getInfo(item.getDutyId());
            if (!ObjectUtil.isEmpty((Object)info)) {
                item.setDutyDate(info.getDutyStartDatetime());
            }
        });
    }

    @Override
    public List<OmDutyApplyEntity> getTypeList(OmDutyApplyPagination omDutyApplyPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int omDutyApplyNum = 0;
        QueryWrapper omDutyApplyQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)omDutyApplyPagination.getDutyUserId())) {
            ++omDutyApplyNum;
            omDutyApplyQueryWrapper.lambda().like(OmDutyApplyEntity::getDutyUserId, (Object)omDutyApplyPagination.getDutyUserId());
        }
        if (StringUtils.isNotEmpty((String)omDutyApplyPagination.getChangeDutyUserId())) {
            ++omDutyApplyNum;
            omDutyApplyQueryWrapper.lambda().like(OmDutyApplyEntity::getChangeDutyUserId, (Object)omDutyApplyPagination.getChangeDutyUserId());
        }
        if (StringUtils.isNotEmpty((String)omDutyApplyPagination.getDutyId())) {
            ++omDutyApplyNum;
            omDutyApplyQueryWrapper.lambda().like(OmDutyApplyEntity::getDutyId, (Object)omDutyApplyPagination.getDutyId());
        }
        if (StringUtils.isNotEmpty((String)omDutyApplyPagination.getDescription())) {
            ++omDutyApplyNum;
            omDutyApplyQueryWrapper.lambda().like(OmDutyApplyEntity::getDescription, (Object)omDutyApplyPagination.getDescription());
        }
        if (StringUtils.isNotEmpty((String)omDutyApplyPagination.getEnabledMark())) {
            ++omDutyApplyNum;
            omDutyApplyQueryWrapper.lambda().like(OmDutyApplyEntity::getEnabledMark, (Object)omDutyApplyPagination.getEnabledMark());
        }
        if (AllIdList.size() > 0) {
            omDutyApplyQueryWrapper.lambda().in(OmDutyApplyEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)omDutyApplyPagination.getSidx())) {
            omDutyApplyQueryWrapper.lambda().orderByDesc(OmDutyApplyEntity::getId);
        } else {
            try {
                String sidx = omDutyApplyPagination.getSidx();
                OmDutyApplyEntity omDutyApplyEntity = new OmDutyApplyEntity();
                Field declaredField = omDutyApplyEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                omDutyApplyQueryWrapper = "asc".equals(omDutyApplyPagination.getSort().toLowerCase()) ? (QueryWrapper)omDutyApplyQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)omDutyApplyQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(omDutyApplyPagination.getCurrentPage(), omDutyApplyPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)omDutyApplyQueryWrapper);
                return omDutyApplyPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return omDutyApplyPagination.setData(list, list.size());
        }
        return this.list((Wrapper)omDutyApplyQueryWrapper);
    }

    @Override
    public OmDutyApplyEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OmDutyApplyEntity::getId, (Object)id);
        return (OmDutyApplyEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(OmDutyApplyEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, OmDutyApplyEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(OmDutyApplyEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    public void updateEnableMarkById(String id, Integer enableMark, FlowModel model) {
        OmDutyApplyEntity infoDutyApply;
        if (2 == enableMark && !ObjectUtil.isEmpty((Object)(infoDutyApply = this.getInfo(id)))) {
            OmDutyEntity dutyEntity = new OmDutyEntity();
            dutyEntity.setDutyUserId(infoDutyApply.getChangeDutyUserId());
            dutyEntity.setEnabledMark(DutyEnableMarkEnum.notDuty.getCode());
            this.omDutyService.update(infoDutyApply.getDutyId(), dutyEntity);
        }
    }
}

