/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.duty.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.duty.entity.OmDutyEntity;
import com.bringspring.duty.entity.OmDutyPlanEntity;
import com.bringspring.duty.entity.OmDutyPlanUserEntity;
import com.bringspring.duty.mapper.OmDutyPlanMapper;
import com.bringspring.duty.model.omdutyplan.OmDutyPlanCrForm;
import com.bringspring.duty.model.omdutyplan.OmDutyPlanInfoVO;
import com.bringspring.duty.model.omdutyplan.OmDutyPlanPagination;
import com.bringspring.duty.service.OmDutyPlanService;
import com.bringspring.duty.service.OmDutyPlanUserService;
import com.bringspring.duty.service.OmDutyService;
import com.bringspring.duty.util.DutyEnableMarkEnum;
import com.bringspring.duty.util.DutyPlanTypeEnum;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OmDutyPlanServiceImpl
extends ServiceImpl<OmDutyPlanMapper, OmDutyPlanEntity>
implements OmDutyPlanService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OmDutyService omDutyService;
    @Autowired
    private OmDutyPlanUserService omDutyPlanUserService;

    @Override
    public List<OmDutyPlanEntity> getList(OmDutyPlanPagination omDutyPlanPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int omDutyPlanNum = 0;
        QueryWrapper omDutyPlanQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)omDutyPlanPagination.getName())) {
            ++omDutyPlanNum;
            omDutyPlanQueryWrapper.lambda().like(OmDutyPlanEntity::getName, (Object)omDutyPlanPagination.getName());
        }
        if (StringUtils.isNotEmpty((String)omDutyPlanPagination.getType())) {
            ++omDutyPlanNum;
            omDutyPlanQueryWrapper.lambda().like(OmDutyPlanEntity::getType, (Object)omDutyPlanPagination.getType());
        }
        if (StringUtils.isNotEmpty((String)omDutyPlanPagination.getCycle())) {
            ++omDutyPlanNum;
            omDutyPlanQueryWrapper.lambda().like(OmDutyPlanEntity::getCycle, (Object)omDutyPlanPagination.getCycle());
        }
        if (StringUtils.isNotEmpty((String)omDutyPlanPagination.getStartDatetime())) {
            ++omDutyPlanNum;
            omDutyPlanQueryWrapper.lambda().like(OmDutyPlanEntity::getStartDatetime, (Object)omDutyPlanPagination.getStartDatetime());
        }
        if (StringUtils.isNotEmpty((String)omDutyPlanPagination.getEndDatetime())) {
            ++omDutyPlanNum;
            omDutyPlanQueryWrapper.lambda().like(OmDutyPlanEntity::getEndDatetime, (Object)omDutyPlanPagination.getEndDatetime());
        }
        if (AllIdList.size() > 0) {
            omDutyPlanQueryWrapper.lambda().in(OmDutyPlanEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)omDutyPlanPagination.getSidx())) {
            omDutyPlanQueryWrapper.lambda().orderByDesc(OmDutyPlanEntity::getId);
        } else {
            try {
                String sidx = omDutyPlanPagination.getSidx();
                OmDutyPlanEntity omDutyPlanEntity = new OmDutyPlanEntity();
                Field declaredField = omDutyPlanEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                omDutyPlanQueryWrapper = "asc".equals(omDutyPlanPagination.getSort().toLowerCase()) ? (QueryWrapper)omDutyPlanQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)omDutyPlanQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(omDutyPlanPagination.getCurrentPage(), omDutyPlanPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)omDutyPlanQueryWrapper);
            return omDutyPlanPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return omDutyPlanPagination.setData(list, list.size());
    }

    @Override
    public void selectValues(List<OmDutyPlanCrForm> outputVo) {
        if (ObjectUtil.isNull(outputVo)) {
            return;
        }
        outputVo.stream().forEach(item -> item.setTypeName(DutyPlanTypeEnum.getEnum(item.getType())));
    }

    @Override
    public void selectValue(List<OmDutyPlanInfoVO> outputVo) {
        if (ObjectUtil.isNull(outputVo)) {
            return;
        }
        outputVo.stream().forEach(item -> {
            item.setTypeName(DutyPlanTypeEnum.getEnum(item.getType()));
            List<OmDutyEntity> infoByPlanId = this.omDutyService.getInfoByPlanId(item.getId());
            if (!ObjectUtil.isEmpty(infoByPlanId)) {
                List<String> collectPlanUser = infoByPlanId.stream().map(t -> t.getDutyUserId()).distinct().collect(Collectors.toList());
                item.setPlanUser(collectPlanUser);
            }
        });
    }

    @Override
    public List<OmDutyPlanEntity> getTypeList(OmDutyPlanPagination omDutyPlanPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int omDutyPlanNum = 0;
        QueryWrapper omDutyPlanQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)omDutyPlanPagination.getName())) {
            ++omDutyPlanNum;
            omDutyPlanQueryWrapper.lambda().like(OmDutyPlanEntity::getName, (Object)omDutyPlanPagination.getName());
        }
        if (StringUtils.isNotEmpty((String)omDutyPlanPagination.getType())) {
            ++omDutyPlanNum;
            omDutyPlanQueryWrapper.lambda().like(OmDutyPlanEntity::getType, (Object)omDutyPlanPagination.getType());
        }
        if (StringUtils.isNotEmpty((String)omDutyPlanPagination.getCycle())) {
            ++omDutyPlanNum;
            omDutyPlanQueryWrapper.lambda().like(OmDutyPlanEntity::getCycle, (Object)omDutyPlanPagination.getCycle());
        }
        if (StringUtils.isNotEmpty((String)omDutyPlanPagination.getStartDatetime())) {
            ++omDutyPlanNum;
            omDutyPlanQueryWrapper.lambda().like(OmDutyPlanEntity::getStartDatetime, (Object)omDutyPlanPagination.getStartDatetime());
        }
        if (StringUtils.isNotEmpty((String)omDutyPlanPagination.getEndDatetime())) {
            ++omDutyPlanNum;
            omDutyPlanQueryWrapper.lambda().like(OmDutyPlanEntity::getEndDatetime, (Object)omDutyPlanPagination.getEndDatetime());
        }
        if (AllIdList.size() > 0) {
            omDutyPlanQueryWrapper.lambda().in(OmDutyPlanEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)omDutyPlanPagination.getSidx())) {
            omDutyPlanQueryWrapper.lambda().orderByDesc(OmDutyPlanEntity::getId);
        } else {
            try {
                String sidx = omDutyPlanPagination.getSidx();
                OmDutyPlanEntity omDutyPlanEntity = new OmDutyPlanEntity();
                Field declaredField = omDutyPlanEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                omDutyPlanQueryWrapper = "asc".equals(omDutyPlanPagination.getSort().toLowerCase()) ? (QueryWrapper)omDutyPlanQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)omDutyPlanQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(omDutyPlanPagination.getCurrentPage(), omDutyPlanPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)omDutyPlanQueryWrapper);
                return omDutyPlanPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return omDutyPlanPagination.setData(list, list.size());
        }
        return this.list((Wrapper)omDutyPlanQueryWrapper);
    }

    @Override
    public OmDutyPlanEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OmDutyPlanEntity::getId, (Object)id);
        return (OmDutyPlanEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(OmDutyPlanCrForm omDutyPlanCrForm) {
        omDutyPlanCrForm.setStartDatetime(omDutyPlanCrForm.getDateTime().get(0));
        omDutyPlanCrForm.setEndDatetime(omDutyPlanCrForm.getDateTime().get(1));
        String planId = RandomUtil.uuId();
        omDutyPlanCrForm.setId(planId);
        ArrayList<OmDutyEntity> omDutyEntityList = new ArrayList<OmDutyEntity>();
        ArrayList<OmDutyPlanUserEntity> omDutyPlanUserEntityList = new ArrayList<OmDutyPlanUserEntity>();
        if (!ObjectUtil.isEmpty(omDutyPlanCrForm.getPlanUser())) {
            Date startDatetime = omDutyPlanCrForm.getStartDatetime();
            List<String> planUser = omDutyPlanCrForm.getPlanUser();
            int diffDays = DateUtil.getDiffDays((Date)omDutyPlanCrForm.getStartDatetime(), (Date)omDutyPlanCrForm.getEndDatetime());
            int sizePlanUser = omDutyPlanCrForm.getPlanUser().size();
            Integer i2 = 0;
            while (i2 < diffDays) {
                if (-1 == DateUtil.dateCompare((Date)startDatetime, (Date)omDutyPlanCrForm.getEndDatetime())) {
                    OmDutyEntity omDutyEntity = new OmDutyEntity();
                    omDutyEntity.setId(RandomUtil.uuId());
                    omDutyEntity.setPlanId(planId);
                    omDutyEntity.setDutyUserId(planUser.get(i2 / omDutyPlanCrForm.getCycle() % sizePlanUser));
                    omDutyEntity.setEnabledMark(DutyEnableMarkEnum.notDuty.getCode());
                    omDutyEntity.setDutyStartDatetime(startDatetime);
                    Date nextDay = DateUtil.getNextDay((Date)startDatetime, (int)omDutyPlanCrForm.getCycle());
                    omDutyEntity.setDutyEndDatetime(DateUtil.getNextDay((Date)startDatetime, (int)1));
                    startDatetime = omDutyEntity.getDutyEndDatetime();
                    omDutyEntityList.add(omDutyEntity);
                    OmDutyPlanUserEntity omDutyPlanUserEntity = new OmDutyPlanUserEntity();
                    omDutyPlanUserEntity.setId(RandomUtil.uuId());
                    omDutyPlanUserEntity.setPlanId(planId);
                    omDutyPlanUserEntity.setUserId(planUser.get(i2 % sizePlanUser));
                    omDutyPlanUserEntity.setSortMark(i2 + 1);
                    omDutyPlanUserEntityList.add(omDutyPlanUserEntity);
                }
                Integer n = i2;
                Integer n2 = i2 = Integer.valueOf(i2 + 1);
            }
            omDutyPlanCrForm.getPlanUser().forEach(i -> {});
        }
        this.omDutyService.saveBatch(omDutyEntityList);
        this.omDutyPlanUserService.saveBatch(omDutyPlanUserEntityList);
        OmDutyPlanEntity entity = (OmDutyPlanEntity)JsonUtil.getJsonToBean((Object)omDutyPlanCrForm, OmDutyPlanEntity.class);
        this.save(entity);
    }

    @Override
    public boolean update(String planId, OmDutyPlanCrForm omDutyPlanCrForm) {
        ArrayList<OmDutyEntity> omDutyEntityList = new ArrayList<OmDutyEntity>();
        ArrayList omDutyPlanUserEntityList = new ArrayList();
        List<String> planUser = omDutyPlanCrForm.getPlanUser();
        omDutyPlanCrForm.setId(planId);
        Date startDatetime = omDutyPlanCrForm.getStartDatetime();
        int diffDays = DateUtil.getDiffDays((Date)omDutyPlanCrForm.getStartDatetime(), (Date)omDutyPlanCrForm.getEndDatetime());
        int sizePlanUser = omDutyPlanCrForm.getPlanUser().size();
        Integer i = 0;
        while (i < diffDays) {
            Object omDutyEntity = new OmDutyEntity();
            ((OmDutyEntity)omDutyEntity).setId(RandomUtil.uuId());
            ((OmDutyEntity)omDutyEntity).setPlanId(planId);
            ((OmDutyEntity)omDutyEntity).setDutyUserId(planUser.get(i / omDutyPlanCrForm.getCycle() % sizePlanUser));
            ((OmDutyEntity)omDutyEntity).setEnabledMark(DutyEnableMarkEnum.notDuty.getCode());
            ((OmDutyEntity)omDutyEntity).setDutyStartDatetime(startDatetime);
            Date nextDay = DateUtil.getNextDay((Date)startDatetime, (int)omDutyPlanCrForm.getCycle());
            ((OmDutyEntity)omDutyEntity).setDutyEndDatetime(DateUtil.getNextDay((Date)startDatetime, (int)1));
            omDutyEntityList.add((OmDutyEntity)omDutyEntity);
            startDatetime = ((OmDutyEntity)omDutyEntity).getDutyEndDatetime();
            omDutyEntity = i;
            Integer n = i = Integer.valueOf(i + 1);
        }
        OmDutyPlanEntity subentity = (OmDutyPlanEntity)JsonUtil.getJsonToBean((Object)omDutyPlanCrForm, OmDutyPlanEntity.class);
        ArrayList dutyId = new ArrayList();
        omDutyEntityList.stream().forEach(t -> {
            List<OmDutyEntity> infoByDutyDate = this.omDutyService.getInfoByDutyDate((OmDutyEntity)t);
            if (!ObjectUtil.isEmpty(infoByDutyDate)) {
                dutyId.addAll(infoByDutyDate.stream().map(a -> a.getId()).collect(Collectors.toList()));
            }
        });
        this.omDutyService.removeBatchByIds(dutyId);
        this.omDutyService.saveBatch(omDutyEntityList);
        return this.updateById(subentity);
    }

    @Override
    public void delete(OmDutyPlanEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

