/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.duty.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.duty.entity.OmDutyEntity;
import com.bringspring.duty.mapper.OmDutyMapper;
import com.bringspring.duty.model.omduty.OmDutyListVO;
import com.bringspring.duty.model.omduty.OmDutyPagination;
import com.bringspring.duty.service.OmDutyService;
import com.bringspring.duty.util.DutyEnableMarkEnum;
import com.bringspring.system.permission.util.BaseDataUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OmDutyServiceImpl
extends ServiceImpl<OmDutyMapper, OmDutyEntity>
implements OmDutyService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private BaseDataUtil baseDataUtil;

    @Override
    public List<OmDutyEntity> getList(OmDutyPagination omDutyPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int omDutyNum = 0;
        QueryWrapper omDutyQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)omDutyPagination.getDutyStartDateBefore())) {
            ++omDutyNum;
            omDutyQueryWrapper.lambda().ge(OmDutyEntity::getDutyStartDatetime, (Object)omDutyPagination.getDutyStartDateBefore());
        }
        if (StringUtils.isNotEmpty((String)omDutyPagination.getDutyStartDateAfter())) {
            ++omDutyNum;
            omDutyQueryWrapper.lambda().le(OmDutyEntity::getDutyStartDatetime, (Object)omDutyPagination.getDutyStartDateAfter());
        }
        if (StringUtils.isNotEmpty((String)omDutyPagination.getId())) {
            ++omDutyNum;
            omDutyQueryWrapper.lambda().eq(OmDutyEntity::getId, (Object)omDutyPagination.getId());
        }
        if (StringUtils.isNotEmpty((String)omDutyPagination.getDutyUserId())) {
            ++omDutyNum;
            omDutyQueryWrapper.lambda().like(OmDutyEntity::getDutyUserId, (Object)omDutyPagination.getDutyUserId());
        }
        if (StringUtils.isNotEmpty((String)omDutyPagination.getDutyStartDatetime())) {
            ++omDutyNum;
            omDutyQueryWrapper.lambda().like(OmDutyEntity::getDutyStartDatetime, (Object)omDutyPagination.getDutyStartDatetime());
        }
        if (StringUtils.isNotEmpty((String)omDutyPagination.getDutyEndDatetime())) {
            ++omDutyNum;
            omDutyQueryWrapper.lambda().like(OmDutyEntity::getDutyEndDatetime, (Object)omDutyPagination.getDutyEndDatetime());
        }
        if (StringUtils.isNotEmpty((String)omDutyPagination.getDescription())) {
            ++omDutyNum;
            omDutyQueryWrapper.lambda().like(OmDutyEntity::getDescription, (Object)omDutyPagination.getDescription());
        }
        if (StringUtils.isNotEmpty((String)omDutyPagination.getEnabledMark())) {
            ++omDutyNum;
            omDutyQueryWrapper.lambda().like(OmDutyEntity::getEnabledMark, (Object)omDutyPagination.getEnabledMark());
        }
        if (AllIdList.size() > 0) {
            omDutyQueryWrapper.lambda().in(OmDutyEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)omDutyPagination.getSidx())) {
            omDutyQueryWrapper.lambda().orderByDesc(OmDutyEntity::getId);
        } else {
            try {
                String sidx = omDutyPagination.getSidx();
                OmDutyEntity omDutyEntity = new OmDutyEntity();
                Field declaredField = omDutyEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                omDutyQueryWrapper = "asc".equals(omDutyPagination.getSort().toLowerCase()) ? (QueryWrapper)omDutyQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)omDutyQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(omDutyPagination.getCurrentPage(), omDutyPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)omDutyQueryWrapper);
            return omDutyPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return omDutyPagination.setData(list, list.size());
    }

    @Override
    public List<OmDutyEntity> getInfoByPlanId(String planId) {
        QueryWrapper omDutyQueryWrapper = new QueryWrapper();
        omDutyQueryWrapper.lambda().eq(OmDutyEntity::getPlanId, (Object)planId);
        return this.list((Wrapper)omDutyQueryWrapper);
    }

    @Override
    public List<OmDutyEntity> getInfoByDutyDate(OmDutyEntity dutyPlanCrForm) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OmDutyEntity::getPlanId, (Object)dutyPlanCrForm.getPlanId());
        queryWrapper.lambda().eq(OmDutyEntity::getDutyStartDatetime, (Object)dutyPlanCrForm.getDutyStartDatetime());
        queryWrapper.lambda().eq(OmDutyEntity::getDutyEndDatetime, (Object)dutyPlanCrForm.getDutyEndDatetime());
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<OmDutyEntity> getInfoBetweenDutyDate(Date workOrderStartDatetime) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().le(OmDutyEntity::getDutyStartDatetime, (Object)workOrderStartDatetime);
        queryWrapper.lambda().ge(OmDutyEntity::getDutyEndDatetime, (Object)workOrderStartDatetime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void selectValues(List<OmDutyListVO> outputVo) {
        if (ObjectUtil.isNull(outputVo)) {
            return;
        }
        outputVo.stream().forEach(item -> {
            if (!ObjectUtil.isEmpty((Object)item.getDutyUserId())) {
                item.setDutyUserName(this.baseDataUtil.userSelectValueNoAccount(item.getDutyUserId()));
            }
            if (!ObjectUtil.isEmpty((Object)item.getEnabledMark())) {
                item.setEnabledMarkName(DutyEnableMarkEnum.getEnum(item.getEnabledMark()));
            }
        });
    }

    @Override
    public List<OmDutyEntity> getTypeList(OmDutyPagination omDutyPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int omDutyNum = 0;
        QueryWrapper omDutyQueryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)omDutyPagination.getDutyUserId())) {
            ++omDutyNum;
            omDutyQueryWrapper.lambda().like(OmDutyEntity::getDutyUserId, (Object)omDutyPagination.getDutyUserId());
        }
        if (StringUtils.isNotEmpty((String)omDutyPagination.getDutyStartDatetime())) {
            ++omDutyNum;
            omDutyQueryWrapper.lambda().like(OmDutyEntity::getDutyStartDatetime, (Object)omDutyPagination.getDutyStartDatetime());
        }
        if (StringUtils.isNotEmpty((String)omDutyPagination.getDutyEndDatetime())) {
            ++omDutyNum;
            omDutyQueryWrapper.lambda().like(OmDutyEntity::getDutyEndDatetime, (Object)omDutyPagination.getDutyEndDatetime());
        }
        if (StringUtils.isNotEmpty((String)omDutyPagination.getDescription())) {
            ++omDutyNum;
            omDutyQueryWrapper.lambda().like(OmDutyEntity::getDescription, (Object)omDutyPagination.getDescription());
        }
        if (StringUtils.isNotEmpty((String)omDutyPagination.getEnabledMark())) {
            ++omDutyNum;
            omDutyQueryWrapper.lambda().like(OmDutyEntity::getEnabledMark, (Object)omDutyPagination.getEnabledMark());
        }
        if (AllIdList.size() > 0) {
            omDutyQueryWrapper.lambda().in(OmDutyEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)omDutyPagination.getSidx())) {
            omDutyQueryWrapper.lambda().orderByDesc(OmDutyEntity::getId);
        } else {
            try {
                String sidx = omDutyPagination.getSidx();
                OmDutyEntity omDutyEntity = new OmDutyEntity();
                Field declaredField = omDutyEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                omDutyQueryWrapper = "asc".equals(omDutyPagination.getSort().toLowerCase()) ? (QueryWrapper)omDutyQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)omDutyQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(omDutyPagination.getCurrentPage(), omDutyPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)omDutyQueryWrapper);
                return omDutyPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return omDutyPagination.setData(list, list.size());
        }
        return this.list((Wrapper)omDutyQueryWrapper);
    }

    @Override
    public OmDutyEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OmDutyEntity::getId, (Object)id);
        return (OmDutyEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(OmDutyEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, OmDutyEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(OmDutyEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

