/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workorder.controller;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.logistics.entity.OmWorkOrderHistoryEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.workorder.entity.OmWorkOrderAttachEntity;
import com.bringspring.workorder.entity.OmWorkOrderEntity;
import com.bringspring.workorder.entity.OmWorkOrderTypeEntity;
import com.bringspring.workorder.model.chatgptworkorder.ChatGptOmWorkOrderCr;
import com.bringspring.workorder.model.chatgptworkorder.ChatGptOmWorkOrderGetListByCodeVO;
import com.bringspring.workorder.model.chatgptworkorder.ChatGptOmWorkOrderPagination;
import com.bringspring.workorder.model.chatgptworkorder.ChatGptOmWorkOrderUpdateAttachVO;
import com.bringspring.workorder.model.omworkorder.OmWorkOrderCrForm;
import com.bringspring.workorder.model.omworkorder.OmWorkOrderPagination;
import com.bringspring.workorder.model.omworkorder.OmWorkOrderUpForm;
import com.bringspring.workorder.service.OmWorkOrderAttachService;
import com.bringspring.workorder.service.OmWorkOrderService;
import com.bringspring.workorder.service.OmWorkOrderTypeService;
import io.swagger.annotations.Api;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8fd0\u7ef4\u5de5\u5355\u8868"}, value="workorder")
@RequestMapping(value={"/api/workorder/ChatGptOmWorkOrder"})
public class ChatGptOmWorkOrderController {
    private static final Logger log = LoggerFactory.getLogger(ChatGptOmWorkOrderController.class);
    @Autowired
    private OmWorkOrderService omWorkOrderService;
    @Autowired
    private OmWorkOrderAttachService omWorkOrderAttachService;
    @Autowired
    private UserService userService;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private OmWorkOrderTypeService omWorkOrderTypeService;
    @Autowired
    private UserProvider userProvider;

    @PostMapping(value={"/getRecentList"})
    public ActionResult getRecentList(@RequestBody ChatGptOmWorkOrderPagination chatGptOmWorkOrderPagination) throws Exception {
        chatGptOmWorkOrderPagination.setCreatorUserId(this.getSystemInfo(chatGptOmWorkOrderPagination.getCreatorUserId()).getUserId());
        OmWorkOrderPagination pageInput = (OmWorkOrderPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)chatGptOmWorkOrderPagination), OmWorkOrderPagination.class));
        List<OmWorkOrderEntity> list = this.omWorkOrderService.getList(pageInput);
        List listVO = JsonUtil.getJsonToList(list, OmWorkOrderCrForm.class);
        this.omWorkOrderService.selectValues(listVO);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)chatGptOmWorkOrderPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getListByCodeUser"})
    public ActionResult getListByCodeUser(@RequestBody @Valid ChatGptOmWorkOrderGetListByCodeVO getListByCodeVO) throws Exception {
        getListByCodeVO.setCreatorUserId(this.getSystemInfo(getListByCodeVO.getCreatorUserId()).getUserId());
        OmWorkOrderPagination pageInput = (OmWorkOrderPagination)((Object)JsonUtil.getJsonToBean((Object)getListByCodeVO, OmWorkOrderPagination.class));
        List<OmWorkOrderEntity> list = this.omWorkOrderService.getList(pageInput);
        List listVO = JsonUtil.getJsonToList(list, OmWorkOrderCrForm.class);
        this.omWorkOrderService.selectValues(listVO);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pageInput), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getInfoById"})
    public ActionResult getInfoById(@RequestBody @Valid ChatGptOmWorkOrderGetListByCodeVO getListByCodeVO) throws Exception {
        OmWorkOrderCrForm info = this.omWorkOrderService.getInfo(getListByCodeVO.getId());
        return ActionResult.success((Object)info);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid ChatGptOmWorkOrderCr omWorkOrderCrForm) throws Exception {
        UserInfo systemInfo = this.getSystemInfo(omWorkOrderCrForm.getCreatorUserId());
        omWorkOrderCrForm.setCreatorUserId(systemInfo.getUserId());
        omWorkOrderCrForm.setEnabledMark("submit");
        if (ObjectUtil.isEmpty((Object)omWorkOrderCrForm.getPutway())) {
            omWorkOrderCrForm.setPutway("WeCom");
        }
        if (ObjectUtil.isEmpty((Object)omWorkOrderCrForm.getPriority())) {
            omWorkOrderCrForm.setPriority("normal");
        }
        if (ObjectUtil.isEmpty((Object)omWorkOrderCrForm.getStartTime())) {
            omWorkOrderCrForm.setStartTime(new Date());
        }
        if (ObjectUtil.isEmpty((Object)omWorkOrderCrForm.getTitle())) {
            UserEntity infoUser = this.userService.getInfo(systemInfo.getUserId());
            OmWorkOrderTypeEntity infoType = this.omWorkOrderTypeService.getInfo(omWorkOrderCrForm.getWorkOrderTypeId());
            String title = ObjectUtil.isEmpty((Object)infoType) ? infoUser.getRealName() + "\u63d0\u4ea4\u7684\u5de5\u5355" : infoUser.getRealName() + "\u63d0\u4ea4" + infoType.getName() + "\u7684\u5de5\u5355";
            omWorkOrderCrForm.setTitle(title);
        }
        OmWorkOrderEntity omWorkOrderEntity = this.omWorkOrderService.create((OmWorkOrderUpForm)JsonUtil.getJsonToBean((Object)omWorkOrderCrForm, OmWorkOrderUpForm.class));
        omWorkOrderCrForm.setId(omWorkOrderEntity.getId());
        omWorkOrderCrForm.setCode(omWorkOrderEntity.getCode());
        return ActionResult.success((Object)omWorkOrderCrForm);
    }

    @PostMapping(value={"/updateAttach"})
    @Transactional
    public ActionResult updateAttach(@RequestBody @Valid ChatGptOmWorkOrderUpdateAttachVO chatGptOmWorkOrderUpdateAttachVO) throws DataException {
        UserInfo systemInfo = this.getSystemInfo(chatGptOmWorkOrderUpdateAttachVO.getCreatorUserId());
        UserEntity infoUser = this.userService.getInfo(systemInfo.getUserId());
        chatGptOmWorkOrderUpdateAttachVO.setCreatorUserId(systemInfo.getUserId());
        OmWorkOrderHistoryEntity omWorkOrderHistoryEntity = new OmWorkOrderHistoryEntity();
        String historyId = RandomUtil.uuId();
        omWorkOrderHistoryEntity.setWorkOrderId(chatGptOmWorkOrderUpdateAttachVO.getWorkOrderId());
        omWorkOrderHistoryEntity.setId(historyId);
        omWorkOrderHistoryEntity.setDescription(infoUser.getRealName() + "\u4e0a\u4f20\u9644\u4ef6");
        omWorkOrderHistoryEntity.setPhase("record");
        omWorkOrderHistoryEntity.setCreatorUserId(systemInfo.getUserId());
        List<OmWorkOrderAttachEntity> urlList = chatGptOmWorkOrderUpdateAttachVO.getAttach();
        if (!ObjectUtil.isEmpty(urlList)) {
            for (OmWorkOrderAttachEntity url : urlList) {
                url.setId(RandomUtil.uuId());
                url.setWorkOrderHistoryId(historyId);
                this.createAttach(url);
            }
        }
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @GetMapping(value={"/getWorkOrderTypeList"})
    @Transactional
    public ActionResult getWorkOrderTypeList() {
        List<OmWorkOrderTypeEntity> listAll = this.omWorkOrderTypeService.getListAll();
        return ActionResult.success(listAll);
    }

    public void createAttach(OmWorkOrderAttachEntity omWorkOrderAttachEntity) {
        this.omWorkOrderAttachService.create(omWorkOrderAttachEntity);
    }

    public UserInfo getSystemInfo(String thirdId) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        return userInfo;
    }
}

