/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workorder.controller;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.enums.DictionaryDataEnum;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.permission.entity.GroupEntity;
import com.bringspring.system.permission.model.user.vo.UserListVO;
import com.bringspring.system.permission.service.GroupService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.workorder.entity.OmWorkGroupEntity;
import com.bringspring.workorder.entity.OmWorkOrderTypeEntity;
import com.bringspring.workorder.model.omWorkGroup.OmWorkGroupCrForm;
import com.bringspring.workorder.model.omWorkGroup.OmWorkOrderGroupPaginationVO;
import com.bringspring.workorder.model.omworkorder.OmWorkOrderCrForm;
import com.bringspring.workorder.model.omworkordertype.OmWorkOrderTypeCrForm;
import com.bringspring.workorder.service.OmWorkGroupService;
import com.bringspring.workorder.service.OmWorkOrderService;
import com.bringspring.workorder.service.OmWorkOrderTypeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8fd0\u7ef4\u5206\u7ec4\u5de5\u5355\u7c7b\u578b\u5173\u7cfb\u8868"}, value="workorder")
@RequestMapping(value={"/api/workorder/OmWorkGroup"})
public class OmWorkGroupController {
    private static final Logger log = LoggerFactory.getLogger(OmWorkGroupController.class);
    @Autowired
    private OmWorkGroupService omWorkGroupService;
    @Autowired
    private GroupService userGroupService;
    @Autowired
    private OmWorkOrderTypeService omWorkOrderTypeService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private UserService userService;
    @Autowired
    private OmWorkOrderService omWorkOrderService;

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid OmWorkGroupCrForm omWorkGroupCrForm) throws DataException {
        this.omWorkGroupService.deleteByGroup(omWorkGroupCrForm.getBaseGroupIdList());
        List<String> baseGroupIdList = omWorkGroupCrForm.getBaseGroupIdList();
        List<String> workOrderTypeIdList = omWorkGroupCrForm.getWorkOrderTypeIdList();
        for (String groupItem : baseGroupIdList) {
            GroupEntity info = this.userGroupService.getInfo(groupItem);
            if (ObjectUtil.isEmpty((Object)info)) continue;
            for (String typeId : workOrderTypeIdList) {
                List<OmWorkOrderTypeEntity> listByParentId = this.omWorkOrderTypeService.getListByParentId(typeId);
                if (!ObjectUtil.isEmpty(listByParentId)) continue;
                OmWorkGroupEntity addEntity = new OmWorkGroupEntity();
                addEntity.setId(RandomUtil.uuId());
                addEntity.setBaseGroupId(groupItem);
                addEntity.setWorkOrderTypeId(typeId);
                this.omWorkGroupService.save(addEntity);
            }
        }
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/getByGroup"})
    @Transactional
    public ActionResult getByGroup(@RequestParam String groupId) {
        List<OmWorkGroupEntity> byGroup = this.omWorkGroupService.getByGroup(groupId);
        return ActionResult.success(byGroup);
    }

    @ApiOperation(value="\u83b7\u53d6\u5206\u7ec4\u7ba1\u7406\u5217\u8868")
    @GetMapping(value={"/getGroupList"})
    public ActionResult list(Pagination pagination) {
        List list = this.userGroupService.getList(pagination);
        List jsonToList = JsonUtil.getJsonToList((Object)list, OmWorkOrderGroupPaginationVO.class);
        List dictionaryDataEntities = this.dictionaryDataService.getDicList(DictionaryDataEnum.PERMISSION_GROUP.getDictionaryTypeId());
        for (OmWorkOrderGroupPaginationVO userGroupPaginationVO : jsonToList) {
            DictionaryDataEntity dictionaryDataEntity = dictionaryDataEntities.stream().filter(t -> t.getId().equals(userGroupPaginationVO.getType())).findFirst().orElse(null);
            userGroupPaginationVO.setType(dictionaryDataEntity != null ? dictionaryDataEntity.getFullName() : userGroupPaginationVO.getId());
            userGroupPaginationVO.setTypeCount(this.omWorkGroupService.getByGroup(userGroupPaginationVO.getId()).size());
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)pagination, PaginationVO.class);
        return ActionResult.page((List)jsonToList, (PaginationVO)paginationVO);
    }

    @GetMapping(value={"/getUserByConfigKey"})
    @Transactional
    public ActionResult getUserByConfigKey(@RequestParam String workOrderId) {
        List<OmWorkGroupEntity> groupByTypes;
        List listByObjectIdAll;
        List outPutList = new ArrayList();
        OmWorkOrderCrForm infoWorkOrder = this.omWorkOrderService.getInfo(workOrderId);
        ArrayList<Object> listTreeStep = new ArrayList<Object>();
        listTreeStep.add(JsonUtil.getJsonToBean((Object)this.omWorkOrderTypeService.getInfo(infoWorkOrder.getWorkOrderTypeId()), OmWorkOrderTypeCrForm.class));
        List<OmWorkOrderTypeCrForm> listTreeStepType = this.omWorkOrderTypeService.getListTreeStep(infoWorkOrder.getWorkOrderTypeId());
        if (!ObjectUtil.isEmpty(listTreeStepType)) {
            listTreeStep.addAll(listTreeStepType);
        }
        if (!ObjectUtil.isEmpty((Object)(listByObjectIdAll = this.userRelationService.getListByObjectIdAll((groupByTypes = this.omWorkGroupService.getByTypes(listTreeStep.stream().map(item -> item.getId()).collect(Collectors.toList()))).stream().map(item -> item.getBaseGroupId()).distinct().collect(Collectors.toList()))))) {
            List userList = this.userService.listByIds((Collection)listByObjectIdAll.stream().map(item -> item.getUserId()).collect(Collectors.toList()));
            outPutList = JsonUtil.getJsonToList((Object)userList, UserListVO.class);
        }
        return ActionResult.success(outPutList);
    }
}

