/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workorder.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.event.GeneralEvent;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.logistics.entity.OmWorkOrderHistoryEntity;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.permission.entity.GroupEntity;
import com.bringspring.system.permission.model.user.vo.UserInfoVO;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workorder.entity.OmWorkOrderAttachEntity;
import com.bringspring.workorder.entity.OmWorkOrderEntity;
import com.bringspring.workorder.model.omworkorder.OmWorkOrderCrForm;
import com.bringspring.workorder.model.omworkorder.OmWorkOrderInfoVO;
import com.bringspring.workorder.model.omworkorder.OmWorkOrderPagination;
import com.bringspring.workorder.model.omworkorder.OmWorkOrderPaginationExportModel;
import com.bringspring.workorder.model.omworkorder.OmWorkOrderUpForm;
import com.bringspring.workorder.model.omworkorderhistory.OmWorkOrderHistoryCrForm;
import com.bringspring.workorder.service.OmWorkOrderAttachService;
import com.bringspring.workorder.service.OmWorkOrderHistoryService;
import com.bringspring.workorder.service.OmWorkOrderMaterialService;
import com.bringspring.workorder.service.OmWorkOrderService;
import com.bringspring.workorder.util.BusinessTypeEnum;
import com.bringspring.workorder.util.UploaderVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8fd0\u7ef4\u5de5\u5355\u8868"}, value="workorder")
@RequestMapping(value={"/api/workorder/OmWorkOrder"})
public class OmWorkOrderController {
    private static final Logger log = LoggerFactory.getLogger(OmWorkOrderController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OmWorkOrderService omWorkOrderService;
    @Autowired
    private OmWorkOrderHistoryService omWorkOrderHistoryService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private OmWorkOrderAttachService omWorkOrderAttachService;
    @Autowired
    private UserService userService;
    @Autowired
    private OmWorkOrderMaterialService omWorkOrderMaterialService;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OmWorkOrderPagination omWorkOrderPagination) throws Exception {
        List<OmWorkOrderEntity> list = this.omWorkOrderService.getList(omWorkOrderPagination);
        List listVO = JsonUtil.getJsonToList(list, OmWorkOrderCrForm.class);
        this.omWorkOrderService.selectValues(listVO);
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)omWorkOrderPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getEnableMarkCount"})
    public ActionResult getEnableMarkCount(@RequestBody OmWorkOrderCrForm workOrderCrForm) {
        long enableMarkCount = this.omWorkOrderService.getEnableMarkCount(workOrderCrForm);
        return ActionResult.success((Object)enableMarkCount);
    }

    @PostMapping(value={"/urgingWorkOrder"})
    public ActionResult urgingWorkOrder(@RequestBody OmWorkOrderCrForm workOrderCrForm) throws Exception {
        this.omWorkOrderService.urgingWorkOrder(workOrderCrForm);
        return ActionResult.success((String)"\u50ac\u529e\u6210\u529f\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\uff01");
    }

    @PostMapping(value={"/getListByWorkId"})
    public ActionResult getListByWorkId(@RequestBody OmWorkOrderCrForm workOrderCrForm) throws IOException {
        List<OmWorkOrderHistoryEntity> listByWorkId = this.omWorkOrderHistoryService.getListByWorkId(workOrderCrForm.getId(), workOrderCrForm.getEnabledMark());
        List listVO = JsonUtil.getJsonToList(listByWorkId, OmWorkOrderHistoryCrForm.class);
        listVO.stream().forEach(item -> {
            if ("draft".equals(item.getPhase()) || "execute".equals(item.getPhase()) || "assign".equals(item.getPhase()) || "record".equals(item.getPhase())) {
                List<OmWorkOrderAttachEntity> listByHistoryId = this.omWorkOrderAttachService.getListByHistoryId(item.getId());
                ArrayList<UploaderVO> urlList = new ArrayList<UploaderVO>();
                for (OmWorkOrderAttachEntity o : listByHistoryId) {
                    UploaderVO uploaderVO = new UploaderVO();
                    if (!ObjectUtil.isEmpty((Object)o.getAttachNote())) {
                        uploaderVO = (UploaderVO)JSON.parseObject((String)o.getAttachNote(), (TypeReference)new TypeReference<UploaderVO>(){}, (Feature[])new Feature[0]);
                        String[] splitName = uploaderVO.getName().split("\\.");
                        uploaderVO.setFileType(splitName[splitName.length - 1]);
                    }
                    urlList.add(uploaderVO);
                }
                item.setUrl(urlList);
            }
            if ("record".equals(item.getPhase()) || "execute".equals(item.getPhase())) {
                item.setMaterial(this.omWorkOrderMaterialService.getByWorkHistoryId(item.getId(), workOrderCrForm.getId()));
            }
            item.setPhaseName(this.baseDataUtil.getDictName(item.getPhase(), "WorkHistoryPhass"));
            item.setCreatorTimeFormat(DateUtil.dateFormat((Date)item.getCreatorTime()));
            UserInfoVO infoCreater = null;
            try {
                infoCreater = this.userService.getInfoDetail(item.getCreatorUserId());
            }
            catch (DataException e) {
                throw new RuntimeException(e);
            }
            if (!ObjectUtil.isEmpty((Object)infoCreater)) {
                item.setCreatorUserName(infoCreater.getRealName());
                item.setAvatar(infoCreater.getHeadIcon());
                item.setDepartment(this.baseDataUtil.comSelectValues(infoCreater.getOrganizeId()));
            }
        });
        return ActionResult.success((Object)listVO);
    }

    @PostMapping(value={"/updateWorkWithHistory"})
    public ActionResult updateWorkWithHistory(@RequestBody OmWorkOrderCrForm workOrderCrForm) throws Exception {
        if (!this.omWorkOrderService.permitState(workOrderCrForm.getId(), workOrderCrForm.getEnabledMark())) {
            return ActionResult.fail((String)"\u5de5\u5355\u72b6\u6001\u5df2\u7ecf\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u65b0\u64cd\u4f5c\uff01");
        }
        Integer integer = this.omWorkOrderService.updateWorkWithHistory(workOrderCrForm);
        return ActionResult.success((Object)integer);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid OmWorkOrderUpForm omWorkOrderCrForm) throws Exception {
        if (ObjectUtil.isEmpty((Object)omWorkOrderCrForm.getStartTime())) {
            omWorkOrderCrForm.setStartTime(new Date());
        }
        if ("submit".equals(omWorkOrderCrForm.getEnabledMark())) {
            HashMap<String, String> toDevice = new HashMap<String, String>();
            toDevice.put("device", omWorkOrderCrForm.getBusinessId());
            toDevice.put("type", "1");
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new GeneralEvent((Object)"workOrder", toDevice));
        }
        this.omWorkOrderService.create(omWorkOrderCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OmWorkOrderCrForm> info(@PathVariable(value="id") String id) {
        OmWorkOrderCrForm entity = this.omWorkOrderService.getInfo(id);
        return ActionResult.success((Object)entity);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OmWorkOrderInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OmWorkOrderCrForm entity = this.omWorkOrderService.getInfo(id);
        OmWorkOrderInfoVO vo = (OmWorkOrderInfoVO)JsonUtil.getJsonToBean((Object)entity, OmWorkOrderInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/getGroupByLeader"})
    public ActionResult<List<GroupEntity>> getGroupByLeader() {
        UserInfo userInfo = this.userProvider.get();
        List<GroupEntity> groupByLeader = this.omWorkOrderService.getGroupByLeader(userInfo.getUserId());
        return ActionResult.success(groupByLeader);
    }

    @PostMapping(value={"/autoAssign"})
    public ActionResult<List<GroupEntity>> autoAssign() throws Exception {
        UserInfo userInfo = this.userProvider.get();
        this.omWorkOrderService.autoAssign();
        return ActionResult.success((String)"\u63d0\u4ea4\u6210\u529f");
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OmWorkOrderUpForm omWorkOrderUpForm) throws DataException {
        if (!this.omWorkOrderService.permitState(id, omWorkOrderUpForm.getEnabledMark())) {
            return ActionResult.fail((String)"\u5de5\u5355\u72b6\u6001\u5df2\u7ecf\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u65b0\u64cd\u4f5c\uff01");
        }
        UserInfo userInfo = this.userProvider.get();
        OmWorkOrderEntity entity = (OmWorkOrderEntity)this.omWorkOrderService.getById((Serializable)((Object)id));
        if (entity != null) {
            HashMap<String, String> toDevice;
            OmWorkOrderEntity subentity = (OmWorkOrderEntity)JsonUtil.getJsonToBean((Object)omWorkOrderUpForm, OmWorkOrderEntity.class);
            this.omWorkOrderService.update(id, subentity);
            if ("submit".equals(omWorkOrderUpForm.getEnabledMark())) {
                toDevice = new HashMap<String, String>();
                toDevice.put("device", omWorkOrderUpForm.getBusinessId());
                toDevice.put("type", "1");
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new GeneralEvent((Object)"workOrder", toDevice));
            } else if ("confirm".equals(omWorkOrderUpForm.getEnabledMark())) {
                toDevice = new HashMap();
                toDevice.put("device", omWorkOrderUpForm.getBusinessId());
                toDevice.put("type", "0");
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new GeneralEvent((Object)"workOrder", toDevice));
            }
            List<OmWorkOrderHistoryEntity> draft = this.omWorkOrderHistoryService.getListByWorkId(id, "draft");
            String createHistoryId = !ObjectUtil.isEmpty(draft) ? draft.get(0).getId() : "";
            List<UploaderVO> urlList = omWorkOrderUpForm.getUrl();
            if ("submit".equals(omWorkOrderUpForm.getEnabledMark())) {
                OmWorkOrderHistoryEntity createHistory = new OmWorkOrderHistoryEntity();
                createHistory.setWorkOrderId(id);
                createHistory.setId(RandomUtil.uuId());
                createHistory.setPhase(omWorkOrderUpForm.getEnabledMark());
                DictionaryDataEntity dictionaryDataentity = this.dictionaryDataService.getSwapInfo(omWorkOrderUpForm.getEnabledMark(), "408965779678037317");
                if (!ObjectUtil.isEmpty((Object)dictionaryDataentity)) {
                    createHistory.setDescription(userInfo.getUserName() + dictionaryDataentity.getDescription());
                }
                this.omWorkOrderHistoryService.create(createHistory);
                try {
                    this.omWorkOrderService.autoAssign();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.omWorkOrderAttachService.deleteByHistoryId(createHistoryId);
            if (!ObjectUtil.isEmpty(urlList)) {
                for (UploaderVO url : urlList) {
                    OmWorkOrderAttachEntity omWorkOrderAttachEntity = new OmWorkOrderAttachEntity();
                    omWorkOrderAttachEntity.setId(RandomUtil.uuId());
                    omWorkOrderAttachEntity.setWorkOrderHistoryId(createHistoryId);
                    omWorkOrderAttachEntity.setAttachUrl(url.getUrl());
                    omWorkOrderAttachEntity.setAttachNote(JSON.toJSONString((Object)url));
                    this.createAttach(omWorkOrderAttachEntity);
                }
            }
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PostMapping(value={"/evaluateWorkOrder"})
    @Transactional
    public ActionResult evaluateWorkOrder(@RequestBody @Valid OmWorkOrderCrForm omWorkOrderUpForm) {
        OmWorkOrderEntity entity = (OmWorkOrderEntity)this.omWorkOrderService.getById((Serializable)((Object)omWorkOrderUpForm.getId()));
        if (entity != null) {
            OmWorkOrderEntity subentity = (OmWorkOrderEntity)JsonUtil.getJsonToBean((Object)omWorkOrderUpForm, OmWorkOrderEntity.class);
            this.omWorkOrderService.update(omWorkOrderUpForm.getId(), subentity);
            OmWorkOrderHistoryEntity createHistory = new OmWorkOrderHistoryEntity();
            createHistory.setWorkOrderId(omWorkOrderUpForm.getId());
            createHistory.setId(RandomUtil.uuId());
            createHistory.setPhase(omWorkOrderUpForm.getEnabledMark());
            DictionaryDataEntity dictionaryDataentity = this.dictionaryDataService.getSwapInfo(omWorkOrderUpForm.getEnabledMark(), "408965779678037317");
            if (!ObjectUtil.isEmpty((Object)dictionaryDataentity)) {
                createHistory.setDescription(dictionaryDataentity.getDescription() + "\u3010" + omWorkOrderUpForm.getEvaluateDescription() + "\u3011");
            }
            this.omWorkOrderHistoryService.create(createHistory);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    public void createAttach(OmWorkOrderAttachEntity omWorkOrderAttachEntity) {
        this.omWorkOrderAttachService.create(omWorkOrderAttachEntity);
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OmWorkOrderEntity entity = (OmWorkOrderEntity)this.omWorkOrderService.getById((Serializable)((Object)id));
        if (entity != null) {
            UserInfo userInfo = this.userProvider.get();
            entity.setDeleteMark(0);
            entity.setDeleteUserId(userInfo.getUserId());
            entity.setDeleteTime(new Date());
            this.omWorkOrderService.update(id, entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OmWorkOrderPaginationExportModel omWorkOrderPaginationExportModel) throws Exception {
        if (StringUtils.isEmpty((String)omWorkOrderPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OmWorkOrderPagination omWorkOrderPagination = (OmWorkOrderPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)omWorkOrderPaginationExportModel), OmWorkOrderPagination.class));
        List<Object> list = new ArrayList();
        if ("1".equals(omWorkOrderPaginationExportModel.getDataType())) {
            omWorkOrderPagination.setPageSize(1000000L);
            list = this.omWorkOrderService.getList(omWorkOrderPagination);
        } else {
            list = this.omWorkOrderService.getList(omWorkOrderPagination);
        }
        List listVO = JsonUtil.getJsonToList(list, OmWorkOrderCrForm.class);
        this.omWorkOrderService.selectValues(listVO);
        listVO.stream().forEach(v -> v.setCreatorTimeFormat(DateUtil.daFormat((Long)v.getCreatorTime())));
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)omWorkOrderPaginationExportModel.getSelectKey()) ? omWorkOrderPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block30: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "title": {
                        entitys.add(new ExcelExportEntity("\u5de5\u5355\u6807\u9898", (Object)"title"));
                        continue block30;
                    }
                    case "code": {
                        entitys.add(new ExcelExportEntity("\u5de5\u5355\u7f16\u53f7", (Object)"code"));
                        continue block30;
                    }
                    case "workOrderTypeName": {
                        entitys.add(new ExcelExportEntity("\u5de5\u5355\u7c7b\u578b\u540d\u79f0", (Object)"workOrderTypeName"));
                        continue block30;
                    }
                    case "priorityName": {
                        entitys.add(new ExcelExportEntity("\u4f18\u5148\u7ea7", (Object)"priorityName"));
                        continue block30;
                    }
                    case "enabledMarkName": {
                        entitys.add(new ExcelExportEntity("\u5de5\u5355\u72b6\u6001", (Object)"enabledMarkName"));
                        continue block30;
                    }
                    case "creatorUserName": {
                        entitys.add(new ExcelExportEntity("\u7533\u62a5\u4eba", (Object)"creatorUserName"));
                        continue block30;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u7533\u62a5\u65f6\u95f4", (Object)"creatorTimeFormat"));
                        continue block30;
                    }
                    case "executeUserName": {
                        entitys.add(new ExcelExportEntity("\u6267\u884c\u4eba", (Object)"executeUserName"));
                        continue block30;
                    }
                    case "executeTime": {
                        entitys.add(new ExcelExportEntity("\u6267\u884c\u65f6\u95f4", (Object)"executeTime"));
                        continue block30;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/businessTypeEnum"})
    public ActionResult<BusinessTypeEnum[]> transportTypeEnum() {
        return ActionResult.success((Object)BusinessTypeEnum.values());
    }
}

