/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workorder.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.workorder.model.omworkordergateway.OmWorkOrderCountStatistics;
import com.bringspring.workorder.model.omworkordergateway.OmWorkOrderGateway;
import com.bringspring.workorder.model.omworkordergateway.OmWorkOrderStatistics;
import com.bringspring.workorder.service.OmWorkOrderService;
import io.swagger.annotations.Api;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8fd0\u7ef4\u5de5\u5355\u8868"}, value="OmWorkOrderGateway")
@RequestMapping(value={"/api/workorder/OmWorkOrderGateway"})
public class OmWorkOrderGatewayController {
    private static final Logger log = LoggerFactory.getLogger(OmWorkOrderGatewayController.class);
    @Autowired
    private OmWorkOrderService omWorkOrderService;

    @PostMapping(value={"/getTotal"})
    @Transactional
    public ActionResult getTotal(@RequestBody @Valid OmWorkOrderGateway omWorkOrderGateway) throws Exception {
        OmWorkOrderGateway total = this.omWorkOrderService.getTotal(omWorkOrderGateway);
        return ActionResult.success((Object)total);
    }

    @PostMapping(value={"/getStatistics"})
    @Transactional
    public ActionResult getStatistics(@RequestBody @Valid OmWorkOrderGateway omWorkOrderGateway) throws Exception {
        List<OmWorkOrderStatistics> statistics = this.omWorkOrderService.getStatistics(omWorkOrderGateway);
        return ActionResult.success(statistics);
    }

    @PostMapping(value={"/getCreateUserStatistics"})
    @Transactional
    public ActionResult getCreateUserStatistics(@RequestBody @Valid OmWorkOrderGateway omWorkOrderGateway) throws Exception {
        List<OmWorkOrderStatistics> statistics = this.omWorkOrderService.getCreateUserStatistics(omWorkOrderGateway);
        return ActionResult.success(statistics);
    }

    @PostMapping(value={"/getDepartStatistics"})
    @Transactional
    public ActionResult getDepartStatistics(@RequestBody @Valid OmWorkOrderGateway omWorkOrderGateway) throws Exception {
        List<OmWorkOrderStatistics> statistics = this.omWorkOrderService.getDepartStatistics(omWorkOrderGateway);
        return ActionResult.success(statistics);
    }

    @PostMapping(value={"/getTypeStatistics"})
    @Transactional
    public ActionResult getTypeStatistics(@RequestBody @Valid OmWorkOrderGateway omWorkOrderGateway) throws Exception {
        List<OmWorkOrderStatistics> statistics = this.omWorkOrderService.getTypeStatistics(omWorkOrderGateway);
        return ActionResult.success(statistics);
    }

    @PostMapping(value={"/getTotalStatistics"})
    @Transactional
    public ActionResult getTotalStatistics(@RequestBody @Valid OmWorkOrderGateway omWorkOrderGateway) throws Exception {
        List<OmWorkOrderGateway> statistics = this.omWorkOrderService.getTotalStatistics(omWorkOrderGateway);
        return ActionResult.success(statistics);
    }

    @PostMapping(value={"/getDateStatistics"})
    @Transactional
    public ActionResult getDateStatistics(@RequestBody @Valid OmWorkOrderGateway omWorkOrderGateway) throws Exception {
        OmWorkOrderCountStatistics omWorkOrderGateways = this.omWorkOrderService.getDateStatistics(omWorkOrderGateway);
        return ActionResult.success((Object)omWorkOrderGateways);
    }

    @PostMapping(value={"/getGradeStatistics"})
    @Transactional
    public ActionResult getGradeStatistics(@RequestBody @Valid OmWorkOrderGateway omWorkOrderGateway) throws Exception {
        List<Double> returnDouble = this.omWorkOrderService.getGradeStatistics(omWorkOrderGateway);
        return ActionResult.success(returnDouble);
    }
}

