/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workorder.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.logistics.entity.OmWorkOrderHistoryEntity;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workorder.model.omworkorderhistory.OmWorkOrderHistoryCrForm;
import com.bringspring.workorder.model.omworkorderhistory.OmWorkOrderHistoryInfoVO;
import com.bringspring.workorder.model.omworkorderhistory.OmWorkOrderHistoryListVO;
import com.bringspring.workorder.model.omworkorderhistory.OmWorkOrderHistoryPagination;
import com.bringspring.workorder.model.omworkorderhistory.OmWorkOrderHistoryUpForm;
import com.bringspring.workorder.service.OmWorkOrderHistoryService;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8fd0\u7ef4\u5de5\u5355\u5386\u53f2"}, value="workorder")
@RequestMapping(value={"/api/workorder/OmWorkOrderHistory"})
public class OmWorkOrderHistoryController {
    private static final Logger log = LoggerFactory.getLogger(OmWorkOrderHistoryController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OmWorkOrderHistoryService omWorkOrderHistoryService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OmWorkOrderHistoryPagination omWorkOrderHistoryPagination) throws IOException {
        List<OmWorkOrderHistoryEntity> list = this.omWorkOrderHistoryService.getList(omWorkOrderHistoryPagination);
        for (OmWorkOrderHistoryEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, OmWorkOrderHistoryListVO.class);
        for (OmWorkOrderHistoryListVO omWorkOrderHistoryListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)omWorkOrderHistoryPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @Transactional
    public ActionResult create(@RequestBody @Valid OmWorkOrderHistoryCrForm omWorkOrderHistoryCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        OmWorkOrderHistoryEntity entity = (OmWorkOrderHistoryEntity)JsonUtil.getJsonToBean((Object)omWorkOrderHistoryCrForm, OmWorkOrderHistoryEntity.class);
        entity.setId(mainId);
        this.omWorkOrderHistoryService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OmWorkOrderHistoryInfoVO> info(@PathVariable(value="id") String id) {
        OmWorkOrderHistoryEntity entity = this.omWorkOrderHistoryService.getInfo(id);
        OmWorkOrderHistoryInfoVO vo = (OmWorkOrderHistoryInfoVO)JsonUtil.getJsonToBean((Object)entity, OmWorkOrderHistoryInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OmWorkOrderHistoryInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OmWorkOrderHistoryEntity entity = this.omWorkOrderHistoryService.getInfo(id);
        OmWorkOrderHistoryInfoVO vo = (OmWorkOrderHistoryInfoVO)JsonUtil.getJsonToBean((Object)entity, OmWorkOrderHistoryInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OmWorkOrderHistoryUpForm omWorkOrderHistoryUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        OmWorkOrderHistoryEntity entity = this.omWorkOrderHistoryService.getInfo(id);
        if (entity != null) {
            OmWorkOrderHistoryEntity subentity = (OmWorkOrderHistoryEntity)JsonUtil.getJsonToBean((Object)omWorkOrderHistoryUpForm, OmWorkOrderHistoryEntity.class);
            this.omWorkOrderHistoryService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @Transactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OmWorkOrderHistoryEntity entity = this.omWorkOrderHistoryService.getInfo(id);
        if (entity != null) {
            this.omWorkOrderHistoryService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

