/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.workorder.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.workorder.entity.OmWorkOrderMaterialEntity;
import com.bringspring.workorder.model.omworkordermaterial.OmWorkOrderMaterialCrForm;
import com.bringspring.workorder.model.omworkordermaterial.OmWorkOrderMaterialInfoVO;
import com.bringspring.workorder.model.omworkordermaterial.OmWorkOrderMaterialListVO;
import com.bringspring.workorder.model.omworkordermaterial.OmWorkOrderMaterialPagination;
import com.bringspring.workorder.model.omworkordermaterial.OmWorkOrderMaterialUpForm;
import com.bringspring.workorder.service.OmWorkOrderMaterialService;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5de5\u5355\u8017\u6750"}, value="workorder")
@RequestMapping(value={"/api/workorder/OmWorkOrderMaterial"})
public class OmWorkOrderMaterialController {
    private static final Logger log = LoggerFactory.getLogger(OmWorkOrderMaterialController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OmWorkOrderMaterialService omWorkOrderMaterialService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OmWorkOrderMaterialPagination omWorkOrderMaterialPagination) throws IOException {
        List<OmWorkOrderMaterialEntity> list = this.omWorkOrderMaterialService.getList(omWorkOrderMaterialPagination);
        for (OmWorkOrderMaterialEntity object : list) {
        }
        List listVO = JsonUtil.getJsonToList(list, OmWorkOrderMaterialListVO.class);
        for (OmWorkOrderMaterialListVO omWorkOrderMaterialListVO : listVO) {
        }
        PageListVO pageListVO = new PageListVO();
        pageListVO.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)omWorkOrderMaterialPagination), PaginationVO.class);
        pageListVO.setPagination(page);
        return ActionResult.success((Object)pageListVO);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid OmWorkOrderMaterialCrForm omWorkOrderMaterialCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        OmWorkOrderMaterialEntity entity = (OmWorkOrderMaterialEntity)JsonUtil.getJsonToBean((Object)omWorkOrderMaterialCrForm, OmWorkOrderMaterialEntity.class);
        entity.setId(mainId);
        this.omWorkOrderMaterialService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OmWorkOrderMaterialInfoVO> info(@PathVariable(value="id") String id) {
        OmWorkOrderMaterialEntity entity = this.omWorkOrderMaterialService.getInfo(id);
        OmWorkOrderMaterialInfoVO vo = (OmWorkOrderMaterialInfoVO)JsonUtil.getJsonToBean((Object)entity, OmWorkOrderMaterialInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OmWorkOrderMaterialInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OmWorkOrderMaterialEntity entity = this.omWorkOrderMaterialService.getInfo(id);
        OmWorkOrderMaterialInfoVO vo = (OmWorkOrderMaterialInfoVO)JsonUtil.getJsonToBean((Object)entity, OmWorkOrderMaterialInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OmWorkOrderMaterialUpForm omWorkOrderMaterialUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        OmWorkOrderMaterialEntity entity = this.omWorkOrderMaterialService.getInfo(id);
        if (entity != null) {
            OmWorkOrderMaterialEntity subentity = (OmWorkOrderMaterialEntity)JsonUtil.getJsonToBean((Object)omWorkOrderMaterialUpForm, OmWorkOrderMaterialEntity.class);
            this.omWorkOrderMaterialService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        OmWorkOrderMaterialEntity entity = this.omWorkOrderMaterialService.getInfo(id);
        if (entity != null) {
            this.omWorkOrderMaterialService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

